/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah.symmetric;

import com.googlecode.javaewah.BitmapStorage;
import com.googlecode.javaewah.symmetric.EWAHPointer;
import com.googlecode.javaewah.symmetric.UpdateableBitmapFunction;
import java.util.Arrays;

public final class ThresholdFuncBitmap
extends UpdateableBitmapFunction {
    private final int min;
    private long[] buffers;
    private int bufferUsed;
    private final int[] bufCounters = new int[64];
    private static final int[] zeroes64 = new int[64];

    public ThresholdFuncBitmap(int min2) {
        this.min = min2;
        this.buffers = new long[16];
        this.bufferUsed = 0;
    }

    @Override
    public void dispatch(BitmapStorage out, int runBegin, int runEnd) {
        int runLength = runEnd - runBegin;
        if (this.hammingWeight >= this.min) {
            out.addStreamOfEmptyWords(true, runLength);
        } else if (this.litWeight + this.hammingWeight < this.min) {
            out.addStreamOfEmptyWords(false, runLength);
        } else {
            int deficit = this.min - this.hammingWeight;
            if (deficit == 1) {
                this.orLiterals(out, runBegin, runLength);
                return;
            }
            this.bufferUsed = this.getNumberOfLiterals();
            if (this.bufferUsed == deficit) {
                this.andLiterals(out, runBegin, runLength);
            } else {
                this.generalLiterals(deficit, out, runBegin, runLength);
            }
        }
    }

    private long threshold2buf(int t, long[] buf, int bufUsed) {
        long result = 0L;
        int[] counters = this.bufCounters;
        System.arraycopy(zeroes64, 0, counters, 0, 64);
        for (int k = 0; k < bufUsed; ++k) {
            long t2;
            for (long bitset = buf[k]; bitset != 0L; bitset ^= t2) {
                t2 = bitset & -bitset;
                int n = Long.bitCount(t2 - 1L);
                counters[n] = counters[n] + 1;
            }
        }
        for (int pos = 0; pos < 64; ++pos) {
            if (counters[pos] < t) continue;
            result |= 1L << pos;
        }
        return result;
    }

    private static long threshold3(int t, long[] buffers, int bufUsed) {
        if (buffers.length == 0) {
            return 0L;
        }
        long[] v = new long[t];
        v[0] = buffers[0];
        for (int k = 1; k < bufUsed; ++k) {
            int m3;
            long c = buffers[k];
            for (int j = m3 = Math.min(t - 1, k); j >= 1; --j) {
                int n = j;
                v[n] = v[n] | c & v[j - 1];
            }
            v[0] = v[0] | c;
        }
        return v[t - 1];
    }

    private long threshold4(int T, long[] buf, int bufUsed) {
        if (T >= 128) {
            return this.threshold2buf(T, buf, bufUsed);
        }
        int B = 0;
        for (int k = 0; k < bufUsed; ++k) {
            B += Long.bitCount(buf[k]);
        }
        if (2 * B >= bufUsed * T) {
            return ThresholdFuncBitmap.threshold3(T, buf, bufUsed);
        }
        return this.threshold2buf(T, buf, bufUsed);
    }

    private void orLiterals(BitmapStorage out, int runBegin, int runLength) {
        for (int i = 0; i < runLength; ++i) {
            long w = 0L;
            for (EWAHPointer R : this.getLiterals()) {
                w |= R.iterator.getLiteralWordAt(i + runBegin - R.beginOfRun());
            }
            out.addWord(w);
        }
    }

    private void andLiterals(BitmapStorage out, int runBegin, int runLength) {
        for (int i = 0; i < runLength; ++i) {
            long w = -1L;
            for (EWAHPointer R : this.getLiterals()) {
                w &= R.iterator.getLiteralWordAt(i + runBegin - R.beginOfRun());
            }
            out.addWord(w);
        }
    }

    private void generalLiterals(int deficit, BitmapStorage out, int runBegin, int runLength) {
        if (this.bufferUsed > this.buffers.length) {
            this.buffers = Arrays.copyOf(this.buffers, 2 * this.bufferUsed);
        }
        for (int i = 0; i < runLength; ++i) {
            int p = 0;
            for (EWAHPointer R : this.getLiterals()) {
                this.buffers[p++] = R.iterator.getLiteralWordAt(i + runBegin - R.beginOfRun());
            }
            out.addWord(this.threshold4(deficit, this.buffers, this.bufferUsed));
        }
    }
}

