/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.Events;
import org.netbeans.Module;
import org.netbeans.ModuleManager;
import org.netbeans.StandardModule;

public final class JaveleonModule
extends StandardModule {
    private static final Logger LOG = Logger.getLogger(JaveleonModule.class.getName());
    public static final boolean isJaveleonPresent;
    private static final Method incrementGlobalId;
    private static final Method registerClassLoader;
    private static HashMap<String, ClassLoader> currentClassLoaders;

    public static boolean incrementGlobalId() {
        assert (isJaveleonPresent);
        try {
            incrementGlobalId.invoke(null, new Object[0]);
            return true;
        }
        catch (Exception x) {
            LOG.log(Level.INFO, "Could not reload", x);
            return false;
        }
    }

    static void registerClassLoader(ClassLoader loader, String codeNameBase) {
        if (isJaveleonPresent) {
            try {
                registerClassLoader.invoke(null, loader, codeNameBase);
            }
            catch (Exception x) {
                LOG.log(Level.INFO, "Could not register " + codeNameBase, x);
            }
        }
    }

    public JaveleonModule(ModuleManager mgr, File jar, Object history, Events ev) throws IOException {
        super(mgr, ev, jar, history, true, false, false);
        this.setEnabled(true);
    }

    @Override
    protected ClassLoader createNewClassLoader(List<File> classp, List<ClassLoader> parents) {
        ClassLoader cl = super.createNewClassLoader(classp, parents);
        currentClassLoaders.put(this.getCodeNameBase(), cl);
        return cl;
    }

    @Override
    public void classLoaderUp(Set<Module> parents) throws IOException {
        super.classLoaderUp(parents);
    }

    @Override
    protected ClassLoader getParentLoader(Module parent) {
        if (currentClassLoaders.containsKey(parent.getCodeNameBase())) {
            return currentClassLoaders.get(parent.getCodeNameBase());
        }
        return parent.getClassLoader();
    }

    @Override
    public String toString() {
        return "Javeleon module " + this.getJarFile().toString();
    }

    @Override
    protected void classLoaderDown() {
    }

    @Override
    public final void reload() throws IOException {
    }

    @Override
    protected void cleanup() {
    }

    @Override
    public void destroy() {
    }

    static {
        Method _incrementGlobalId = null;
        Method _registerClassLoader = null;
        try {
            _incrementGlobalId = Class.forName("org.javeleon.reload.ReloadModule").getDeclaredMethod("incrementGlobalId", new Class[0]);
            _registerClassLoader = Class.forName("org.javeleon.reload.ReloadFacade").getDeclaredMethod("registerClassLoader", ClassLoader.class, String.class);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (Exception x) {
            LOG.log(Level.INFO, "Could not load Javeleon integration", x);
        }
        isJaveleonPresent = _incrementGlobalId != null && _registerClassLoader != null;
        incrementGlobalId = _incrementGlobalId;
        registerClassLoader = _registerClassLoader;
        currentClassLoaders = new HashMap();
    }
}

