/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Future;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.downloadtasks.DownloadTaskList;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.layer.gpx.DownloadAlongPanel;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.progress.swing.PleaseWaitProgressMonitor;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;

public abstract class DownloadAlongAction
extends JosmAction {
    protected abstract PleaseWaitRunnable createTask();

    protected DownloadAlongAction(String name, String iconName, String tooltip, Shortcut shortcut, boolean registerInToolbar) {
        super(name, iconName, tooltip, shortcut, registerInToolbar);
    }

    protected static void addToDownload(Area a, Rectangle2D r, Collection<Rectangle2D> results, double maxArea) {
        Area tmp = new Area(r);
        tmp.intersect(a);
        if (tmp.isEmpty()) {
            return;
        }
        Rectangle2D bounds = tmp.getBounds2D();
        if (bounds.getWidth() * bounds.getHeight() > maxArea) {
            Rectangle2D.Double r2;
            Rectangle2D.Double r1;
            if (bounds.getWidth() > bounds.getHeight()) {
                r1 = new Rectangle2D.Double(bounds.getX(), bounds.getY(), bounds.getWidth() / 2.0, bounds.getHeight());
                r2 = new Rectangle2D.Double(bounds.getX() + bounds.getWidth() / 2.0, bounds.getY(), bounds.getWidth() / 2.0, bounds.getHeight());
            } else {
                r1 = new Rectangle2D.Double(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight() / 2.0);
                r2 = new Rectangle2D.Double(bounds.getX(), bounds.getY() + bounds.getHeight() / 2.0, bounds.getWidth(), bounds.getHeight() / 2.0);
            }
            DownloadAlongAction.addToDownload(tmp, r1, results, maxArea);
            DownloadAlongAction.addToDownload(tmp, r2, results, maxArea);
        } else {
            DataSet ds = MainApplication.getLayerManager().getEditDataSet();
            if (ds != null) {
                double p = 1.0E-7;
                LatLon min = new LatLon(bounds.getY() + p, bounds.getX() + p);
                LatLon max = new LatLon(bounds.getY() + bounds.getHeight() - p, bounds.getX() + bounds.getWidth() - p);
                if (ds.getDataSourceBounds().stream().anyMatch(current -> current.contains(min) && current.contains(max))) {
                    return;
                }
            }
            results.add(bounds);
        }
    }

    protected static void confirmAndDownloadAreas(Area a, double maxArea, boolean osmDownload, boolean gpxDownload, String title, boolean newLayer) {
        ArrayList<Rectangle2D> toDownload = new ArrayList<Rectangle2D>();
        DownloadAlongAction.addToDownload(a, a.getBounds(), toDownload, maxArea);
        if (toDownload.isEmpty()) {
            return;
        }
        if (toDownload.size() > 1) {
            JPanel msg = new JPanel(new GridBagLayout());
            msg.add((Component)new JLabel(I18n.trn("<html>This action will require {0} individual<br>download request. Do you wish<br>to continue?</html>", "<html>This action will require {0} individual<br>download requests. Do you wish<br>to continue?</html>", toDownload.size(), toDownload.size())), GBC.eol());
            if (!GraphicsEnvironment.isHeadless() && 0 != JOptionPane.showConfirmDialog(MainApplication.getMainFrame(), msg, title, 2, -1)) {
                return;
            }
        }
        PleaseWaitProgressMonitor monitor = new PleaseWaitProgressMonitor(I18n.tr("Download data", new Object[0]));
        Future<?> future = new DownloadTaskList(Config.getPref().getBoolean("download.along.zoom-after-download")).download(newLayer, (List<Rectangle2D>)toDownload, osmDownload, gpxDownload, (ProgressMonitor)monitor);
        DownloadAlongAction.waitFuture(future, monitor);
    }

    protected static Collection<LatLon> calcBetweenPoints(LatLon p1, LatLon p2, double bufferDist) {
        ArrayList<LatLon> intermediateNodes = new ArrayList<LatLon>();
        intermediateNodes.add(p2);
        if (p1 != null && p2.greatCircleDistance(p1) > bufferDist) {
            double d = p2.greatCircleDistance(p1) / bufferDist;
            int nbNodes = (int)d;
            if (Logging.isDebugEnabled()) {
                Logging.debug(MessageFormat.format("{0} intermediate nodes to download between {1} and {2}", nbNodes, p2, p1));
            }
            double latStep = (p2.lat() - p1.lat()) / (double)(nbNodes + 1);
            double lonStep = (p2.lon() - p1.lon()) / (double)(nbNodes + 1);
            for (int i = 1; i <= nbNodes; ++i) {
                LatLon intermediate = new LatLon(p1.lat() + (double)i * latStep, p1.lon() + (double)i * lonStep);
                intermediateNodes.add(intermediate);
                if (!Logging.isTraceEnabled()) continue;
                Logging.trace(I18n.tr("  adding {0} {1}", intermediate.lat(), intermediate.lon()));
            }
        }
        return intermediateNodes;
    }

    protected PleaseWaitRunnable createCalcTask(final Path2D alongPath, final DownloadAlongPanel panel, final String confirmTitle, boolean newLayer) {
        double latsum = 0.0;
        int latcnt = 0;
        PathIterator pit = alongPath.getPathIterator(null);
        double[] res = new double[6];
        while (!pit.isDone()) {
            int type = pit.currentSegment(res);
            if (type == 1 || type == 0) {
                latsum += res[1];
                ++latcnt;
            }
            pit.next();
        }
        if (latcnt == 0) {
            return null;
        }
        double avglat = latsum / (double)latcnt;
        double scale = Math.cos(Utils.toRadians(avglat));
        final double bufferDist = panel.getDistance();
        final double maxArea = panel.getArea() / 10000.0 / scale;
        final double bufferY = bufferDist / 100000.0;
        final double bufferX = bufferY / scale;
        final int totalTicks = latcnt;
        final boolean displayProgress = totalTicks > 20000 && bufferY < 0.01;
        class CalculateDownloadArea
        extends PleaseWaitRunnable {
            private final Path2D downloadPath;
            private final boolean newLayer;
            private boolean cancel;
            private int ticks;
            private final Rectangle2D r;

            CalculateDownloadArea(boolean newLayer) {
                super(I18n.tr("Calculating Download Area", new Object[0]), bl ? null : NullProgressMonitor.INSTANCE, false);
                this.downloadPath = new Path2D.Double();
                this.r = new Rectangle2D.Double();
                this.newLayer = newLayer;
            }

            @Override
            protected void cancel() {
                this.cancel = true;
            }

            @Override
            protected void finish() {
            }

            @Override
            protected void afterFinish() {
                if (this.cancel) {
                    return;
                }
                DownloadAlongAction.confirmAndDownloadAreas(new Area(this.downloadPath), maxArea, panel.isDownloadOsmData(), panel.isDownloadGpxData(), confirmTitle, this.newLayer);
            }

            private void tick() {
                ++this.ticks;
                if (this.ticks % 100 == 0) {
                    this.progressMonitor.worked(100);
                }
            }

            private void calcAreaForWayPoint(LatLon c) {
                this.r.setRect(c.lon() - bufferX, c.lat() - bufferY, 2.0 * bufferX, 2.0 * bufferY);
                this.downloadPath.append(this.r, false);
            }

            @Override
            protected void realRun() {
                this.progressMonitor.setTicksCount(totalTicks);
                PathIterator pit = alongPath.getPathIterator(null);
                double[] res = new double[6];
                LatLon previous = null;
                while (!pit.isDone()) {
                    int type = pit.currentSegment(res);
                    LatLon c = new LatLon(res[1], res[0]);
                    if (type == 1) {
                        this.tick();
                        for (LatLon d : DownloadAlongAction.calcBetweenPoints(previous, c, bufferDist)) {
                            this.calcAreaForWayPoint(d);
                        }
                        previous = c;
                    } else if (type == 0) {
                        previous = c;
                        this.tick();
                        this.calcAreaForWayPoint(c);
                    }
                    pit.next();
                }
            }
        }
        return new CalculateDownloadArea(newLayer);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        PleaseWaitRunnable task = this.createTask();
        if (task != null) {
            MainApplication.worker.submit(task);
        }
    }
}

