/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.awt.geom.Line2D;
import java.util.Objects;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Way;

public final class WaySegment
implements Comparable<WaySegment> {
    public final Way way;
    public final int lowerIndex;

    public WaySegment(Way w, int i) {
        this.way = w;
        this.lowerIndex = i;
        if (i < 0 || i >= w.getNodesCount() - 1) {
            throw new IllegalArgumentException(this.toString());
        }
    }

    public Node getFirstNode() {
        return this.way.getNode(this.lowerIndex);
    }

    public Node getSecondNode() {
        return this.way.getNode(this.lowerIndex + 1);
    }

    public static WaySegment forNodePair(Way way, Node first, Node second) {
        for (int endIndex = way.getNodesCount() - 1; endIndex > 0; --endIndex) {
            int indexOfFirst = way.getNodes().subList(0, endIndex).lastIndexOf(first);
            if (!second.equals(way.getNode(indexOfFirst + 1))) continue;
            return new WaySegment(way, indexOfFirst);
        }
        throw new IllegalArgumentException("Node pair is not part of way!");
    }

    public Way toWay() {
        Way w = new Way();
        w.addNode(this.getFirstNode());
        w.addNode(this.getSecondNode());
        return w;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WaySegment that = (WaySegment)o;
        return this.lowerIndex == that.lowerIndex && Objects.equals(this.way, that.way);
    }

    public int hashCode() {
        return Objects.hash(this.way, this.lowerIndex);
    }

    @Override
    public int compareTo(WaySegment o) {
        return o == null ? -1 : (this.equals(o) ? 0 : this.toWay().compareTo(o.toWay()));
    }

    public boolean intersects(WaySegment s2) {
        if (this.getFirstNode().equals(s2.getFirstNode()) || this.getSecondNode().equals(s2.getSecondNode()) || this.getFirstNode().equals(s2.getSecondNode()) || this.getSecondNode().equals(s2.getFirstNode())) {
            return false;
        }
        return Line2D.linesIntersect(this.getFirstNode().getEastNorth().east(), this.getFirstNode().getEastNorth().north(), this.getSecondNode().getEastNorth().east(), this.getSecondNode().getEastNorth().north(), s2.getFirstNode().getEastNorth().east(), s2.getFirstNode().getEastNorth().north(), s2.getSecondNode().getEastNorth().east(), s2.getSecondNode().getEastNorth().north());
    }

    public boolean isSimilar(WaySegment s2) {
        return this.getFirstNode().equals(s2.getFirstNode()) && this.getSecondNode().equals(s2.getSecondNode()) || this.getFirstNode().equals(s2.getSecondNode()) && this.getSecondNode().equals(s2.getFirstNode());
    }

    public String toString() {
        return "WaySegment [way=" + this.way.getUniqueId() + ", lowerIndex=" + this.lowerIndex + ']';
    }
}

