/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.providers;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0006\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH&J\u0016\u0010\n\u001a\u0004\u0018\u00010\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rH&J\u0016\u0010\u000e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000f2\u0006\u0010\b\u001a\u00020\tH&J\u0014\u0010\u0010\u001a\u00020\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0016J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\tH&J\u0016\u0010\u0012\u001a\u0004\u0018\u00010\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0011\u001a\u00020\tH&J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00142\u0006\u0010\u0011\u001a\u00020\u0015H&J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0011\u001a\u00020\u0015H\u0016J\"\u0010\u0017\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r0\u00142\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aH&R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0005\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/providers/FirProvider;", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "()V", "isPhasedFirAllowed", "", "()Z", "getClassLikeSymbolByFqName", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "getFirCallableContainerFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "getFirClassifierByFqName", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "getFirClassifierContainerFile", "fqName", "getFirClassifierContainerFileIfAny", "getFirFilesByPackage", "", "Lorg/jetbrains/kotlin/name/FqName;", "getPackage", "getTopLevelCallableSymbols", "packageFqName", "name", "Lorg/jetbrains/kotlin/name/Name;", "resolve"})
public abstract class FirProvider
extends FirSymbolProvider {
    public boolean isPhasedFirAllowed() {
        return false;
    }

    @Nullable
    public abstract FirClassLikeDeclaration<?> getFirClassifierByFqName(@NotNull ClassId var1);

    @Override
    @Nullable
    public abstract FirClassLikeSymbol<?> getClassLikeSymbolByFqName(@NotNull ClassId var1);

    @Override
    @NotNull
    public abstract List<FirCallableSymbol<?>> getTopLevelCallableSymbols(@NotNull FqName var1, @NotNull Name var2);

    @Override
    @Nullable
    public FqName getPackage(@NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter(fqName2, "fqName");
        Collection collection = this.getFirFilesByPackage(fqName2);
        boolean bl = false;
        if (!collection.isEmpty()) {
            return fqName2;
        }
        return null;
    }

    @NotNull
    public abstract FirFile getFirClassifierContainerFile(@NotNull ClassId var1);

    @Nullable
    public abstract FirFile getFirClassifierContainerFileIfAny(@NotNull ClassId var1);

    @NotNull
    public FirFile getFirClassifierContainerFile(@NotNull FirClassLikeSymbol<?> symbol2) {
        Intrinsics.checkNotNullParameter(symbol2, "symbol");
        return this.getFirClassifierContainerFile(symbol2.getClassId());
    }

    @Nullable
    public FirFile getFirClassifierContainerFileIfAny(@NotNull FirClassLikeSymbol<?> symbol2) {
        Intrinsics.checkNotNullParameter(symbol2, "symbol");
        return this.getFirClassifierContainerFileIfAny(symbol2.getClassId());
    }

    @Nullable
    public abstract FirFile getFirCallableContainerFile(@NotNull FirCallableSymbol<?> var1);

    @NotNull
    public abstract List<FirFile> getFirFilesByPackage(@NotNull FqName var1);
}

