/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.SystemInfo;
import oshi.annotation.concurrent.NotThreadSafe;
import oshi.hardware.HWPartition;
import oshi.hardware.platform.linux.LinuxDisks;
import oshi.hardware.platform.mac.MacDisks;
import oshi.hardware.platform.unix.freebsd.FreeBsdDisks;
import oshi.hardware.platform.unix.solaris.SolarisDisks;
import oshi.hardware.platform.windows.WindowsDisks;
import oshi.util.FormatUtil;

@NotThreadSafe
public class HWDiskStore
implements Comparable<HWDiskStore> {
    private static final Logger LOG = LoggerFactory.getLogger(HWDiskStore.class);
    private String model = "";
    private String name = "";
    private String serial = "";
    private long size = 0L;
    private long reads = 0L;
    private long readBytes = 0L;
    private long writes = 0L;
    private long writeBytes = 0L;
    private long currentQueueLength = 0L;
    private long transferTime = 0L;
    private HWPartition[] partitions = new HWPartition[0];
    private long timeStamp = 0L;

    public HWDiskStore() {
    }

    public HWDiskStore(HWDiskStore diskStore) {
        HWPartition[] partsOrig = diskStore.getPartitions();
        HWPartition[] partsCopy = new HWPartition[partsOrig.length];
        for (int i = 0; i < partsOrig.length; ++i) {
            partsCopy[i] = new HWPartition(partsOrig[i].getIdentification(), partsOrig[i].getName(), partsOrig[i].getType(), partsOrig[i].getUuid(), partsOrig[i].getSize(), partsOrig[i].getMajor(), partsOrig[i].getMinor(), partsOrig[i].getMountPoint());
        }
        this.name = diskStore.name;
        this.model = diskStore.model;
        this.serial = diskStore.serial;
        this.size = diskStore.size;
        this.reads = diskStore.reads;
        this.readBytes = diskStore.readBytes;
        this.writes = diskStore.writes;
        this.writeBytes = diskStore.writeBytes;
        this.currentQueueLength = diskStore.currentQueueLength;
        this.transferTime = diskStore.transferTime;
        this.partitions = partsCopy;
        this.timeStamp = diskStore.timeStamp;
    }

    public boolean updateAtrributes() {
        switch (SystemInfo.getCurrentPlatformEnum()) {
            case WINDOWS: {
                return WindowsDisks.updateDiskStats(this);
            }
            case LINUX: {
                return LinuxDisks.updateDiskStats(this);
            }
            case MACOSX: {
                return MacDisks.updateDiskStats(this);
            }
            case SOLARIS: {
                return SolarisDisks.updateDiskStats(this);
            }
            case FREEBSD: {
                return FreeBsdDisks.updateDiskStats(this);
            }
        }
        LOG.error("Unsupported platform. No update performed.");
        return false;
    }

    public String getName() {
        return this.name;
    }

    public String getModel() {
        return this.model;
    }

    public String getSerial() {
        return this.serial;
    }

    public long getSize() {
        return this.size;
    }

    public long getReads() {
        return this.reads;
    }

    public long getReadBytes() {
        return this.readBytes;
    }

    public long getWrites() {
        return this.writes;
    }

    public long getWriteBytes() {
        return this.writeBytes;
    }

    public long getCurrentQueueLength() {
        return this.currentQueueLength;
    }

    public long getTransferTime() {
        return this.transferTime;
    }

    public HWPartition[] getPartitions() {
        return this.partitions;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void setName(String name) {
        this.name = name == null ? "" : name;
    }

    public void setModel(String model) {
        this.model = model == null ? "" : model;
    }

    public void setSerial(String serial) {
        this.serial = serial == null ? "" : serial;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public void setReads(long reads) {
        this.reads = reads;
    }

    public void setReadBytes(long readBytes) {
        this.readBytes = readBytes;
    }

    public void setWrites(long writes) {
        this.writes = writes;
    }

    public void setWriteBytes(long writeBytes) {
        this.writeBytes = writeBytes;
    }

    public void setCurrentQueueLength(long currentQueueLength) {
        this.currentQueueLength = currentQueueLength;
    }

    public void setTransferTime(long transferTime) {
        this.transferTime = transferTime;
    }

    public void setPartitions(HWPartition[] partitions) {
        this.partitions = partitions;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    @Override
    public int compareTo(HWDiskStore store) {
        return this.getName().compareTo(store.getName());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.model == null ? 0 : this.model.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.serial == null ? 0 : this.serial.hashCode());
        result = 31 * result + (int)(this.size ^ this.size >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        HWDiskStore other = (HWDiskStore)obj;
        if (this.model == null ? other.model != null : !this.model.equals(other.model)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.serial == null ? other.serial != null : !this.serial.equals(other.serial)) {
            return false;
        }
        return this.size == other.size;
    }

    public String toString() {
        boolean readwrite = this.getReads() > 0L || this.getWrites() > 0L;
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName()).append(": ");
        sb.append("(model: ").append(this.getModel());
        sb.append(" - S/N: ").append(this.getSerial()).append(") ");
        sb.append("size: ").append(this.getSize() > 0L ? FormatUtil.formatBytesDecimal(this.getSize()) : "?").append(", ");
        sb.append("reads: ").append(readwrite ? Long.valueOf(this.getReads()) : "?");
        sb.append(" (").append(readwrite ? FormatUtil.formatBytes(this.getReadBytes()) : "?").append("), ");
        sb.append("writes: ").append(readwrite ? Long.valueOf(this.getWrites()) : "?");
        sb.append(" (").append(readwrite ? FormatUtil.formatBytes(this.getWriteBytes()) : "?").append("), ");
        sb.append("xfer: ").append(readwrite ? Long.valueOf(this.getTransferTime()) : "?");
        return sb.toString();
    }
}

