/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.unix.freebsd;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.software.common.AbstractFileSystem;
import oshi.software.os.OSFileStore;
import oshi.util.ExecutingCommand;
import oshi.util.ParseUtil;
import oshi.util.platform.unix.freebsd.BsdSysctlUtil;

@ThreadSafe
public final class FreeBsdFileSystem
extends AbstractFileSystem {
    private static final List<String> TMP_FS_PATHS = Arrays.asList("/system", "/tmp", "/dev/fd");

    @Override
    public OSFileStore[] getFileStores(boolean localOnly) {
        String[] split;
        HashMap<String, String> uuidMap = new HashMap<String, String>();
        String device = "";
        for (String line : ExecutingCommand.runNative("geom part list")) {
            if (line.contains("Name: ")) {
                device = line.substring(line.lastIndexOf(32) + 1);
            }
            if (device.isEmpty() || !(line = line.trim()).startsWith("rawuuid:")) continue;
            uuidMap.put(device, line.substring(line.lastIndexOf(32) + 1));
            device = "";
        }
        ArrayList<OSFileStore> fsList = new ArrayList<OSFileStore>();
        HashMap<String, Long> inodeFreeMap = new HashMap<String, Long>();
        HashMap<String, Long> inodeTotalMap = new HashMap<String, Long>();
        for (String line : ExecutingCommand.runNative("df -i")) {
            if (!line.startsWith("/") || (split = ParseUtil.whitespaces.split(line)).length <= 7) continue;
            inodeFreeMap.put(split[0], ParseUtil.parseLongOrDefault(split[6], 0L));
            inodeTotalMap.put(split[0], (Long)inodeFreeMap.get(split[0]) + ParseUtil.parseLongOrDefault(split[5], 0L));
        }
        for (String fs : ExecutingCommand.runNative("mount -p")) {
            split = ParseUtil.whitespaces.split(fs);
            if (split.length < 5) continue;
            String volume = split[0];
            String path = split[1];
            String type = split[2];
            String options = split[3];
            if (localOnly && NETWORK_FS_TYPES.contains(type) || PSEUDO_FS_TYPES.contains(type) || path.equals("/dev") || ParseUtil.filePathStartsWith(TMP_FS_PATHS, path) || volume.startsWith("rpool") && !path.equals("/")) continue;
            String name = path.substring(path.lastIndexOf(47) + 1);
            if (name.isEmpty()) {
                name = volume.substring(volume.lastIndexOf(47) + 1);
            }
            File f = new File(path);
            long totalSpace = f.getTotalSpace();
            long usableSpace = f.getUsableSpace();
            long freeSpace = f.getFreeSpace();
            String description = volume.startsWith("/dev") || path.equals("/") ? "Local Disk" : (volume.equals("tmpfs") ? "Ram Disk" : (NETWORK_FS_TYPES.contains(type) ? "Network Disk" : "Mount Point"));
            String uuid = uuidMap.getOrDefault(name, "");
            OSFileStore osStore = new OSFileStore();
            osStore.setName(name);
            osStore.setVolume(volume);
            osStore.setLabel(name);
            osStore.setMount(path);
            osStore.setDescription(description);
            osStore.setType(type);
            osStore.setOptions(options);
            osStore.setUUID(uuid);
            osStore.setFreeSpace(freeSpace);
            osStore.setUsableSpace(usableSpace);
            osStore.setTotalSpace(totalSpace);
            osStore.setFreeInodes(inodeFreeMap.containsKey(path) ? (Long)inodeFreeMap.get(path) : 0L);
            osStore.setTotalInodes(inodeTotalMap.containsKey(path) ? (Long)inodeTotalMap.get(path) : 0L);
            fsList.add(osStore);
        }
        return fsList.toArray(new OSFileStore[0]);
    }

    @Override
    public long getOpenFileDescriptors() {
        return BsdSysctlUtil.sysctl("kern.openfiles", 0);
    }

    @Override
    public long getMaxFileDescriptors() {
        return BsdSysctlUtil.sysctl("kern.maxfiles", 0);
    }

    public static boolean updateFileStoreStats(OSFileStore osFileStore) {
        for (OSFileStore fileStore : new FreeBsdFileSystem().getFileStores()) {
            if (!osFileStore.getName().equals(fileStore.getName()) || !osFileStore.getVolume().equals(fileStore.getVolume()) || !osFileStore.getMount().equals(fileStore.getMount())) continue;
            osFileStore.setLogicalVolume(fileStore.getLogicalVolume());
            osFileStore.setDescription(fileStore.getDescription());
            osFileStore.setType(fileStore.getType());
            osFileStore.setUUID(fileStore.getUUID());
            osFileStore.setFreeSpace(fileStore.getFreeSpace());
            osFileStore.setUsableSpace(fileStore.getUsableSpace());
            osFileStore.setTotalSpace(fileStore.getTotalSpace());
            osFileStore.setFreeInodes(fileStore.getFreeInodes());
            osFileStore.setTotalInodes(fileStore.getTotalInodes());
            return true;
        }
        return false;
    }
}

