/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.SkinParam;
import net.sourceforge.plantuml.TitledDiagram;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOptional;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;

public class CommandFooter
extends SingleLineCommand2<TitledDiagram> {
    public CommandFooter() {
        super(CommandFooter.getRegexConcat());
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandFooter.class.getName(), RegexLeaf.start(), new RegexOptional((IRegex)new RegexLeaf("POSITION", "(left|right|center)")), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("footer"), new RegexOr(new RegexConcat(RegexLeaf.spaceZeroOrMore(), new RegexLeaf(":"), RegexLeaf.spaceZeroOrMore()), RegexLeaf.spaceOneOrMore()), new RegexLeaf("LABEL", "(.*[\\p{L}0-9_.].*)"), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(TitledDiagram diagram, LineLocation location, RegexResult arg) {
        String align = arg.get("POSITION", 0);
        HorizontalAlignment ha = HorizontalAlignment.fromString(align, HorizontalAlignment.CENTER);
        if (SkinParam.USE_STYLES() && align == null) {
            ha = FontParam.FOOTER.getStyleDefinition(null).getMergedStyle(diagram.getCurrentStyleBuilder()).getHorizontalAlignment();
        }
        diagram.getFooter().putDisplay(Display.getWithNewlines(arg.get("LABEL", 0)), ha);
        return CommandExecutionResult.ok();
    }
}

