/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graph;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import net.sourceforge.plantuml.graph.ALink;
import net.sourceforge.plantuml.graph.ANode;
import net.sourceforge.plantuml.graph.Board;

public class Graph1 {
    private final Board board;
    private final int widthCell = 40;
    private final int heightCell = 40;

    public Graph1(Board board) {
        this.board = board;
    }

    public BufferedImage createBufferedImage() {
        BufferedImage im = new BufferedImage(600, 600, 1);
        Graphics2D g2d = im.createGraphics();
        g2d.setColor(Color.WHITE);
        g2d.fillRect(0, 0, im.getWidth(), im.getHeight());
        g2d.setColor(Color.BLACK);
        for (ANode aNode : this.board.getNodes()) {
            int x = this.board.getCol(aNode) * 40;
            int y = aNode.getRow() * 40;
            g2d.drawString(aNode.getCode(), x + 5, y + 20 - 5);
            g2d.drawOval(x, y, 20, 20);
        }
        for (ALink aLink : this.board.getLinks()) {
            ANode n1 = aLink.getNode1();
            ANode n2 = aLink.getNode2();
            int x1 = 10 + this.board.getCol(n1) * 40;
            int y1 = 10 + n1.getRow() * 40;
            int x2 = 10 + this.board.getCol(n2) * 40;
            int y2 = 10 + n2.getRow() * 40;
            g2d.drawLine(x1, y1, x2, y2);
        }
        return im;
    }
}

