/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.core2;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.project.core2.Hole;
import net.sourceforge.plantuml.project.core2.HolesList;
import net.sourceforge.plantuml.project.time.DayOfWeek;

public class Slice {
    private final long start;
    private final long end;
    private final int workLoad;

    public Slice(long start, long end, int workLoad) {
        if (end <= start) {
            throw new IllegalArgumentException();
        }
        this.start = start;
        this.end = end;
        this.workLoad = workLoad;
    }

    public String toString() {
        return DayOfWeek.timeToString(this.start) + " --> " + DayOfWeek.timeToString(this.end) + " <" + this.workLoad + ">";
    }

    public boolean containsTime(long time) {
        return time >= this.start && time <= this.end;
    }

    public final long getStart() {
        return this.start;
    }

    public final long getEnd() {
        return this.end;
    }

    public final int getWorkLoad() {
        return this.workLoad;
    }

    public List<Slice> intersectWith(HolesList holes) {
        ArrayList<Slice> result = new ArrayList<Slice>();
        for (Hole hole : holes.negate()) {
            Slice inter = this.intersectWith(hole);
            if (inter == null) continue;
            result.add(inter);
        }
        return Collections.unmodifiableList(result);
    }

    private Slice intersectWith(Hole hole) {
        long newStart = Math.max(this.start, hole.getStart());
        long newEnd = Math.min(this.end, hole.getEnd());
        if (newEnd <= newStart) {
            return null;
        }
        return new Slice(newStart, newEnd, this.workLoad);
    }
}

