/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.version;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.OptionPrint;
import net.sourceforge.plantuml.Run;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.cucadiagram.dot.GraphvizUtils;
import net.sourceforge.plantuml.dedication.Dedication;
import net.sourceforge.plantuml.graphic.GraphicPosition;
import net.sourceforge.plantuml.graphic.GraphicStrings;
import net.sourceforge.plantuml.preproc.ImportedFiles;
import net.sourceforge.plantuml.preproc.Stdlib;
import net.sourceforge.plantuml.preproc2.PreprocessorUtils;
import net.sourceforge.plantuml.security.ImageIO;
import net.sourceforge.plantuml.security.SFile;
import net.sourceforge.plantuml.security.SecurityProfile;
import net.sourceforge.plantuml.security.SecurityUtils;
import net.sourceforge.plantuml.svek.GraphvizCrash;
import net.sourceforge.plantuml.svek.TextBlockBackcolored;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;
import net.sourceforge.plantuml.ugraphic.color.ColorMapperIdentity;
import net.sourceforge.plantuml.version.License;
import net.sourceforge.plantuml.version.LicenseInfo;
import net.sourceforge.plantuml.version.Version;

public class PSystemVersion
extends AbstractPSystem {
    private final List<String> strings = new ArrayList<String>();
    private BufferedImage image;
    private static BufferedImage transparentIcon;

    PSystemVersion(boolean withImage, List<String> args) {
        this.strings.addAll(args);
        if (withImage) {
            this.image = PSystemVersion.getPlantumlImage();
        }
    }

    private PSystemVersion(List<String> args, BufferedImage image) {
        this.strings.addAll(args);
        this.image = image;
    }

    public static BufferedImage getPlantumlImage() {
        return PSystemVersion.getImage("logo.png");
    }

    public static BufferedImage getCharlieImage() {
        return PSystemVersion.getImage("charlie.png");
    }

    public static BufferedImage getTime01() {
        return PSystemVersion.getImage("time01.png");
    }

    public static BufferedImage getTime15() {
        return PSystemVersion.getImage("time15.png");
    }

    public static BufferedImage getPlantumlSmallIcon() {
        return PSystemVersion.getImage("favicon.png");
    }

    public static BufferedImage getArecibo() {
        return PSystemVersion.getImage("arecibo.png");
    }

    public static BufferedImage getDotc() {
        return PSystemVersion.getImage("dotc.png");
    }

    public static BufferedImage getApple2Image() {
        return PSystemVersion.getImageWebp("apple2.png");
    }

    private static BufferedImage getImage(String name) {
        try {
            InputStream is = PSystemVersion.class.getResourceAsStream(name);
            BufferedImage image = ImageIO.read(is);
            is.close();
            return image;
        }
        catch (IOException e) {
            e.printStackTrace();
            return new BufferedImage(10, 10, 2);
        }
    }

    private static BufferedImage getImageWebp(String name) {
        try {
            InputStream is = PSystemVersion.class.getResourceAsStream(name);
            BufferedImage image = Dedication.getBufferedImage(is);
            is.close();
            return image;
        }
        catch (IOException e) {
            e.printStackTrace();
            return new BufferedImage(10, 10, 2);
        }
    }

    public static BufferedImage getPlantumlSmallIcon2() {
        if (transparentIcon != null) {
            return transparentIcon;
        }
        BufferedImage ico = PSystemVersion.getPlantumlSmallIcon();
        if (ico == null) {
            return new BufferedImage(10, 10, 2);
        }
        transparentIcon = new BufferedImage(ico.getWidth(), ico.getHeight(), 3);
        for (int i = 0; i < ico.getWidth(); ++i) {
            for (int j = 0; j < ico.getHeight(); ++j) {
                int col = ico.getRGB(i, j);
                if (col == ico.getRGB(0, 0)) continue;
                transparentIcon.setRGB(i, j, col);
            }
        }
        return transparentIcon;
    }

    @Override
    protected final ImageData exportDiagramNow(OutputStream os, int num, FileFormatOption fileFormat, long seed) throws IOException {
        TextBlockBackcolored result = GraphicStrings.createBlackOnWhite(this.strings, this.image, GraphicPosition.BACKGROUND_CORNER_BOTTOM_RIGHT);
        ImageBuilder imageBuilder = ImageBuilder.buildA(new ColorMapperIdentity(), false, null, this.getMetadata(), null, 1.0, result.getBackcolor());
        imageBuilder.setUDrawable(result);
        return imageBuilder.writeImageTOBEMOVED(fileFormat, seed, os);
    }

    public static PSystemVersion createShowVersion() {
        ArrayList<String> strings = new ArrayList<String>();
        strings.add("<b>PlantUML version " + Version.versionString() + "</b> (" + Version.compileTimeString() + ")");
        strings.add("(" + (Object)((Object)License.getCurrent()) + " source distribution)");
        GraphvizCrash.checkOldVersionWarning(strings);
        if (OptionFlags.ALLOW_INCLUDE) {
            if (SecurityUtils.getSecurityProfile() == SecurityProfile.UNSECURE) {
                strings.add("Loaded from " + Version.getJarPath());
            }
            if (OptionFlags.getInstance().isWord()) {
                strings.add("Word Mode");
                strings.add("Command Line: " + Run.getCommandLine());
                strings.add("Current Dir: " + new SFile(".").getAbsolutePath());
                strings.add("plantuml.include.path: " + PreprocessorUtils.getenv("plantuml.include.path"));
            }
        }
        strings.add(" ");
        GraphvizUtils.addDotStatus(strings, true);
        strings.add(" ");
        for (String name : OptionPrint.interestingProperties()) {
            strings.add(name);
        }
        for (String v : OptionPrint.interestingValues()) {
            strings.add(v);
        }
        return new PSystemVersion(true, strings);
    }

    public static PSystemVersion createStdLib() {
        ArrayList<String> strings = new ArrayList<String>();
        Stdlib.addInfoVersion(strings, true);
        strings.add(" ");
        return new PSystemVersion(true, strings);
    }

    public static PSystemVersion createShowAuthors() {
        List<String> strings = PSystemVersion.getAuthorsStrings(true);
        return new PSystemVersion(true, strings);
    }

    public static List<String> getAuthorsStrings(boolean withTag) {
        ArrayList<String> strings = new ArrayList<String>();
        PSystemVersion.add(strings, "<b>PlantUML version " + Version.versionString() + "</b> (" + Version.compileTimeString() + ")", withTag);
        PSystemVersion.add(strings, "(" + (Object)((Object)License.getCurrent()) + " source distribution)", withTag);
        PSystemVersion.add(strings, " ", withTag);
        PSystemVersion.add(strings, "<u>Original idea</u>: Arnaud Roques", withTag);
        PSystemVersion.add(strings, "<u>Word Macro</u>: Alain Bertucat & Matthieu Sabatier", withTag);
        PSystemVersion.add(strings, "<u>Word Add-in</u>: Adriaan van den Brand", withTag);
        PSystemVersion.add(strings, "<u>J2V8 & viz.js integration</u>: Andreas Studer", withTag);
        PSystemVersion.add(strings, "<u>Official Eclipse Plugin</u>: Hallvard Tr\u00e6tteberg", withTag);
        PSystemVersion.add(strings, "<u>Original Eclipse Plugin</u>: Claude Durif & Anne Pecoil", withTag);
        PSystemVersion.add(strings, "<u>Servlet & XWiki</u>: Maxime Sinclair", withTag);
        PSystemVersion.add(strings, "<u>Docker</u>: David Ducatel", withTag);
        PSystemVersion.add(strings, "<u>AWS lib</u>: Chris Passarello", withTag);
        PSystemVersion.add(strings, "<u>Stdlib Icons</u>: tupadr3", withTag);
        PSystemVersion.add(strings, "<u>Site design</u>: Raphael Cotisson", withTag);
        PSystemVersion.add(strings, "<u>Logo</u>: Benjamin Croizet", withTag);
        PSystemVersion.add(strings, " ", withTag);
        PSystemVersion.add(strings, "http://plantuml.com", withTag);
        PSystemVersion.add(strings, " ", withTag);
        return strings;
    }

    private static void add(List<String> result, String s, boolean withTag) {
        if (!withTag) {
            s = s.replaceAll("\\</?\\w+\\>", "");
        }
        result.add(s);
    }

    public static PSystemVersion createTestDot() throws IOException {
        ArrayList<String> strings = new ArrayList<String>();
        strings.add(Version.fullDescription());
        GraphvizUtils.addDotStatus(strings, true);
        return new PSystemVersion(false, strings);
    }

    public static PSystemVersion createDumpStackTrace() throws IOException {
        ArrayList<String> strings = new ArrayList<String>();
        Throwable creationPoint = new Throwable();
        creationPoint.fillInStackTrace();
        for (StackTraceElement ste : creationPoint.getStackTrace()) {
            strings.add(ste.toString());
        }
        return new PSystemVersion(false, strings);
    }

    public static PSystemVersion createKeyDistributor() throws IOException {
        LicenseInfo license = LicenseInfo.retrieveDistributor();
        BufferedImage im = null;
        ArrayList<String> strings = new ArrayList<String>();
        if (license == null) {
            strings.add("No license found");
        } else {
            strings.add(license.getOwner());
            strings.add(license.getContext());
            strings.add(license.getGenerationDate().toString());
            strings.add(license.getExpirationDate().toString());
            im = LicenseInfo.retrieveDistributorImage(license);
        }
        return new PSystemVersion(strings, im);
    }

    public static PSystemVersion createPath() throws IOException {
        ArrayList<String> strings = new ArrayList<String>();
        strings.add("<u>Current Dir</u>: " + new SFile(".").getPrintablePath());
        strings.add(" ");
        strings.add("<u>Default path</u>:");
        for (SFile f : ImportedFiles.createImportedFiles(null).getPath()) {
            strings.add(f.getPrintablePath());
        }
        return new PSystemVersion(true, strings);
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(Version)");
    }

    public List<String> getLines() {
        return Collections.unmodifiableList(this.strings);
    }
}

