/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.IllegalPathStateException;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Stack;
import java.util.Vector;
import java.util.logging.Logger;
import org.freehep.graphicsio.emf.EMFHeader;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.EMFTag;
import org.freehep.graphicsio.emf.gdi.GDIObject;
import org.freehep.util.io.Tag;

public class EMFRenderer {
    private static final Logger logger = Logger.getLogger("org.freehep.graphicsio.emf");
    private EMFHeader header;
    public static double TWIP_SCALE = 0.1763888888888889;
    private GeneralPath figure = null;
    private AffineTransform initialTransform;
    private Point windowOrigin = null;
    private Point viewportOrigin = null;
    private Dimension windowSize = null;
    private Dimension viewportSize = null;
    private boolean mapModeIsotropic = false;
    private AffineTransform mapModeTransform = AffineTransform.getScaleInstance(TWIP_SCALE, TWIP_SCALE);
    private Shape initialClip;
    private Graphics2D g2;
    private GDIObject[] gdiObjects = new GDIObject[256];
    private Paint brushPaint = new Color(0, 0, 0, 0);
    private Paint penPaint = Color.BLACK;
    private Stroke penStroke = new BasicStroke();
    private int textAlignMode = 0;
    private Color textColor = Color.BLACK;
    private int windingRule = 0;
    private int bkMode = 2;
    private boolean useCreatePen = true;
    private int meterLimit = 10;
    private int rop2 = 13;
    private int scaleMode = 4;
    private Point brushOrigin = new Point(0, 0);
    private Vector<Tag> tags = new Vector(0);
    private GeneralPath path = null;
    private AffineTransform pathTransform = new AffineTransform();
    private Stack<DC> dcStack = new Stack();
    private int arcDirection = 1;

    public EMFRenderer(EMFInputStream is) throws IOException {
        Tag tag;
        this.header = is.readHeader();
        while ((tag = is.readTag()) != null) {
            this.tags.add(tag);
        }
        is.close();
    }

    public Dimension getSize() {
        return this.header.getBounds().getSize();
    }

    public void paint(Graphics2D g2) {
        this.g2 = g2;
        Shape clip = g2.getClip();
        AffineTransform at = g2.getTransform();
        RenderingHints hints = g2.getRenderingHints();
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.initialTransform = g2.getTransform();
        this.path = null;
        this.figure = null;
        this.meterLimit = 10;
        this.windingRule = 0;
        this.bkMode = 2;
        this.useCreatePen = true;
        this.scaleMode = 4;
        this.windowOrigin = null;
        this.viewportOrigin = null;
        this.windowSize = null;
        this.viewportSize = null;
        this.mapModeIsotropic = false;
        this.mapModeTransform = AffineTransform.getScaleInstance(TWIP_SCALE, TWIP_SCALE);
        this.resetTransformation(g2);
        this.initialClip = g2.getClip();
        for (int i = 0; i < this.tags.size(); ++i) {
            Tag tag = this.tags.get(i);
            if (tag instanceof EMFTag) {
                ((EMFTag)this.tags.get(i)).render(this);
                continue;
            }
            logger.warning("unknown tag: " + tag);
        }
        g2.setRenderingHints(hints);
        g2.setTransform(at);
        g2.setClip(clip);
    }

    private void resetTransformation(Graphics2D g2) {
        if (this.initialTransform != null) {
            g2.setTransform(this.initialTransform);
        } else {
            g2.setTransform(new AffineTransform());
        }
        if (this.windowOrigin != null) {
            g2.translate(-this.windowOrigin.getX(), -this.windowOrigin.getY());
        }
        if (this.viewportOrigin != null) {
            g2.translate(-this.viewportOrigin.getX(), -this.viewportOrigin.getY());
        }
        if (this.viewportSize != null && this.windowSize != null) {
            double scaleX = this.viewportSize.getWidth() / this.windowSize.getWidth();
            double scaleY = this.viewportSize.getHeight() / this.windowSize.getHeight();
            g2.scale(scaleX, scaleY);
        }
    }

    public void saveDC() {
        DC dc = new DC();
        dc.paint = this.g2.getPaint();
        dc.stroke = this.g2.getStroke();
        dc.transform = this.g2.getTransform();
        dc.pathTransform = this.pathTransform;
        dc.clip = this.g2.getClip();
        dc.path = this.path;
        dc.meterLimit = this.meterLimit;
        dc.windingRule = this.windingRule;
        dc.bkMode = this.bkMode;
        dc.useCreatePen = this.useCreatePen;
        dc.scaleMode = this.scaleMode;
        this.dcStack.push(dc);
    }

    public void retoreDC() {
        if (!this.dcStack.empty()) {
            DC dc = this.dcStack.pop();
            this.meterLimit = dc.meterLimit;
            this.windingRule = dc.windingRule;
            this.path = dc.path;
            this.bkMode = dc.bkMode;
            this.useCreatePen = dc.useCreatePen;
            this.scaleMode = dc.scaleMode;
            this.pathTransform = dc.pathTransform;
            this.g2.setPaint(dc.paint);
            this.g2.setStroke(dc.stroke);
            this.g2.setTransform(dc.transform);
            this.g2.setClip(dc.clip);
        }
    }

    public void closeFigure() {
        if (this.figure == null) {
            return;
        }
        try {
            this.figure.closePath();
            this.appendToPath(this.figure);
            this.figure = null;
        }
        catch (IllegalPathStateException e) {
            logger.warning("no figure to close");
        }
    }

    public void fixViewportSize() {
        if (this.mapModeIsotropic && this.windowSize != null && this.viewportSize != null) {
            this.viewportSize.setSize(this.viewportSize.getWidth(), this.viewportSize.getWidth() * (this.windowSize.getHeight() / this.windowSize.getWidth()));
        }
    }

    private void fillAndDrawOrAppend(Graphics2D g2, Shape s) {
        if (!this.appendToPath(s)) {
            if (this.useCreatePen) {
                if (this.bkMode == 2) {
                    this.fillShape(g2, s);
                } else {
                    this.fillShape(g2, s);
                }
            } else {
                this.fillShape(g2, s);
            }
            this.drawShape(g2, s);
        }
    }

    private void drawOrAppend(Graphics2D g2, Shape s) {
        if (!this.appendToPath(s)) {
            this.drawShape(g2, s);
        }
    }

    public void drawOrAppendText(String text, double x, double y) {
        if (this.path != null) {
            TextLayout tl = new TextLayout(text, this.g2.getFont(), this.g2.getFontRenderContext());
            this.path.append(tl.getOutline(null), false);
        } else {
            this.g2.setPaint(this.textColor);
            this.g2.drawString(text, (int)x, (int)y);
        }
    }

    private boolean appendToPath(Shape s) {
        if (this.path != null) {
            if (this.pathTransform != null) {
                s = this.pathTransform.createTransformedShape(s);
            }
            this.path.append(s, false);
            return true;
        }
        return false;
    }

    public void closePath() {
        if (this.path != null) {
            try {
                this.path.closePath();
            }
            catch (IllegalPathStateException e) {
                logger.warning("no figure to close");
            }
        }
    }

    private void fillShape(Graphics2D g2, Shape s) {
        g2.setPaint(this.brushPaint);
        g2.fill(s);
    }

    private void drawShape(Graphics2D g2, Shape s) {
        g2.setStroke(this.penStroke);
        if (this.rop2 == 1) {
            g2.setComposite(AlphaComposite.SrcOver);
            g2.setPaint(Color.black);
        } else if (this.rop2 == 13) {
            g2.setComposite(AlphaComposite.SrcOver);
            g2.setPaint(this.penPaint);
        } else if (this.rop2 == 11) {
            g2.setComposite(AlphaComposite.SrcOver);
            g2.setPaint(this.penPaint);
        } else if (this.rop2 == 16) {
            g2.setComposite(AlphaComposite.SrcOver);
            g2.setPaint(Color.white);
        } else if (this.rop2 == 4) {
            g2.setComposite(AlphaComposite.SrcOver);
        } else if (this.rop2 == 7) {
            g2.setComposite(AlphaComposite.Xor);
        } else {
            logger.warning("got unsupported ROP" + this.rop2);
        }
        g2.draw(s);
    }

    public void setFont(Font font) {
        this.g2.setFont(font);
    }

    public AffineTransform getTransform() {
        return this.g2.getTransform();
    }

    public void transform(AffineTransform transform) {
        this.g2.transform(transform);
    }

    public void resetTransformation() {
        this.resetTransformation(this.g2);
    }

    public void setTransform(AffineTransform at) {
        this.g2.setTransform(at);
    }

    public void setClip(Shape shape) {
        this.g2.setClip(shape);
    }

    public void clip(Shape shape) {
        this.g2.clip(shape);
    }

    public Shape getClip() {
        return this.g2.getClip();
    }

    public void drawImage(BufferedImage image, AffineTransform transform) {
        this.g2.drawImage(image, transform, null);
    }

    public void drawImage(BufferedImage image, int x, int y, int width, int height) {
        this.g2.drawImage(image, x, y, width, height, null);
    }

    public void drawShape(Shape shape) {
        this.drawShape(this.g2, shape);
    }

    public void fillShape(Shape shape) {
        this.fillShape(this.g2, shape);
    }

    public void fillAndDrawOrAppend(Shape s) {
        this.fillAndDrawOrAppend(this.g2, s);
    }

    public void drawOrAppend(Shape s) {
        this.drawOrAppend(this.g2, s);
    }

    public int getWindingRule() {
        return this.windingRule;
    }

    public GeneralPath getFigure() {
        return this.figure;
    }

    public void setFigure(GeneralPath figure) {
        this.figure = figure;
    }

    public GeneralPath getPath() {
        return this.path;
    }

    public void setPath(GeneralPath path) {
        this.path = path;
    }

    public Shape getInitialClip() {
        return this.initialClip;
    }

    public AffineTransform getPathTransform() {
        return this.pathTransform;
    }

    public void setPathTransform(AffineTransform pathTransform) {
        this.pathTransform = pathTransform;
    }

    public void setWindingRule(int windingRule) {
        this.windingRule = windingRule;
    }

    public void setMapModeIsotropic(boolean mapModeIsotropic) {
        this.mapModeIsotropic = mapModeIsotropic;
    }

    public AffineTransform getMapModeTransform() {
        return this.mapModeTransform;
    }

    public void setMapModeTransform(AffineTransform mapModeTransform) {
        this.mapModeTransform = mapModeTransform;
    }

    public void setWindowOrigin(Point windowOrigin) {
        this.windowOrigin = windowOrigin;
    }

    public void setViewportOrigin(Point viewportOrigin) {
        this.viewportOrigin = viewportOrigin;
    }

    public void setViewportSize(Dimension viewportSize) {
        this.viewportSize = viewportSize;
        this.fixViewportSize();
        this.resetTransformation();
    }

    public void setWindowSize(Dimension windowSize) {
        this.windowSize = windowSize;
        this.fixViewportSize();
        this.resetTransformation();
    }

    public GDIObject getGDIObject(int index) {
        return this.gdiObjects[index];
    }

    public void storeGDIObject(int index, GDIObject tag) {
        this.gdiObjects[index] = tag;
    }

    public void setUseCreatePen(boolean useCreatePen) {
        this.useCreatePen = useCreatePen;
    }

    public void setPenPaint(Paint penPaint) {
        this.penPaint = penPaint;
    }

    public Stroke getPenStroke() {
        return this.penStroke;
    }

    public void setPenStroke(Stroke penStroke) {
        this.penStroke = penStroke;
    }

    public void setBrushPaint(Paint brushPaint) {
        this.brushPaint = brushPaint;
    }

    public float getMeterLimit() {
        return this.meterLimit;
    }

    public void setMeterLimit(int meterLimit) {
        this.meterLimit = meterLimit;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
    }

    public void setRop2(int rop2) {
        this.rop2 = rop2;
    }

    public void setBkMode(int bkMode) {
        this.bkMode = bkMode;
    }

    public int getTextAlignMode() {
        return this.textAlignMode;
    }

    public void setTextAlignMode(int textAlignMode) {
        this.textAlignMode = textAlignMode;
    }

    public void setScaleMode(int scaleMode) {
        this.scaleMode = scaleMode;
    }

    public Point getBrushOrigin() {
        return this.brushOrigin;
    }

    public void setBrushOrigin(Point brushOrigin) {
        this.brushOrigin = brushOrigin;
    }

    public void setArcDirection(int arcDirection) {
        this.arcDirection = arcDirection;
    }

    public int getArcDirection() {
        return this.arcDirection;
    }

    private class DC {
        private Paint paint;
        private Stroke stroke;
        private AffineTransform transform;
        private Shape clip;
        public GeneralPath path;
        public int bkMode;
        public int windingRule;
        public int meterLimit;
        public boolean useCreatePen;
        public int scaleMode;
        public AffineTransform pathTransform;

        private DC() {
        }
    }
}

