/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.io.EOFException;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.net.NioChannel;
import org.apache.tomcat.util.net.NioEndpoint;

public class NioBlockingSelector {
    private static final Log log = LogFactory.getLog(NioBlockingSelector.class);
    private static AtomicInteger threadCounter = new AtomicInteger(0);
    private Queue<KeyReference> keyReferenceQueue = new ConcurrentLinkedQueue<KeyReference>();
    protected Selector sharedSelector;
    protected BlockPoller poller;

    public void open(Selector selector) {
        this.sharedSelector = selector;
        this.poller = new BlockPoller();
        this.poller.selector = this.sharedSelector;
        this.poller.setDaemon(true);
        this.poller.setName("NioBlockingSelector.BlockPoller-" + threadCounter.getAndIncrement());
        this.poller.start();
    }

    public void close() {
        if (this.poller != null) {
            this.poller.disable();
            this.poller.interrupt();
            this.poller = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(ByteBuffer byteBuffer, NioChannel nioChannel, long l) throws IOException {
        SelectionKey selectionKey = nioChannel.getIOChannel().keyFor(nioChannel.getPoller().getSelector());
        if (selectionKey == null) {
            throw new IOException("Key no longer registered");
        }
        KeyReference keyReference = this.keyReferenceQueue.poll();
        if (keyReference == null) {
            keyReference = new KeyReference();
        }
        NioEndpoint.KeyAttachment keyAttachment = (NioEndpoint.KeyAttachment)selectionKey.attachment();
        int n = 0;
        boolean bl = false;
        int n2 = 1;
        long l2 = System.currentTimeMillis();
        try {
            while (!bl && byteBuffer.hasRemaining()) {
                if (n2 > 0) {
                    int n3 = nioChannel.write(byteBuffer);
                    if (n3 == -1) {
                        throw new EOFException();
                    }
                    n += n3;
                    if (n3 > 0) {
                        l2 = System.currentTimeMillis();
                        continue;
                    }
                }
                try {
                    if (keyAttachment.getWriteLatch() == null || keyAttachment.getWriteLatch().getCount() == 0L) {
                        keyAttachment.startWriteLatch(1);
                    }
                    this.poller.add(keyAttachment, 4, keyReference);
                    if (l < 0L) {
                        keyAttachment.awaitWriteLatch(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
                    } else {
                        keyAttachment.awaitWriteLatch(l, TimeUnit.MILLISECONDS);
                    }
                }
                catch (InterruptedException interruptedException) {
                    Thread.interrupted();
                }
                if (keyAttachment.getWriteLatch() != null && keyAttachment.getWriteLatch().getCount() > 0L) {
                    n2 = 0;
                } else {
                    n2 = 1;
                    keyAttachment.resetWriteLatch();
                }
                if (l <= 0L || n2 != 0) continue;
                bl = System.currentTimeMillis() - l2 >= l;
            }
            if (bl) {
                throw new SocketTimeoutException();
            }
        }
        finally {
            this.poller.remove(keyAttachment, 4);
            if (bl && keyReference.key != null) {
                this.poller.cancelKey(keyReference.key);
            }
            keyReference.key = null;
            this.keyReferenceQueue.add(keyReference);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(ByteBuffer byteBuffer, NioChannel nioChannel, long l) throws IOException {
        SelectionKey selectionKey = nioChannel.getIOChannel().keyFor(nioChannel.getPoller().getSelector());
        if (selectionKey == null) {
            throw new IOException("Key no longer registered");
        }
        KeyReference keyReference = this.keyReferenceQueue.poll();
        if (keyReference == null) {
            keyReference = new KeyReference();
        }
        NioEndpoint.KeyAttachment keyAttachment = (NioEndpoint.KeyAttachment)selectionKey.attachment();
        int n = 0;
        boolean bl = false;
        int n2 = 1;
        long l2 = System.currentTimeMillis();
        try {
            while (!bl) {
                if (n2 > 0) {
                    n = nioChannel.read(byteBuffer);
                    if (n == -1) {
                        throw new EOFException();
                    }
                    if (n > 0) break;
                }
                try {
                    if (keyAttachment.getReadLatch() == null || keyAttachment.getReadLatch().getCount() == 0L) {
                        keyAttachment.startReadLatch(1);
                    }
                    this.poller.add(keyAttachment, 1, keyReference);
                    if (l < 0L) {
                        keyAttachment.awaitReadLatch(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
                    } else {
                        keyAttachment.awaitReadLatch(l, TimeUnit.MILLISECONDS);
                    }
                }
                catch (InterruptedException interruptedException) {
                    Thread.interrupted();
                }
                if (keyAttachment.getReadLatch() != null && keyAttachment.getReadLatch().getCount() > 0L) {
                    n2 = 0;
                } else {
                    n2 = 1;
                    keyAttachment.resetReadLatch();
                }
                if (l < 0L || n2 != 0) continue;
                bl = System.currentTimeMillis() - l2 >= l;
            }
            if (bl) {
                throw new SocketTimeoutException();
            }
        }
        finally {
            this.poller.remove(keyAttachment, 1);
            if (bl && keyReference.key != null) {
                this.poller.cancelKey(keyReference.key);
            }
            keyReference.key = null;
            this.keyReferenceQueue.add(keyReference);
        }
        return n;
    }

    public static class KeyReference {
        SelectionKey key = null;

        public void finalize() throws Throwable {
            if (this.key != null && this.key.isValid()) {
                log.warn((Object)"Possible key leak, cancelling key in the finalizer.");
                try {
                    this.key.cancel();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.key = null;
            super.finalize();
        }
    }

    protected static class BlockPoller
    extends Thread {
        protected volatile boolean run = true;
        protected Selector selector = null;
        protected ConcurrentLinkedQueue<Runnable> events = new ConcurrentLinkedQueue();
        protected AtomicInteger wakeupCounter = new AtomicInteger(0);

        protected BlockPoller() {
        }

        public void disable() {
            this.run = false;
            this.selector.wakeup();
        }

        public void cancelKey(final SelectionKey selectionKey) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    selectionKey.cancel();
                }
            };
            this.events.offer(runnable);
            this.wakeup();
        }

        public void wakeup() {
            if (this.wakeupCounter.addAndGet(1) == 0) {
                this.selector.wakeup();
            }
        }

        public void cancel(SelectionKey selectionKey, NioEndpoint.KeyAttachment keyAttachment, int n) {
            if (selectionKey != null) {
                selectionKey.cancel();
                selectionKey.attach(null);
                if (4 == (n & 4)) {
                    this.countDown(keyAttachment.getWriteLatch());
                }
                if (1 == (n & 1)) {
                    this.countDown(keyAttachment.getReadLatch());
                }
            }
        }

        public void add(final NioEndpoint.KeyAttachment keyAttachment, final int n, final KeyReference keyReference) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (keyAttachment == null) {
                        return;
                    }
                    NioChannel nioChannel = keyAttachment.getChannel();
                    if (nioChannel == null) {
                        return;
                    }
                    SocketChannel socketChannel = nioChannel.getIOChannel();
                    if (socketChannel == null) {
                        return;
                    }
                    SelectionKey selectionKey = socketChannel.keyFor(BlockPoller.this.selector);
                    try {
                        if (selectionKey == null) {
                            keyReference.key = selectionKey = socketChannel.register(BlockPoller.this.selector, n, keyAttachment);
                        } else if (!selectionKey.isValid()) {
                            BlockPoller.this.cancel(selectionKey, keyAttachment, n);
                        } else {
                            selectionKey.interestOps(selectionKey.interestOps() | n);
                        }
                    }
                    catch (CancelledKeyException cancelledKeyException) {
                        BlockPoller.this.cancel(selectionKey, keyAttachment, n);
                    }
                    catch (ClosedChannelException closedChannelException) {
                        BlockPoller.this.cancel(selectionKey, keyAttachment, n);
                    }
                }
            };
            this.events.offer(runnable);
            this.wakeup();
        }

        public void remove(final NioEndpoint.KeyAttachment keyAttachment, final int n) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    block14: {
                        if (keyAttachment == null) {
                            return;
                        }
                        NioChannel nioChannel = keyAttachment.getChannel();
                        if (nioChannel == null) {
                            return;
                        }
                        SocketChannel socketChannel = nioChannel.getIOChannel();
                        if (socketChannel == null) {
                            return;
                        }
                        SelectionKey selectionKey = socketChannel.keyFor(BlockPoller.this.selector);
                        try {
                            if (selectionKey == null) {
                                if (4 == (n & 4)) {
                                    BlockPoller.this.countDown(keyAttachment.getWriteLatch());
                                }
                                if (1 == (n & 1)) {
                                    BlockPoller.this.countDown(keyAttachment.getReadLatch());
                                }
                            } else if (selectionKey.isValid()) {
                                selectionKey.interestOps(selectionKey.interestOps() & ~n);
                                if (4 == (n & 4)) {
                                    BlockPoller.this.countDown(keyAttachment.getWriteLatch());
                                }
                                if (1 == (n & 1)) {
                                    BlockPoller.this.countDown(keyAttachment.getReadLatch());
                                }
                                if (selectionKey.interestOps() == 0) {
                                    selectionKey.cancel();
                                    selectionKey.attach(null);
                                }
                            } else {
                                selectionKey.cancel();
                                selectionKey.attach(null);
                            }
                        }
                        catch (CancelledKeyException cancelledKeyException) {
                            if (selectionKey == null) break block14;
                            selectionKey.cancel();
                            selectionKey.attach(null);
                        }
                    }
                }
            };
            this.events.offer(runnable);
            this.wakeup();
        }

        public boolean events() {
            Runnable runnable = null;
            int n = this.events.size();
            for (int i = 0; i < n && (runnable = this.events.poll()) != null; ++i) {
                runnable.run();
            }
            return n > 0;
        }

        @Override
        public void run() {
            block21: {
                block20: {
                    while (this.run) {
                        try {
                            Iterator<SelectionKey> iterator;
                            this.events();
                            int n = 0;
                            try {
                                int n2 = this.wakeupCounter.get();
                                if (n2 > 0) {
                                    n = this.selector.selectNow();
                                } else {
                                    this.wakeupCounter.set(-1);
                                    n = this.selector.select(1000L);
                                }
                                this.wakeupCounter.set(0);
                                if (!this.run) {
                                    break;
                                }
                            }
                            catch (NullPointerException nullPointerException) {
                                if (this.selector == null) {
                                    throw nullPointerException;
                                }
                                if (!log.isDebugEnabled()) continue;
                                log.debug((Object)"Possibly encountered sun bug 5076772 on windows JDK 1.5", (Throwable)nullPointerException);
                                continue;
                            }
                            catch (CancelledKeyException cancelledKeyException) {
                                if (!log.isDebugEnabled()) continue;
                                log.debug((Object)"Possibly encountered sun bug 5076772 on windows JDK 1.5", (Throwable)cancelledKeyException);
                                continue;
                            }
                            catch (Throwable throwable) {
                                ExceptionUtils.handleThrowable(throwable);
                                log.error((Object)"", throwable);
                                continue;
                            }
                            Iterator<SelectionKey> iterator2 = iterator = n > 0 ? this.selector.selectedKeys().iterator() : null;
                            while (this.run && iterator != null && iterator.hasNext()) {
                                SelectionKey selectionKey = iterator.next();
                                NioEndpoint.KeyAttachment keyAttachment = (NioEndpoint.KeyAttachment)selectionKey.attachment();
                                try {
                                    keyAttachment.access();
                                    iterator.remove();
                                    selectionKey.interestOps(selectionKey.interestOps() & ~selectionKey.readyOps());
                                    if (selectionKey.isReadable()) {
                                        this.countDown(keyAttachment.getReadLatch());
                                    }
                                    if (!selectionKey.isWritable()) continue;
                                    this.countDown(keyAttachment.getWriteLatch());
                                }
                                catch (CancelledKeyException cancelledKeyException) {
                                    selectionKey.cancel();
                                    this.countDown(keyAttachment.getReadLatch());
                                    this.countDown(keyAttachment.getWriteLatch());
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            log.error((Object)"", throwable);
                        }
                    }
                    this.events.clear();
                    if (this.selector.isOpen()) {
                        try {
                            this.selector.selectNow();
                        }
                        catch (Exception exception) {
                            if (!log.isDebugEnabled()) break block20;
                            log.debug((Object)"", (Throwable)exception);
                        }
                    }
                }
                try {
                    this.selector.close();
                }
                catch (Exception exception) {
                    if (!log.isDebugEnabled()) break block21;
                    log.debug((Object)"", (Throwable)exception);
                }
            }
        }

        public void countDown(CountDownLatch countDownLatch) {
            if (countDownLatch == null) {
                return;
            }
            countDownLatch.countDown();
        }
    }
}

