/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.painter;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.RoundRectangle2D;
import org.jdesktop.swingx.painter.AbstractAreaPainter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CapsulePainter
extends AbstractAreaPainter<Object> {
    private Portion portion;

    public CapsulePainter() {
        this.setPortion(Portion.Full);
    }

    public CapsulePainter(Portion portion) {
        this.setPortion(portion);
    }

    public Portion getPortion() {
        return this.portion;
    }

    public void setPortion(Portion portion) {
        Portion old = this.portion;
        this.portion = portion;
        this.setDirty(true);
        this.firePropertyChange("portion", (Object)old, (Object)this.getPortion());
    }

    @Override
    protected void doPaint(Graphics2D g, Object component, int width, int height) {
        Shape rect = this.provideShape(g, component, width, height);
        if (this.getStyle() == AbstractAreaPainter.Style.BOTH || this.getStyle() == AbstractAreaPainter.Style.FILLED) {
            g.setPaint(this.getFillPaint());
            g.fill(rect);
        }
        if (this.getStyle() == AbstractAreaPainter.Style.BOTH || this.getStyle() == AbstractAreaPainter.Style.OUTLINE) {
            g.setPaint(this.getBorderPaint());
            g.draw(rect);
        }
    }

    @Override
    protected Shape provideShape(Graphics2D g, Object comp, int width, int height) {
        int round = 10;
        int rheight = height;
        int ry = 0;
        if (this.getPortion() == Portion.Top) {
            round = height * 2;
            rheight = height * 2;
        }
        if (this.getPortion() == Portion.Bottom) {
            round = height * 2;
            rheight = height * 2;
            ry = -height;
        }
        return new RoundRectangle2D.Double(0.0, ry, width, rheight, round, round);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Portion {
        Top,
        Full,
        Bottom,
        Left,
        Right;

    }
}

