/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.datalab.tables;

import java.util.Arrays;
import java.util.HashSet;
import javax.swing.table.AbstractTableModel;
import org.gephi.desktop.datalab.tables.columns.ElementDataColumn;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Element;

public class ElementsDataTableModel<T extends Element>
extends AbstractTableModel {
    private T[] elements;
    private ElementDataColumn<T>[] columns;

    public ElementsDataTableModel(T[] elements, ElementDataColumn<T>[] cols) {
        this.elements = elements;
        this.columns = cols;
    }

    @Override
    public int getRowCount() {
        return this.elements.length;
    }

    @Override
    public int getColumnCount() {
        return this.columns.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.columns[columnIndex].getColumnName();
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.columns[columnIndex].getColumnClass();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.columns[columnIndex].isEditable();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        try {
            return this.columns[columnIndex].getValueFor(this.elements[rowIndex]);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.columns[columnIndex].setValueFor(this.elements[rowIndex], aValue);
    }

    public T getElementAtRow(int row) {
        return this.elements[row];
    }

    public ElementDataColumn<T>[] getColumns() {
        return this.columns;
    }

    public T[] getElements() {
        return this.elements;
    }

    public void configure(T[] elements, ElementDataColumn<T>[] columns) {
        HashSet<ElementDataColumn<T>> newColumns;
        HashSet<ElementDataColumn<T>> oldColumns = new HashSet<ElementDataColumn<T>>(Arrays.asList(this.columns));
        boolean columnsChanged = !oldColumns.equals(newColumns = new HashSet<ElementDataColumn<T>>(Arrays.asList(columns)));
        this.columns = columns;
        this.elements = elements;
        if (columnsChanged) {
            this.fireTableStructureChanged();
        } else {
            this.fireTableDataChanged();
        }
    }

    public Column getColumnAtIndex(int i) {
        if (i >= 0 && i < this.columns.length) {
            return this.columns[i].getColumn();
        }
        return null;
    }
}

