/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.Component;
import java.awt.event.KeyEvent;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import org.gjt.sp.jedit.BeanShell;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.Debug;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.Macros;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.HistoryModel;
import org.gjt.sp.jedit.gui.KeyEventTranslator;
import org.gjt.sp.jedit.gui.KeyEventWorkaround;
import org.gjt.sp.jedit.input.AbstractInputHandler;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.util.GenericGUIUtilities;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;

public abstract class InputHandler
extends AbstractInputHandler<EditAction> {
    protected final View view;

    protected InputHandler(View view) {
        this.view = view;
    }

    public final boolean handleKey(KeyEventTranslator.Key key) {
        return this.handleKey(key, false);
    }

    @Override
    public void processKeyEvent(KeyEvent keyEvent, int n, boolean bl) {
        if (Debug.DUMP_KEY_EVENTS) {
            Log.log(1, this, "Key event                 : " + AbstractInputHandler.toString(keyEvent) + " from " + n);
            Log.log(1, this, this.view + ".isFocused()=" + this.view.isFocused() + ".", new Exception());
        }
        if (this.view.getTextArea().hasFocus() && n == 0) {
            return;
        }
        if ((keyEvent = this._preprocessKeyEvent(keyEvent)) == null) {
            return;
        }
        if (Debug.DUMP_KEY_EVENTS) {
            Log.log(1, this, "Key event after workaround: " + AbstractInputHandler.toString(keyEvent) + " from " + n);
        }
        Component component = this.view.getPrefixFocusOwner();
        boolean bl2 = false;
        switch (keyEvent.getID()) {
            case 400: {
                if (component != null && component.isShowing()) {
                    component.requestFocus();
                    bl2 = true;
                }
                if (this.keyEventInterceptor != null) {
                    this.keyEventInterceptor.keyTyped(keyEvent);
                } else if (n == 2 || this.isPrefixActive() || this.view.getTextArea().hasFocus()) {
                    this.processKeyEventKeyStrokeHandling(keyEvent, n, "type ", bl);
                }
                this.processKeyEventSub(bl2);
                break;
            }
            case 401: {
                if (this.keyEventInterceptor != null) {
                    this.keyEventInterceptor.keyPressed(keyEvent);
                    break;
                }
                if (!KeyEventWorkaround.isBindable(keyEvent.getKeyCode())) break;
                if (component != null) {
                    if (component.isShowing()) {
                        component.requestFocus();
                        bl2 = true;
                    }
                    this.view.setPrefixFocusOwner(null);
                }
                this.processKeyEventKeyStrokeHandling(keyEvent, n, "press", bl);
                this.processKeyEventSub(bl2);
                break;
            }
            case 402: {
                if (this.keyEventInterceptor == null) break;
                this.keyEventInterceptor.keyReleased(keyEvent);
            }
        }
    }

    private KeyEvent _preprocessKeyEvent(KeyEvent keyEvent) {
        if (this.view.isClosed()) {
            return null;
        }
        Component component = this.view.getFocusOwner();
        if (component instanceof JComponent) {
            KeyStroke keyStroke;
            Object object;
            JComponent jComponent = (JComponent)component;
            InputMap inputMap = jComponent.getInputMap();
            ActionMap actionMap = jComponent.getActionMap();
            if (inputMap != null && actionMap != null && jComponent.isEnabled() && (object = inputMap.get(keyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent))) != null && actionMap.get(object) != null) {
                return null;
            }
        }
        if (component instanceof JTextComponent && keyEvent.getID() == 401) {
            switch (keyEvent.getKeyCode()) {
                case 8: 
                case 9: 
                case 10: 
                case 32: {
                    return null;
                }
            }
        }
        if (keyEvent.isConsumed()) {
            return null;
        }
        if (Debug.DUMP_KEY_EVENTS) {
            Log.log(1, this, "Key event (preprocessing) : " + AbstractInputHandler.toString(keyEvent));
        }
        return KeyEventWorkaround.processKeyEvent(keyEvent);
    }

    private void processKeyEventSub(boolean bl) {
        if (this.view.isClosed()) {
            return;
        }
        if (this.isPrefixActive()) {
            Component component = this.view.getFocusOwner();
            if (component instanceof JTextComponent) {
                this.view.setPrefixFocusOwner(component);
                this.view.getTextArea().requestFocus();
            } else if (bl) {
                this.view.getTextArea().requestFocus();
            } else {
                this.view.setPrefixFocusOwner(null);
            }
        } else {
            this.view.setPrefixFocusOwner(null);
        }
    }

    public int getRepeatCount() {
        return this.repeatCount;
    }

    public void setRepeatCount(int n) {
        int n2 = this.repeatCount;
        this.repeatCount = n;
        if (n2 != n) {
            this.view.getStatus().setMessage(null);
        }
    }

    public EditAction getLastAction() {
        return (EditAction)this.lastAction;
    }

    public void readNextChar(String string, String string2) {
        this.view.getStatus().setMessage(string);
        this.readNextChar = string2;
    }

    @Override
    public void invokeAction(String string) {
        this.invokeAction(jEdit.getAction(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invokeAction(EditAction editAction) {
        Buffer buffer = this.view.getBuffer();
        if (!editAction.noRememberLast()) {
            HistoryModel.getModel("action").addItem(editAction.getName());
            if (this.lastAction == editAction) {
                ++this.lastActionCount;
            } else {
                this.lastAction = editAction;
                this.lastActionCount = 1;
            }
        }
        int n = this.repeatCount;
        if (editAction.noRepeat() || n == 1) {
            editAction.invoke(this.view);
        } else {
            String string;
            Object[] objectArray;
            if (n > 20 && GUIUtilities.confirm(this.view, "large-repeat-count", objectArray = new Object[]{string = (string = editAction.getLabel()) == null ? editAction.getName() : GenericGUIUtilities.prettifyMenuLabel(string), n}, 2, 0) != 0) {
                this.repeatCount = 1;
                this.view.getStatus().setMessage(null);
                return;
            }
            try {
                buffer.beginCompoundEdit();
                for (int i = 0; i < n; ++i) {
                    editAction.invoke(this.view);
                }
            }
            finally {
                buffer.endCompoundEdit();
            }
        }
        Macros.Recorder recorder = this.view.getMacroRecorder();
        if (recorder != null && !editAction.noRecord()) {
            recorder.record(n, editAction.getCode());
        }
        if (n != 1) {
            if (this.readNextChar != null) {
                return;
            }
            this.repeatCount = 1;
            this.view.getStatus().setMessage(null);
        }
    }

    public void invokeLastAction() {
        if (this.lastAction == null) {
            UIManager.getLookAndFeel().provideErrorFeedback(null);
        } else {
            this.invokeAction((EditAction)this.lastAction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void userInput(char c) {
        Object[] objectArray;
        this.lastActionCount = 0;
        JEditTextArea jEditTextArea = this.view.getTextArea();
        if (this.repeatCount == 1) {
            jEditTextArea.userInput(c);
        } else {
            if (this.repeatCount > 20 && GUIUtilities.confirm(this.view, "large-repeat-count.user-input", objectArray = new Object[]{String.valueOf(c), this.repeatCount}, 2, 0) != 0) {
                this.repeatCount = 1;
                this.view.getStatus().setMessage(null);
                return;
            }
            objectArray = this.view.getBuffer();
            try {
                if (this.repeatCount != 1) {
                    objectArray.beginCompoundEdit();
                }
                for (int i = 0; i < this.repeatCount; ++i) {
                    jEditTextArea.userInput(c);
                }
            }
            finally {
                if (this.repeatCount != 1) {
                    objectArray.endCompoundEdit();
                }
            }
        }
        objectArray = this.view.getMacroRecorder();
        if (objectArray != null) {
            objectArray.recordInput(this.repeatCount, c, jEditTextArea.isOverwriteEnabled());
        }
        this.repeatCount = 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invokeReadNextChar(char c) {
        int n;
        Buffer buffer = this.view.getBuffer();
        String string = StandardUtilities.charsToEscapes(String.valueOf(c));
        while ((n = this.readNextChar.indexOf("__char__")) != -1) {
            this.readNextChar = this.readNextChar.substring(0, n) + "'" + string + "'" + this.readNextChar.substring(n + 8);
        }
        Macros.Recorder recorder = this.view.getMacroRecorder();
        if (recorder != null) {
            recorder.record(this.getRepeatCount(), this.readNextChar);
        }
        this.view.getStatus().setMessage(null);
        if (this.getRepeatCount() != 1) {
            try {
                buffer.beginCompoundEdit();
                BeanShell.eval(this.view, BeanShell.getNameSpace(), "for(int i = 1; i < " + this.getRepeatCount() + "; i++)\n{\n" + this.readNextChar + "\n}");
            }
            finally {
                buffer.endCompoundEdit();
            }
        } else {
            BeanShell.eval(this.view, BeanShell.getNameSpace(), this.readNextChar);
        }
        this.readNextChar = null;
    }
}

