/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl.impl;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.jruby.ext.openssl.Cipher;
import org.jruby.ext.openssl.SecurityHelper;
import org.jruby.ext.openssl.impl.ASN1Registry;

public class EVP {
    public static Cipher getCipher(ASN1ObjectIdentifier oid2) throws NoSuchAlgorithmException, NoSuchPaddingException {
        String algorithm = EVP.getAlgorithmName(oid2);
        String realName = Cipher.Algorithm.getRealName(algorithm);
        return SecurityHelper.getCipher(realName);
    }

    public static MessageDigest getDigest(ASN1ObjectIdentifier oid2) throws NoSuchAlgorithmException {
        String algorithm = EVP.getAlgorithmName(oid2);
        return SecurityHelper.getMessageDigest(algorithm);
    }

    public static MessageDigest sha1() {
        try {
            return SecurityHelper.getMessageDigest("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    public static int type(MessageDigest digest2) {
        String name2 = digest2.getAlgorithm().toLowerCase();
        String oid2 = ASN1Registry.getOIDLookup().get(name2);
        if (oid2 == null) {
            name2 = name2.replace("sha-", "sha");
            oid2 = ASN1Registry.getOIDLookup().get(name2);
        }
        return ASN1Registry.oid2nid(oid2);
    }

    public static String signatureAlgorithm(MessageDigest digest2, Key key) {
        String sig = digest2.getAlgorithm().toLowerCase().replace("sha-", "sha");
        String type = key.getAlgorithm().toLowerCase();
        if (sig == null) {
            sig = "none";
        }
        return sig + "with" + type;
    }

    public static byte[] decrypt(byte[] input, int offset, int len, Key key) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException {
        String algorithm = key.getAlgorithm();
        if ("RSA".equals(algorithm)) {
            algorithm = "RSA/NONE/PKCS1Padding";
        }
        Cipher cipher2 = SecurityHelper.getCipher(algorithm);
        cipher2.init(2, key);
        return cipher2.doFinal(input, offset, len);
    }

    public static byte[] decrypt(byte[] input, Key key) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException {
        return EVP.decrypt(input, 0, input.length, key);
    }

    private static String getAlgorithmName(ASN1ObjectIdentifier oid2) {
        String algorithm = ASN1Registry.o2a(oid2);
        return algorithm != null ? algorithm.toUpperCase() : oid2.getId();
    }
}

