/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.math.BigInteger;
import java.util.Arrays;

public class Random {
    public static final int N = 624;
    private static final int M = 397;
    private static final int MATRIX_A = -1727483681;
    private static final int UMASK = Integer.MIN_VALUE;
    private static final int LMASK = Integer.MAX_VALUE;
    private final int[] state = new int[624];
    private int left = 1;
    private static final BigInteger INTPAIR_CONST = BigInteger.valueOf(0x20000000000001L);
    private static final double LDEXP_CONST = Math.pow(2.0, -53.0);

    private static int MIXBITS(int u, int v) {
        return u & Integer.MIN_VALUE | v & Integer.MAX_VALUE;
    }

    private static int TWIST(int u, int v) {
        return Random.MIXBITS(u, v) >>> 1 ^ ((v & 1) != 0 ? -1727483681 : 0);
    }

    public Random() {
    }

    public Random(int s2) {
        this.initGenrand(s2);
    }

    public Random(int[] initKey) {
        this.initByArray(initKey);
    }

    public Random(Random orig) {
        System.arraycopy(orig.state, 0, this.state, 0, this.state.length);
        this.left = orig.left;
    }

    public Random(int[] state2, int left2) {
        if (state2.length != this.state.length) {
            throw new IllegalStateException("wrong state length: " + state2.length);
        }
        System.arraycopy(state2, 0, this.state, 0, this.state.length);
        this.left = left2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Random)) {
            return false;
        }
        Random rhs = (Random)obj;
        return this.left == rhs.left && Arrays.equals(this.state, rhs.state);
    }

    public int hashCode() {
        return (629 + this.left) * 37 + Arrays.hashCode(this.state);
    }

    private void initGenrand(int s2) {
        this.state[0] = s2;
        for (int j = 1; j < 624; ++j) {
            this.state[j] = 1812433253 * (this.state[j - 1] ^ this.state[j - 1] >>> 30) + j;
        }
        this.left = 1;
    }

    private void initByArray(int[] initKey) {
        int k;
        this.initGenrand(19650218);
        int len = initKey.length;
        int i2 = 1;
        int j = 0;
        int n = k = 624 > len ? 624 : len;
        while (k > 0) {
            this.state[i2] = (this.state[i2] ^ (this.state[i2 - 1] ^ this.state[i2 - 1] >>> 30) * 1664525) + initKey[j] + j;
            ++j;
            if (++i2 >= 624) {
                this.state[0] = this.state[623];
                i2 = 1;
            }
            if (j >= len) {
                j = 0;
            }
            --k;
        }
        for (k = 623; k > 0; --k) {
            this.state[i2] = (this.state[i2] ^ (this.state[i2 - 1] ^ this.state[i2 - 1] >>> 30) * 1566083941) - i2;
            if (++i2 < 624) continue;
            this.state[0] = this.state[623];
            i2 = 1;
        }
        this.state[0] = Integer.MIN_VALUE;
    }

    private void nextState() {
        int p2 = 0;
        this.left = 624;
        int j = 228;
        while (--j > 0) {
            this.state[p2] = this.state[p2 + 397] ^ Random.TWIST(this.state[p2 + 0], this.state[p2 + 1]);
            ++p2;
        }
        j = 397;
        while (--j > 0) {
            this.state[p2] = this.state[p2 + 397 - 624] ^ Random.TWIST(this.state[p2 + 0], this.state[p2 + 1]);
            ++p2;
        }
        this.state[p2] = this.state[p2 + 397 - 624] ^ Random.TWIST(this.state[p2 + 0], this.state[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int genrandInt32() {
        int y;
        Random random = this;
        synchronized (random) {
            if (--this.left <= 0) {
                this.nextState();
            }
            y = this.state[624 - this.left];
        }
        y ^= y >>> 11;
        y = (int)((long)y ^ (long)(y << 7) & 0x9D2C5680L);
        y = (int)((long)y ^ (long)(y << 15) & 0xEFC60000L);
        y ^= y >>> 18;
        return y;
    }

    public double genrandReal() {
        int a = this.genrandInt32() >>> 5;
        int b2 = this.genrandInt32() >>> 6;
        return ((double)a * 6.7108864E7 + (double)b2) * (double)1.110223E-16f;
    }

    public double genrandReal2() {
        int a = this.genrandInt32();
        int b2 = this.genrandInt32();
        return this.intPairToRealInclusive(a, b2);
    }

    private double intPairToRealInclusive(int a, int b2) {
        BigInteger c = BigInteger.valueOf((long)a & 0xFFFFFFFFL);
        BigInteger d = BigInteger.valueOf((long)b2 & 0xFFFFFFFFL);
        return c.shiftLeft(32).or(d).multiply(INTPAIR_CONST).shiftRight(64).doubleValue() * LDEXP_CONST;
    }

    public int[] getState() {
        return this.state;
    }

    public int getLeft() {
        return this.left;
    }
}

