/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.sansorm;

import com.zaxxer.sansorm.SqlFunction;
import com.zaxxer.sansorm.SqlVarArgsFunction;
import com.zaxxer.sansorm.internal.ConnectionProxy;
import com.zaxxer.sansorm.transaction.TransactionElf;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;

public class SqlClosure<T> {
    private static DataSource defaultDataSource;
    private Object[] args;
    private DataSource dataSource;

    public SqlClosure() {
        this.dataSource = defaultDataSource;
        if (this.dataSource == null) {
            throw new RuntimeException("No default DataSource has been set");
        }
    }

    public SqlClosure(Object ... args2) {
        this.args = args2;
    }

    public SqlClosure(DataSource ds) {
        this.dataSource = ds;
    }

    public SqlClosure(DataSource ds, Object ... args2) {
        this.dataSource = ds;
        this.args = args2;
    }

    public SqlClosure(SqlClosure copyClosure) {
        this.dataSource = copyClosure.dataSource;
    }

    static void setDefaultDataSource(DataSource ds) {
        defaultDataSource = ds;
    }

    public static <V> V sqlExecute(final SqlFunction<V> functional) {
        return (V)new SqlClosure<V>(){

            @Override
            public V execute(Connection connection) throws SQLException {
                return functional.execute(connection);
            }
        }.execute();
    }

    public static <V> V sqlExecute(final SqlVarArgsFunction<V> functional, Object ... args2) {
        return (V)new SqlClosure<V>(){

            @Override
            public V execute(Connection connection, Object ... params) throws SQLException {
                return functional.execute(connection, params);
            }
        }.executeWith(args2);
    }

    public final <V> V exec(final SqlFunction<V> functional) {
        return (V)new SqlClosure<V>(this){

            @Override
            public V execute(Connection connection) throws SQLException {
                return functional.execute(connection);
            }
        }.execute();
    }

    public final <V> V exec(final SqlVarArgsFunction<V> functional, Object ... args2) {
        return (V)new SqlClosure<V>(this){

            @Override
            public V execute(Connection connection, Object ... params) throws SQLException {
                return functional.execute(connection, params);
            }
        }.executeWith(args2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final T execute() {
        boolean txOwner = !TransactionElf.hasTransactionManager() || TransactionElf.beginOrJoinTransaction();
        Connection connection = null;
        try {
            connection = ConnectionProxy.wrapConnection(this.dataSource.getConnection());
            if (txOwner) {
                connection.setAutoCommit(false);
            }
            T t = this.args == null ? this.execute(connection) : this.execute(connection, this.args);
            return t;
        }
        catch (SQLException e) {
            if (e.getNextException() != null) {
                e = e.getNextException();
            }
            if (txOwner) {
                txOwner = false;
                SqlClosure.rollback(connection);
            }
            throw new RuntimeException(e);
        }
        catch (Throwable e) {
            if (txOwner) {
                txOwner = false;
                SqlClosure.rollback(connection);
            }
            throw e;
        }
        finally {
            try {
                if (txOwner) {
                    SqlClosure.commit(connection);
                }
            }
            finally {
                SqlClosure.quietClose(connection);
            }
        }
    }

    public final T executeWith(Object ... args2) {
        this.args = args2;
        return this.execute();
    }

    protected T execute(Connection connection) throws SQLException {
        throw new AbstractMethodError("You must provide an implementation of this method.");
    }

    protected T execute(Connection connection, Object ... args2) throws SQLException {
        throw new AbstractMethodError("You must provide an implementation of this method.");
    }

    public static void quietClose(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static void quietClose(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static void quietClose(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private static void rollback(Connection connection) {
        if (TransactionElf.hasTransactionManager()) {
            TransactionElf.rollback();
        } else if (connection != null) {
            try {
                connection.rollback();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static void commit(Connection connection) {
        if (TransactionElf.hasTransactionManager()) {
            TransactionElf.commit();
        } else if (connection != null) {
            try {
                connection.commit();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

