/*
 * Decompiled with CFR 0.152.
 */
package mediathek.mainwindow;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JFrame;
import mediathek.tool.ApplicationConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.sync.LockMode;

class WindowLocationConfigSaverListener
extends ComponentAdapter {
    private static final int DEFAULT_WIDTH = 640;
    private static final int DEFAULT_HEIGHT = 480;

    WindowLocationConfigSaverListener() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void componentResized(ComponentEvent e) {
        JFrame mainWindow = (JFrame)e.getComponent();
        Configuration config = ApplicationConfiguration.getConfiguration();
        Dimension dims = mainWindow.getSize();
        if (dims.width < 640 && dims.height < 480) {
            mainWindow.setSize(640, 480);
        }
        try {
            config.lock(LockMode.WRITE);
            boolean isMaximized = (mainWindow.getExtendedState() & 6) == 6;
            config.setProperty("application.ui.mainwindow.maximized", isMaximized);
            config.setProperty("application.ui.mainwindow.width", dims.width);
            config.setProperty("application.ui.mainwindow.height", dims.height);
        }
        finally {
            config.unlock(LockMode.WRITE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void componentMoved(ComponentEvent e) {
        JFrame mainWindow = (JFrame)e.getComponent();
        Configuration config = ApplicationConfiguration.getConfiguration();
        Point pt = mainWindow.getLocation();
        try {
            config.lock(LockMode.WRITE);
            boolean isMaximized = (mainWindow.getExtendedState() & 6) == 6;
            config.setProperty("application.ui.mainwindow.maximized", isMaximized);
            config.setProperty("application.ui.mainwindow.location.x", pt.x);
            config.setProperty("application.ui.mainwindow.location.y", pt.y);
        }
        finally {
            config.unlock(LockMode.WRITE);
        }
    }
}

