/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.Guillemet;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.LineParam;
import net.sourceforge.plantuml.SkinParam;
import net.sourceforge.plantuml.SkinParamUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.creole.Stencil;
import net.sourceforge.plantuml.cucadiagram.BodyEnhanced;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.EntityPortion;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.PortionShower;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.SkinParameter;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignature;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.svek.image.RotatedEllipse;
import net.sourceforge.plantuml.ugraphic.AbstractUGraphicHorizontalLine;
import net.sourceforge.plantuml.ugraphic.TextBlockInEllipse;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UHorizontalLine;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class EntityImageUseCase
extends AbstractEntityImage {
    private final TextBlock desc;
    private final Url url;

    public EntityImageUseCase(ILeaf entity, ISkinParam skinParam, PortionShower portionShower) {
        super(entity, skinParam);
        Stereotype stereotype = entity.getStereotype();
        BodyEnhanced tmp = new BodyEnhanced(entity.getDisplay(), FontParam.USECASE, skinParam, HorizontalAlignment.CENTER, stereotype, true, false, entity, SName.componentDiagram);
        if (stereotype == null || stereotype.getLabel(Guillemet.DOUBLE_COMPARATOR) == null || !portionShower.showPortion(EntityPortion.STEREOTYPE, entity)) {
            this.desc = tmp;
        } else {
            TextBlock stereo = stereotype.getSprite(this.getSkinParam()) != null ? stereotype.getSprite(this.getSkinParam()) : Display.getWithNewlines(stereotype.getLabel(this.getSkinParam().guillemet())).create(new FontConfiguration(this.getSkinParam(), FontParam.USECASE_STEREOTYPE, stereotype), HorizontalAlignment.CENTER, skinParam);
            this.desc = TextBlockUtils.mergeTB(stereo, tmp, HorizontalAlignment.CENTER);
        }
        this.url = entity.getUrl99();
    }

    private UStroke getStroke() {
        if (SkinParam.USE_STYLES()) {
            Style style = this.getDefaultStyleDefinition().getMergedStyle(this.getSkinParam().getCurrentStyleBuilder());
            return style.getStroke();
        }
        UStroke stroke = this.getSkinParam().getThickness(LineParam.usecaseBorder, this.getStereo());
        if (stroke == null) {
            stroke = new UStroke(1.5);
        }
        return stroke;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return new TextBlockInEllipse(this.desc, stringBounder).calculateDimension(stringBounder);
    }

    @Override
    public final void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        TextBlockInEllipse ellipse = new TextBlockInEllipse(this.desc, stringBounder);
        if (this.getSkinParam().shadowing2(this.getEntity().getStereotype(), SkinParameter.USECASE)) {
            ellipse.setDeltaShadow(3.0);
        }
        if (this.url != null) {
            ug.startUrl(this.url);
        }
        ug = ug.apply(this.getStroke());
        HColor linecolor = this.getLineColor();
        ug = ug.apply(linecolor);
        HColor backcolor = this.getBackColor();
        ug = ug.apply(backcolor.bg());
        MyUGraphicEllipse ug2 = new MyUGraphicEllipse(ug, 0.0, 0.0, ellipse.getUEllipse());
        ellipse.drawU(ug2);
        if (this.getEntity().getLeafType() == LeafType.USECASE_BUSINESS) {
            this.specialBusiness(ug, ellipse.getUEllipse());
        }
        if (this.url != null) {
            ug.closeUrl();
        }
    }

    private void specialBusiness(UGraphic ug, UEllipse frontier) {
        RotatedEllipse rotatedEllipse = new RotatedEllipse(frontier, 0.7853981633974483);
        double theta1 = 0.3490658503988659;
        double theta2 = rotatedEllipse.getOtherTheta(0.3490658503988659);
        UEllipse frontier2 = frontier.scale(0.99);
        Point2D p1 = frontier2.getPointAtAngle(-0.3490658503988659);
        Point2D p2 = frontier2.getPointAtAngle(-theta2);
        this.drawLine(ug, p1, p2);
    }

    private void specialBusiness0(UGraphic ug, UEllipse frontier) {
        double c = frontier.getWidth() / frontier.getHeight();
        double ouverture = 1.5707963267948966;
        Point2D p1 = frontier.getPointAtAngle(this.getTrueAngle(c, -0.7853981633974483));
        Point2D p2 = frontier.getPointAtAngle(this.getTrueAngle(c, 2.356194490192345));
        this.drawLine(ug, p1, p2);
    }

    private void drawLine(UGraphic ug, Point2D p1, Point2D p2) {
        ug = ug.apply(new UTranslate(p1));
        ug.draw(new ULine(p2.getX() - p1.getX(), p2.getY() - p1.getY()));
    }

    private double getTrueAngle(double c, double gamma) {
        return Math.atan2(Math.sin(gamma), Math.cos(gamma) / c);
    }

    private HColor getBackColor() {
        HColor backcolor = this.getEntity().getColors(this.getSkinParam()).getColor(ColorType.BACK);
        if (backcolor == null) {
            if (SkinParam.USE_STYLES()) {
                Style style = this.getDefaultStyleDefinition().getMergedStyle(this.getSkinParam().getCurrentStyleBuilder());
                backcolor = style.value(PName.BackGroundColor).asColor(this.getSkinParam().getIHtmlColorSet());
            } else {
                backcolor = SkinParamUtils.getColor(this.getSkinParam(), this.getStereo(), ColorParam.usecaseBackground);
            }
        }
        return backcolor;
    }

    private StyleSignature getDefaultStyleDefinition() {
        return StyleSignature.of(SName.root, SName.element, SName.componentDiagram, SName.usecase);
    }

    private HColor getLineColor() {
        HColor linecolor = this.getEntity().getColors(this.getSkinParam()).getColor(ColorType.LINE);
        if (linecolor == null) {
            if (SkinParam.USE_STYLES()) {
                Style style = this.getDefaultStyleDefinition().getMergedStyle(this.getSkinParam().getCurrentStyleBuilder());
                linecolor = style.value(PName.LineColor).asColor(this.getSkinParam().getIHtmlColorSet());
            } else {
                linecolor = SkinParamUtils.getColor(this.getSkinParam(), this.getStereo(), ColorParam.usecaseBorder);
            }
        }
        return linecolor;
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.OVAL;
    }

    static class MyUGraphicEllipse
    extends AbstractUGraphicHorizontalLine {
        private final double startingX;
        private final double yTheoricalPosition;
        private final UEllipse ellipse;

        @Override
        protected AbstractUGraphicHorizontalLine copy(UGraphic ug) {
            return new MyUGraphicEllipse(ug, this.startingX, this.yTheoricalPosition, this.ellipse);
        }

        MyUGraphicEllipse(UGraphic ug, double startingX, double yTheoricalPosition, UEllipse ellipse) {
            super(ug);
            this.startingX = startingX;
            this.ellipse = ellipse;
            this.yTheoricalPosition = yTheoricalPosition;
        }

        private double getNormalized(double y) {
            if (y < this.yTheoricalPosition) {
                throw new IllegalArgumentException();
            }
            if ((y -= this.yTheoricalPosition) > this.ellipse.getHeight()) {
                throw new IllegalArgumentException();
            }
            return y;
        }

        private double getStartingXInternal(double y) {
            return this.startingX + this.ellipse.getStartingX(this.getNormalized(y));
        }

        private double getEndingXInternal(double y) {
            return this.startingX + this.ellipse.getEndingX(this.getNormalized(y));
        }

        private Stencil getStencil2(UTranslate translate) {
            final double dy = translate.getDy();
            return new Stencil(){

                @Override
                public double getStartingX(StringBounder stringBounder, double y) {
                    return MyUGraphicEllipse.this.getStartingXInternal(y + dy);
                }

                @Override
                public double getEndingX(StringBounder stringBounder, double y) {
                    return MyUGraphicEllipse.this.getEndingXInternal(y + dy);
                }
            };
        }

        @Override
        protected void drawHline(UGraphic ug, UHorizontalLine line, UTranslate translate) {
            UStroke stroke = new UStroke(1.5);
            line.drawLineInternal(ug.apply(translate), this.getStencil2(translate), 0.0, stroke);
        }
    }
}

