/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.extensions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.extensions.IrPluginContext;
import org.jetbrains.kotlin.backend.common.ir.BuiltinSymbolsBase;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.descriptors.IrBuiltIns;
import org.jetbrains.kotlin.ir.linkage.IrDeserializer;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.ReferenceSymbolTable;
import org.jetbrains.kotlin.ir.util.TypeTranslator;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u0012\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020(H\u0016J\u0016\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*2\u0006\u0010,\u001a\u00020(H\u0016J\u0016\u0010-\u001a\b\u0012\u0004\u0012\u00020.0*2\u0006\u0010'\u001a\u00020(H\u0016J\u0016\u0010/\u001a\b\u0012\u0004\u0012\u0002000*2\u0006\u0010'\u001a\u00020(H\u0016J\u0012\u00101\u001a\u0004\u0018\u0001022\u0006\u0010'\u001a\u00020(H\u0002J7\u00103\u001a\u0004\u0018\u0001H4\"\b\b\u0000\u00104*\u0002052\u0006\u0010'\u001a\u00020(2\u0014\u00106\u001a\u0010\u0012\u0004\u0012\u000202\u0012\u0006\u0012\u0004\u0018\u0001H407H\u0002\u00a2\u0006\u0002\u00108J:\u00109\u001a\b\u0012\u0004\u0012\u0002H40*\"\b\b\u0000\u00104*\u0002052\u0006\u0010'\u001a\u00020(2\u0018\u00106\u001a\u0014\u0012\u0004\u0012\u000202\u0012\n\u0012\b\u0012\u0004\u0012\u0002H40*07H\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$\u00a8\u0006:"}, d2={"Lorg/jetbrains/kotlin/backend/common/extensions/IrPluginContextImpl;", "Lorg/jetbrains/kotlin/backend/common/extensions/IrPluginContext;", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "st", "Lorg/jetbrains/kotlin/ir/util/ReferenceSymbolTable;", "typeTranslator", "Lorg/jetbrains/kotlin/ir/util/TypeTranslator;", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/descriptors/IrBuiltIns;", "linker", "Lorg/jetbrains/kotlin/ir/linkage/IrDeserializer;", "symbols", "Lorg/jetbrains/kotlin/backend/common/ir/BuiltinSymbolsBase;", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/resolve/BindingContext;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/ir/util/ReferenceSymbolTable;Lorg/jetbrains/kotlin/ir/util/TypeTranslator;Lorg/jetbrains/kotlin/ir/descriptors/IrBuiltIns;Lorg/jetbrains/kotlin/ir/linkage/IrDeserializer;Lorg/jetbrains/kotlin/backend/common/ir/BuiltinSymbolsBase;)V", "getBindingContext", "()Lorg/jetbrains/kotlin/resolve/BindingContext;", "getIrBuiltIns", "()Lorg/jetbrains/kotlin/ir/descriptors/IrBuiltIns;", "getLanguageVersionSettings", "()Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "getLinker", "()Lorg/jetbrains/kotlin/ir/linkage/IrDeserializer;", "moduleDescriptor", "getModuleDescriptor", "()Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "symbolTable", "getSymbolTable", "()Lorg/jetbrains/kotlin/ir/util/ReferenceSymbolTable;", "getSymbols", "()Lorg/jetbrains/kotlin/backend/common/ir/BuiltinSymbolsBase;", "getTypeTranslator", "()Lorg/jetbrains/kotlin/ir/util/TypeTranslator;", "referenceClass", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "referenceConstructors", "", "Lorg/jetbrains/kotlin/ir/symbols/IrConstructorSymbol;", "classFqn", "referenceFunctions", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "referenceProperties", "Lorg/jetbrains/kotlin/ir/symbols/IrPropertySymbol;", "resolveMemberScope", "Lorg/jetbrains/kotlin/resolve/scopes/MemberScope;", "resolveSymbol", "S", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "referencer", "Lkotlin/Function1;", "(Lorg/jetbrains/kotlin/name/FqName;Lkotlin/jvm/functions/Function1;)Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "resolveSymbolCollection", "ir.backend.common"})
public class IrPluginContextImpl
implements IrPluginContext {
    @NotNull
    private final ModuleDescriptor moduleDescriptor;
    @NotNull
    private final ReferenceSymbolTable symbolTable;
    private final ModuleDescriptor module;
    @NotNull
    private final BindingContext bindingContext;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    private final ReferenceSymbolTable st;
    @NotNull
    private final TypeTranslator typeTranslator;
    @NotNull
    private final IrBuiltIns irBuiltIns;
    @NotNull
    private final IrDeserializer linker;
    @NotNull
    private final BuiltinSymbolsBase symbols;

    @Override
    @NotNull
    public ModuleDescriptor getModuleDescriptor() {
        return this.moduleDescriptor;
    }

    @Override
    @NotNull
    public ReferenceSymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    private final MemberScope resolveMemberScope(FqName fqName2) {
        block7: {
            PackageViewDescriptor pkg;
            block6: {
                pkg = this.module.getPackage(fqName2);
                if (fqName2.isRoot()) break block6;
                Collection collection = pkg.getFragments();
                boolean bl = false;
                if (!(!collection.isEmpty())) break block7;
            }
            return pkg.getMemberScope();
        }
        FqName fqName3 = fqName2.parent();
        Intrinsics.checkNotNullExpressionValue(fqName3, "fqName.parent()");
        MemberScope memberScope2 = this.resolveMemberScope(fqName3);
        if (memberScope2 == null) {
            return null;
        }
        MemberScope parentMemberScope = memberScope2;
        Name name = fqName2.shortName();
        Intrinsics.checkNotNullExpressionValue(name, "fqName.shortName()");
        ClassifierDescriptor classifierDescriptor = parentMemberScope.getContributedClassifier(name, NoLookupLocation.FROM_BACKEND);
        if (!(classifierDescriptor instanceof ClassDescriptor)) {
            classifierDescriptor = null;
        }
        ClassDescriptor classDescriptor2 = (ClassDescriptor)classifierDescriptor;
        if (classDescriptor2 == null) {
            return null;
        }
        ClassDescriptor classDescriptor3 = classDescriptor2;
        return classDescriptor3.getUnsubstitutedMemberScope();
    }

    private final <S extends IrSymbol> S resolveSymbol(FqName fqName2, Function1<? super MemberScope, ? extends S> referencer) {
        MemberScope memberScope2 = this.resolveMemberScope(fqName2);
        if (memberScope2 == null) {
            return null;
        }
        MemberScope memberScope3 = memberScope2;
        IrSymbol irSymbol = (IrSymbol)referencer.invoke(memberScope3);
        if (irSymbol == null) {
            return null;
        }
        IrSymbol symbol2 = irSymbol;
        if (symbol2.isBound()) {
            return (S)symbol2;
        }
        this.linker.getDeclaration(symbol2);
        this.linker.postProcess();
        return (S)symbol2;
    }

    private final <S extends IrSymbol> Collection<S> resolveSymbolCollection(FqName fqName2, Function1<? super MemberScope, ? extends Collection<? extends S>> referencer) {
        MemberScope memberScope2 = this.resolveMemberScope(fqName2);
        if (memberScope2 == null) {
            return CollectionsKt.emptyList();
        }
        MemberScope memberScope3 = memberScope2;
        Collection<? extends S> symbols2 = referencer.invoke(memberScope3);
        Iterable $this$forEach$iv = symbols2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrSymbol it = (IrSymbol)element$iv;
            boolean bl = false;
            if (it.isBound()) continue;
            this.linker.getDeclaration(it);
        }
        this.linker.postProcess();
        return symbols2;
    }

    @Override
    @Nullable
    public IrClassSymbol referenceClass(@NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter(fqName2, "fqName");
        boolean bl = !fqName2.isRoot();
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string2 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        FqName fqName3 = fqName2.parent();
        Intrinsics.checkNotNullExpressionValue(fqName3, "fqName.parent()");
        return (IrClassSymbol)this.resolveSymbol(fqName3, (Function1)new Function1<MemberScope, IrClassSymbol>(this, fqName2){
            final /* synthetic */ IrPluginContextImpl this$0;
            final /* synthetic */ FqName $fqName;

            @Nullable
            public final IrClassSymbol invoke(@NotNull MemberScope scope2) {
                IrClassSymbol irClassSymbol;
                ClassDescriptor classDescriptor2;
                Intrinsics.checkNotNullParameter(scope2, "scope");
                Name name = this.$fqName.shortName();
                Intrinsics.checkNotNullExpressionValue(name, "fqName.shortName()");
                ClassifierDescriptor classifierDescriptor = scope2.getContributedClassifier(name, NoLookupLocation.FROM_BACKEND);
                if (!(classifierDescriptor instanceof ClassDescriptor)) {
                    classifierDescriptor = null;
                }
                ClassDescriptor classDescriptor3 = classDescriptor2 = (ClassDescriptor)classifierDescriptor;
                if (classDescriptor3 != null) {
                    ClassDescriptor classDescriptor4 = classDescriptor3;
                    boolean bl = false;
                    boolean bl2 = false;
                    ClassDescriptor it = classDescriptor4;
                    boolean bl3 = false;
                    irClassSymbol = IrPluginContextImpl.access$getSt$p(this.this$0).referenceClass(it);
                } else {
                    irClassSymbol = null;
                }
                return irClassSymbol;
            }
            {
                this.this$0 = irPluginContextImpl;
                this.$fqName = fqName2;
                super(1);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<IrConstructorSymbol> referenceConstructors(@NotNull FqName classFqn) {
        void $this$mapTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter(classFqn, "classFqn");
        IrClassSymbol irClassSymbol = this.referenceClass(classFqn);
        if (irClassSymbol == null) {
            String string2 = "Cannot find class " + classFqn;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        IrClassSymbol classSymbol = irClassSymbol;
        Iterable $this$filterIsInstance$iv = ((IrClass)classSymbol.getOwner()).getDeclarations();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof IrConstructor)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterIsInstanceTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrConstructor irConstructor = (IrConstructor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            IrConstructorSymbol irConstructorSymbol = (IrConstructorSymbol)it.getSymbol();
            collection.add(irConstructorSymbol);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public Collection<IrSimpleFunctionSymbol> referenceFunctions(@NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter(fqName2, "fqName");
        boolean bl = !fqName2.isRoot();
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string2 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        FqName fqName3 = fqName2.parent();
        Intrinsics.checkNotNullExpressionValue(fqName3, "fqName.parent()");
        return this.resolveSymbolCollection(fqName3, (Function1)new Function1<MemberScope, Collection<? extends IrSimpleFunctionSymbol>>(this, fqName2){
            final /* synthetic */ IrPluginContextImpl this$0;
            final /* synthetic */ FqName $fqName;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Collection<IrSimpleFunctionSymbol> invoke(@NotNull MemberScope scope2) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter(scope2, "scope");
                Name name = this.$fqName.shortName();
                Intrinsics.checkNotNullExpressionValue(name, "fqName.shortName()");
                Collection<? extends SimpleFunctionDescriptor> descriptors = scope2.getContributedFunctions(name, NoLookupLocation.FROM_BACKEND);
                Iterable $this$map$iv = descriptors;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    SimpleFunctionDescriptor simpleFunctionDescriptor = (SimpleFunctionDescriptor)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    IrSimpleFunctionSymbol irSimpleFunctionSymbol = IrPluginContextImpl.access$getSt$p(this.this$0).referenceSimpleFunction((FunctionDescriptor)it);
                    collection.add(irSimpleFunctionSymbol);
                }
                return (List)destination$iv$iv;
            }
            {
                this.this$0 = irPluginContextImpl;
                this.$fqName = fqName2;
                super(1);
            }
        });
    }

    @Override
    @NotNull
    public Collection<IrPropertySymbol> referenceProperties(@NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter(fqName2, "fqName");
        boolean bl = !fqName2.isRoot();
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string2 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        FqName fqName3 = fqName2.parent();
        Intrinsics.checkNotNullExpressionValue(fqName3, "fqName.parent()");
        return this.resolveSymbolCollection(fqName3, (Function1)new Function1<MemberScope, Collection<? extends IrPropertySymbol>>(this, fqName2){
            final /* synthetic */ IrPluginContextImpl this$0;
            final /* synthetic */ FqName $fqName;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Collection<IrPropertySymbol> invoke(@NotNull MemberScope scope2) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter(scope2, "scope");
                Name name = this.$fqName.shortName();
                Intrinsics.checkNotNullExpressionValue(name, "fqName.shortName()");
                Collection<? extends PropertyDescriptor> descriptors = scope2.getContributedVariables(name, NoLookupLocation.FROM_BACKEND);
                Iterable $this$map$iv = descriptors;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    PropertyDescriptor propertyDescriptor = (PropertyDescriptor)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    IrPropertySymbol irPropertySymbol = IrPluginContextImpl.access$getSt$p(this.this$0).referenceProperty((PropertyDescriptor)it);
                    collection.add(irPropertySymbol);
                }
                return (List)destination$iv$iv;
            }
            {
                this.this$0 = irPluginContextImpl;
                this.$fqName = fqName2;
                super(1);
            }
        });
    }

    @Override
    @NotNull
    public BindingContext getBindingContext() {
        return this.bindingContext;
    }

    @Override
    @NotNull
    public LanguageVersionSettings getLanguageVersionSettings() {
        return this.languageVersionSettings;
    }

    @Override
    @NotNull
    public TypeTranslator getTypeTranslator() {
        return this.typeTranslator;
    }

    @Override
    @NotNull
    public IrBuiltIns getIrBuiltIns() {
        return this.irBuiltIns;
    }

    @NotNull
    public final IrDeserializer getLinker() {
        return this.linker;
    }

    @Override
    @NotNull
    public BuiltinSymbolsBase getSymbols() {
        return this.symbols;
    }

    public IrPluginContextImpl(@NotNull ModuleDescriptor module2, @NotNull BindingContext bindingContext, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull ReferenceSymbolTable st, @NotNull TypeTranslator typeTranslator, @NotNull IrBuiltIns irBuiltIns, @NotNull IrDeserializer linker, @NotNull BuiltinSymbolsBase symbols2) {
        Intrinsics.checkNotNullParameter(module2, "module");
        Intrinsics.checkNotNullParameter(bindingContext, "bindingContext");
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        Intrinsics.checkNotNullParameter(st, "st");
        Intrinsics.checkNotNullParameter(typeTranslator, "typeTranslator");
        Intrinsics.checkNotNullParameter(irBuiltIns, "irBuiltIns");
        Intrinsics.checkNotNullParameter(linker, "linker");
        Intrinsics.checkNotNullParameter(symbols2, "symbols");
        this.module = module2;
        this.bindingContext = bindingContext;
        this.languageVersionSettings = languageVersionSettings;
        this.st = st;
        this.typeTranslator = typeTranslator;
        this.irBuiltIns = irBuiltIns;
        this.linker = linker;
        this.symbols = symbols2;
        this.moduleDescriptor = this.module;
        this.symbolTable = this.st;
    }

    public /* synthetic */ IrPluginContextImpl(ModuleDescriptor moduleDescriptor, BindingContext bindingContext, LanguageVersionSettings languageVersionSettings, ReferenceSymbolTable referenceSymbolTable, TypeTranslator typeTranslator, IrBuiltIns irBuiltIns, IrDeserializer irDeserializer, BuiltinSymbolsBase builtinSymbolsBase, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x80) != 0) {
            builtinSymbolsBase = new BuiltinSymbolsBase(irBuiltIns, irBuiltIns.getBuiltIns(), referenceSymbolTable);
        }
        this(moduleDescriptor, bindingContext, languageVersionSettings, referenceSymbolTable, typeTranslator, irBuiltIns, irDeserializer, builtinSymbolsBase);
    }

    @Override
    @NotNull
    public KotlinBuiltIns getBuiltIns() {
        return IrPluginContext.DefaultImpls.getBuiltIns(this);
    }

    public static final /* synthetic */ ReferenceSymbolTable access$getSt$p(IrPluginContextImpl $this) {
        return $this.st;
    }
}

