//
// Copyright (c) ZeroC, Inc. All rights reserved.
//
//
// Ice version 3.7.4
//
// <auto-generated>
//
// Generated from file `FileParser.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

#ifndef __IceGrid_FileParser_h__
#define __IceGrid_FileParser_h__

#include <IceUtil/PushDisableWarnings.h>
#include <Ice/ProxyF.h>
#include <Ice/ObjectF.h>
#include <Ice/ValueF.h>
#include <Ice/Exception.h>
#include <Ice/LocalObject.h>
#include <Ice/StreamHelpers.h>
#include <Ice/Comparable.h>
#include <Ice/Proxy.h>
#include <Ice/Object.h>
#include <Ice/GCObject.h>
#include <Ice/Value.h>
#include <Ice/Incoming.h>
#include <Ice/IncomingAsync.h>
#include <Ice/FactoryTableInit.h>
#include <IceUtil/ScopedArray.h>
#include <Ice/Optional.h>
#include <Ice/ExceptionHelpers.h>
#include <Ice/SlicedDataF.h>
#include <IceGrid/Admin.h>
#include <IceUtil/UndefSysMacros.h>
#include <IceGrid/Config.h>

#ifndef ICE_IGNORE_VERSION
#   if ICE_INT_VERSION / 100 != 307
#       error Ice version mismatch!
#   endif
#   if ICE_INT_VERSION % 100 >= 50
#       error Beta header file detected
#   endif
#   if ICE_INT_VERSION % 100 < 4
#       error Ice patch level mismatch!
#   endif
#endif

#ifndef ICEGRID_API
#   if defined(ICE_STATIC_LIBS)
#       define ICEGRID_API /**/
#   elif defined(ICEGRID_API_EXPORTS)
#       define ICEGRID_API ICE_DECLSPEC_EXPORT
#   else
#       define ICEGRID_API ICE_DECLSPEC_IMPORT
#   endif
#endif

#ifdef ICE_CPP11_MAPPING // C++11 mapping

namespace IceGrid
{

class FileParser;
class FileParserPrx;

}

namespace IceGrid
{

/**
 * This exception is raised if an error occurs during parsing.
 * \headerfile IceGrid/IceGrid.h
 */
class ICE_CLASS(ICEGRID_API) ParseException : public ::Ice::UserExceptionHelper<ParseException, ::Ice::UserException>
{
public:

    ICE_MEMBER(ICEGRID_API) virtual ~ParseException();

    ParseException(const ParseException&) = default;

    ParseException() = default;

    /**
     * One-shot constructor to initialize all data members.
     * @param reason The reason for the failure.
     */
    ParseException(const ::std::string& reason) :
        reason(reason)
    {
    }

    /**
     * Obtains a tuple containing all of the exception's data members.
     * @return The data members in a tuple.
     */
    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(reason);
    }

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

    /**
     * The reason for the failure.
     */
    ::std::string reason;
};

/// \cond INTERNAL
static ParseException _iceS_ParseException_init;
/// \endcond

}

namespace IceGrid
{

/**
 * <code>icegridadmin</code> provides a {@link FileParser}
 * object to transform XML files into {@link ApplicationDescriptor}
 * objects.
 * \headerfile IceGrid/IceGrid.h
 */
class ICEGRID_API FileParser : public virtual ::Ice::Object
{
public:

    using ProxyType = FileParserPrx;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(::std::string id, const ::Ice::Current& current) const override;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current& current) const override;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual ::std::string ice_id(const ::Ice::Current& current) const override;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Parse a file.
     * @param xmlFile Full pathname to the file.
     * @param adminProxy An Admin proxy, used only to retrieve default
     * templates when needed. May be null.
     * @param current The Current object for the invocation.
     * @return The application descriptor.
     * @throws IceGrid::ParseException Raised if an error occurred during parsing.
     */
    virtual ApplicationDescriptor parse(::std::string xmlFile, ::std::shared_ptr<AdminPrx> adminProxy, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_parse(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
    /// \endcond
};

}

namespace IceGrid
{

/**
 * <code>icegridadmin</code> provides a {@link FileParser}
 * object to transform XML files into {@link ApplicationDescriptor}
 * objects.
 * \headerfile IceGrid/IceGrid.h
 */
class ICE_CLASS(ICEGRID_API) FileParserPrx : public virtual ::Ice::Proxy<FileParserPrx, ::Ice::ObjectPrx>
{
public:

    /**
     * Parse a file.
     * @param xmlFile Full pathname to the file.
     * @param adminProxy An Admin proxy, used only to retrieve default
     * templates when needed. May be null.
     * @param context The Context map to send with the invocation.
     * @return The application descriptor.
     * @throws IceGrid::ParseException Raised if an error occurred during parsing.
     */
    ApplicationDescriptor parse(const ::std::string& xmlFile, const ::std::shared_ptr<AdminPrx>& adminProxy, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::IceGrid::ApplicationDescriptor>(true, this, &FileParserPrx::_iceI_parse, xmlFile, adminProxy, context).get();
    }

    /**
     * Parse a file.
     * @param xmlFile Full pathname to the file.
     * @param adminProxy An Admin proxy, used only to retrieve default
     * templates when needed. May be null.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto parseAsync(const ::std::string& xmlFile, const ::std::shared_ptr<AdminPrx>& adminProxy, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::IceGrid::ApplicationDescriptor>>().get_future())
    {
        return _makePromiseOutgoing<::IceGrid::ApplicationDescriptor, P>(false, this, &FileParserPrx::_iceI_parse, xmlFile, adminProxy, context);
    }

    /**
     * Parse a file.
     * @param xmlFile Full pathname to the file.
     * @param adminProxy An Admin proxy, used only to retrieve default
     * templates when needed. May be null.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    parseAsync(const ::std::string& xmlFile, const ::std::shared_ptr<AdminPrx>& adminProxy,
               ::std::function<void(::IceGrid::ApplicationDescriptor)> response,
               ::std::function<void(::std::exception_ptr)> ex = nullptr,
               ::std::function<void(bool)> sent = nullptr,
               const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::IceGrid::ApplicationDescriptor>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::FileParserPrx::_iceI_parse, xmlFile, adminProxy, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_parse(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::IceGrid::ApplicationDescriptor>>&, const ::std::string&, const ::std::shared_ptr<AdminPrx>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Obtains the Slice type ID of this interface.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

protected:

    /// \cond INTERNAL
    FileParserPrx() = default;
    friend ::std::shared_ptr<FileParserPrx> IceInternal::createProxy<FileParserPrx>();

    ICE_MEMBER(ICEGRID_API) virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
    /// \endcond
};

}

/// \cond STREAM
namespace Ice
{

template<typename S>
struct StreamReader<::IceGrid::ParseException, S>
{
    static void read(S* istr, ::IceGrid::ParseException& v)
    {
        istr->readAll(v.reason);
    }
};

}
/// \endcond

/// \cond INTERNAL
namespace IceGrid
{

using FileParserPtr = ::std::shared_ptr<FileParser>;
using FileParserPrxPtr = ::std::shared_ptr<FileParserPrx>;

}
/// \endcond

#else // C++98 mapping

namespace IceProxy
{

namespace IceGrid
{

class FileParser;
/// \cond INTERNAL
ICEGRID_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< FileParser>&);
ICEGRID_API ::IceProxy::Ice::Object* upCast(FileParser*);
/// \endcond

}

}

namespace IceGrid
{

class FileParser;
/// \cond INTERNAL
ICEGRID_API ::Ice::Object* upCast(FileParser*);
/// \endcond
typedef ::IceInternal::Handle< FileParser> FileParserPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::FileParser> FileParserPrx;
typedef FileParserPrx FileParserPrxPtr;
/// \cond INTERNAL
ICEGRID_API void _icePatchObjectPtr(FileParserPtr&, const ::Ice::ObjectPtr&);
/// \endcond

}

namespace IceGrid
{

/**
 * This exception is raised if an error occurs during parsing.
 * \headerfile IceGrid/IceGrid.h
 */
class ICEGRID_API ParseException : public ::Ice::UserException
{
public:

    ParseException() {}
    /**
     * One-shot constructor to initialize all data members.
     * @param reason The reason for the failure.
     */
    explicit ParseException(const ::std::string& reason);
    virtual ~ParseException() throw();

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    virtual ::std::string ice_id() const;
    /**
     * Polymporphically clones this exception.
     * @return A shallow copy of this exception.
     */
    virtual ParseException* ice_clone() const;
    /**
     * Throws this exception.
     */
    virtual void ice_throw() const;

    /**
     * The reason for the failure.
     */
    ::std::string reason;

protected:

    /// \cond STREAM
    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
    /// \endcond
};

/// \cond INTERNAL
static ParseException _iceS_ParseException_init;
/// \endcond

}

/// \cond INTERNAL
namespace IceAsync
{

}
/// \endcond

namespace IceGrid
{

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::FileParser::begin_parse.
 * Create a wrapper instance by calling ::IceGrid::newCallback_FileParser_parse.
 */
class Callback_FileParser_parse_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_FileParser_parse_Base> Callback_FileParser_parsePtr;

}

namespace IceProxy
{

namespace IceGrid
{

class ICE_CLASS(ICEGRID_API) FileParser : public virtual ::Ice::Proxy<FileParser, ::IceProxy::Ice::Object>
{
public:

    /**
     * Parse a file.
     * @param xmlFile Full pathname to the file.
     * @param adminProxy An Admin proxy, used only to retrieve default
     * templates when needed. May be null.
     * @param context The Context map to send with the invocation.
     * @return The application descriptor.
     * @throws IceGrid::ParseException Raised if an error occurred during parsing.
     */
    ICE_MEMBER(ICEGRID_API) ::IceGrid::ApplicationDescriptor parse(const ::std::string& xmlFile, const ::IceGrid::AdminPrx& adminProxy, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_parse(_iceI_begin_parse(xmlFile, adminProxy, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Parse a file.
     * @param xmlFile Full pathname to the file.
     * @param adminProxy An Admin proxy, used only to retrieve default
     * templates when needed. May be null.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_parse(const ::std::string& xmlFile, const ::IceGrid::AdminPrx& adminProxy, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_parse(xmlFile, adminProxy, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Parse a file.
     * @param xmlFile Full pathname to the file.
     * @param adminProxy An Admin proxy, used only to retrieve default
     * templates when needed. May be null.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_parse(const ::std::string& xmlFile, const ::IceGrid::AdminPrx& adminProxy, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_parse(xmlFile, adminProxy, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Parse a file.
     * @param xmlFile Full pathname to the file.
     * @param adminProxy An Admin proxy, used only to retrieve default
     * templates when needed. May be null.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_parse(const ::std::string& xmlFile, const ::IceGrid::AdminPrx& adminProxy, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_parse(xmlFile, adminProxy, context, cb, cookie);
    }

    /**
     * Parse a file.
     * @param xmlFile Full pathname to the file.
     * @param adminProxy An Admin proxy, used only to retrieve default
     * templates when needed. May be null.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_parse(const ::std::string& xmlFile, const ::IceGrid::AdminPrx& adminProxy, const ::IceGrid::Callback_FileParser_parsePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_parse(xmlFile, adminProxy, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Parse a file.
     * @param xmlFile Full pathname to the file.
     * @param adminProxy An Admin proxy, used only to retrieve default
     * templates when needed. May be null.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_parse(const ::std::string& xmlFile, const ::IceGrid::AdminPrx& adminProxy, const ::Ice::Context& context, const ::IceGrid::Callback_FileParser_parsePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_parse(xmlFile, adminProxy, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_parse.
     * @param result The asynchronous result object for the invocation.
     * @return The application descriptor.
     * @throws IceGrid::ParseException Raised if an error occurred during parsing.
     */
    ICE_MEMBER(ICEGRID_API) ::IceGrid::ApplicationDescriptor end_parse(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_parse(const ::std::string&, const ::IceGrid::AdminPrx&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Obtains the Slice type ID corresponding to this interface.
     * @return A fully-scoped type ID.
     */
    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    ICE_MEMBER(ICEGRID_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

}

}

namespace IceGrid
{

/**
 * <code>icegridadmin</code> provides a {@link FileParser}
 * object to transform XML files into {@link ApplicationDescriptor}
 * objects.
 * \headerfile IceGrid/IceGrid.h
 */
class ICEGRID_API FileParser : public virtual ::Ice::Object
{
public:

    typedef FileParserPrx ProxyType;
    typedef FileParserPtr PointerType;

    virtual ~FileParser();

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Parse a file.
     * @param xmlFile Full pathname to the file.
     * @param adminProxy An Admin proxy, used only to retrieve default
     * templates when needed. May be null.
     * @param current The Current object for the invocation.
     * @return The application descriptor.
     * @throws IceGrid::ParseException Raised if an error occurred during parsing.
     */
    virtual ApplicationDescriptor parse(const ::std::string& xmlFile, const AdminPrx& adminProxy, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_parse(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
    /// \endcond
};

/// \cond INTERNAL
inline bool operator==(const FileParser& lhs, const FileParser& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const FileParser& lhs, const FileParser& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}
/// \endcond

}

/// \cond STREAM
namespace Ice
{

template<>
struct StreamableTraits< ::IceGrid::ParseException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<typename S>
struct StreamWriter< ::IceGrid::ParseException, S>
{
    static void write(S* ostr, const ::IceGrid::ParseException& v)
    {
        ostr->write(v.reason);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::ParseException, S>
{
    static void read(S* istr, ::IceGrid::ParseException& v)
    {
        istr->read(v.reason);
    }
};

}
/// \endcond

namespace IceGrid
{

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::FileParser::begin_parse.
 * Create a wrapper instance by calling ::IceGrid::newCallback_FileParser_parse.
 */
template<class T>
class CallbackNC_FileParser_parse : public Callback_FileParser_parse_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ApplicationDescriptor&);

    CallbackNC_FileParser_parse(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        FileParserPrx proxy = FileParserPrx::uncheckedCast(result->getProxy());
        ApplicationDescriptor ret;
        try
        {
            ret = proxy->end_parse(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::FileParser::begin_parse.
 */
template<class T> Callback_FileParser_parsePtr
newCallback_FileParser_parse(const IceUtil::Handle<T>& instance, void (T::*cb)(const ApplicationDescriptor&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_FileParser_parse<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::FileParser::begin_parse.
 */
template<class T> Callback_FileParser_parsePtr
newCallback_FileParser_parse(T* instance, void (T::*cb)(const ApplicationDescriptor&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_FileParser_parse<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::FileParser::begin_parse.
 * Create a wrapper instance by calling ::IceGrid::newCallback_FileParser_parse.
 */
template<class T, typename CT>
class Callback_FileParser_parse : public Callback_FileParser_parse_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ApplicationDescriptor&, const CT&);

    Callback_FileParser_parse(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        FileParserPrx proxy = FileParserPrx::uncheckedCast(result->getProxy());
        ApplicationDescriptor ret;
        try
        {
            ret = proxy->end_parse(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::FileParser::begin_parse.
 */
template<class T, typename CT> Callback_FileParser_parsePtr
newCallback_FileParser_parse(const IceUtil::Handle<T>& instance, void (T::*cb)(const ApplicationDescriptor&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_FileParser_parse<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::FileParser::begin_parse.
 */
template<class T, typename CT> Callback_FileParser_parsePtr
newCallback_FileParser_parse(T* instance, void (T::*cb)(const ApplicationDescriptor&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_FileParser_parse<T, CT>(instance, cb, excb, sentcb);
}

}

#endif

#include <IceUtil/PopDisableWarnings.h>
#endif
