/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ha.backend;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.StringTokenizer;
import org.apache.catalina.ha.backend.HeartbeatListener;
import org.apache.catalina.ha.backend.Proxy;
import org.apache.catalina.ha.backend.Sender;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class TcpSender
implements Sender {
    private static final Log log = LogFactory.getLog(HeartbeatListener.class);
    HeartbeatListener config = null;
    protected Proxy[] proxies = null;
    protected Socket[] connections = null;
    protected BufferedReader[] connectionReaders = null;
    protected BufferedWriter[] connectionWriters = null;

    @Override
    public void init(HeartbeatListener heartbeatListener) throws Exception {
        this.config = heartbeatListener;
        StringTokenizer stringTokenizer = new StringTokenizer(heartbeatListener.getProxyList(), ",");
        this.proxies = new Proxy[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken().trim();
            int n2 = string.indexOf(58);
            if (n2 <= 0) {
                throw new Exception("bad ProxyList");
            }
            this.proxies[n] = new Proxy();
            this.proxies[n].port = Integer.parseInt(string.substring(n2 + 1));
            try {
                this.proxies[n].address = InetAddress.getByName(string.substring(0, n2));
            }
            catch (Exception exception) {
                throw new Exception("bad ProxyList");
            }
            ++n;
        }
        this.connections = new Socket[this.proxies.length];
        this.connectionReaders = new BufferedReader[this.proxies.length];
        this.connectionWriters = new BufferedWriter[this.proxies.length];
    }

    @Override
    public int send(String string) throws Exception {
        if (this.connections == null) {
            log.error((Object)"Not initialized");
            return -1;
        }
        String string2 = "POST " + this.config.getProxyURL() + " HTTP/1.0";
        block4: for (int i = 0; i < this.connections.length; ++i) {
            Object object;
            Object object2;
            if (this.connections[i] == null) {
                try {
                    if (this.config.getHost() != null) {
                        this.connections[i] = new Socket();
                        object2 = InetAddress.getByName(this.config.getHost());
                        object = new InetSocketAddress((InetAddress)object2, 0);
                        this.connections[i].setReuseAddress(true);
                        this.connections[i].bind((SocketAddress)object);
                        object = new InetSocketAddress(this.proxies[i].address, this.proxies[i].port);
                        this.connections[i].connect((SocketAddress)object);
                    } else {
                        this.connections[i] = new Socket(this.proxies[i].address, this.proxies[i].port);
                    }
                    this.connectionReaders[i] = new BufferedReader(new InputStreamReader(this.connections[i].getInputStream()));
                    this.connectionWriters[i] = new BufferedWriter(new OutputStreamWriter(this.connections[i].getOutputStream()));
                }
                catch (Exception exception) {
                    log.error((Object)("Unable to connect to proxy: " + exception));
                    this.close(i);
                }
            }
            if (this.connections[i] == null) continue;
            object2 = this.connectionWriters[i];
            try {
                ((Writer)object2).write(string2);
                ((Writer)object2).write("\r\n");
                ((Writer)object2).write("Content-Length: " + string.length() + "\r\n");
                ((Writer)object2).write("User-Agent: HeartbeatListener/1.0\r\n");
                ((Writer)object2).write("Connection: Keep-Alive\r\n");
                ((Writer)object2).write("\r\n");
                ((Writer)object2).write(string);
                ((Writer)object2).write("\r\n");
                ((BufferedWriter)object2).flush();
            }
            catch (Exception exception) {
                log.error((Object)("Unable to send collected load information to proxy: " + exception));
                this.close(i);
            }
            if (this.connections[i] == null) continue;
            object = this.connectionReaders[i].readLine();
            if (object == null) {
                log.error((Object)"Unable to read response from proxy");
                this.close(i);
                continue;
            }
            int n = Integer.parseInt((String)(object = ((String)object).substring(((String)object).indexOf(32) + 1, ((String)object).indexOf(32, ((String)object).indexOf(32) + 1))));
            if (n != 200) {
                log.error((Object)("Status is " + n));
                this.close(i);
                continue;
            }
            String string3 = this.connectionReaders[i].readLine();
            int n2 = 0;
            while (!string3.isEmpty()) {
                int n3 = string3.indexOf(58);
                String string4 = string3.substring(0, n3).trim();
                String string5 = string3.substring(n3 + 1).trim();
                if ("content-length".equalsIgnoreCase(string4)) {
                    n2 = Integer.parseInt(string5);
                }
                string3 = this.connectionReaders[i].readLine();
            }
            if (n2 <= 0) continue;
            char[] cArray = new char[512];
            while (n2 > 0) {
                int n4 = n2 > cArray.length ? cArray.length : n2;
                int n5 = this.connectionReaders[i].read(cArray, 0, n4);
                if (n5 <= 0) {
                    log.error((Object)"Read content failed");
                    this.close(i);
                    continue block4;
                }
                n2 -= n5;
            }
        }
        return 0;
    }

    protected void close(int n) {
        try {
            if (this.connectionReaders[n] != null) {
                this.connectionReaders[n].close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.connectionReaders[n] = null;
        try {
            if (this.connectionWriters[n] != null) {
                this.connectionWriters[n].close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.connectionWriters[n] = null;
        try {
            if (this.connections[n] != null) {
                this.connections[n].close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.connections[n] = null;
    }
}

