/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.config.Config;
import tim.prune.data.DataPoint;
import tim.prune.data.Distance;
import tim.prune.data.Field;
import tim.prune.data.Latitude;
import tim.prune.data.Longitude;
import tim.prune.data.Unit;
import tim.prune.data.UnitSetLibrary;
import tim.prune.gui.DecimalNumberField;
import tim.prune.gui.GuiGridLayout;
import tim.prune.gui.WholeNumberField;

public class ProjectPoint
extends GenericFunction {
    private JDialog _dialog = null;
    private WholeNumberField _bearingField = null;
    private JLabel _distanceDescLabel = null;
    private DecimalNumberField _distanceField = null;
    private boolean _distanceIsMetric = true;
    private JTextField _nameField = null;
    private JButton _okButton = null;

    public ProjectPoint(App app) {
        super(app);
    }

    @Override
    public String getNameKey() {
        return "function.projectpoint";
    }

    @Override
    public void begin() {
        if (this._dialog == null) {
            this._dialog = new JDialog(this._parentFrame, I18nManager.getText(this.getNameKey()), true);
            this._dialog.setLocationRelativeTo(this._parentFrame);
            this._dialog.setDefaultCloseOperation(2);
            this._dialog.getContentPane().add(this.makeDialogComponents());
            this._dialog.pack();
        }
        this._bearingField.setText("");
        this._distanceField.setText("");
        this._nameField.setText("");
        this.setLabelText();
        this.enableOK();
        this._dialog.setVisible(true);
    }

    private Component makeDialogComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 10));
        jPanel.add((Component)new JLabel(I18nManager.getText("dialog.projectpoint.desc")), "North");
        JPanel jPanel2 = new JPanel();
        GuiGridLayout guiGridLayout = new GuiGridLayout(jPanel2);
        this._bearingField = new WholeNumberField(3);
        this._distanceField = new DecimalNumberField(false);
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                ProjectPoint.this.enableOK();
                if (keyEvent.getKeyCode() == 27) {
                    ProjectPoint.this._dialog.dispose();
                }
            }
        };
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                ProjectPoint.this.enableOK();
            }
        };
        this._bearingField.addKeyListener(keyAdapter);
        this._bearingField.addMouseListener(mouseAdapter);
        this._distanceField.addKeyListener(keyAdapter);
        this._distanceField.addMouseListener(mouseAdapter);
        JLabel jLabel = new JLabel(I18nManager.getText("dialog.projectpoint.bearing"));
        jLabel.setHorizontalAlignment(4);
        guiGridLayout.add(jLabel);
        guiGridLayout.add(this._bearingField);
        this._distanceDescLabel = new JLabel(String.valueOf(I18nManager.getText("fieldname.distance")) + " (ft)");
        this._distanceDescLabel.setHorizontalAlignment(4);
        guiGridLayout.add(this._distanceDescLabel);
        guiGridLayout.add(this._distanceField);
        JLabel jLabel2 = new JLabel(I18nManager.getText("dialog.pointnameedit.name"));
        jLabel2.setHorizontalAlignment(4);
        guiGridLayout.add(jLabel2);
        this._nameField = new JTextField("", 12);
        guiGridLayout.add(this._nameField);
        jPanel.add((Component)jPanel2, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(2));
        this._okButton = new JButton(I18nManager.getText("button.ok"));
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ProjectPoint.this._okButton.isEnabled()) {
                    ProjectPoint.this.finish();
                }
            }
        };
        this._okButton.addActionListener(actionListener);
        this._okButton.setEnabled(false);
        jPanel3.add(this._okButton);
        JButton jButton = new JButton(I18nManager.getText("button.cancel"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProjectPoint.this._dialog.dispose();
            }
        });
        jPanel3.add(jButton);
        jPanel.add((Component)jPanel3, "South");
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 15));
        return jPanel;
    }

    private void setLabelText() {
        Unit unit = Config.getUnitSet().getDistanceUnit();
        this._distanceIsMetric = unit == UnitSetLibrary.UNITS_METRES || unit == UnitSetLibrary.UNITS_KILOMETRES;
        unit = this._distanceIsMetric ? UnitSetLibrary.UNITS_METRES : UnitSetLibrary.UNITS_FEET;
        String string = unit.getShortnameKey();
        this._distanceDescLabel.setText(String.valueOf(I18nManager.getText("fieldname.distance")) + " (" + I18nManager.getText(string) + ")");
    }

    private void enableOK() {
        boolean bl = !this._bearingField.getText().isEmpty() && this._bearingField.getValue() < 360;
        boolean bl2 = this._distanceField.getValue() > 0.0;
        this._okButton.setEnabled(bl && bl2);
    }

    private void finish() {
        DataPoint dataPoint = this._app.getTrackInfo().getCurrentPoint();
        Unit unit = this._distanceIsMetric ? UnitSetLibrary.UNITS_METRES : UnitSetLibrary.UNITS_FEET;
        double d = Distance.convertDistanceToRadians(this._distanceField.getValue(), unit);
        double d2 = Math.toRadians(dataPoint.getLatitude().getDouble());
        double d3 = Math.toRadians(dataPoint.getLongitude().getDouble());
        System.out.println("Project from: " + d2 + ", " + d3);
        double d4 = Math.toRadians(this._bearingField.getValue());
        double d5 = Math.asin(Math.sin(d2) * Math.cos(d) + Math.cos(d2) * Math.sin(d) * Math.cos(d4));
        double d6 = d3 + Math.atan2(Math.sin(d4) * Math.sin(d) * Math.cos(d2), Math.cos(d) - Math.sin(d2) * Math.sin(d5));
        double d7 = Math.toDegrees(d5);
        double d8 = Math.toDegrees(d6);
        System.out.println("Result is: lat=" + d7 + ", lon=" + d8);
        DataPoint dataPoint2 = new DataPoint(new Latitude(d7, 12), new Longitude(d8, 12), null);
        dataPoint2.setFieldValue(Field.WAYPT_NAME, this._nameField.getText(), false);
        this._app.createPoint(dataPoint2);
        this._dialog.dispose();
    }
}

