/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.estimate;

import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import tim.prune.I18nManager;
import tim.prune.function.estimate.EstimationParameters;
import tim.prune.gui.DisplayUtils;

public class ParametersPanel
extends JPanel {
    private boolean _showAverageError = false;
    private JLabel _fsUnitsLabel = null;
    private JLabel _flatSpeedLabel = null;
    private JLabel _climbUnitsLabel = null;
    private JLabel _gentleClimbLabel = null;
    private JLabel _steepClimbLabel = null;
    private JLabel _descentUnitsLabel = null;
    private JLabel _gentleDescentLabel = null;
    private JLabel _steepDescentLabel = null;
    private JLabel _averageErrorLabel = null;

    public ParametersPanel(String string) {
        this(string, false);
    }

    public ParametersPanel(String string, boolean bl) {
        this._showAverageError = bl;
        if (string != null) {
            this.setBorder(BorderFactory.createTitledBorder(I18nManager.getText(string)));
        }
        this.setLayout(new GridLayout(0, 3, 3, 3));
        this.addLabels();
    }

    private void addLabels() {
        this._fsUnitsLabel = new JLabel(String.valueOf(I18nManager.getText("dialog.estimatetime.parameters.timefor")) + " 5km : ");
        this._fsUnitsLabel.setAlignmentX(1.0f);
        this.add(this._fsUnitsLabel);
        this._flatSpeedLabel = new JLabel("60 minutes");
        this.add(this._flatSpeedLabel);
        this.add(new JLabel(""));
        this.add(new JLabel(""));
        JLabel jLabel = new JLabel(I18nManager.getText("dialog.estimatetime.gentle"));
        this.add(jLabel);
        JLabel jLabel2 = new JLabel(I18nManager.getText("dialog.estimatetime.steep"));
        this.add(jLabel2);
        this._climbUnitsLabel = new JLabel("Climb 100m: ");
        this._climbUnitsLabel.setAlignmentX(1.0f);
        this.add(this._climbUnitsLabel);
        this._gentleClimbLabel = new JLabel("22 minutes");
        this.add(this._gentleClimbLabel);
        this._steepClimbLabel = new JLabel("22 minutes");
        this.add(this._steepClimbLabel);
        this._descentUnitsLabel = new JLabel(String.valueOf(I18nManager.getText("dialog.estimatetime.parameters.timefor")) + ": ");
        this._descentUnitsLabel.setAlignmentX(1.0f);
        this.add(this._descentUnitsLabel);
        this._gentleDescentLabel = new JLabel("22 minutes");
        this.add(this._gentleDescentLabel);
        this._steepDescentLabel = new JLabel("22 minutes");
        this.add(this._steepDescentLabel);
        if (this._showAverageError) {
            JLabel jLabel3 = new JLabel(String.valueOf(I18nManager.getText("dialog.learnestimationparams.averageerror")) + ": ");
            jLabel3.setAlignmentX(1.0f);
            this.add(jLabel3);
            this._averageErrorLabel = new JLabel("22 minutes");
            this.add(this._averageErrorLabel);
        }
    }

    private void updateParameters(EstimationParameters estimationParameters, double d, boolean bl) {
        if (estimationParameters == null || !estimationParameters.isValid()) {
            this._flatSpeedLabel.setText("");
            this._gentleClimbLabel.setText("");
            this._steepClimbLabel.setText("");
            this._gentleDescentLabel.setText("");
            this._steepDescentLabel.setText("");
        } else {
            String string = " " + I18nManager.getText("units.minutes");
            String[] stringArray = estimationParameters.getStrings();
            this._fsUnitsLabel.setText(String.valueOf(I18nManager.getText("dialog.estimatetime.parameters.timefor")) + " " + EstimationParameters.getStandardDistance() + ": ");
            this._flatSpeedLabel.setText(String.valueOf(stringArray[0]) + string);
            String string2 = " " + EstimationParameters.getStandardClimb() + ": ";
            this._climbUnitsLabel.setText(String.valueOf(I18nManager.getText("dialog.estimatetime.climb")) + string2);
            this._gentleClimbLabel.setText(String.valueOf(stringArray[1]) + string);
            this._steepClimbLabel.setText(String.valueOf(stringArray[2]) + string);
            this._descentUnitsLabel.setText(String.valueOf(I18nManager.getText("dialog.estimatetime.descent")) + string2);
            this._gentleDescentLabel.setText(String.valueOf(stringArray[3]) + string);
            this._steepDescentLabel.setText(String.valueOf(stringArray[4]) + string);
        }
        if (this._averageErrorLabel != null) {
            if (estimationParameters == null || !estimationParameters.isValid() || !bl) {
                this._averageErrorLabel.setText("");
            } else {
                this._averageErrorLabel.setText(String.valueOf(DisplayUtils.formatOneDp(d)) + " %");
            }
        }
    }

    public void updateParameters(EstimationParameters estimationParameters) {
        this.updateParameters(estimationParameters, 0.0, false);
    }

    public void updateParameters(EstimationParameters estimationParameters, double d) {
        this.updateParameters(estimationParameters, d, true);
    }
}

