/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.messages.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.SmartFMap;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.MessageHandler;
import com.intellij.util.messages.Topic;
import com.intellij.util.messages.impl.Message;
import com.intellij.util.messages.impl.MessageBusImpl;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import org.jetbrains.annotations.NotNull;

final class MessageBusConnectionImpl
implements MessageBusConnection {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.messages.impl.MessageBusConnectionImpl");
    private final MessageBusImpl myBus;
    private final ThreadLocal<Queue<Message>> myPendingMessages;
    private MessageHandler myDefaultHandler;
    private volatile SmartFMap<Topic<?>, Object> mySubscriptions;

    MessageBusConnectionImpl(@NotNull MessageBusImpl bus) {
        if (bus == null) {
            MessageBusConnectionImpl.$$$reportNull$$$0(0);
        }
        this.myPendingMessages = MessageBusImpl.createThreadLocalQueue();
        this.mySubscriptions = SmartFMap.emptyMap();
        this.myBus = bus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <L> void subscribe(@NotNull Topic<L> topic, @NotNull L handler2) {
        if (topic == null) {
            MessageBusConnectionImpl.$$$reportNull$$$0(1);
        }
        if (handler2 == null) {
            MessageBusConnectionImpl.$$$reportNull$$$0(2);
        }
        boolean notifyBusAboutTopic = false;
        ThreadLocal<Queue<Message>> threadLocal = this.myPendingMessages;
        synchronized (threadLocal) {
            Object currentHandler = this.mySubscriptions.get(topic);
            if (currentHandler == null) {
                this.mySubscriptions = this.mySubscriptions.plus(topic, handler2);
                notifyBusAboutTopic = true;
            } else if (currentHandler instanceof List) {
                ((List)currentHandler).add(handler2);
            } else {
                ArrayList<Object> newList = new ArrayList<Object>();
                newList.add(currentHandler);
                newList.add(handler2);
                this.mySubscriptions = this.mySubscriptions.plus(topic, newList);
            }
        }
        if (notifyBusAboutTopic) {
            this.myBus.notifyOnSubscription(this, topic);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <L> void subscribe(@NotNull Topic<L> topic, @NotNull List<Object> handlers2) {
        if (topic == null) {
            MessageBusConnectionImpl.$$$reportNull$$$0(3);
        }
        if (handlers2 == null) {
            MessageBusConnectionImpl.$$$reportNull$$$0(4);
        }
        boolean notifyBusAboutTopic = false;
        ThreadLocal<Queue<Message>> threadLocal = this.myPendingMessages;
        synchronized (threadLocal) {
            Object currentHandler = this.mySubscriptions.get(topic);
            if (currentHandler == null) {
                this.mySubscriptions = this.mySubscriptions.plus(topic, handlers2);
                notifyBusAboutTopic = true;
            } else if (currentHandler instanceof List) {
                ((List)currentHandler).addAll(handlers2);
            } else {
                ArrayList<Object> newList = new ArrayList<Object>(handlers2.size() + 1);
                newList.add(currentHandler);
                newList.addAll(handlers2);
                this.mySubscriptions = this.mySubscriptions.plus(topic, newList);
            }
        }
        if (notifyBusAboutTopic) {
            this.myBus.notifyOnSubscription(this, topic);
        }
    }

    @Override
    public void dispose() {
        this.myPendingMessages.get();
        this.myPendingMessages.remove();
        this.myBus.notifyConnectionTerminated(this);
    }

    @Override
    public void disconnect() {
        Disposer.dispose(this);
    }

    @Override
    public void deliverImmediately() {
        Queue<Message> messages = this.myPendingMessages.get();
        while (!messages.isEmpty()) {
            this.myBus.deliverSingleMessage();
        }
    }

    void deliverMessage(@NotNull Message message2) {
        if (message2 == null) {
            MessageBusConnectionImpl.$$$reportNull$$$0(6);
        }
        Message messageOnLocalQueue = this.myPendingMessages.get().poll();
        assert (messageOnLocalQueue == message2);
        Topic topic = message2.getTopic();
        Object handler2 = this.mySubscriptions.get(topic);
        try {
            if (handler2 == this.myDefaultHandler) {
                this.myDefaultHandler.handle(message2.getListenerMethod(), message2.getArgs());
            } else if (handler2 instanceof List) {
                for (Object o : (List)handler2) {
                    this.myBus.invokeListener(message2, o);
                }
            } else {
                this.myBus.invokeListener(message2, handler2);
            }
        }
        catch (AbstractMethodError abstractMethodError) {
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof ProcessCanceledException) {
                throw (ProcessCanceledException)e.getCause();
            }
            LOG.error(e.getCause() == null ? e : e.getCause());
        }
        catch (Throwable e) {
            LOG.error(e.getCause() == null ? e : e.getCause());
        }
    }

    void scheduleMessageDelivery(@NotNull Message message2) {
        if (message2 == null) {
            MessageBusConnectionImpl.$$$reportNull$$$0(7);
        }
        this.myPendingMessages.get().offer(message2);
    }

    public String toString() {
        return this.mySubscriptions.toString();
    }

    @NotNull
    MessageBusImpl getBus() {
        MessageBusImpl messageBusImpl = this.myBus;
        if (messageBusImpl == null) {
            MessageBusConnectionImpl.$$$reportNull$$$0(9);
        }
        return messageBusImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bus";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topic";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handlers";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/messages/impl/MessageBusConnectionImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/messages/impl/MessageBusConnectionImpl";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getBus";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "subscribe";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "deliverMessage";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "scheduleMessageDelivery";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "containsMessage";
                break;
            }
            case 9: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

