/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower.loops;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import org.jetbrains.kotlin.backend.common.ScopeWithIr;
import org.jetbrains.kotlin.backend.common.ir.Symbols;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.common.lower.loops.DefaultHeaderInfoBuilder;
import org.jetbrains.kotlin.backend.common.lower.loops.ForLoopHeader;
import org.jetbrains.kotlin.backend.common.lower.loops.HeaderProcessor;
import org.jetbrains.kotlin.backend.common.lower.loops.LoopReplacement;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.Scope;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetVariable;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.expressions.impl.IrCompositeImpl;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrVariableSymbol;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoidKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001:\u0002*+B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002J\u0006\u0010\u001b\u001a\u00020\u001cJ\u0018\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\u001a\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020%2\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00030\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/loops/RangeLoopTransformer;", "Lorg/jetbrains/kotlin/backend/common/IrElementTransformerVoidWithContext;", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrSymbolOwner;", "oldLoopToNewLoop", "", "Lorg/jetbrains/kotlin/ir/expressions/IrLoop;", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;Lorg/jetbrains/kotlin/ir/declarations/IrSymbolOwner;Ljava/util/Map;)V", "getContainer", "()Lorg/jetbrains/kotlin/ir/declarations/IrSymbolOwner;", "getContext", "()Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "headerInfoBuilder", "Lorg/jetbrains/kotlin/backend/common/lower/loops/DefaultHeaderInfoBuilder;", "headerProcessor", "Lorg/jetbrains/kotlin/backend/common/lower/loops/HeaderProcessor;", "getOldLoopToNewLoop", "()Ljava/util/Map;", "symbols", "Lorg/jetbrains/kotlin/backend/common/ir/Symbols;", "gatherLoopVariableInfo", "Lorg/jetbrains/kotlin/backend/common/lower/loops/RangeLoopTransformer$LoopVariableInfo;", "statements", "", "Lorg/jetbrains/kotlin/ir/IrStatement;", "getScopeOwnerSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "lowerHeader", "variable", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "loopHeader", "Lorg/jetbrains/kotlin/backend/common/lower/loops/ForLoopHeader;", "lowerWhileLoop", "Lorg/jetbrains/kotlin/backend/common/lower/loops/LoopReplacement;", "loop", "Lorg/jetbrains/kotlin/ir/expressions/IrWhileLoop;", "visitBlock", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrBlock;", "FindInitializerCallVisitor", "LoopVariableInfo", "ir.backend.common"})
final class RangeLoopTransformer
extends IrElementTransformerVoidWithContext {
    private final Symbols<CommonBackendContext> symbols;
    private final DefaultHeaderInfoBuilder headerInfoBuilder;
    private final HeaderProcessor headerProcessor;
    @NotNull
    private final CommonBackendContext context;
    @NotNull
    private final IrSymbolOwner container;
    @NotNull
    private final Map<IrLoop, IrLoop> oldLoopToNewLoop;

    @NotNull
    public final IrSymbol getScopeOwnerSymbol() {
        Object object = this.getCurrentScope();
        if (object == null || (object = ((ScopeWithIr)object).getScope()) == null || (object = ((Scope)object).getScopeOwnerSymbol()) == null) {
            object = this.container.getSymbol();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public IrExpression visitBlock(@NotNull IrBlock expression2) {
        void newLoop;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        if (Intrinsics.areEqual(expression2.getOrigin(), IrStatementOrigin.FOR_LOOP.INSTANCE) ^ true) {
            return super.visitBlock(expression2);
        }
        List<IrStatement> list2 = expression2.getStatements();
        boolean bl = false;
        boolean bl2 = false;
        List<IrStatement> $this$with = list2;
        boolean bl3 = false;
        boolean bl4 = $this$with.size() == 2;
        boolean bl5 = false;
        if (_Assertions.ENABLED && !bl4) {
            boolean $i$a$-assert-RangeLoopTransformer$visitBlock$1$42 = false;
            String $i$a$-assert-RangeLoopTransformer$visitBlock$1$42 = "Expected 2 statements in for-loop block, was:\n" + DumpIrTreeKt.dump$default(expression2, false, 1, null);
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-RangeLoopTransformer$visitBlock$1$42));
        }
        IrStatement irStatement = $this$with.get(0);
        if (irStatement == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrVariable");
        }
        IrVariable iteratorVariable = (IrVariable)irStatement;
        bl5 = Intrinsics.areEqual(iteratorVariable.getOrigin(), IrDeclarationOrigin.FOR_LOOP_ITERATOR.INSTANCE);
        boolean $i$a$-assert-RangeLoopTransformer$visitBlock$1$42 = false;
        if (_Assertions.ENABLED && !bl5) {
            boolean $i$a$-assert-RangeLoopTransformer$visitBlock$1$52 = false;
            String $i$a$-assert-RangeLoopTransformer$visitBlock$1$52 = "Expected FOR_LOOP_ITERATOR origin for iterator variable, was:\n" + DumpIrTreeKt.dump$default(iteratorVariable, false, 1, null);
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-RangeLoopTransformer$visitBlock$1$52));
        }
        ForLoopHeader forLoopHeader = this.headerProcessor.extractHeader(iteratorVariable);
        if (forLoopHeader == null) {
            return super.visitBlock(expression2);
        }
        ForLoopHeader loopHeader = forLoopHeader;
        IrStatement loweredHeader = this.lowerHeader(iteratorVariable, loopHeader);
        IrStatement irStatement2 = $this$with.get(1);
        if (irStatement2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrWhileLoop");
        }
        IrWhileLoop oldLoop = (IrWhileLoop)irStatement2;
        boolean bl6 = Intrinsics.areEqual(oldLoop.getOrigin(), IrStatementOrigin.FOR_LOOP_INNER_WHILE.INSTANCE);
        boolean bl7 = false;
        if (_Assertions.ENABLED && !bl6) {
            boolean bl8 = false;
            String string2 = "Expected FOR_LOOP_INNER_WHILE origin for while loop, was:\n" + DumpIrTreeKt.dump$default(oldLoop, false, 1, null);
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        LoopReplacement loopReplacement = this.lowerWhileLoop(oldLoop, loopHeader);
        if (loopReplacement == null) {
            return super.visitBlock(expression2);
        }
        LoopReplacement loopReplacement2 = loopReplacement;
        IrLoop irLoop = loopReplacement2.component1();
        IrExpression loopReplacementExpression = loopReplacement2.component2();
        this.oldLoopToNewLoop.put(oldLoop, (IrLoop)newLoop);
        $this$with.set(0, loweredHeader);
        $this$with.set(1, loopReplacementExpression);
        return super.visitBlock(expression2);
    }

    private final IrStatement lowerHeader(IrVariable variable2, ForLoopHeader loopHeader) {
        return new IrCompositeImpl(variable2.getStartOffset(), variable2.getEndOffset(), this.context.getIrBuiltIns().getUnitType(), null, loopHeader.getLoopInitStatements());
    }

    /*
     * WARNING - void declaration
     */
    private final LoopReplacement lowerWhileLoop(IrWhileLoop loop2, ForLoopHeader loopHeader) {
        IrExpression irExpression;
        void mainLoopVariableIndex;
        void loopVariableComponents;
        void mainLoopVariable;
        Object object;
        IrExpression irExpression2 = loop2.getBody();
        if (!(irExpression2 instanceof IrContainerExpression)) {
            irExpression2 = null;
        }
        if ((object = (IrContainerExpression)irExpression2) == null || (object = object.getStatements()) == null) {
            return null;
        }
        Object loopBodyStatements = object;
        LoopVariableInfo loopVariableInfo = this.gatherLoopVariableInfo((List<IrStatement>)loopBodyStatements);
        IrVariable irVariable2 = loopVariableInfo.component1();
        int n = loopVariableInfo.component2();
        Map<Integer, IrVariable> map2 = loopVariableInfo.component3();
        List<Integer> loopVariableComponentIndices = loopVariableInfo.component4();
        if (loopHeader.getConsumesLoopVariableComponents() && Intrinsics.areEqual(mainLoopVariable.getOrigin(), IrDeclarationOrigin.IR_TEMPORARY_VARIABLE.INSTANCE) ^ true) {
            return null;
        }
        IrExpression irExpression3 = mainLoopVariable.getInitializer();
        Intrinsics.checkNotNull(irExpression3);
        IrExpression initializer2 = irExpression3;
        DeclarationIrBuilder declarationIrBuilder = LowerUtilsKt.createIrBuilder(this.context, this.getScopeOwnerSymbol(), initializer2.getStartOffset(), initializer2.getEndOffset());
        boolean bl = false;
        boolean bl2 = false;
        DeclarationIrBuilder $this$with = declarationIrBuilder;
        boolean bl3 = false;
        IrCompositeImpl replacement = new IrCompositeImpl(mainLoopVariable.getStartOffset(), mainLoopVariable.getEndOffset(), $this$with.getContext().getIrBuiltIns().getUnitType(), IrStatementOrigin.FOR_LOOP_NEXT.INSTANCE, loopHeader.initializeIteration((IrVariable)mainLoopVariable, (Map<Integer, ? extends IrVariable>)loopVariableComponents, $this$with));
        if (loopHeader.getConsumesLoopVariableComponents()) {
            Iterator<Integer> iterator2 = CollectionsKt.asReversed(loopVariableComponentIndices).iterator();
            while (iterator2.hasNext()) {
                int index2 = ((Number)iterator2.next()).intValue();
                bl2 = index2 > mainLoopVariableIndex;
                boolean bl4 = false;
                bl3 = false;
                if (_Assertions.ENABLED && !bl2) {
                    boolean bl5 = false;
                    String string2 = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string2));
                }
                loopBodyStatements.remove(index2);
            }
        }
        loopBodyStatements.set((int)mainLoopVariableIndex, replacement);
        IrExpression irExpression4 = loop2.getBody();
        if (irExpression4 != null) {
            IrExpression irExpression5 = irExpression4;
            bl2 = false;
            boolean bl6 = false;
            IrExpression it = irExpression5;
            boolean bl7 = false;
            irExpression = it instanceof IrContainerExpression && !((IrContainerExpression)it).isTransparentScope() ? (IrExpression)new IrCompositeImpl(loop2.getStartOffset(), loop2.getEndOffset(), it.getType(), ((IrContainerExpression)it).getOrigin(), ((IrContainerExpression)it).getStatements()) : it;
        } else {
            irExpression = null;
        }
        IrExpression newBody = irExpression;
        return loopHeader.buildLoop(LowerUtilsKt.createIrBuilder(this.context, this.getScopeOwnerSymbol(), loop2.getStartOffset(), loop2.getEndOffset()), loop2, newBody);
    }

    /*
     * WARNING - void declaration
     */
    private final LoopVariableInfo gatherLoopVariableInfo(List<IrStatement> statements2) {
        IrVariable mainLoopVariable = null;
        int mainLoopVariableIndex = -1;
        boolean bl = false;
        Map loopVariableComponents = new LinkedHashMap();
        boolean bl2 = false;
        List loopVariableComponentIndices = new ArrayList();
        bl2 = false;
        for (IrStatement stmt : (Iterable)statements2) {
            void i;
            if (stmt instanceof IrVariable) {
                IrStatementOrigin origin;
                IrMemberAccessExpression initializer2;
                IrMemberAccessExpression irMemberAccessExpression;
                if (((IrVariable)stmt).getInitializer() != null) {
                    IrExpression irExpression;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    IrExpression it = irExpression;
                    boolean bl5 = false;
                    FindInitializerCallVisitor findInitializerCallVisitor = new FindInitializerCallVisitor(mainLoopVariable);
                    boolean bl6 = false;
                    boolean bl7 = false;
                    FindInitializerCallVisitor $this$apply = findInitializerCallVisitor;
                    boolean bl8 = false;
                    IrElementVisitorVoidKt.acceptVoid(it, $this$apply);
                    irMemberAccessExpression = findInitializerCallVisitor.getInitializerCall();
                } else {
                    irMemberAccessExpression = null;
                }
                IrMemberAccessExpression irMemberAccessExpression2 = initializer2 = irMemberAccessExpression;
                IrStatementOrigin irStatementOrigin = origin = irMemberAccessExpression2 != null ? irMemberAccessExpression2.getOrigin() : null;
                if (Intrinsics.areEqual(origin, IrStatementOrigin.FOR_LOOP_NEXT.INSTANCE)) {
                    mainLoopVariable = (IrVariable)stmt;
                    mainLoopVariableIndex = i;
                } else if (origin instanceof IrStatementOrigin.COMPONENT_N) {
                    loopVariableComponents.put(((IrStatementOrigin.COMPONENT_N)origin).getIndex(), stmt);
                    loopVariableComponentIndices.add((int)i);
                }
            }
            ++i;
        }
        IrVariable irVariable2 = mainLoopVariable;
        boolean bl9 = false;
        boolean bl10 = false;
        if (irVariable2 == null) {
            boolean bl11 = false;
            String string2 = "No 'next' statement in for-loop";
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        boolean bl12 = mainLoopVariableIndex >= 0;
        bl9 = false;
        bl10 = false;
        if (_Assertions.ENABLED && !bl12) {
            boolean bl13 = false;
            String string3 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string3));
        }
        return new LoopVariableInfo(mainLoopVariable, mainLoopVariableIndex, loopVariableComponents, loopVariableComponentIndices);
    }

    @NotNull
    public final CommonBackendContext getContext() {
        return this.context;
    }

    @NotNull
    public final IrSymbolOwner getContainer() {
        return this.container;
    }

    @NotNull
    public final Map<IrLoop, IrLoop> getOldLoopToNewLoop() {
        return this.oldLoopToNewLoop;
    }

    public RangeLoopTransformer(@NotNull CommonBackendContext context2, @NotNull IrSymbolOwner container, @NotNull Map<IrLoop, IrLoop> oldLoopToNewLoop) {
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(container, "container");
        Intrinsics.checkNotNullParameter(oldLoopToNewLoop, "oldLoopToNewLoop");
        this.context = context2;
        this.container = container;
        this.oldLoopToNewLoop = oldLoopToNewLoop;
        this.symbols = this.context.getIr().getSymbols();
        this.headerInfoBuilder = new DefaultHeaderInfoBuilder(this.context, (Function0<? extends IrSymbol>)new Function0<IrSymbol>(this){

            @NotNull
            public final IrSymbol invoke() {
                return ((RangeLoopTransformer)this.receiver).getScopeOwnerSymbol();
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(RangeLoopTransformer.class);
            }

            public final String getName() {
                return "getScopeOwnerSymbol";
            }

            public final String getSignature() {
                return "getScopeOwnerSymbol()Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;";
            }
        });
        this.headerProcessor = new HeaderProcessor(this.context, this.headerInfoBuilder, (Function0<? extends IrSymbol>)new Function0<IrSymbol>(this){

            @NotNull
            public final IrSymbol invoke() {
                return ((RangeLoopTransformer)this.receiver).getScopeOwnerSymbol();
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(RangeLoopTransformer.class);
            }

            public final String getName() {
                return "getScopeOwnerSymbol";
            }

            public final String getSignature() {
                return "getScopeOwnerSymbol()Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;";
            }
        });
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010 \n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00030\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\u0015\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00030\u0007H\u00c6\u0003J\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\tH\u00c6\u0003JC\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00030\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/loops/RangeLoopTransformer$LoopVariableInfo;", "", "mainLoopVariable", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "mainLoopVariableIndex", "", "loopVariableComponents", "", "loopVariableComponentIndices", "", "(Lorg/jetbrains/kotlin/ir/declarations/IrVariable;ILjava/util/Map;Ljava/util/List;)V", "getLoopVariableComponentIndices", "()Ljava/util/List;", "getLoopVariableComponents", "()Ljava/util/Map;", "getMainLoopVariable", "()Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "getMainLoopVariableIndex", "()I", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "", "ir.backend.common"})
    private static final class LoopVariableInfo {
        @NotNull
        private final IrVariable mainLoopVariable;
        private final int mainLoopVariableIndex;
        @NotNull
        private final Map<Integer, IrVariable> loopVariableComponents;
        @NotNull
        private final List<Integer> loopVariableComponentIndices;

        @NotNull
        public final IrVariable getMainLoopVariable() {
            return this.mainLoopVariable;
        }

        public final int getMainLoopVariableIndex() {
            return this.mainLoopVariableIndex;
        }

        @NotNull
        public final Map<Integer, IrVariable> getLoopVariableComponents() {
            return this.loopVariableComponents;
        }

        @NotNull
        public final List<Integer> getLoopVariableComponentIndices() {
            return this.loopVariableComponentIndices;
        }

        public LoopVariableInfo(@NotNull IrVariable mainLoopVariable, int mainLoopVariableIndex, @NotNull Map<Integer, ? extends IrVariable> loopVariableComponents, @NotNull List<Integer> loopVariableComponentIndices) {
            Intrinsics.checkNotNullParameter(mainLoopVariable, "mainLoopVariable");
            Intrinsics.checkNotNullParameter(loopVariableComponents, "loopVariableComponents");
            Intrinsics.checkNotNullParameter(loopVariableComponentIndices, "loopVariableComponentIndices");
            this.mainLoopVariable = mainLoopVariable;
            this.mainLoopVariableIndex = mainLoopVariableIndex;
            this.loopVariableComponents = loopVariableComponents;
            this.loopVariableComponentIndices = loopVariableComponentIndices;
        }

        @NotNull
        public final IrVariable component1() {
            return this.mainLoopVariable;
        }

        public final int component2() {
            return this.mainLoopVariableIndex;
        }

        @NotNull
        public final Map<Integer, IrVariable> component3() {
            return this.loopVariableComponents;
        }

        @NotNull
        public final List<Integer> component4() {
            return this.loopVariableComponentIndices;
        }

        @NotNull
        public final LoopVariableInfo copy(@NotNull IrVariable mainLoopVariable, int mainLoopVariableIndex, @NotNull Map<Integer, ? extends IrVariable> loopVariableComponents, @NotNull List<Integer> loopVariableComponentIndices) {
            Intrinsics.checkNotNullParameter(mainLoopVariable, "mainLoopVariable");
            Intrinsics.checkNotNullParameter(loopVariableComponents, "loopVariableComponents");
            Intrinsics.checkNotNullParameter(loopVariableComponentIndices, "loopVariableComponentIndices");
            return new LoopVariableInfo(mainLoopVariable, mainLoopVariableIndex, loopVariableComponents, loopVariableComponentIndices);
        }

        public static /* synthetic */ LoopVariableInfo copy$default(LoopVariableInfo loopVariableInfo, IrVariable irVariable2, int n, Map map2, List list2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                irVariable2 = loopVariableInfo.mainLoopVariable;
            }
            if ((n2 & 2) != 0) {
                n = loopVariableInfo.mainLoopVariableIndex;
            }
            if ((n2 & 4) != 0) {
                map2 = loopVariableInfo.loopVariableComponents;
            }
            if ((n2 & 8) != 0) {
                list2 = loopVariableInfo.loopVariableComponentIndices;
            }
            return loopVariableInfo.copy(irVariable2, n, map2, list2);
        }

        @NotNull
        public String toString() {
            return "LoopVariableInfo(mainLoopVariable=" + this.mainLoopVariable + ", mainLoopVariableIndex=" + this.mainLoopVariableIndex + ", loopVariableComponents=" + this.loopVariableComponents + ", loopVariableComponentIndices=" + this.loopVariableComponentIndices + ")";
        }

        public int hashCode() {
            IrVariable irVariable2 = this.mainLoopVariable;
            Map<Integer, IrVariable> map2 = this.loopVariableComponents;
            List<Integer> list2 = this.loopVariableComponentIndices;
            return (((irVariable2 != null ? irVariable2.hashCode() : 0) * 31 + Integer.hashCode(this.mainLoopVariableIndex)) * 31 + (map2 != null ? ((Object)map2).hashCode() : 0)) * 31 + (list2 != null ? ((Object)list2).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof LoopVariableInfo)) break block3;
                    LoopVariableInfo loopVariableInfo = (LoopVariableInfo)object;
                    if (!Intrinsics.areEqual(this.mainLoopVariable, loopVariableInfo.mainLoopVariable) || this.mainLoopVariableIndex != loopVariableInfo.mainLoopVariableIndex || !Intrinsics.areEqual(this.loopVariableComponents, loopVariableInfo.loopVariableComponents) || !Intrinsics.areEqual(this.loopVariableComponentIndices, loopVariableInfo.loopVariableComponentIndices)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0006H\u0016J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/loops/RangeLoopTransformer$FindInitializerCallVisitor;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementVisitorVoid;", "mainLoopVariable", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "(Lorg/jetbrains/kotlin/ir/declarations/IrVariable;)V", "initializerCall", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "getInitializerCall", "()Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "setInitializerCall", "(Lorg/jetbrains/kotlin/ir/expressions/IrCall;)V", "visitCall", "", "expression", "visitElement", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "ir.backend.common"})
    private static final class FindInitializerCallVisitor
    implements IrElementVisitorVoid {
        @Nullable
        private IrCall initializerCall;
        private final IrVariable mainLoopVariable;

        @Nullable
        public final IrCall getInitializerCall() {
            return this.initializerCall;
        }

        public final void setInitializerCall(@Nullable IrCall irCall) {
            this.initializerCall = irCall;
        }

        @Override
        public void visitElement(@NotNull IrElement element) {
            Intrinsics.checkNotNullParameter(element, "element");
            IrElementVisitorVoidKt.acceptChildrenVoid(element, this);
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void visitCall(@NotNull IrCall expression) {
            block8: {
                block9: {
                    block7: {
                        Intrinsics.checkNotNullParameter(expression, "expression");
                        var3_2 = expression.getOrigin();
                        if (!Intrinsics.areEqual(var3_2, IrStatementOrigin.FOR_LOOP_NEXT.INSTANCE)) break block7;
                        v0 = expression;
                        break block8;
                    }
                    if (!(var3_2 instanceof IrStatementOrigin.COMPONENT_N)) break block9;
                    if (this.mainLoopVariable == null) ** GOTO lbl-1000
                    v1 = expression.getDispatchReceiver();
                    if (!(v1 instanceof IrGetValue)) {
                        v1 = null;
                    }
                    v2 = (IrGetValue)v1;
                    if (Intrinsics.areEqual(v2 != null ? v2.getSymbol() : null, (IrVariableSymbol)this.mainLoopVariable.getSymbol())) {
                        v0 = expression;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v0 = null;
                    }
                    break block8;
                }
                v0 = null;
            }
            candidateCall = v0;
            if (candidateCall == null) {
                IrElementVisitorVoid.DefaultImpls.visitCall(this, expression);
            } else if (this.initializerCall == null) {
                this.initializerCall = candidateCall;
            } else {
                v3 = new StringBuilder().append("Multiple initializer calls found. First: ");
                v4 = this.initializerCall;
                Intrinsics.checkNotNull(v4);
                throw (Throwable)new IllegalStateException(v3.append(RenderIrElementKt.render(v4)).append("\nSecond: ").append(RenderIrElementKt.render(candidateCall)).toString());
            }
        }

        public FindInitializerCallVisitor(@Nullable IrVariable mainLoopVariable) {
            this.mainLoopVariable = mainLoopVariable;
        }

        @Override
        public void visitElement(@NotNull IrElement element, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(element, "element");
            IrElementVisitorVoid.DefaultImpls.visitElement(this, element, data);
        }

        @Override
        public void visitCall(@NotNull IrCall expression2, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2, data);
        }

        @Override
        public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration2) {
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration2);
        }

        @Override
        public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration2, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration2, data);
        }

        @Override
        public void visitBlock(@NotNull IrBlock expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2);
        }

        @Override
        public void visitBlock(@NotNull IrBlock expression2, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2, data);
        }

        @Override
        public void visitBlockBody(@NotNull IrBlockBody body2) {
            Intrinsics.checkNotNullParameter(body2, "body");
            IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2);
        }

        @Override
        public void visitBlockBody(@NotNull IrBlockBody body2, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(body2, "body");
            IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2, data);
        }

        @Override
        public void visitBody(@NotNull IrBody body2) {
            Intrinsics.checkNotNullParameter(body2, "body");
            IrElementVisitorVoid.DefaultImpls.visitBody(this, body2);
        }

        @Override
        public void visitBody(@NotNull IrBody body2, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(body2, "body");
            IrElementVisitorVoid.DefaultImpls.visitBody(this, body2, data);
        }

        @Override
        public void visitBranch(@NotNull IrBranch branch) {
            Intrinsics.checkNotNullParameter(branch, "branch");
            IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch);
        }

        @Override
        public void visitBranch(@NotNull IrBranch branch, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(branch, "branch");
            IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch, data);
        }

        @Override
        public void visitBreak(@NotNull IrBreak jump) {
            Intrinsics.checkNotNullParameter(jump, "jump");
            IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump);
        }

        @Override
        public void visitBreak(@NotNull IrBreak jump, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(jump, "jump");
            IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump, data);
        }

        @Override
        public void visitBreakContinue(@NotNull IrBreakContinue jump) {
            Intrinsics.checkNotNullParameter(jump, "jump");
            IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump);
        }

        @Override
        public void visitBreakContinue(@NotNull IrBreakContinue jump, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(jump, "jump");
            IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump, data);
        }

        @Override
        public void visitCallableReference(@NotNull IrCallableReference expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2);
        }

        @Override
        public void visitCallableReference(@NotNull IrCallableReference expression2, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2, data);
        }

        @Override
        public void visitCatch(@NotNull IrCatch aCatch) {
            Intrinsics.checkNotNullParameter(aCatch, "aCatch");
            IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch);
        }

        @Override
        public void visitCatch(@NotNull IrCatch aCatch, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(aCatch, "aCatch");
            IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch, data);
        }

        @Override
        public void visitClass(@NotNull IrClass declaration2) {
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration2);
        }

        @Override
        public void visitClass(@NotNull IrClass declaration2, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration2, data);
        }

        @Override
        public void visitClassReference(@NotNull IrClassReference expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2);
        }

        @Override
        public void visitClassReference(@NotNull IrClassReference expression2, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2, data);
        }

        @Override
        public void visitComposite(@NotNull IrComposite expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2);
        }

        @Override
        public void visitComposite(@NotNull IrComposite expression2, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2, data);
        }

        @Override
        public <T> void visitConst(@NotNull IrConst<T> expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2);
        }

        @Override
        public <T> void visitConst(@NotNull IrConst<T> expression2, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2, data);
        }

        @Override
        public void visitConstructor(@NotNull IrConstructor declaration2) {
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration2);
        }

        @Override
        public void visitConstructor(@NotNull IrConstructor declaration2, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration2, data);
        }

        @Override
        public void visitConstructorCall(@NotNull IrConstructorCall expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2);
        }

        @Override
        public void visitConstructorCall(@NotNull IrConstructorCall expression2, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2, data);
        }

        @Override
        public void visitContainerExpression(@NotNull IrContainerExpression expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2);
        }

        @Override
        public void visitContainerExpression(@NotNull IrContainerExpression expression2, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2, data);
        }

        @Override
        public void visitContinue(@NotNull IrContinue jump) {
            Intrinsics.checkNotNullParameter(jump, "jump");
            IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump);
        }

        @Override
        public void visitContinue(@NotNull IrContinue jump, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(jump, "jump");
            IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump, data);
        }

        @Override
        public void visitDeclaration(@NotNull IrDeclaration declaration2) {
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration2);
        }

        @Override
        public void visitDeclaration(@NotNull IrDeclaration declaration2, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration2, data);
        }

        @Override
        public void visitDeclarationReference(@NotNull IrDeclarationReference expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2);
        }

        @Override
        public void visitDeclarationReference(@NotNull IrDeclarationReference expression2, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2, data);
        }

        @Override
        public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2);
        }

        @Override
        public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data);
        }

        @Override
        public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2) {
            Intrinsics.checkNotNullParameter(loop2, "loop");
            IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2);
        }

        @Override
        public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(loop2, "loop");
            IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2, data);
        }

        @Override
        public void visitDynamicExpression(@NotNull IrDynamicExpression expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2);
        }

        @Override
        public void visitDynamicExpression(@NotNull IrDynamicExpression expression2, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2, data);
        }

        @Override
        public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2);
        }

        @Override
        public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2, data);
        }

        @Override
        public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2);
        }

        @Override
        public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data);
        }

        @Override
        public void visitElseBranch(@NotNull IrElseBranch branch) {
            Intrinsics.checkNotNullParameter(branch, "branch");
            IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch);
        }

        @Override
        public void visitElseBranch(@NotNull IrElseBranch branch, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(branch, "branch");
            IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch, data);
        }

        @Override
        public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2);
        }

        @Override
        public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2, data);
        }

        @Override
        public void visitEnumEntry(@NotNull IrEnumEntry declaration2) {
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration2);
        }

        @Override
        public void visitEnumEntry(@NotNull IrEnumEntry declaration2, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration2, data);
        }

        @Override
        public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2);
        }

        @Override
        public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2, data);
        }

        @Override
        public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration2) {
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration2);
        }

        @Override
        public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration2, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration2, data);
        }

        @Override
        public void visitErrorExpression(@NotNull IrErrorExpression expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2);
        }

        @Override
        public void visitErrorExpression(@NotNull IrErrorExpression expression2, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2, data);
        }

        @Override
        public void visitExpression(@NotNull IrExpression expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2);
        }

        @Override
        public void visitExpression(@NotNull IrExpression expression2, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2, data);
        }

        @Override
        public void visitExpressionBody(@NotNull IrExpressionBody body2) {
            Intrinsics.checkNotNullParameter(body2, "body");
            IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2);
        }

        @Override
        public void visitExpressionBody(@NotNull IrExpressionBody body2, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(body2, "body");
            IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2, data);
        }

        @Override
        public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration2) {
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration2);
        }

        @Override
        public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration2, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration2, data);
        }

        @Override
        public void visitField(@NotNull IrField declaration2) {
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitField(this, declaration2);
        }

        @Override
        public void visitField(@NotNull IrField declaration2, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitField(this, declaration2, data);
        }

        @Override
        public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2);
        }

        @Override
        public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2, data);
        }

        @Override
        public void visitFile(@NotNull IrFile declaration2) {
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration2);
        }

        @Override
        public void visitFile(@NotNull IrFile declaration2, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration2, data);
        }

        @Override
        public void visitFunction(@NotNull IrFunction declaration2) {
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration2);
        }

        @Override
        public void visitFunction(@NotNull IrFunction declaration2, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration2, data);
        }

        @Override
        public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2);
        }

        @Override
        public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2, data);
        }

        @Override
        public void visitFunctionExpression(@NotNull IrFunctionExpression expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2);
        }

        @Override
        public void visitFunctionExpression(@NotNull IrFunctionExpression expression2, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2, data);
        }

        @Override
        public void visitFunctionReference(@NotNull IrFunctionReference expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2);
        }

        @Override
        public void visitFunctionReference(@NotNull IrFunctionReference expression2, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2, data);
        }

        @Override
        public void visitGetClass(@NotNull IrGetClass expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2);
        }

        @Override
        public void visitGetClass(@NotNull IrGetClass expression2, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2, data);
        }

        @Override
        public void visitGetEnumValue(@NotNull IrGetEnumValue expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2);
        }

        @Override
        public void visitGetEnumValue(@NotNull IrGetEnumValue expression2, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2, data);
        }

        @Override
        public void visitGetField(@NotNull IrGetField expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2);
        }

        @Override
        public void visitGetField(@NotNull IrGetField expression2, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2, data);
        }

        @Override
        public void visitGetObjectValue(@NotNull IrGetObjectValue expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2);
        }

        @Override
        public void visitGetObjectValue(@NotNull IrGetObjectValue expression2, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2, data);
        }

        @Override
        public void visitGetValue(@NotNull IrGetValue expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2);
        }

        @Override
        public void visitGetValue(@NotNull IrGetValue expression2, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2, data);
        }

        @Override
        public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2);
        }

        @Override
        public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2, data);
        }

        @Override
        public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration2) {
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration2);
        }

        @Override
        public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration2, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration2, data);
        }

        @Override
        public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2);
        }

        @Override
        public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data);
        }

        @Override
        public void visitLoop(@NotNull IrLoop loop2) {
            Intrinsics.checkNotNullParameter(loop2, "loop");
            IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2);
        }

        @Override
        public void visitLoop(@NotNull IrLoop loop2, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(loop2, "loop");
            IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2, data);
        }

        @Override
        public void visitMemberAccess(@NotNull IrMemberAccessExpression expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2);
        }

        @Override
        public void visitMemberAccess(@NotNull IrMemberAccessExpression expression2, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2, data);
        }

        @Override
        public void visitModuleFragment(@NotNull IrModuleFragment declaration2) {
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration2);
        }

        @Override
        public void visitModuleFragment(@NotNull IrModuleFragment declaration2, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration2, data);
        }

        @Override
        public void visitPackageFragment(@NotNull IrPackageFragment declaration2) {
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration2);
        }

        @Override
        public void visitPackageFragment(@NotNull IrPackageFragment declaration2, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration2, data);
        }

        @Override
        public void visitProperty(@NotNull IrProperty declaration2) {
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration2);
        }

        @Override
        public void visitProperty(@NotNull IrProperty declaration2, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration2, data);
        }

        @Override
        public void visitPropertyReference(@NotNull IrPropertyReference expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2);
        }

        @Override
        public void visitPropertyReference(@NotNull IrPropertyReference expression2, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2, data);
        }

        @Override
        public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2);
        }

        @Override
        public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2, data);
        }

        @Override
        public void visitReturn(@NotNull IrReturn expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2);
        }

        @Override
        public void visitReturn(@NotNull IrReturn expression2, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2, data);
        }

        @Override
        public void visitScript(@NotNull IrScript declaration2) {
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration2);
        }

        @Override
        public void visitScript(@NotNull IrScript declaration2, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration2, data);
        }

        @Override
        public void visitSetField(@NotNull IrSetField expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2);
        }

        @Override
        public void visitSetField(@NotNull IrSetField expression2, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2, data);
        }

        @Override
        public void visitSetVariable(@NotNull IrSetVariable expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitSetVariable(this, expression2);
        }

        @Override
        public void visitSetVariable(@NotNull IrSetVariable expression2, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitSetVariable(this, expression2, data);
        }

        @Override
        public void visitSimpleFunction(@NotNull IrSimpleFunction declaration2) {
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration2);
        }

        @Override
        public void visitSimpleFunction(@NotNull IrSimpleFunction declaration2, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration2, data);
        }

        @Override
        public void visitSingletonReference(@NotNull IrGetSingletonValue expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2);
        }

        @Override
        public void visitSingletonReference(@NotNull IrGetSingletonValue expression2, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2, data);
        }

        @Override
        public void visitSpreadElement(@NotNull IrSpreadElement spread) {
            Intrinsics.checkNotNullParameter(spread, "spread");
            IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread);
        }

        @Override
        public void visitSpreadElement(@NotNull IrSpreadElement spread, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(spread, "spread");
            IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread, data);
        }

        @Override
        public void visitStringConcatenation(@NotNull IrStringConcatenation expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2);
        }

        @Override
        public void visitStringConcatenation(@NotNull IrStringConcatenation expression2, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2, data);
        }

        @Override
        public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2);
        }

        @Override
        public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2, data);
        }

        @Override
        public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2);
        }

        @Override
        public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2, data);
        }

        @Override
        public void visitSyntheticBody(@NotNull IrSyntheticBody body2) {
            Intrinsics.checkNotNullParameter(body2, "body");
            IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2);
        }

        @Override
        public void visitSyntheticBody(@NotNull IrSyntheticBody body2, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(body2, "body");
            IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2, data);
        }

        @Override
        public void visitThrow(@NotNull IrThrow expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2);
        }

        @Override
        public void visitThrow(@NotNull IrThrow expression2, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2, data);
        }

        @Override
        public void visitTry(@NotNull IrTry aTry) {
            Intrinsics.checkNotNullParameter(aTry, "aTry");
            IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry);
        }

        @Override
        public void visitTry(@NotNull IrTry aTry, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(aTry, "aTry");
            IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry, data);
        }

        @Override
        public void visitTypeAlias(@NotNull IrTypeAlias declaration2) {
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration2);
        }

        @Override
        public void visitTypeAlias(@NotNull IrTypeAlias declaration2, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration2, data);
        }

        @Override
        public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2);
        }

        @Override
        public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2, data);
        }

        @Override
        public void visitTypeParameter(@NotNull IrTypeParameter declaration2) {
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration2);
        }

        @Override
        public void visitTypeParameter(@NotNull IrTypeParameter declaration2, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration2, data);
        }

        @Override
        public void visitValueAccess(@NotNull IrValueAccessExpression expression2, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression2, data);
        }

        @Override
        public void visitValueParameter(@NotNull IrValueParameter declaration2) {
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration2);
        }

        @Override
        public void visitValueParameter(@NotNull IrValueParameter declaration2, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration2, data);
        }

        @Override
        public void visitVararg(@NotNull IrVararg expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2);
        }

        @Override
        public void visitVararg(@NotNull IrVararg expression2, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2, data);
        }

        @Override
        public void visitVariable(@NotNull IrVariable declaration2) {
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration2);
        }

        @Override
        public void visitVariable(@NotNull IrVariable declaration2, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration2, data);
        }

        @Override
        public void visitVariableAccess(@NotNull IrValueAccessExpression expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitVariableAccess(this, expression2);
        }

        @Override
        public void visitWhen(@NotNull IrWhen expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2);
        }

        @Override
        public void visitWhen(@NotNull IrWhen expression2, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2, data);
        }

        @Override
        public void visitWhileLoop(@NotNull IrWhileLoop loop2) {
            Intrinsics.checkNotNullParameter(loop2, "loop");
            IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2);
        }

        @Override
        public void visitWhileLoop(@NotNull IrWhileLoop loop2, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(loop2, "loop");
            IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2, data);
        }
    }
}

