/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls.tower;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.resolve.BodyResolveComponents;
import org.jetbrains.kotlin.fir.resolve.calls.CallInfo;
import org.jetbrains.kotlin.fir.resolve.calls.CallKind;
import org.jetbrains.kotlin.fir.resolve.calls.CandidateCollector;
import org.jetbrains.kotlin.fir.resolve.calls.CandidateFactory;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionStageRunner;
import org.jetbrains.kotlin.fir.resolve.calls.tower.CandidateFactoriesAndCollectors;
import org.jetbrains.kotlin.fir.resolve.calls.tower.FirTowerResolverSession;
import org.jetbrains.kotlin.fir.resolve.calls.tower.TowerResolveManager;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0006\u0010\u000f\u001a\u00020\u0010J\"\u0010\u0011\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nJ\u001a\u0010\u0012\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0014R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/tower/FirTowerResolver;", "", "components", "Lorg/jetbrains/kotlin/fir/resolve/BodyResolveComponents;", "resolutionStageRunner", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionStageRunner;", "(Lorg/jetbrains/kotlin/fir/resolve/BodyResolveComponents;Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionStageRunner;)V", "collector", "Lorg/jetbrains/kotlin/fir/resolve/calls/CandidateCollector;", "manager", "Lorg/jetbrains/kotlin/fir/resolve/calls/tower/TowerResolveManager;", "buildCandidateFactoriesAndCollectors", "Lorg/jetbrains/kotlin/fir/resolve/calls/tower/CandidateFactoriesAndCollectors;", "info", "Lorg/jetbrains/kotlin/fir/resolve/calls/CallInfo;", "reset", "", "runResolver", "runResolverForDelegatingConstructor", "constructorClassSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;", "resolve"})
public final class FirTowerResolver {
    private final CandidateCollector collector;
    private final TowerResolveManager manager;
    private final BodyResolveComponents components;

    @NotNull
    public final CandidateCollector runResolver(@NotNull CallInfo info, @NotNull CandidateCollector collector2, @NotNull TowerResolveManager manager) {
        Intrinsics.checkNotNullParameter(info, "info");
        Intrinsics.checkNotNullParameter(collector2, "collector");
        Intrinsics.checkNotNullParameter(manager, "manager");
        CandidateFactoriesAndCollectors candidateFactoriesAndCollectors = this.buildCandidateFactoriesAndCollectors(info, collector2);
        FirTowerResolverSession towerResolverSession = new FirTowerResolverSession(this.components, manager, candidateFactoriesAndCollectors, info);
        towerResolverSession.runResolution(info);
        manager.runTasks();
        return collector2;
    }

    public static /* synthetic */ CandidateCollector runResolver$default(FirTowerResolver firTowerResolver, CallInfo callInfo, CandidateCollector candidateCollector, TowerResolveManager towerResolveManager, int n, Object object) {
        if ((n & 2) != 0) {
            candidateCollector = firTowerResolver.collector;
        }
        if ((n & 4) != 0) {
            towerResolveManager = firTowerResolver.manager;
        }
        return firTowerResolver.runResolver(callInfo, candidateCollector, towerResolveManager);
    }

    @NotNull
    public final CandidateCollector runResolverForDelegatingConstructor(@NotNull CallInfo info, @NotNull FirClassSymbol<?> constructorClassSymbol) {
        Intrinsics.checkNotNullParameter(info, "info");
        Intrinsics.checkNotNullParameter(constructorClassSymbol, "constructorClassSymbol");
        CandidateFactoriesAndCollectors candidateFactoriesAndCollectors = this.buildCandidateFactoriesAndCollectors(info, this.collector);
        FirTowerResolverSession towerResolverSession = new FirTowerResolverSession(this.components, this.manager, candidateFactoriesAndCollectors, info);
        towerResolverSession.runResolutionForDelegatingConstructor(info, constructorClassSymbol);
        this.manager.runTasks();
        return this.collector;
    }

    private final CandidateFactoriesAndCollectors buildCandidateFactoriesAndCollectors(CallInfo info, CandidateCollector collector2) {
        CandidateFactory candidateFactory = new CandidateFactory(this.components, info);
        CandidateFactory stubReceiverCandidateFactory = info.getCallKind() == CallKind.CallableReference && info.getStubReceiver() != null ? candidateFactory.replaceCallInfo(info.replaceExplicitReceiver(info.getStubReceiver())) : null;
        CandidateCollector invokeReceiverCollector = null;
        CandidateFactory invokeReceiverCandidateFactory = null;
        CandidateFactory invokeBuiltinExtensionReceiverCandidateFactory = null;
        if (info.getCallKind() == CallKind.Function) {
            invokeReceiverCollector = new CandidateCollector(this.components, this.components.getResolutionStageRunner());
            invokeReceiverCandidateFactory = new CandidateFactory(this.components, info.replaceWithVariableAccess());
            if (info.getExplicitReceiver() != null) {
                boolean bl = false;
                boolean bl2 = false;
                CandidateFactory $this$with = invokeReceiverCandidateFactory;
                boolean bl3 = false;
                invokeBuiltinExtensionReceiverCandidateFactory = $this$with.replaceCallInfo($this$with.getCallInfo().replaceExplicitReceiver(null));
            }
        }
        return new CandidateFactoriesAndCollectors(candidateFactory, collector2, stubReceiverCandidateFactory, invokeReceiverCandidateFactory, invokeReceiverCollector, invokeBuiltinExtensionReceiverCandidateFactory);
    }

    public final void reset() {
        this.collector.newDataSet();
        this.manager.reset();
    }

    public FirTowerResolver(@NotNull BodyResolveComponents components, @NotNull ResolutionStageRunner resolutionStageRunner) {
        Intrinsics.checkNotNullParameter(components, "components");
        Intrinsics.checkNotNullParameter(resolutionStageRunner, "resolutionStageRunner");
        this.components = components;
        this.collector = new CandidateCollector(this.components, resolutionStageRunner);
        this.manager = new TowerResolveManager(this.collector);
    }
}

