/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.filters;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.catalina.filters.FilterBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class ExpiresFilter
extends FilterBase {
    private static final Pattern commaSeparatedValuesPattern = Pattern.compile("\\s*,\\s*");
    private static final String HEADER_CACHE_CONTROL = "Cache-Control";
    private static final String HEADER_EXPIRES = "Expires";
    private static final String HEADER_LAST_MODIFIED = "Last-Modified";
    private final Log log = LogFactory.getLog(ExpiresFilter.class);
    private static final String PARAMETER_EXPIRES_BY_TYPE = "ExpiresByType";
    private static final String PARAMETER_EXPIRES_DEFAULT = "ExpiresDefault";
    private static final String PARAMETER_EXPIRES_EXCLUDED_RESPONSE_STATUS_CODES = "ExpiresExcludedResponseStatusCodes";
    private ExpiresConfiguration defaultExpiresConfiguration;
    private int[] excludedResponseStatusCodes = new int[]{304};
    private Map<String, ExpiresConfiguration> expiresConfigurationByContentType = new LinkedHashMap<String, ExpiresConfiguration>();

    protected static int[] commaDelimitedListToIntArray(String string) {
        String[] stringArray = ExpiresFilter.commaDelimitedListToStringArray(string);
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            try {
                nArray[i] = Integer.parseInt(string2);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                throw new RuntimeException(sm.getString("expiresFilter.numberError", new Object[]{i, string}));
            }
        }
        return nArray;
    }

    protected static String[] commaDelimitedListToStringArray(String string) {
        return string == null || string.length() == 0 ? new String[]{} : commaSeparatedValuesPattern.split(string);
    }

    protected static boolean contains(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        return string.indexOf(string2) >= 0;
    }

    protected static String intsToCommaDelimitedString(int[] nArray) {
        if (nArray == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < nArray.length; ++i) {
            stringBuilder.append(nArray[i]);
            if (i >= nArray.length - 1) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.toString();
    }

    protected static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    protected static boolean isNotEmpty(String string) {
        return !ExpiresFilter.isEmpty(string);
    }

    protected static boolean startsWithIgnoreCase(String string, String string2) {
        if (string == null || string2 == null) {
            return string == null && string2 == null;
        }
        if (string2.length() > string.length()) {
            return false;
        }
        return string.regionMatches(true, 0, string2, 0, string2.length());
    }

    protected static String substringBefore(String string, String string2) {
        if (string == null || string.isEmpty() || string2 == null) {
            return null;
        }
        if (string2.isEmpty()) {
            return "";
        }
        int n = string.indexOf(string2);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (servletRequest instanceof HttpServletRequest && servletResponse instanceof HttpServletResponse) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
            HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
            if (servletResponse.isCommitted()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)sm.getString("expiresFilter.responseAlreadyCommited", new Object[]{httpServletRequest.getRequestURL()}));
                }
                filterChain.doFilter(servletRequest, servletResponse);
            } else {
                XHttpServletResponse xHttpServletResponse = new XHttpServletResponse(httpServletRequest, httpServletResponse);
                filterChain.doFilter(servletRequest, (ServletResponse)xHttpServletResponse);
                if (!xHttpServletResponse.isWriteResponseBodyStarted()) {
                    this.onBeforeWriteResponseBody(httpServletRequest, xHttpServletResponse);
                }
            }
        } else {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    public ExpiresConfiguration getDefaultExpiresConfiguration() {
        return this.defaultExpiresConfiguration;
    }

    public String getExcludedResponseStatusCodes() {
        return ExpiresFilter.intsToCommaDelimitedString(this.excludedResponseStatusCodes);
    }

    public int[] getExcludedResponseStatusCodesAsInts() {
        return this.excludedResponseStatusCodes;
    }

    protected Date getExpirationDate(XHttpServletResponse xHttpServletResponse) {
        Object object;
        ExpiresConfiguration expiresConfiguration;
        String string = xHttpServletResponse.getContentType();
        if (string != null) {
            string = string.toLowerCase(Locale.ENGLISH);
        }
        if ((expiresConfiguration = this.expiresConfigurationByContentType.get(string)) != null) {
            Date date = this.getExpirationDate(expiresConfiguration, xHttpServletResponse);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)sm.getString("expiresFilter.useMatchingConfiguration", new Object[]{expiresConfiguration, string, string, date}));
            }
            return date;
        }
        if (ExpiresFilter.contains(string, ";") && (expiresConfiguration = this.expiresConfigurationByContentType.get(object = ExpiresFilter.substringBefore(string, ";").trim())) != null) {
            Date date = this.getExpirationDate(expiresConfiguration, xHttpServletResponse);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)sm.getString("expiresFilter.useMatchingConfiguration", new Object[]{expiresConfiguration, object, string, date}));
            }
            return date;
        }
        if (ExpiresFilter.contains(string, "/") && (expiresConfiguration = this.expiresConfigurationByContentType.get(object = ExpiresFilter.substringBefore(string, "/"))) != null) {
            Date date = this.getExpirationDate(expiresConfiguration, xHttpServletResponse);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)sm.getString("expiresFilter.useMatchingConfiguration", new Object[]{expiresConfiguration, object, string, date}));
            }
            return date;
        }
        if (this.defaultExpiresConfiguration != null) {
            object = this.getExpirationDate(this.defaultExpiresConfiguration, xHttpServletResponse);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)sm.getString("expiresFilter.useDefaultConfiguration", new Object[]{this.defaultExpiresConfiguration, string, object}));
            }
            return object;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)sm.getString("expiresFilter.noExpirationConfiguredForContentType", new Object[]{string}));
        }
        return null;
    }

    protected Date getExpirationDate(ExpiresConfiguration expiresConfiguration, XHttpServletResponse xHttpServletResponse) {
        Calendar calendar;
        switch (expiresConfiguration.getStartingPoint()) {
            case ACCESS_TIME: {
                calendar = Calendar.getInstance();
                break;
            }
            case LAST_MODIFICATION_TIME: {
                if (xHttpServletResponse.isLastModifiedHeaderSet()) {
                    try {
                        long l = xHttpServletResponse.getLastModifiedHeader();
                        calendar = Calendar.getInstance();
                        calendar.setTimeInMillis(l);
                    }
                    catch (NumberFormatException numberFormatException) {
                        calendar = Calendar.getInstance();
                    }
                    break;
                }
                calendar = Calendar.getInstance();
                break;
            }
            default: {
                throw new IllegalStateException(sm.getString("expiresFilter.unsupportedStartingPoint", new Object[]{expiresConfiguration.getStartingPoint()}));
            }
        }
        for (Duration duration : expiresConfiguration.getDurations()) {
            calendar.add(duration.getUnit().getCalendardField(), duration.getAmount());
        }
        return calendar.getTime();
    }

    public Map<String, ExpiresConfiguration> getExpiresConfigurationByContentType() {
        return this.expiresConfigurationByContentType;
    }

    @Override
    protected Log getLogger() {
        return this.log;
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        Enumeration enumeration = filterConfig.getInitParameterNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = filterConfig.getInitParameter(string);
            try {
                Object object;
                if (string.startsWith(PARAMETER_EXPIRES_BY_TYPE)) {
                    object = string.substring(PARAMETER_EXPIRES_BY_TYPE.length()).trim();
                    ExpiresConfiguration expiresConfiguration = this.parseExpiresConfiguration(string2);
                    this.expiresConfigurationByContentType.put((String)object, expiresConfiguration);
                    continue;
                }
                if (string.equalsIgnoreCase(PARAMETER_EXPIRES_DEFAULT)) {
                    this.defaultExpiresConfiguration = object = this.parseExpiresConfiguration(string2);
                    continue;
                }
                if (string.equalsIgnoreCase(PARAMETER_EXPIRES_EXCLUDED_RESPONSE_STATUS_CODES)) {
                    this.excludedResponseStatusCodes = ExpiresFilter.commaDelimitedListToIntArray(string2);
                    continue;
                }
                this.log.warn((Object)sm.getString("expiresFilter.unknownParameterIgnored", new Object[]{string, string2}));
            }
            catch (RuntimeException runtimeException) {
                throw new ServletException(sm.getString("expiresFilter.exceptionProcessingParameter", new Object[]{string, string2}), (Throwable)runtimeException);
            }
        }
        this.log.debug((Object)sm.getString("expiresFilter.filterInitialized", new Object[]{this.toString()}));
    }

    protected boolean isEligibleToExpirationHeaderGeneration(HttpServletRequest httpServletRequest, XHttpServletResponse xHttpServletResponse) {
        boolean bl;
        boolean bl2 = bl = xHttpServletResponse.containsHeader(HEADER_EXPIRES) || ExpiresFilter.contains(xHttpServletResponse.getCacheControlHeader(), "max-age");
        if (bl) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)sm.getString("expiresFilter.expirationHeaderAlreadyDefined", new Object[]{httpServletRequest.getRequestURI(), xHttpServletResponse.getStatus(), xHttpServletResponse.getContentType()}));
            }
            return false;
        }
        for (int n : this.excludedResponseStatusCodes) {
            if (xHttpServletResponse.getStatus() != n) continue;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)sm.getString("expiresFilter.skippedStatusCode", new Object[]{httpServletRequest.getRequestURI(), xHttpServletResponse.getStatus(), xHttpServletResponse.getContentType()}));
            }
            return false;
        }
        return true;
    }

    public void onBeforeWriteResponseBody(HttpServletRequest httpServletRequest, XHttpServletResponse xHttpServletResponse) {
        if (!this.isEligibleToExpirationHeaderGeneration(httpServletRequest, xHttpServletResponse)) {
            return;
        }
        Date date = this.getExpirationDate(xHttpServletResponse);
        if (date == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)sm.getString("expiresFilter.noExpirationConfigured", new Object[]{httpServletRequest.getRequestURI(), xHttpServletResponse.getStatus(), xHttpServletResponse.getContentType()}));
            }
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)sm.getString("expiresFilter.setExpirationDate", new Object[]{httpServletRequest.getRequestURI(), xHttpServletResponse.getStatus(), xHttpServletResponse.getContentType(), date}));
            }
            String string = "max-age=" + (date.getTime() - System.currentTimeMillis()) / 1000L;
            String string2 = xHttpServletResponse.getCacheControlHeader();
            String string3 = string2 == null ? string : string2 + ", " + string;
            xHttpServletResponse.setHeader(HEADER_CACHE_CONTROL, string3);
            xHttpServletResponse.setDateHeader(HEADER_EXPIRES, date.getTime());
        }
    }

    protected ExpiresConfiguration parseExpiresConfiguration(String string) {
        StartingPoint startingPoint;
        String string2;
        String string3 = string.trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string3, " ");
        try {
            string2 = stringTokenizer.nextToken();
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new IllegalStateException(sm.getString("expiresFilter.startingPointNotFound", new Object[]{string3}));
        }
        if ("access".equalsIgnoreCase(string2) || "now".equalsIgnoreCase(string2)) {
            startingPoint = StartingPoint.ACCESS_TIME;
        } else if ("modification".equalsIgnoreCase(string2)) {
            startingPoint = StartingPoint.LAST_MODIFICATION_TIME;
        } else if (!stringTokenizer.hasMoreTokens() && ExpiresFilter.startsWithIgnoreCase(string2, "a")) {
            startingPoint = StartingPoint.ACCESS_TIME;
            stringTokenizer = new StringTokenizer(string2.substring(1) + " seconds", " ");
        } else if (!stringTokenizer.hasMoreTokens() && ExpiresFilter.startsWithIgnoreCase(string2, "m")) {
            startingPoint = StartingPoint.LAST_MODIFICATION_TIME;
            stringTokenizer = new StringTokenizer(string2.substring(1) + " seconds", " ");
        } else {
            throw new IllegalStateException(sm.getString("expiresFilter.startingPointInvalid", new Object[]{string2, string3}));
        }
        try {
            string2 = stringTokenizer.nextToken();
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new IllegalStateException(sm.getString("expiresFilter.noDurationFound", new Object[]{string3}));
        }
        if ("plus".equalsIgnoreCase(string2)) {
            try {
                string2 = stringTokenizer.nextToken();
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new IllegalStateException(sm.getString("expiresFilter.noDurationFound", new Object[]{string3}));
            }
        }
        ArrayList<Duration> arrayList = new ArrayList<Duration>();
        while (string2 != null) {
            DurationUnit durationUnit;
            int n;
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalStateException(sm.getString("expiresFilter.invalidDurationNumber", new Object[]{string2, string3}));
            }
            try {
                string2 = stringTokenizer.nextToken();
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new IllegalStateException(sm.getString("expiresFilter.noDurationUnitAfterAmount", new Object[]{n, string3}));
            }
            if ("year".equalsIgnoreCase(string2) || "years".equalsIgnoreCase(string2)) {
                durationUnit = DurationUnit.YEAR;
            } else if ("month".equalsIgnoreCase(string2) || "months".equalsIgnoreCase(string2)) {
                durationUnit = DurationUnit.MONTH;
            } else if ("week".equalsIgnoreCase(string2) || "weeks".equalsIgnoreCase(string2)) {
                durationUnit = DurationUnit.WEEK;
            } else if ("day".equalsIgnoreCase(string2) || "days".equalsIgnoreCase(string2)) {
                durationUnit = DurationUnit.DAY;
            } else if ("hour".equalsIgnoreCase(string2) || "hours".equalsIgnoreCase(string2)) {
                durationUnit = DurationUnit.HOUR;
            } else if ("minute".equalsIgnoreCase(string2) || "minutes".equalsIgnoreCase(string2)) {
                durationUnit = DurationUnit.MINUTE;
            } else if ("second".equalsIgnoreCase(string2) || "seconds".equalsIgnoreCase(string2)) {
                durationUnit = DurationUnit.SECOND;
            } else {
                throw new IllegalStateException(sm.getString("expiresFilter.invalidDurationUnit", new Object[]{string2, string3}));
            }
            Duration duration = new Duration(n, durationUnit);
            arrayList.add(duration);
            if (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                continue;
            }
            string2 = null;
        }
        return new ExpiresConfiguration(startingPoint, arrayList);
    }

    public void setDefaultExpiresConfiguration(ExpiresConfiguration expiresConfiguration) {
        this.defaultExpiresConfiguration = expiresConfiguration;
    }

    public void setExcludedResponseStatusCodes(int[] nArray) {
        this.excludedResponseStatusCodes = nArray;
    }

    public void setExpiresConfigurationByContentType(Map<String, ExpiresConfiguration> map) {
        this.expiresConfigurationByContentType = map;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[excludedResponseStatusCode=[" + ExpiresFilter.intsToCommaDelimitedString(this.excludedResponseStatusCodes) + "], default=" + this.defaultExpiresConfiguration + ", byType=" + this.expiresConfigurationByContentType + "]";
    }

    public class XServletOutputStream
    extends ServletOutputStream {
        private final HttpServletRequest request;
        private final XHttpServletResponse response;
        private final ServletOutputStream servletOutputStream;

        public XServletOutputStream(ServletOutputStream servletOutputStream, HttpServletRequest httpServletRequest, XHttpServletResponse xHttpServletResponse) {
            this.servletOutputStream = servletOutputStream;
            this.response = xHttpServletResponse;
            this.request = httpServletRequest;
        }

        public void close() throws IOException {
            this.fireOnBeforeWriteResponseBodyEvent();
            this.servletOutputStream.close();
        }

        private void fireOnBeforeWriteResponseBodyEvent() {
            if (!this.response.isWriteResponseBodyStarted()) {
                this.response.setWriteResponseBodyStarted(true);
                ExpiresFilter.this.onBeforeWriteResponseBody(this.request, this.response);
            }
        }

        public void flush() throws IOException {
            this.fireOnBeforeWriteResponseBodyEvent();
            this.servletOutputStream.flush();
        }

        public void print(boolean bl) throws IOException {
            this.fireOnBeforeWriteResponseBodyEvent();
            this.servletOutputStream.print(bl);
        }

        public void print(char c) throws IOException {
            this.fireOnBeforeWriteResponseBodyEvent();
            this.servletOutputStream.print(c);
        }

        public void print(double d) throws IOException {
            this.fireOnBeforeWriteResponseBodyEvent();
            this.servletOutputStream.print(d);
        }

        public void print(float f) throws IOException {
            this.fireOnBeforeWriteResponseBodyEvent();
            this.servletOutputStream.print(f);
        }

        public void print(int n) throws IOException {
            this.fireOnBeforeWriteResponseBodyEvent();
            this.servletOutputStream.print(n);
        }

        public void print(long l) throws IOException {
            this.fireOnBeforeWriteResponseBodyEvent();
            this.servletOutputStream.print(l);
        }

        public void print(String string) throws IOException {
            this.fireOnBeforeWriteResponseBodyEvent();
            this.servletOutputStream.print(string);
        }

        public void println() throws IOException {
            this.fireOnBeforeWriteResponseBodyEvent();
            this.servletOutputStream.println();
        }

        public void println(boolean bl) throws IOException {
            this.fireOnBeforeWriteResponseBodyEvent();
            this.servletOutputStream.println(bl);
        }

        public void println(char c) throws IOException {
            this.fireOnBeforeWriteResponseBodyEvent();
            this.servletOutputStream.println(c);
        }

        public void println(double d) throws IOException {
            this.fireOnBeforeWriteResponseBodyEvent();
            this.servletOutputStream.println(d);
        }

        public void println(float f) throws IOException {
            this.fireOnBeforeWriteResponseBodyEvent();
            this.servletOutputStream.println(f);
        }

        public void println(int n) throws IOException {
            this.fireOnBeforeWriteResponseBodyEvent();
            this.servletOutputStream.println(n);
        }

        public void println(long l) throws IOException {
            this.fireOnBeforeWriteResponseBodyEvent();
            this.servletOutputStream.println(l);
        }

        public void println(String string) throws IOException {
            this.fireOnBeforeWriteResponseBodyEvent();
            this.servletOutputStream.println(string);
        }

        public void write(byte[] byArray) throws IOException {
            this.fireOnBeforeWriteResponseBodyEvent();
            this.servletOutputStream.write(byArray);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.fireOnBeforeWriteResponseBodyEvent();
            this.servletOutputStream.write(byArray, n, n2);
        }

        public void write(int n) throws IOException {
            this.fireOnBeforeWriteResponseBodyEvent();
            this.servletOutputStream.write(n);
        }
    }

    public class XPrintWriter
    extends PrintWriter {
        private final PrintWriter out;
        private final HttpServletRequest request;
        private final XHttpServletResponse response;

        public XPrintWriter(PrintWriter printWriter, HttpServletRequest httpServletRequest, XHttpServletResponse xHttpServletResponse) {
            super(printWriter);
            this.out = printWriter;
            this.request = httpServletRequest;
            this.response = xHttpServletResponse;
        }

        @Override
        public PrintWriter append(char c) {
            this.fireBeforeWriteResponseBodyEvent();
            return this.out.append(c);
        }

        @Override
        public PrintWriter append(CharSequence charSequence) {
            this.fireBeforeWriteResponseBodyEvent();
            return this.out.append(charSequence);
        }

        @Override
        public PrintWriter append(CharSequence charSequence, int n, int n2) {
            this.fireBeforeWriteResponseBodyEvent();
            return this.out.append(charSequence, n, n2);
        }

        @Override
        public void close() {
            this.fireBeforeWriteResponseBodyEvent();
            this.out.close();
        }

        private void fireBeforeWriteResponseBodyEvent() {
            if (!this.response.isWriteResponseBodyStarted()) {
                this.response.setWriteResponseBodyStarted(true);
                ExpiresFilter.this.onBeforeWriteResponseBody(this.request, this.response);
            }
        }

        @Override
        public void flush() {
            this.fireBeforeWriteResponseBodyEvent();
            this.out.flush();
        }

        @Override
        public void print(boolean bl) {
            this.fireBeforeWriteResponseBodyEvent();
            this.out.print(bl);
        }

        @Override
        public void print(char c) {
            this.fireBeforeWriteResponseBodyEvent();
            this.out.print(c);
        }

        @Override
        public void print(char[] cArray) {
            this.fireBeforeWriteResponseBodyEvent();
            this.out.print(cArray);
        }

        @Override
        public void print(double d) {
            this.fireBeforeWriteResponseBodyEvent();
            this.out.print(d);
        }

        @Override
        public void print(float f) {
            this.fireBeforeWriteResponseBodyEvent();
            this.out.print(f);
        }

        @Override
        public void print(int n) {
            this.fireBeforeWriteResponseBodyEvent();
            this.out.print(n);
        }

        @Override
        public void print(long l) {
            this.fireBeforeWriteResponseBodyEvent();
            this.out.print(l);
        }

        @Override
        public void print(Object object) {
            this.fireBeforeWriteResponseBodyEvent();
            this.out.print(object);
        }

        @Override
        public void print(String string) {
            this.fireBeforeWriteResponseBodyEvent();
            this.out.print(string);
        }

        @Override
        public PrintWriter printf(Locale locale, String string, Object ... objectArray) {
            this.fireBeforeWriteResponseBodyEvent();
            return this.out.printf(locale, string, objectArray);
        }

        @Override
        public PrintWriter printf(String string, Object ... objectArray) {
            this.fireBeforeWriteResponseBodyEvent();
            return this.out.printf(string, objectArray);
        }

        @Override
        public void println() {
            this.fireBeforeWriteResponseBodyEvent();
            this.out.println();
        }

        @Override
        public void println(boolean bl) {
            this.fireBeforeWriteResponseBodyEvent();
            this.out.println(bl);
        }

        @Override
        public void println(char c) {
            this.fireBeforeWriteResponseBodyEvent();
            this.out.println(c);
        }

        @Override
        public void println(char[] cArray) {
            this.fireBeforeWriteResponseBodyEvent();
            this.out.println(cArray);
        }

        @Override
        public void println(double d) {
            this.fireBeforeWriteResponseBodyEvent();
            this.out.println(d);
        }

        @Override
        public void println(float f) {
            this.fireBeforeWriteResponseBodyEvent();
            this.out.println(f);
        }

        @Override
        public void println(int n) {
            this.fireBeforeWriteResponseBodyEvent();
            this.out.println(n);
        }

        @Override
        public void println(long l) {
            this.fireBeforeWriteResponseBodyEvent();
            this.out.println(l);
        }

        @Override
        public void println(Object object) {
            this.fireBeforeWriteResponseBodyEvent();
            this.out.println(object);
        }

        @Override
        public void println(String string) {
            this.fireBeforeWriteResponseBodyEvent();
            this.out.println(string);
        }

        @Override
        public void write(char[] cArray) {
            this.fireBeforeWriteResponseBodyEvent();
            this.out.write(cArray);
        }

        @Override
        public void write(char[] cArray, int n, int n2) {
            this.fireBeforeWriteResponseBodyEvent();
            this.out.write(cArray, n, n2);
        }

        @Override
        public void write(int n) {
            this.fireBeforeWriteResponseBodyEvent();
            this.out.write(n);
        }

        @Override
        public void write(String string) {
            this.fireBeforeWriteResponseBodyEvent();
            this.out.write(string);
        }

        @Override
        public void write(String string, int n, int n2) {
            this.fireBeforeWriteResponseBodyEvent();
            this.out.write(string, n, n2);
        }
    }

    public class XHttpServletResponse
    extends HttpServletResponseWrapper {
        private String cacheControlHeader;
        private long lastModifiedHeader;
        private boolean lastModifiedHeaderSet;
        private PrintWriter printWriter;
        private final HttpServletRequest request;
        private ServletOutputStream servletOutputStream;
        private boolean writeResponseBodyStarted;

        public XHttpServletResponse(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
            super(httpServletResponse);
            this.request = httpServletRequest;
        }

        public void addDateHeader(String string, long l) {
            super.addDateHeader(string, l);
            if (!this.lastModifiedHeaderSet) {
                this.lastModifiedHeader = l;
                this.lastModifiedHeaderSet = true;
            }
        }

        public void addHeader(String string, String string2) {
            super.addHeader(string, string2);
            if (ExpiresFilter.HEADER_CACHE_CONTROL.equalsIgnoreCase(string) && this.cacheControlHeader == null) {
                this.cacheControlHeader = string2;
            }
        }

        public String getCacheControlHeader() {
            return this.cacheControlHeader;
        }

        public long getLastModifiedHeader() {
            return this.lastModifiedHeader;
        }

        public ServletOutputStream getOutputStream() throws IOException {
            if (this.servletOutputStream == null) {
                this.servletOutputStream = new XServletOutputStream(super.getOutputStream(), this.request, this);
            }
            return this.servletOutputStream;
        }

        public PrintWriter getWriter() throws IOException {
            if (this.printWriter == null) {
                this.printWriter = new XPrintWriter(super.getWriter(), this.request, this);
            }
            return this.printWriter;
        }

        public boolean isLastModifiedHeaderSet() {
            return this.lastModifiedHeaderSet;
        }

        public boolean isWriteResponseBodyStarted() {
            return this.writeResponseBodyStarted;
        }

        public void reset() {
            super.reset();
            this.lastModifiedHeader = 0L;
            this.lastModifiedHeaderSet = false;
            this.cacheControlHeader = null;
        }

        public void setDateHeader(String string, long l) {
            super.setDateHeader(string, l);
            if (ExpiresFilter.HEADER_LAST_MODIFIED.equalsIgnoreCase(string)) {
                this.lastModifiedHeader = l;
                this.lastModifiedHeaderSet = true;
            }
        }

        public void setHeader(String string, String string2) {
            super.setHeader(string, string2);
            if (ExpiresFilter.HEADER_CACHE_CONTROL.equalsIgnoreCase(string)) {
                this.cacheControlHeader = string2;
            }
        }

        public void setWriteResponseBodyStarted(boolean bl) {
            this.writeResponseBodyStarted = bl;
        }
    }

    protected static enum StartingPoint {
        ACCESS_TIME,
        LAST_MODIFICATION_TIME;

    }

    protected static class ExpiresConfiguration {
        private final List<Duration> durations;
        private final StartingPoint startingPoint;

        public ExpiresConfiguration(StartingPoint startingPoint, List<Duration> list) {
            this.startingPoint = startingPoint;
            this.durations = list;
        }

        public List<Duration> getDurations() {
            return this.durations;
        }

        public StartingPoint getStartingPoint() {
            return this.startingPoint;
        }

        public String toString() {
            return "ExpiresConfiguration[startingPoint=" + (Object)((Object)this.startingPoint) + ", duration=" + this.durations + "]";
        }
    }

    protected static enum DurationUnit {
        DAY(6),
        HOUR(10),
        MINUTE(12),
        MONTH(2),
        SECOND(13),
        WEEK(3),
        YEAR(1);

        private final int calendarField;

        private DurationUnit(int n2) {
            this.calendarField = n2;
        }

        public int getCalendardField() {
            return this.calendarField;
        }
    }

    protected static class Duration {
        protected final int amount;
        protected final DurationUnit unit;

        public Duration(int n, DurationUnit durationUnit) {
            this.amount = n;
            this.unit = durationUnit;
        }

        public int getAmount() {
            return this.amount;
        }

        public DurationUnit getUnit() {
            return this.unit;
        }

        public String toString() {
            return this.amount + " " + (Object)((Object)this.unit);
        }
    }
}

