/*
 * Decompiled with CFR 0.152.
 */
package org.apache.el.util;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.el.ELException;
import javax.el.MethodNotFoundException;
import org.apache.el.lang.ELSupport;
import org.apache.el.util.JreCompat;
import org.apache.el.util.MessageFactory;

public class ReflectionUtil {
    protected static final String[] PRIMITIVE_NAMES = new String[]{"boolean", "byte", "char", "double", "float", "int", "long", "short", "void"};
    protected static final Class<?>[] PRIMITIVES = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Double.TYPE, Float.TYPE, Integer.TYPE, Long.TYPE, Short.TYPE, Void.TYPE};

    private ReflectionUtil() {
    }

    public static Class<?> forName(String string) throws ClassNotFoundException {
        if (null == string || "".equals(string)) {
            return null;
        }
        Class<?> clazz = ReflectionUtil.forNamePrimitive(string);
        if (clazz == null) {
            if (string.endsWith("[]")) {
                String string2 = string.substring(0, string.length() - 2);
                clazz = Class.forName(string2, true, ReflectionUtil.getContextClassLoader());
                clazz = Array.newInstance(clazz, 0).getClass();
            } else {
                clazz = Class.forName(string, true, ReflectionUtil.getContextClassLoader());
            }
        }
        return clazz;
    }

    protected static Class<?> forNamePrimitive(String string) {
        int n;
        if (string.length() <= 8 && (n = Arrays.binarySearch(PRIMITIVE_NAMES, string)) >= 0) {
            return PRIMITIVES[n];
        }
        return null;
    }

    public static Class<?>[] toTypeArray(String[] stringArray) throws ClassNotFoundException {
        if (stringArray == null) {
            return null;
        }
        Class[] classArray = new Class[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            classArray[i] = ReflectionUtil.forName(stringArray[i]);
        }
        return classArray;
    }

    public static String[] toTypeNameArray(Class<?>[] classArray) {
        if (classArray == null) {
            return null;
        }
        String[] stringArray = new String[classArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            stringArray[i] = classArray[i].getName();
        }
        return stringArray;
    }

    public static Method getMethod(Object object, Object object2, Class<?>[] classArray, Object[] objectArray) throws MethodNotFoundException {
        int n;
        if (object == null || object2 == null) {
            throw new MethodNotFoundException(MessageFactory.get("error.method.notfound", object, object2, ReflectionUtil.paramString(classArray)));
        }
        String string = object2 instanceof String ? (String)object2 : object2.toString();
        int n2 = classArray == null ? 0 : classArray.length;
        Method[] methodArray = object.getClass().getMethods();
        HashMap<Object, MatchResult> hashMap = new HashMap<Object, MatchResult>();
        for (Method method : methodArray) {
            Class<?>[] object3;
            if (!method.getName().equals(string) || n2 != (n = (object3 = method.getParameterTypes()) == null ? 0 : object3.length) && (!method.isVarArgs() || n2 < n)) continue;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            boolean bl = false;
            block1: for (int i = 0; i < n; ++i) {
                if (object3[i].equals(classArray[i])) {
                    ++n3;
                    continue;
                }
                if (i == n - 1 && method.isVarArgs()) {
                    Class<?> clazz = object3[i].getComponentType();
                    for (int j = i; j < n2; ++j) {
                        if (ReflectionUtil.isAssignableFrom(classArray[j], clazz)) {
                            ++n4;
                            continue;
                        }
                        if (objectArray == null || j >= objectArray.length) {
                            bl = true;
                            continue block1;
                        }
                        if (ReflectionUtil.isCoercibleFrom(objectArray[j], clazz)) {
                            ++n5;
                            continue;
                        }
                        bl = true;
                        continue block1;
                    }
                    continue;
                }
                if (ReflectionUtil.isAssignableFrom(classArray[i], object3[i])) {
                    ++n4;
                    continue;
                }
                if (objectArray == null || i >= objectArray.length) {
                    bl = true;
                    break;
                }
                if (ReflectionUtil.isCoercibleFrom(objectArray[i], object3[i])) {
                    ++n5;
                    continue;
                }
                bl = true;
                break;
            }
            if (bl) continue;
            if (n3 == n2) {
                return ReflectionUtil.getMethod(object.getClass(), object, method);
            }
            hashMap.put(method, new MatchResult(n3, n4, n5, method.isBridge()));
        }
        Object object4 = new MatchResult(0, 0, 0, false);
        Method method = null;
        int n6 = 0;
        for (Map.Entry entry : hashMap.entrySet()) {
            n = ((MatchResult)entry.getValue()).compareTo((MatchResult)object4);
            if (n > 0 || method == null) {
                object4 = (MatchResult)entry.getValue();
                method = (Method)entry.getKey();
                n6 = 0;
                continue;
            }
            if (n != 0) continue;
            n6 = 1;
        }
        if (n6 != 0 && (method = ((MatchResult)object4).getExact() == n2 - 1 ? ReflectionUtil.resolveAmbiguousMethod(hashMap.keySet(), classArray) : null) == null) {
            throw new MethodNotFoundException(MessageFactory.get("error.method.ambiguous", object, object2, ReflectionUtil.paramString(classArray)));
        }
        if (method == null) {
            throw new MethodNotFoundException(MessageFactory.get("error.method.notfound", object, object2, ReflectionUtil.paramString(classArray)));
        }
        return ReflectionUtil.getMethod(object.getClass(), object, method);
    }

    private static Method resolveAmbiguousMethod(Set<Method> set, Class<?>[] classArray) {
        Object object;
        Method method = set.iterator().next();
        int n = 0;
        Class<?> clazz = null;
        for (int i = 0; i < classArray.length; ++i) {
            if (method.getParameterTypes()[i] == classArray[i]) continue;
            n = i;
            clazz = classArray[i];
            break;
        }
        if (clazz == null) {
            return null;
        }
        Class clazz2 = set.iterator();
        while (clazz2.hasNext()) {
            object = clazz2.next();
            if (((Method)object).getParameterTypes()[n] != classArray[n]) continue;
            return null;
        }
        for (clazz2 = clazz.getSuperclass(); clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            for (Method object2 : set) {
                if (!object2.getParameterTypes()[n].equals(clazz2)) continue;
                return object2;
            }
        }
        object = null;
        if (Number.class.isAssignableFrom(clazz)) {
            for (Method method2 : set) {
                Class<?> clazz3 = method2.getParameterTypes()[n];
                if (!Number.class.isAssignableFrom(clazz3) && !clazz3.isPrimitive()) continue;
                if (object == null) {
                    object = method2;
                    continue;
                }
                object = null;
                break;
            }
        }
        return object;
    }

    private static boolean isAssignableFrom(Class<?> clazz, Class<?> clazz2) {
        if (clazz == null) {
            return true;
        }
        Class<Object> clazz3 = clazz2.isPrimitive() ? (clazz2 == Boolean.TYPE ? Boolean.class : (clazz2 == Character.TYPE ? Character.class : (clazz2 == Byte.TYPE ? Byte.class : (clazz2 == Short.TYPE ? Short.class : (clazz2 == Integer.TYPE ? Integer.class : (clazz2 == Long.TYPE ? Long.class : (clazz2 == Float.TYPE ? Float.class : Double.class))))))) : clazz2;
        return clazz3.isAssignableFrom(clazz);
    }

    private static boolean isCoercibleFrom(Object object, Class<?> clazz) {
        try {
            ELSupport.coerceToType(object, clazz);
        }
        catch (ELException eLException) {
            return false;
        }
        return true;
    }

    private static Method getMethod(Class<?> clazz, Object object, Method method) {
        JreCompat jreCompat = JreCompat.getInstance();
        if (method == null || Modifier.isPublic(clazz.getModifiers()) && (jreCompat.canAcccess(object, method) || object != null && jreCompat.canAcccess(null, method))) {
            return method;
        }
        Class<?>[] classArray = clazz.getInterfaces();
        Method method2 = null;
        for (Class<?> clazz2 : classArray) {
            try {
                method2 = clazz2.getMethod(method.getName(), method.getParameterTypes());
                method2 = ReflectionUtil.getMethod(method2.getDeclaringClass(), object, method2);
                if (method2 == null) continue;
                return method2;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        Class<?> clazz3 = clazz.getSuperclass();
        if (clazz3 != null) {
            try {
                method2 = clazz3.getMethod(method.getName(), method.getParameterTypes());
                method2 = ReflectionUtil.getMethod(method2.getDeclaringClass(), object, method2);
                if (method2 != null) {
                    return method2;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return null;
    }

    private static final String paramString(Class<?>[] classArray) {
        if (classArray != null) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Class<?> clazz : classArray) {
                if (clazz == null) {
                    stringBuilder.append("null, ");
                    continue;
                }
                stringBuilder.append(clazz.getName()).append(", ");
            }
            if (stringBuilder.length() > 2) {
                stringBuilder.setLength(stringBuilder.length() - 2);
            }
            return stringBuilder.toString();
        }
        return null;
    }

    private static ClassLoader getContextClassLoader() {
        ClassLoader classLoader;
        if (System.getSecurityManager() != null) {
            PrivilegedGetTccl privilegedGetTccl = new PrivilegedGetTccl();
            classLoader = AccessController.doPrivileged(privilegedGetTccl);
        } else {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        return classLoader;
    }

    private static class MatchResult
    implements Comparable<MatchResult> {
        private final int exact;
        private final int assignable;
        private final int coercible;
        private final boolean bridge;

        public MatchResult(int n, int n2, int n3, boolean bl) {
            this.exact = n;
            this.assignable = n2;
            this.coercible = n3;
            this.bridge = bl;
        }

        public int getExact() {
            return this.exact;
        }

        public int getAssignable() {
            return this.assignable;
        }

        public int getCoercible() {
            return this.coercible;
        }

        public boolean isBridge() {
            return this.bridge;
        }

        @Override
        public int compareTo(MatchResult matchResult) {
            if (this.getExact() < matchResult.getExact()) {
                return -1;
            }
            if (this.getExact() > matchResult.getExact()) {
                return 1;
            }
            if (this.getAssignable() < matchResult.getAssignable()) {
                return -1;
            }
            if (this.getAssignable() > matchResult.getAssignable()) {
                return 1;
            }
            if (this.getCoercible() < matchResult.getCoercible()) {
                return -1;
            }
            if (this.getCoercible() > matchResult.getCoercible()) {
                return 1;
            }
            if (matchResult.isBridge() && !this.isBridge()) {
                return 1;
            }
            if (!matchResult.isBridge() && this.isBridge()) {
                return -1;
            }
            return 0;
        }
    }

    private static class PrivilegedGetTccl
    implements PrivilegedAction<ClassLoader> {
        private PrivilegedGetTccl() {
        }

        @Override
        public ClassLoader run() {
            return Thread.currentThread().getContextClassLoader();
        }
    }
}

