/*
 * Decompiled with CFR 0.152.
 */
package esmska.update;

import esmska.data.Config;
import esmska.data.Contacts;
import esmska.data.History;
import esmska.data.Signature;
import esmska.data.Signatures;
import esmska.utils.RuntimeUtils;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.apache.commons.lang.time.DateUtils;

public class Statistics {
    private static final Logger logger = Logger.getLogger(Statistics.class.getName());
    private static final Config config = Config.getInstance();

    public static void refreshUUID() {
        boolean needRegen;
        int currentMonth = Calendar.getInstance().get(2);
        boolean bl = needRegen = StringUtils.isEmpty(config.getUUID()) || config.getUUIDMonth() != currentMonth;
        if (needRegen) {
            logger.fine("Regenerating a new UUID");
            config.setUUID(UUID.randomUUID().toString());
            config.setUUIDMonth(currentMonth);
        }
    }

    public static JSONObject collectUsageInfo() {
        JSONObject info = new JSONObject();
        info.put("uuid", config.getUUID());
        info.put("version", Config.getLatestVersion());
        info.put("stable", (Object)Config.isStableVersion());
        info.put("os", WordUtils.capitalizeFully(RuntimeUtils.detectOS().name()));
        String desktop = null;
        desktop = RuntimeUtils.isGnomeDesktop() ? "Gnome" : (RuntimeUtils.isKDEDesktop() ? "KDE" : "other");
        info.put("desktop", desktop);
        String java = null;
        java = RuntimeUtils.isOracleJava() ? "Oracle" : (RuntimeUtils.isOpenJDK() ? "OpenJDK" : (RuntimeUtils.isAppleJava() ? "Apple" : "other"));
        info.put("java", java);
        info.put("language", Locale.getDefault().getLanguage());
        info.put("lookAndFeel", WordUtils.capitalizeFully(config.getLookAndFeel().name()));
        info.put("countryPrefix", config.getCountryPrefix());
        info.put("useProxy", (Object)config.isUseProxy());
        info.put("notificationIcon", (Object)config.isNotificationIconVisible());
        info.put("advancedSettings", (Object)config.isShowAdvancedSettings());
        info.put("customSignatures", (Object)Signatures.getInstance().getAll().size());
        Signature defaultSig = Signatures.getInstance().get(Signature.DEFAULT.getProfileName());
        info.put("defaultSenderNumber", (Object)StringUtils.isNotEmpty(defaultSig.getUserNumber()));
        info.put("defaultSenderName", (Object)StringUtils.isNotEmpty(defaultSig.getUserName()));
        info.put("contacts", (Object)Contacts.getInstance().size());
        info.put("history", (Object)History.getInstance().getRecords().size());
        info.put("usedGateways", JSONArray.fromObject(Statistics.getUsedGateways()));
        return info;
    }

    private static TreeSet<String> getUsedGateways() {
        List<History.Record> records = History.getInstance().getRecords();
        records = records.subList(Math.max(0, records.size() - 1000), records.size());
        Calendar cal = Calendar.getInstance();
        cal.add(6, -90);
        Date historyLimit = cal.getTime();
        TreeSet<String> gateways = new TreeSet<String>();
        for (History.Record record : records) {
            if (record.getDate().before(historyLimit)) continue;
            gateways.add(record.getGateway());
        }
        return gateways;
    }

    public static void sendUsageInfo() {
        if (!Statistics.shouldSend()) {
            logger.fine("Not sending usage info");
            return;
        }
        logger.fine("Sending usage info");
        JSONObject info = Statistics.collectUsageInfo();
        final String data = info.toString(2);
        try {
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        URL url = new URL("http://ripper.profitux.cz/esmska/stats/receive.php");
                        URLConnection conn = url.openConnection();
                        conn.setDoOutput(true);
                        conn.setUseCaches(false);
                        OutputStream out = conn.getOutputStream();
                        out.write(data.getBytes("UTF-8"));
                        out.flush();
                        InputStream in = conn.getInputStream();
                        in.close();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                config.setLastStatsSent(new Date());
                            }
                        });
                        logger.finer("Usage info sent");
                    }
                    catch (Exception ex) {
                        logger.log(Level.WARNING, "Could not send usage info", ex);
                    }
                }
            });
            t.setDaemon(true);
            t.start();
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Could not execute sending usage info", ex);
        }
    }

    public static boolean shouldSend() {
        if (config.isFirstRun()) {
            logger.fine("Shouldn't send usage info, first program run");
            return false;
        }
        if (config.getLastStatsSent() == null) {
            logger.fine("Last usage info submission date unknown, should send usage info");
            return true;
        }
        Calendar last = DateUtils.toCalendar(config.getLastStatsSent());
        Calendar now = Calendar.getInstance();
        long diff = now.getTimeInMillis() - last.getTimeInMillis();
        double diffDays = (double)diff / 8.64E7;
        DateFormat df = DateFormat.getDateTimeInstance();
        logger.log(Level.FINE, "Last usage info sent on {0} ({1,number} days ago)", new Object[]{df.format(last.getTime()), diffDays});
        if (last.get(2) != now.get(2) || last.get(1) != now.get(1)) {
            logger.fine("Should send usage info, first program run in the current month");
            return true;
        }
        int limit = 0;
        limit = now.get(5) <= 20 ? 5 : 3;
        if (diffDays >= (double)limit) {
            logger.fine("Should send usage info");
            return true;
        }
        logger.fine("Shouldn't send usage info");
        return false;
    }
}

