/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import org.apache.coyote.ActionCode;
import org.apache.coyote.OutputBuffer;
import org.apache.coyote.Response;
import org.apache.coyote.http11.AbstractOutputBuffer;
import org.apache.coyote.http11.Constants;
import org.apache.coyote.http11.OutputFilter;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.http.HttpMessages;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.NioChannel;
import org.apache.tomcat.util.net.NioEndpoint;
import org.apache.tomcat.util.net.NioSelectorPool;
import org.apache.tomcat.util.net.SocketWrapper;

public class InternalNioOutputBuffer
extends AbstractOutputBuffer<NioChannel> {
    private NioChannel socket;
    private NioSelectorPool pool;

    public InternalNioOutputBuffer(Response response, int n) {
        this.response = response;
        this.buf = new byte[n];
        this.outputStreamOutputBuffer = new SocketOutputBuffer();
        this.filterLibrary = new OutputFilter[0];
        this.activeFilters = new OutputFilter[0];
        this.lastActiveFilter = -1;
        this.committed = false;
        this.finished = false;
        HttpMessages.getInstance(response.getLocale()).getMessage(200);
    }

    @Override
    public void flush() throws IOException {
        super.flush();
        this.flushBuffer();
    }

    @Override
    public void recycle() {
        super.recycle();
        if (this.socket != null) {
            this.socket.getBufHandler().getWriteBuffer().clear();
            this.socket = null;
        }
    }

    @Override
    public void endRequest() throws IOException {
        super.endRequest();
        this.flushBuffer();
    }

    @Override
    public void sendAck() throws IOException {
        if (!this.committed) {
            this.socket.getBufHandler().getWriteBuffer().put(Constants.ACK_BYTES, 0, Constants.ACK_BYTES.length);
            this.writeToSocket(this.socket.getBufHandler().getWriteBuffer(), true, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized int writeToSocket(ByteBuffer byteBuffer, boolean bl, boolean bl2) throws IOException {
        if (bl2) {
            byteBuffer.flip();
        }
        int n = 0;
        NioEndpoint.KeyAttachment keyAttachment = (NioEndpoint.KeyAttachment)this.socket.getAttachment();
        if (keyAttachment == null) {
            throw new IOException("Key must be cancelled");
        }
        long l = keyAttachment.getWriteTimeout();
        Selector selector = null;
        try {
            selector = this.pool.get();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            n = this.pool.write(byteBuffer, this.socket, selector, l, bl);
            while (!this.socket.flush(true, selector, l)) {
            }
        }
        finally {
            if (selector != null) {
                this.pool.put(selector);
            }
        }
        if (bl) {
            byteBuffer.clear();
        }
        return n;
    }

    @Override
    public void init(SocketWrapper<NioChannel> socketWrapper, AbstractEndpoint<NioChannel> abstractEndpoint) throws IOException {
        this.socket = socketWrapper.getSocket();
        this.pool = ((NioEndpoint)abstractEndpoint).getSelectorPool();
    }

    @Override
    protected void commit() throws IOException {
        this.committed = true;
        this.response.setCommitted(true);
        if (this.pos > 0) {
            this.addToBB(this.buf, 0, this.pos);
        }
    }

    private synchronized void addToBB(byte[] byArray, int n, int n2) throws IOException {
        while (n2 > 0) {
            int n3 = n2;
            if (this.socket.getBufHandler().getWriteBuffer().position() == this.socket.getBufHandler().getWriteBuffer().capacity() || this.socket.getBufHandler().getWriteBuffer().remaining() == 0) {
                this.flushBuffer();
            }
            if (n3 > this.socket.getBufHandler().getWriteBuffer().remaining()) {
                n3 = this.socket.getBufHandler().getWriteBuffer().remaining();
            }
            this.socket.getBufHandler().getWriteBuffer().put(byArray, n, n3);
            n2 -= n3;
            n += n3;
        }
        NioEndpoint.KeyAttachment keyAttachment = (NioEndpoint.KeyAttachment)this.socket.getAttachment();
        if (keyAttachment != null) {
            keyAttachment.access();
        }
    }

    private void flushBuffer() throws IOException {
        SelectionKey selectionKey = this.socket.getIOChannel().keyFor(this.socket.getPoller().getSelector());
        if (selectionKey != null) {
            NioEndpoint.KeyAttachment keyAttachment = (NioEndpoint.KeyAttachment)selectionKey.attachment();
            keyAttachment.access();
        }
        if (this.socket.getBufHandler().getWriteBuffer().position() > 0) {
            this.socket.getBufHandler().getWriteBuffer().flip();
            this.writeToSocket(this.socket.getBufHandler().getWriteBuffer(), true, false);
        }
    }

    protected class SocketOutputBuffer
    implements OutputBuffer {
        protected SocketOutputBuffer() {
        }

        @Override
        public int doWrite(ByteChunk byteChunk, Response response) throws IOException {
            try {
                int n = byteChunk.getLength();
                int n2 = byteChunk.getStart();
                byte[] byArray = byteChunk.getBuffer();
                InternalNioOutputBuffer.this.addToBB(byArray, n2, n);
                InternalNioOutputBuffer.this.byteCount += (long)byteChunk.getLength();
                return byteChunk.getLength();
            }
            catch (IOException iOException) {
                InternalNioOutputBuffer.this.response.action(ActionCode.CLOSE_NOW, iOException);
                throw iOException;
            }
        }

        @Override
        public long getBytesWritten() {
            return InternalNioOutputBuffer.this.byteCount;
        }
    }
}

