/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.IOException;
import java.security.AccessController;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.catalina.Context;
import org.apache.catalina.Globals;
import org.apache.catalina.Wrapper;
import org.apache.catalina.comet.CometEvent;
import org.apache.catalina.connector.ClientAbortException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.deploy.ErrorPage;
import org.apache.catalina.valves.ValveBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.util.security.PrivilegedSetTccl;

final class StandardHostValve
extends ValveBase {
    private static final Log log = LogFactory.getLog(StandardHostValve.class);
    static final boolean STRICT_SERVLET_COMPLIANCE = Globals.STRICT_SERVLET_COMPLIANCE;
    static final boolean ACCESS_SESSION;
    private static final String info = "org.apache.catalina.core.StandardHostValve/1.0";
    private static final StringManager sm;

    public StandardHostValve() {
        super(true);
    }

    @Override
    public String getInfo() {
        return info;
    }

    @Override
    public final void invoke(Request request, Response response) throws IOException, ServletException {
        Object object;
        Context context = request.getContext();
        if (context == null) {
            response.sendError(500, sm.getString("standardHost.noContext"));
            return;
        }
        if (context.getLoader() != null) {
            if (Globals.IS_SECURITY_ENABLED) {
                PrivilegedSetTccl privilegedSetTccl = new PrivilegedSetTccl(context.getLoader().getClassLoader());
                AccessController.doPrivileged(privilegedSetTccl);
            } else {
                Thread.currentThread().setContextClassLoader(context.getLoader().getClassLoader());
            }
        }
        if (request.isAsyncSupported()) {
            request.setAsyncSupported(context.getPipeline().isAsyncSupported());
        }
        boolean bl = request.isAsync();
        boolean bl2 = request.isAsyncDispatching();
        if (bl || context.fireRequestInitEvent((ServletRequest)request.getRequest())) {
            block19: {
                try {
                    if (!bl || bl2) {
                        context.getPipeline().getFirst().invoke(request, response);
                    } else if (!response.isErrorReportRequired()) {
                        throw new IllegalStateException(sm.getString("standardHost.asyncStateError"));
                    }
                }
                catch (Throwable throwable) {
                    ExceptionUtils.handleThrowable((Throwable)throwable);
                    this.container.getLogger().error((Object)("Exception Processing " + request.getRequestURI()), throwable);
                    if (response.isErrorReportRequired()) break block19;
                    request.setAttribute("javax.servlet.error.exception", throwable);
                    this.throwable(request, response, throwable);
                }
            }
            response.setSuspended(false);
            object = (Throwable)request.getAttribute("javax.servlet.error.exception");
            if (!context.getState().isAvailable()) {
                return;
            }
            if (response.isErrorReportRequired()) {
                if (object != null) {
                    this.throwable(request, response, (Throwable)object);
                } else {
                    this.status(request, response);
                }
            }
            if (!request.isAsync() && !bl) {
                context.fireRequestDestroyEvent((ServletRequest)request.getRequest());
            }
        }
        if (ACCESS_SESSION) {
            request.getSession(false);
        }
        if (Globals.IS_SECURITY_ENABLED) {
            object = new PrivilegedSetTccl(StandardHostValve.class.getClassLoader());
            AccessController.doPrivileged(object);
        } else {
            Thread.currentThread().setContextClassLoader(StandardHostValve.class.getClassLoader());
        }
    }

    @Override
    public final void event(Request request, Response response, CometEvent cometEvent) throws IOException, ServletException {
        Context context = request.getContext();
        if (context.getLoader() != null) {
            Thread.currentThread().setContextClassLoader(context.getLoader().getClassLoader());
        }
        context.getPipeline().getFirst().event(request, response, cometEvent);
        response.setSuspended(false);
        Throwable throwable = (Throwable)request.getAttribute("javax.servlet.error.exception");
        if (throwable != null) {
            this.throwable(request, response, throwable);
        } else {
            this.status(request, response);
        }
        if (ACCESS_SESSION) {
            request.getSession(false);
        }
        Thread.currentThread().setContextClassLoader(StandardHostValve.class.getClassLoader());
    }

    private void status(Request request, Response response) {
        int n = response.getStatus();
        Context context = request.getContext();
        if (context == null) {
            return;
        }
        if (!response.isError()) {
            return;
        }
        ErrorPage errorPage = context.findErrorPage(n);
        if (errorPage == null) {
            errorPage = context.findErrorPage(0);
        }
        if (errorPage != null && response.isErrorReportRequired()) {
            response.setAppCommitted(false);
            request.setAttribute("javax.servlet.error.status_code", n);
            String string = response.getMessage();
            if (string == null) {
                string = "";
            }
            request.setAttribute("javax.servlet.error.message", string);
            request.setAttribute("org.apache.catalina.core.DISPATCHER_REQUEST_PATH", errorPage.getLocation());
            request.setAttribute("org.apache.catalina.core.DISPATCHER_TYPE", DispatcherType.ERROR);
            Wrapper wrapper = request.getWrapper();
            if (wrapper != null) {
                request.setAttribute("javax.servlet.error.servlet_name", wrapper.getName());
            }
            request.setAttribute("javax.servlet.error.request_uri", request.getRequestURI());
            if (this.custom(request, response, errorPage)) {
                response.setErrorReported();
                try {
                    response.finishResponse();
                }
                catch (ClientAbortException clientAbortException) {
                }
                catch (IOException iOException) {
                    this.container.getLogger().warn((Object)("Exception Processing " + errorPage), (Throwable)iOException);
                }
            }
        }
    }

    protected void throwable(Request request, Response response, Throwable throwable) {
        Context context = request.getContext();
        if (context == null) {
            return;
        }
        Throwable throwable2 = throwable;
        if (throwable2 instanceof ServletException && (throwable2 = ((ServletException)throwable2).getRootCause()) == null) {
            throwable2 = throwable;
        }
        if (throwable2 instanceof ClientAbortException) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("standardHost.clientAbort", new Object[]{throwable2.getCause().getMessage()}));
            }
            return;
        }
        ErrorPage errorPage = StandardHostValve.findErrorPage(context, throwable);
        if (errorPage == null && throwable2 != throwable) {
            errorPage = StandardHostValve.findErrorPage(context, throwable2);
        }
        if (errorPage != null) {
            if (response.setErrorReported()) {
                response.setAppCommitted(false);
                request.setAttribute("org.apache.catalina.core.DISPATCHER_REQUEST_PATH", errorPage.getLocation());
                request.setAttribute("org.apache.catalina.core.DISPATCHER_TYPE", DispatcherType.ERROR);
                request.setAttribute("javax.servlet.error.status_code", 500);
                request.setAttribute("javax.servlet.error.message", throwable.getMessage());
                request.setAttribute("javax.servlet.error.exception", throwable2);
                Wrapper wrapper = request.getWrapper();
                if (wrapper != null) {
                    request.setAttribute("javax.servlet.error.servlet_name", wrapper.getName());
                }
                request.setAttribute("javax.servlet.error.request_uri", request.getRequestURI());
                request.setAttribute("javax.servlet.error.exception_type", throwable2.getClass());
                if (this.custom(request, response, errorPage)) {
                    try {
                        response.finishResponse();
                    }
                    catch (IOException iOException) {
                        this.container.getLogger().warn((Object)("Exception Processing " + errorPage), (Throwable)iOException);
                    }
                }
            }
        } else {
            response.setStatus(500);
            response.setError();
            this.status(request, response);
        }
    }

    private boolean custom(Request request, Response response, ErrorPage errorPage) {
        if (this.container.getLogger().isDebugEnabled()) {
            this.container.getLogger().debug((Object)("Processing " + errorPage));
        }
        try {
            ServletContext servletContext = request.getContext().getServletContext();
            RequestDispatcher requestDispatcher = servletContext.getRequestDispatcher(errorPage.getLocation());
            if (requestDispatcher == null) {
                this.container.getLogger().error((Object)sm.getString("standardHostValue.customStatusFailed", new Object[]{errorPage.getLocation()}));
                return false;
            }
            if (response.isCommitted()) {
                requestDispatcher.include((ServletRequest)request.getRequest(), (ServletResponse)response.getResponse());
            } else {
                response.resetBuffer(true);
                response.setContentLength(-1);
                requestDispatcher.forward((ServletRequest)request.getRequest(), (ServletResponse)response.getResponse());
                response.setSuspended(false);
            }
            return true;
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable((Throwable)throwable);
            this.container.getLogger().error((Object)("Exception Processing " + errorPage), throwable);
            return false;
        }
    }

    private static ErrorPage findErrorPage(Context context, Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        Class<?> clazz = throwable.getClass();
        String string = clazz.getName();
        while (!Object.class.equals(clazz)) {
            ErrorPage errorPage = context.findErrorPage(string);
            if (errorPage != null) {
                return errorPage;
            }
            if ((clazz = clazz.getSuperclass()) == null) break;
            string = clazz.getName();
        }
        return null;
    }

    static {
        String string = System.getProperty("org.apache.catalina.core.StandardHostValve.ACCESS_SESSION");
        ACCESS_SESSION = string == null ? STRICT_SERVLET_COMPLIANCE : Boolean.parseBoolean(string);
        sm = StringManager.getManager((String)"org.apache.catalina.core");
    }
}

