/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http2;

import org.apache.coyote.ActionCode;
import org.apache.coyote.Response;
import org.apache.coyote.http2.Stream;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

class WindowAllocationManager {
    private static final Log log = LogFactory.getLog(WindowAllocationManager.class);
    private static final StringManager sm = StringManager.getManager(WindowAllocationManager.class);
    private static final int NONE = 0;
    private static final int STREAM = 1;
    private static final int CONNECTION = 2;
    private final Stream stream;
    private int waitingFor = 0;

    WindowAllocationManager(Stream stream) {
        this.stream = stream;
    }

    void waitForStream(long l) throws InterruptedException {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("windowAllocationManager.waitFor.stream", new Object[]{this.stream.getConnectionId(), this.stream.getIdAsString(), Long.toString(l)}));
        }
        this.waitFor(1, l);
    }

    void waitForConnection(long l) throws InterruptedException {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("windowAllocationManager.waitFor.connection", new Object[]{this.stream.getConnectionId(), this.stream.getIdAsString(), Long.toString(l)}));
        }
        this.waitFor(2, l);
    }

    void waitForStreamNonBlocking() {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("windowAllocationManager.waitForNonBlocking.stream", new Object[]{this.stream.getConnectionId(), this.stream.getIdAsString()}));
        }
        this.waitForNonBlocking(1);
    }

    void waitForConnectionNonBlocking() {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("windowAllocationManager.waitForNonBlocking.connection", new Object[]{this.stream.getConnectionId(), this.stream.getIdAsString()}));
        }
        this.waitForNonBlocking(2);
    }

    void notifyStream() {
        this.notify(1);
    }

    void notifyConnection() {
        this.notify(2);
    }

    void notifyAny() {
        this.notify(3);
    }

    boolean isWaitingForStream() {
        return this.isWaitingFor(1);
    }

    boolean isWaitingForConnection() {
        return this.isWaitingFor(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isWaitingFor(int n) {
        Stream stream = this.stream;
        synchronized (stream) {
            return (this.waitingFor & n) > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitFor(int n, long l) throws InterruptedException {
        Stream stream = this.stream;
        synchronized (stream) {
            if (this.waitingFor != 0) {
                throw new IllegalStateException(sm.getString("windowAllocationManager.waitFor.ise", new Object[]{this.stream.getConnectionId(), this.stream.getIdAsString()}));
            }
            this.waitingFor = n;
            if (l < 0L) {
                this.stream.wait();
            } else {
                this.stream.wait(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForNonBlocking(int n) {
        Stream stream = this.stream;
        synchronized (stream) {
            if (this.waitingFor == 0) {
                this.waitingFor = n;
            } else if (this.waitingFor != n) {
                throw new IllegalStateException(sm.getString("windowAllocationManager.waitFor.ise", new Object[]{this.stream.getConnectionId(), this.stream.getIdAsString()}));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notify(int n) {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("windowAllocationManager.notify", new Object[]{this.stream.getConnectionId(), this.stream.getIdAsString(), Integer.toString(this.waitingFor), Integer.toString(n)}));
        }
        Stream stream = this.stream;
        synchronized (stream) {
            if ((n & this.waitingFor) > 0) {
                this.waitingFor = 0;
                Response response = this.stream.getCoyoteResponse();
                if (response != null) {
                    if (response.getWriteListener() == null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)sm.getString("windowAllocationManager.notified", new Object[]{this.stream.getConnectionId(), this.stream.getIdAsString()}));
                        }
                        this.stream.notify();
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)sm.getString("windowAllocationManager.dispatched", new Object[]{this.stream.getConnectionId(), this.stream.getIdAsString()}));
                        }
                        response.action(ActionCode.DISPATCH_WRITE, null);
                        response.action(ActionCode.DISPATCH_EXECUTE, null);
                    }
                }
            }
        }
    }
}

