/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.mbeans;

import java.util.ArrayList;
import java.util.Iterator;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.catalina.Group;
import org.apache.catalina.Role;
import org.apache.catalina.User;
import org.apache.catalina.UserDatabase;
import org.apache.catalina.mbeans.MBeanUtils;
import org.apache.tomcat.util.modeler.BaseModelMBean;
import org.apache.tomcat.util.modeler.ManagedBean;
import org.apache.tomcat.util.modeler.Registry;

public class MemoryUserDatabaseMBean
extends BaseModelMBean {
    protected final Registry registry = MBeanUtils.createRegistry();
    protected final ManagedBean managed = this.registry.findManagedBean("MemoryUserDatabase");
    protected final ManagedBean managedGroup = this.registry.findManagedBean("Group");
    protected final ManagedBean managedRole = this.registry.findManagedBean("Role");
    protected final ManagedBean managedUser = this.registry.findManagedBean("User");

    public String[] getGroups() {
        UserDatabase userDatabase = (UserDatabase)this.resource;
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator<Group> iterator = userDatabase.getGroups();
        while (iterator.hasNext()) {
            Group group = iterator.next();
            arrayList.add(this.findGroup(group.getGroupname()));
        }
        return arrayList.toArray(new String[0]);
    }

    public String[] getRoles() {
        UserDatabase userDatabase = (UserDatabase)this.resource;
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator<Role> iterator = userDatabase.getRoles();
        while (iterator.hasNext()) {
            Role role = iterator.next();
            arrayList.add(this.findRole(role.getRolename()));
        }
        return arrayList.toArray(new String[0]);
    }

    public String[] getUsers() {
        UserDatabase userDatabase = (UserDatabase)this.resource;
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator<User> iterator = userDatabase.getUsers();
        while (iterator.hasNext()) {
            User user = iterator.next();
            arrayList.add(this.findUser(user.getUsername()));
        }
        return arrayList.toArray(new String[0]);
    }

    public String createGroup(String string, String string2) {
        UserDatabase userDatabase = (UserDatabase)this.resource;
        Group group = userDatabase.createGroup(string, string2);
        try {
            MBeanUtils.createMBean(group);
        }
        catch (Exception exception) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Exception creating group [" + string + "] MBean");
            illegalArgumentException.initCause(exception);
            throw illegalArgumentException;
        }
        return this.findGroup(string);
    }

    public String createRole(String string, String string2) {
        UserDatabase userDatabase = (UserDatabase)this.resource;
        Role role = userDatabase.createRole(string, string2);
        try {
            MBeanUtils.createMBean(role);
        }
        catch (Exception exception) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Exception creating role [" + string + "] MBean");
            illegalArgumentException.initCause(exception);
            throw illegalArgumentException;
        }
        return this.findRole(string);
    }

    public String createUser(String string, String string2, String string3) {
        UserDatabase userDatabase = (UserDatabase)this.resource;
        User user = userDatabase.createUser(string, string2, string3);
        try {
            MBeanUtils.createMBean(user);
        }
        catch (Exception exception) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Exception creating user [" + string + "] MBean");
            illegalArgumentException.initCause(exception);
            throw illegalArgumentException;
        }
        return this.findUser(string);
    }

    public String findGroup(String string) {
        UserDatabase userDatabase = (UserDatabase)this.resource;
        Group group = userDatabase.findGroup(string);
        if (group == null) {
            return null;
        }
        try {
            ObjectName objectName = MBeanUtils.createObjectName(this.managedGroup.getDomain(), group);
            return objectName.toString();
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Cannot create object name for group [" + string + "]");
            illegalArgumentException.initCause(malformedObjectNameException);
            throw illegalArgumentException;
        }
    }

    public String findRole(String string) {
        UserDatabase userDatabase = (UserDatabase)this.resource;
        Role role = userDatabase.findRole(string);
        if (role == null) {
            return null;
        }
        try {
            ObjectName objectName = MBeanUtils.createObjectName(this.managedRole.getDomain(), role);
            return objectName.toString();
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Cannot create object name for role [" + string + "]");
            illegalArgumentException.initCause(malformedObjectNameException);
            throw illegalArgumentException;
        }
    }

    public String findUser(String string) {
        UserDatabase userDatabase = (UserDatabase)this.resource;
        User user = userDatabase.findUser(string);
        if (user == null) {
            return null;
        }
        try {
            ObjectName objectName = MBeanUtils.createObjectName(this.managedUser.getDomain(), user);
            return objectName.toString();
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Cannot create object name for user [" + string + "]");
            illegalArgumentException.initCause(malformedObjectNameException);
            throw illegalArgumentException;
        }
    }

    public void removeGroup(String string) {
        UserDatabase userDatabase = (UserDatabase)this.resource;
        Group group = userDatabase.findGroup(string);
        if (group == null) {
            return;
        }
        try {
            MBeanUtils.destroyMBean(group);
            userDatabase.removeGroup(group);
        }
        catch (Exception exception) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Exception destroying group [" + string + "] MBean");
            illegalArgumentException.initCause(exception);
            throw illegalArgumentException;
        }
    }

    public void removeRole(String string) {
        UserDatabase userDatabase = (UserDatabase)this.resource;
        Role role = userDatabase.findRole(string);
        if (role == null) {
            return;
        }
        try {
            MBeanUtils.destroyMBean(role);
            userDatabase.removeRole(role);
        }
        catch (Exception exception) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Exception destroying role [" + string + "] MBean");
            illegalArgumentException.initCause(exception);
            throw illegalArgumentException;
        }
    }

    public void removeUser(String string) {
        UserDatabase userDatabase = (UserDatabase)this.resource;
        User user = userDatabase.findUser(string);
        if (user == null) {
            return;
        }
        try {
            MBeanUtils.destroyMBean(user);
            userDatabase.removeUser(user);
        }
        catch (Exception exception) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Exception destroying user [" + string + "] MBean");
            illegalArgumentException.initCause(exception);
            throw illegalArgumentException;
        }
    }
}

