/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.util.Queue;
import java.util.Random;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.SessionIdGenerator;
import org.apache.catalina.util.LifecycleBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

public abstract class SessionIdGeneratorBase
extends LifecycleBase
implements SessionIdGenerator {
    private final Log log = LogFactory.getLog(SessionIdGeneratorBase.class);
    private static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.util");
    private final Queue<SecureRandom> randoms = new ConcurrentLinkedQueue<SecureRandom>();
    private String secureRandomClass = null;
    private String secureRandomAlgorithm = "SHA1PRNG";
    private String secureRandomProvider = null;
    private String jvmRoute = "";
    private int sessionIdLength = 16;

    public String getSecureRandomClass() {
        return this.secureRandomClass;
    }

    public void setSecureRandomClass(String string) {
        this.secureRandomClass = string;
    }

    public String getSecureRandomAlgorithm() {
        return this.secureRandomAlgorithm;
    }

    public void setSecureRandomAlgorithm(String string) {
        this.secureRandomAlgorithm = string;
    }

    public String getSecureRandomProvider() {
        return this.secureRandomProvider;
    }

    public void setSecureRandomProvider(String string) {
        this.secureRandomProvider = string;
    }

    @Override
    public String getJvmRoute() {
        return this.jvmRoute;
    }

    @Override
    public void setJvmRoute(String string) {
        this.jvmRoute = string;
    }

    @Override
    public int getSessionIdLength() {
        return this.sessionIdLength;
    }

    @Override
    public void setSessionIdLength(int n) {
        this.sessionIdLength = n;
    }

    @Override
    public String generateSessionId() {
        return this.generateSessionId(this.jvmRoute);
    }

    protected void getRandomBytes(byte[] byArray) {
        SecureRandom secureRandom = this.randoms.poll();
        if (secureRandom == null) {
            secureRandom = this.createSecureRandom();
        }
        secureRandom.nextBytes(byArray);
        this.randoms.add(secureRandom);
    }

    private SecureRandom createSecureRandom() {
        Random random = null;
        long l = System.currentTimeMillis();
        if (this.secureRandomClass != null) {
            try {
                Class<?> clazz = Class.forName(this.secureRandomClass);
                random = (SecureRandom)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception exception) {
                this.log.error((Object)sm.getString("sessionIdGeneratorBase.random", new Object[]{this.secureRandomClass}), (Throwable)exception);
            }
        }
        boolean bl = false;
        if (random == null) {
            try {
                if (this.secureRandomProvider != null && this.secureRandomProvider.length() > 0) {
                    random = SecureRandom.getInstance(this.secureRandomAlgorithm, this.secureRandomProvider);
                } else if (this.secureRandomAlgorithm != null && this.secureRandomAlgorithm.length() > 0) {
                    random = SecureRandom.getInstance(this.secureRandomAlgorithm);
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                bl = true;
                this.log.error((Object)sm.getString("sessionIdGeneratorBase.randomAlgorithm", new Object[]{this.secureRandomAlgorithm}), (Throwable)noSuchAlgorithmException);
            }
            catch (NoSuchProviderException noSuchProviderException) {
                bl = true;
                this.log.error((Object)sm.getString("sessionIdGeneratorBase.randomProvider", new Object[]{this.secureRandomProvider}), (Throwable)noSuchProviderException);
            }
        }
        if (random == null && bl) {
            try {
                random = SecureRandom.getInstance("SHA1PRNG");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                this.log.error((Object)sm.getString("sessionIdGeneratorBase.randomAlgorithm", new Object[]{this.secureRandomAlgorithm}), (Throwable)noSuchAlgorithmException);
            }
        }
        if (random == null) {
            random = new SecureRandom();
        }
        random.nextInt();
        long l2 = System.currentTimeMillis();
        if (l2 - l > 100L) {
            this.log.warn((Object)sm.getString("sessionIdGeneratorBase.createRandom", new Object[]{((SecureRandom)random).getAlgorithm(), l2 - l}));
        }
        return random;
    }

    @Override
    protected void initInternal() throws LifecycleException {
    }

    @Override
    protected void startInternal() throws LifecycleException {
        this.generateSessionId();
        this.setState(LifecycleState.STARTING);
    }

    @Override
    protected void stopInternal() throws LifecycleException {
        this.setState(LifecycleState.STOPPING);
        this.randoms.clear();
    }

    @Override
    protected void destroyInternal() throws LifecycleException {
    }
}

