/*
 * Decompiled with CFR 0.152.
 */
package javax.el;

import java.beans.FeatureDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.PropertyNotWritableException;
import javax.el.Util;

public class MapELResolver
extends ELResolver {
    private static final Class<?> UNMODIFIABLE = Collections.unmodifiableMap(new HashMap()).getClass();
    private final boolean readOnly;

    public MapELResolver() {
        this.readOnly = false;
    }

    public MapELResolver(boolean bl) {
        this.readOnly = bl;
    }

    @Override
    public Class<?> getType(ELContext eLContext, Object object, Object object2) {
        Objects.requireNonNull(eLContext);
        if (object instanceof Map) {
            eLContext.setPropertyResolved(object, object2);
            return Object.class;
        }
        return null;
    }

    @Override
    public Object getValue(ELContext eLContext, Object object, Object object2) {
        Objects.requireNonNull(eLContext);
        if (object instanceof Map) {
            eLContext.setPropertyResolved(object, object2);
            return ((Map)object).get(object2);
        }
        return null;
    }

    @Override
    public void setValue(ELContext eLContext, Object object, Object object2, Object object3) {
        Objects.requireNonNull(eLContext);
        if (object instanceof Map) {
            eLContext.setPropertyResolved(object, object2);
            if (this.readOnly) {
                throw new PropertyNotWritableException(Util.message(eLContext, "resolverNotWriteable", object.getClass().getName()));
            }
            try {
                Map map = (Map)object;
                map.put(object2, object3);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                throw new PropertyNotWritableException(unsupportedOperationException);
            }
        }
    }

    @Override
    public boolean isReadOnly(ELContext eLContext, Object object, Object object2) {
        Objects.requireNonNull(eLContext);
        if (object instanceof Map) {
            eLContext.setPropertyResolved(object, object2);
            return this.readOnly || UNMODIFIABLE.equals(object.getClass());
        }
        return this.readOnly;
    }

    @Override
    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext eLContext, Object object) {
        if (object instanceof Map) {
            Iterator iterator = ((Map)object).keySet().iterator();
            ArrayList<FeatureDescriptor> arrayList = new ArrayList<FeatureDescriptor>();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                FeatureDescriptor featureDescriptor = new FeatureDescriptor();
                featureDescriptor.setDisplayName(k.toString());
                featureDescriptor.setShortDescription("");
                featureDescriptor.setExpert(false);
                featureDescriptor.setHidden(false);
                featureDescriptor.setName(k.toString());
                featureDescriptor.setPreferred(true);
                featureDescriptor.setValue("resolvableAtDesignTime", Boolean.TRUE);
                featureDescriptor.setValue("type", k.getClass());
                arrayList.add(featureDescriptor);
            }
            return arrayList.iterator();
        }
        return null;
    }

    @Override
    public Class<?> getCommonPropertyType(ELContext eLContext, Object object) {
        if (object instanceof Map) {
            return Object.class;
        }
        return null;
    }
}

