import { Request, Response } from 'express';
export interface DebugApiOpts {
    inspector?: {
        port: number;
        host?: string;
    };
    port: number;
    host: string;
}
/**
 * A HTTP based Debug API for bridging
 */
export declare class DebugAPI {
    private opts;
    private app;
    constructor(opts: DebugApiOpts);
    start(): Promise<unknown>;
    addRoute(method: "get" | "post" | "put" | "delete", path: string, callback: (req: Request, res: Response) => void): void;
    private onInspectorStart;
    private onInspectorStop;
}
