/* camel-1.2.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "Camel", gir_namespace = "Camel", gir_version = "1.2", lower_case_cprefix = "camel_")]
namespace Camel {
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_address_get_type ()")]
	public class Address : GLib.Object {
		[CCode (has_construct_function = false)]
		public Address ();
		public virtual int cat (Camel.Address source);
		public int copy (Camel.Address source);
		public virtual int decode (string raw);
		public virtual string encode ();
		public virtual string format ();
		public virtual int length ();
		public Camel.Address new_clone ();
		public virtual void remove (int index);
		public virtual int unformat (string raw);
	}
	[CCode (cheader_filename = "camel/camel.h", has_type_id = false)]
	[Compact]
	[Version (since = "3.12")]
	public class AsyncClosure {
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_block_file_get_type ()")]
	public class BlockFile : GLib.Object {
		[CCode (has_construct_function = false)]
		public BlockFile (string path, int flags, string version, size_t block_size);
		public void attach_block (Camel.Block bl);
		public int @delete ();
		public void detach_block (Camel.Block bl);
		public int free_block (Camel._block_t id);
		[Version (since = "3.24")]
		public int get_cache_limit ();
		[Version (since = "3.24")]
		public unowned Camel.BlockRoot? get_root ();
		[Version (since = "3.24")]
		public unowned Camel.Block? get_root_block ();
		[NoWrapper]
		public virtual int init_root ();
		public int rename (string path);
		[Version (since = "3.24")]
		public void set_cache_limit (int block_cache_limit);
		public int sync ();
		public int sync_block (Camel.Block bl);
		public void touch_block (Camel.Block bl);
		public void unref_block (Camel.Block bl);
		[NoWrapper]
		public virtual int validate_root ();
	}
	[CCode (cheader_filename = "camel/camel.h", ref_function = "camel_cert_ref", type_id = "camel_cert_get_type ()", unref_function = "camel_cert_unref")]
	[Compact]
	public class Cert {
		public string fingerprint;
		public string hostname;
		public string issuer;
		public GLib.Bytes rawcert;
		public int refcount;
		public string subject;
		public Camel.CertTrust trust;
		[CCode (has_construct_function = false)]
		public Cert ();
		public bool load_cert_file () throws GLib.Error;
		public Camel.Cert @ref ();
		public bool save_cert_file (GLib.ByteArray der_data) throws GLib.Error;
		public void unref ();
	}
	[CCode (cheader_filename = "camel/camel.h", lower_case_csuffix = "certdb", type_id = "camel_certdb_get_type ()")]
	public class CertDB : GLib.Object {
		[CCode (has_construct_function = false)]
		public CertDB ();
		[NoWrapper]
		public virtual Camel.Cert cert_load ([CCode (type = "FILE*")] GLib.FileStream istream);
		[NoWrapper]
		public virtual int cert_save (Camel.Cert cert, [CCode (type = "FILE*")] GLib.FileStream ostream);
		public void clear ();
		public static Camel.CertDB get_default ();
		[Version (since = "3.6")]
		public Camel.Cert? get_host (string hostname, string fingerprint);
		[NoWrapper]
		public virtual int header_load ([CCode (type = "FILE*")] GLib.FileStream istream);
		[NoWrapper]
		public virtual int header_save ([CCode (type = "FILE*")] GLib.FileStream ostream);
		[Version (since = "3.16")]
		public GLib.SList<Camel.Cert> list_certs ();
		public int load ();
		[Version (since = "3.6")]
		public void put (Camel.Cert cert);
		[Version (since = "3.6")]
		public void remove_host (string hostname, string fingerprint);
		public int save ();
		public void set_default ();
		public void set_filename (string filename);
		public void touch ();
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_cipher_context_get_type ()")]
	public class CipherContext : GLib.Object {
		[CCode (has_construct_function = false)]
		public CipherContext (Camel.Session session);
		[Version (since = "3.0")]
		public async Camel.CipherValidity decrypt (Camel.MimePart ipart, Camel.MimePart opart, int io_priority, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.0")]
		public virtual Camel.CipherValidity decrypt_sync (Camel.MimePart ipart, Camel.MimePart opart, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.0")]
		public async bool encrypt (string userid, GLib.GenericArray<string> recipients, Camel.MimePart ipart, Camel.MimePart opart, int io_priority, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.0")]
		public virtual bool encrypt_sync (string userid, GLib.GenericArray<string> recipients, Camel.MimePart ipart, Camel.MimePart opart, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "2.32")]
		public unowned Camel.Session get_session ();
		public virtual unowned string hash_to_id (Camel.CipherHash hash);
		public virtual Camel.CipherHash id_to_hash (string id);
		[Version (since = "3.0")]
		public async bool sign (string userid, Camel.CipherHash hash, Camel.MimePart ipart, Camel.MimePart opart, int io_priority, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.0")]
		public virtual bool sign_sync (string userid, Camel.CipherHash hash, Camel.MimePart ipart, Camel.MimePart opart, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.0")]
		public async Camel.CipherValidity verify (Camel.MimePart ipart, int io_priority, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public virtual Camel.CipherValidity verify_sync (Camel.MimePart ipart, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public Camel.Session session { get; construct; }
	}
	[CCode (cheader_filename = "camel/camel.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "camel_cipher_validity_get_type ()")]
	[Compact]
	public class CipherValidity {
		public weak GLib.Queue children;
		[CCode (has_construct_function = false)]
		public CipherValidity ();
		public int add_certinfo (Camel.CipherValidityMode mode, string name, string email);
		[Version (since = "2.30")]
		public int add_certinfo_ex (Camel.CipherValidityMode mode, string name, string email, [CCode (destroy_notify_pos = 4.5)] owned void* cert_data, Camel.CipherCloneFunc? cert_data_clone);
		public void clear ();
		public Camel.CipherValidity clone ();
		public void envelope (Camel.CipherValidity valid);
		public void free ();
		[Version (since = "3.22")]
		public void* get_certinfo_property (Camel.CipherValidityMode mode, int info_index, string name);
		public string get_description ();
		public bool get_valid ();
		public void init ();
		[Version (since = "3.22")]
		public void set_certinfo_property (Camel.CipherValidityMode mode, int info_index, string name, [CCode (destroy_notify_pos = 4.5)] owned void* value, Camel.CipherCloneFunc? value_clone);
		public void set_description (string description);
		public void set_valid (bool valid);
	}
	[CCode (cheader_filename = "camel/camel.h", ref_function = "camel_content_disposition_ref", type_id = "camel_content_disposition_get_type ()", unref_function = "camel_content_disposition_unref")]
	[Compact]
	public class ContentDisposition {
		public string disposition;
		public Camel.HeaderParam @params;
		public uint refcount;
		[CCode (has_construct_function = false)]
		public ContentDisposition ();
		public static Camel.ContentDisposition decode (string @in);
		public string format ();
		public bool is_attachment (Camel.ContentType content_type);
		public bool is_attachment_ex (Camel.ContentType content_type, Camel.ContentType parent_content_type);
		public Camel.ContentDisposition @ref ();
		public void unref ();
	}
	[CCode (cheader_filename = "camel/camel.h", ref_function = "camel_content_type_ref", type_id = "camel_content_type_get_type ()", unref_function = "camel_content_type_unref")]
	[Compact]
	public class ContentType {
		public Camel.HeaderParam @params;
		public uint refcount;
		public string subtype;
		public string type;
		[CCode (has_construct_function = false)]
		public ContentType (string type, string subtype);
		public static Camel.ContentType decode (string @in);
		public void dump ();
		public string format ();
		public bool @is (string type, string subtype);
		public unowned string param (string name);
		public Camel.ContentType @ref ();
		public void set_param (string name, string value);
		public string simple ();
		public void unref ();
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_db_get_type ()")]
	[Version (since = "2.24")]
	public class DB : GLib.Object {
		[CCode (has_construct_function = false)]
		[Version (since = "3.24")]
		public DB (string filename) throws GLib.Error;
		public int abort_transaction () throws GLib.Error;
		public int add_to_transaction (string query) throws GLib.Error;
		public int begin_transaction () throws GLib.Error;
		public static void camel_mir_free (Camel.MIRecord? record);
		public int clear_folder_summary (string folder_name) throws GLib.Error;
		public int command (string stmt) throws GLib.Error;
		public int count_deleted_message_info (string table_name, out uint32 count) throws GLib.Error;
		public int count_junk_message_info (string table_name, out uint32 count) throws GLib.Error;
		public int count_junk_not_deleted_message_info (string table_name, uint32 count) throws GLib.Error;
		[Version (since = "2.26")]
		public int count_message_info (string query, out uint32 count) throws GLib.Error;
		public int count_total_message_info (string table_name, out uint32 count) throws GLib.Error;
		public int count_unread_message_info (string table_name, out uint32 count) throws GLib.Error;
		public int count_visible_message_info (string table_name, out uint32 count) throws GLib.Error;
		public int count_visible_unread_message_info (string table_name, out uint32 count) throws GLib.Error;
		public int create_folders_table () throws GLib.Error;
		public int delete_folder (string folder_name) throws GLib.Error;
		public int delete_uid (string folder_name, string uid) throws GLib.Error;
		public int delete_uids (string folder_name, GLib.List<string> uids) throws GLib.Error;
		public int end_transaction () throws GLib.Error;
		[Version (since = "2.26")]
		public int flush_in_memory_transactions (string folder_name) throws GLib.Error;
		public static void free_sqlized_string (string? string);
		[Version (since = "3.4")]
		public static Camel.DBKnownColumnNames get_column_ident (ref GLib.HashTable<void*,void*> hash, int index, [CCode (array_length_cname = "ncols", array_length_pos = 2.5)] string[] col_names);
		public static string? get_column_name (string raw_name);
		[Version (since = "3.24")]
		public unowned string get_filename ();
		public GLib.GenericArray<string>? get_folder_deleted_uids (string folder_name) throws GLib.Error;
		public GLib.GenericArray<string>? get_folder_junk_uids (string folder_name) throws GLib.Error;
		public int get_folder_uids (string folder_name, string? sort_by, string? collate, GLib.HashTable<string,uint32> hash) throws GLib.Error;
		[Version (since = "3.16")]
		public bool maybe_run_maintenance () throws GLib.Error;
		public int prepare_message_info_table (string folder_name) throws GLib.Error;
		public int read_folder_info_record (string folder_name, out Camel.FIRecord record) throws GLib.Error;
		public int read_message_info_record_with_uid (string folder_name, string uid, [CCode (delegate_target_pos = 2.5)] Camel.DBSelectCB callback) throws GLib.Error;
		public int read_message_info_records (string folder_name, [CCode (delegate_target_pos = 1.5, scope = "async")] Camel.DBSelectCB callback) throws GLib.Error;
		[Version (since = "3.24")]
		public static void release_cache_memory ();
		public int rename_folder (string old_folder_name, string new_folder_name) throws GLib.Error;
		[Version (since = "2.28")]
		public int reset_folder_version (string folder_name, int reset_version) throws GLib.Error;
		public int select (string stmt, Camel.DBSelectCB callback) throws GLib.Error;
		public int set_collate (string col, string collate, Camel.DBCollate func);
		public static string sqlize_string (string string);
		[Version (since = "2.26")]
		public int start_in_memory_transactions () throws GLib.Error;
		public int transaction_command (GLib.List<string> qry_list) throws GLib.Error;
		public int write_folder_info_record (Camel.FIRecord record) throws GLib.Error;
		public int write_message_info_record (string folder_name, Camel.MIRecord record) throws GLib.Error;
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_data_cache_get_type ()")]
	public class DataCache : GLib.Object {
		[CCode (has_construct_function = false)]
		public DataCache (string path) throws GLib.Error;
		public GLib.IOStream add (string path, string key) throws GLib.Error;
		[Version (since = "3.2")]
		public void clear (string path);
		[Version (since = "3.26")]
		public void foreach_remove (string path, Camel.DataCacheRemoveFunc func);
		public GLib.IOStream @get (string path, string key) throws GLib.Error;
		[Version (since = "3.24")]
		public bool get_expire_enabled ();
		[Version (since = "2.26")]
		public string get_filename (string path, string key);
		[Version (since = "2.32")]
		public unowned string get_path ();
		public int remove (string path, string key) throws GLib.Error;
		public void set_expire_access (long when);
		public void set_expire_age (long when);
		[Version (since = "3.24")]
		public void set_expire_enabled (bool expire_enabled);
		[Version (since = "2.32")]
		public void set_path (string path);
		public bool expire_enabled { get; set construct; }
		public string path { get; set construct; }
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_data_wrapper_get_type ()")]
	public class DataWrapper : GLib.Object {
		[CCode (has_construct_function = false)]
		public DataWrapper ();
		[Version (since = "3.24")]
		public size_t calculate_decoded_size_sync (GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.24")]
		public size_t calculate_size_sync (GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.12")]
		public async bool construct_from_input_stream (GLib.InputStream input_stream, int io_priority, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.12")]
		public virtual bool construct_from_input_stream_sync (GLib.InputStream input_stream, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.0")]
		public async bool construct_from_stream (Camel.Stream stream, int io_priority, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.0")]
		public virtual bool construct_from_stream_sync (Camel.Stream stream, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.12")]
		public async ssize_t decode_to_output_stream (GLib.OutputStream output_stream, int io_priority, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.12")]
		public virtual ssize_t decode_to_output_stream_sync (GLib.OutputStream output_stream, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.0")]
		public async ssize_t decode_to_stream (Camel.Stream stream, int io_priority, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.0")]
		public virtual ssize_t decode_to_stream_sync (Camel.Stream stream, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.2")]
		public unowned GLib.ByteArray get_byte_array ();
		[Version (since = "3.24")]
		public Camel.TransferEncoding get_encoding ();
		public virtual string get_mime_type ();
		public virtual unowned Camel.ContentType get_mime_type_field ();
		public virtual bool is_offline ();
		[Version (since = "3.24")]
		public void set_encoding (Camel.TransferEncoding encoding);
		public virtual void set_mime_type (string mime_type);
		public virtual void set_mime_type_field (Camel.ContentType? mime_type);
		[Version (since = "3.24")]
		public void set_offline (bool offline);
		[Version (since = "3.24")]
		public void take_mime_type_field (owned Camel.ContentType? mime_type);
		[Version (since = "3.12")]
		public async ssize_t write_to_output_stream (GLib.OutputStream output_stream, int io_priority, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.12")]
		public virtual ssize_t write_to_output_stream_sync (GLib.OutputStream output_stream, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.0")]
		public async ssize_t write_to_stream (Camel.Stream stream, int io_priority, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.0")]
		public virtual ssize_t write_to_stream_sync (Camel.Stream stream, GLib.Cancellable? cancellable = null) throws GLib.Error;
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_filter_driver_get_type ()")]
	public class FilterDriver : GLib.Object {
		[CCode (has_construct_function = false)]
		public FilterDriver (Camel.Session session);
		public void add_rule (string name, string match, string action);
		public int filter_folder (Camel.Folder folder, Camel.UIDCache cache, GLib.GenericArray<string> uids, bool remove, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public int filter_mbox (string mbox, string? original_source_url, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public int filter_message (Camel.MimeMessage message, Camel.MessageInfo info, string uid, Camel.Folder source, string store_uid, string original_store_uid, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public void flush () throws GLib.Error;
		public bool remove_rule_by_name (string name);
		public void set_default_folder (Camel.Folder? def);
		public void set_folder_func (Camel.FilterGetFolderFunc get_folder);
		public void set_logfile ([CCode (type = "FILE*")] GLib.FileStream logfile);
		public void set_play_sound_func (Camel.FilterPlaySoundFunc func);
		public void set_shell_func (Camel.FilterShellFunc func);
		public void set_status_func (Camel.FilterStatusFunc func);
		public void set_system_beep_func (Camel.FilterSystemBeepFunc func);
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_filter_input_stream_get_type ()")]
	public class FilterInputStream : GLib.FilterInputStream {
		[CCode (has_construct_function = false, type = "GInputStream*")]
		[Version (since = "3.12")]
		public FilterInputStream (GLib.InputStream base_stream, Camel.MimeFilter filter);
		[Version (since = "3.12")]
		public unowned Camel.MimeFilter get_filter ();
		public Camel.MimeFilter filter { get; construct; }
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_filter_output_stream_get_type ()")]
	public class FilterOutputStream : GLib.FilterOutputStream {
		[CCode (has_construct_function = false, type = "GOutputStream*")]
		[Version (since = "3.12")]
		public FilterOutputStream (GLib.OutputStream base_stream, Camel.MimeFilter filter);
		[Version (since = "3.12")]
		public unowned Camel.MimeFilter get_filter ();
		public Camel.MimeFilter filter { get; construct; }
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_folder_get_type ()")]
	public abstract class Folder : Camel.Object {
		[CCode (has_construct_function = false)]
		protected Folder ();
		[Version (since = "3.0")]
		public async bool append_message (Camel.MimeMessage message, Camel.MessageInfo info, int io_priority, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.0")]
		public virtual bool append_message_sync (Camel.MimeMessage message, Camel.MessageInfo info, string appended_uid, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "2.28")]
		public virtual int cmp_uids (string uid1, string uid2);
		[Version (since = "2.26")]
		public virtual uint32 count_by_expression (string expression, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public void @delete ();
		[NoWrapper]
		public virtual void delete_ ();
		[Version (since = "3.8")]
		public string dup_description ();
		[Version (since = "3.8")]
		public string dup_display_name ();
		[Version (since = "3.8")]
		public string dup_full_name ();
		public static GLib.Quark error_quark ();
		[Version (since = "3.0")]
		public async bool expunge (int io_priority, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.0")]
		public virtual bool expunge_sync (GLib.Cancellable? cancellable = null) throws GLib.Error;
		public void free_deep (GLib.GenericArray<string> array);
		public void free_shallow (GLib.GenericArray<string> array);
		public virtual void free_summary (GLib.GenericArray<Camel.MessageInfo> array);
		public virtual void free_uids (GLib.GenericArray<string> array);
		public virtual void freeze ();
		public int get_deleted_message_count ();
		[Version (since = "2.32")]
		public unowned string get_description ();
		[Version (since = "3.2")]
		public unowned string get_display_name ();
		[Version (since = "2.26")]
		public virtual string get_filename (string uid) throws GLib.Error;
		[Version (since = "3.24")]
		public uint32 get_flags ();
		[Version (since = "3.24")]
		public unowned Camel.FolderSummary get_folder_summary ();
		[Version (since = "2.32")]
		public int get_frozen_count ();
		public unowned string get_full_name ();
		[Version (since = "3.32")]
		public Camel.ThreeState get_mark_seen ();
		[Version (since = "3.32")]
		public int get_mark_seen_timeout ();
		[Version (since = "3.0")]
		public async unowned Camel.MimeMessage get_message (string message_uid, int io_priority, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.24")]
		public virtual Camel.MimeMessage? get_message_cached (string message_uid, GLib.Cancellable? cancellable = null);
		public virtual int get_message_count ();
		[Version (deprecated = true)]
		public virtual uint32 get_message_flags (string uid);
		public virtual Camel.MessageInfo get_message_info (string uid);
		[Version (since = "3.0")]
		public virtual unowned Camel.MimeMessage get_message_sync (string message_uid, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (deprecated = true)]
		public virtual bool get_message_user_flag (string uid, string name);
		[Version (deprecated = true)]
		public virtual unowned string get_message_user_tag (string uid, string name);
		public unowned Camel.Store get_parent_store ();
		public virtual uint32 get_permanent_flags ();
		[Version (since = "3.2")]
		public async Camel.FolderQuotaInfo get_quota_info (int io_priority, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.2")]
		public virtual Camel.FolderQuotaInfo get_quota_info_sync (GLib.Cancellable? cancellable = null) throws GLib.Error;
		public virtual unowned GLib.GenericArray<string> get_summary ();
		public virtual unowned GLib.GenericArray<string> get_uids ();
		[Version (since = "2.26")]
		public virtual unowned GLib.GenericArray<string> get_uncached_uids (GLib.GenericArray<string> uids) throws GLib.Error;
		[Version (deprecated = true)]
		public int get_unread_message_count ();
		[NoWrapper]
		public virtual bool has_search_capability ();
		public bool has_summary_capability ();
		public virtual bool is_frozen ();
		[Version (since = "2.32")]
		public void @lock ();
		[Version (since = "3.22")]
		public virtual void prepare_content_refresh ();
		[Version (since = "3.4")]
		public async bool purge_message_cache (string start_uid, string end_uid, int io_priority, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.4")]
		public virtual bool purge_message_cache_sync (string start_uid, string end_uid, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.2")]
		public async bool refresh_info (int io_priority, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.0")]
		public virtual bool refresh_info_sync (GLib.Cancellable? cancellable = null) throws GLib.Error;
		public virtual void rename (string new_name);
		public virtual GLib.GenericArray<string> search_by_expression (string expression, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public virtual GLib.GenericArray<string> search_by_uids (string expression, GLib.GenericArray<string> uids, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public virtual void search_free (GLib.GenericArray<string> result);
		[Version (since = "2.32")]
		public void set_description (string description);
		[Version (since = "3.2")]
		public void set_display_name (string display_name);
		[Version (since = "3.24")]
		public void set_flags (uint32 folder_flags);
		[Version (since = "2.32")]
		public void set_full_name (string full_name);
		[Version (since = "2.30")]
		public void set_lock_async (bool skip_folder_lock);
		[Version (since = "3.32")]
		public void set_mark_seen (Camel.ThreeState mark_seen);
		[Version (since = "3.32")]
		public void set_mark_seen_timeout (int timeout);
		[Version (deprecated = true)]
		public virtual bool set_message_flags (string uid, uint32 mask, uint32 @set);
		[Version (deprecated = true)]
		public virtual void set_message_user_flag (string uid, string name, bool value);
		[Version (deprecated = true)]
		public virtual void set_message_user_tag (string uid, string name, string value);
		[Version (since = "2.24")]
		public virtual void sort_uids (GLib.GenericArray<string> uids);
		[Version (since = "3.0")]
		public async bool synchronize (bool expunge, int io_priority, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.0")]
		public async bool synchronize_message (string message_uid, int io_priority, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.0")]
		public virtual bool synchronize_message_sync (string message_uid, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.0")]
		public virtual bool synchronize_sync (bool expunge, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.24")]
		public void take_folder_summary (owned Camel.FolderSummary summary);
		public virtual void thaw ();
		[Version (since = "3.0")]
		public async bool transfer_messages_to (GLib.GenericArray<string> message_uids, Camel.Folder destination, bool delete_originals, int io_priority, GLib.Cancellable? cancellable = null, out GLib.GenericArray<string> transferred_uids) throws GLib.Error;
		[Version (since = "3.0")]
		public virtual bool transfer_messages_to_sync (GLib.GenericArray<string> message_uids, Camel.Folder destination, bool delete_originals, out GLib.GenericArray<string> transferred_uids, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "2.32")]
		public void @unlock ();
		public string description { get; set construct; }
		public string display_name { get; set construct; }
		public string full_name { get; set construct; }
		[Version (since = "3.32")]
		public Camel.ThreeState mark_seen { get; set construct; }
		[Version (since = "3.32")]
		public int mark_seen_timeout { get; set construct; }
		public Camel.Store parent_store { get; construct; }
		[HasEmitter]
		public virtual signal void changed (Camel.FolderChangeInfo changes);
		public virtual signal void deleted ();
		public virtual signal void renamed (string old_name);
	}
	[CCode (cheader_filename = "camel/camel.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "camel_folder_change_info_get_type ()")]
	[Compact]
	public class FolderChangeInfo {
		public weak GLib.GenericArray<void*> uid_added;
		public weak GLib.GenericArray<void*> uid_changed;
		public weak GLib.GenericArray<void*> uid_recent;
		public weak GLib.GenericArray<void*> uid_removed;
		[CCode (has_construct_function = false)]
		public FolderChangeInfo ();
		public void add_source (string uid);
		public void add_source_list (owned GLib.GenericArray<weak string> list);
		public void add_uid (string uid);
		public void add_update (string uid);
		public void add_update_list (owned GLib.GenericArray<weak string> list);
		public void build_diff ();
		public void cat (Camel.FolderChangeInfo src);
		public void change_uid (string uid);
		public bool changed ();
		public void clear ();
		[Version (since = "3.24")]
		public Camel.FolderChangeInfo copy ();
		public void free ();
		[Version (since = "3.24")]
		public unowned GLib.GenericArray<string> get_added_uids ();
		[Version (since = "3.24")]
		public unowned GLib.GenericArray<string> get_changed_uids ();
		[Version (since = "3.24")]
		public unowned GLib.GenericArray<string> get_recent_uids ();
		[Version (since = "3.24")]
		public unowned GLib.GenericArray<string> get_removed_uids ();
		public void recent_uid (string uid);
		public void remove_uid (string uid);
	}
	[CCode (cheader_filename = "camel/camel.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "camel_folder_info_get_type ()")]
	[Compact]
	public class FolderInfo {
		public Camel.FolderInfo? child;
		public string display_name;
		public Camel.FolderInfoFlags flags;
		public string full_name;
		public Camel.FolderInfo? next;
		public weak Camel.FolderInfo? parent;
		public int32 total;
		public int32 unread;
		[CCode (has_construct_function = false)]
		[Version (since = "2.22")]
		public FolderInfo ();
		public static Camel.FolderInfo build (GLib.GenericArray<Camel.FolderInfo> folders, string namespace_, char separator, bool short_names);
		public Camel.FolderInfo clone ();
		public void free ();
	}
	[CCode (cheader_filename = "camel/camel.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "camel_folder_quota_info_get_type ()")]
	[Compact]
	[Version (since = "2.24")]
	public class FolderQuotaInfo {
		public string name;
		public Camel.FolderQuotaInfo? next;
		public uint64 total;
		public uint64 used;
		[CCode (has_construct_function = false)]
		public FolderQuotaInfo (string name, uint64 used, uint64 total);
		public Camel.FolderQuotaInfo clone ();
		public void free ();
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_folder_search_get_type ()")]
	public class FolderSearch : GLib.Object {
		[CCode (has_construct_function = false)]
		public FolderSearch ();
		[Version (since = "2.26")]
		public uint32 count (string expr, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public void free_result (GLib.GenericArray<string>? result);
		[Version (since = "3.24")]
		public unowned Camel.MessageInfo? get_current_message_info ();
		[Version (since = "3.24")]
		public unowned GLib.GenericArray<string> get_current_summary ();
		[Version (since = "3.24")]
		public unowned Camel.Folder get_folder ();
		[Version (since = "3.24")]
		public bool get_only_cached_messages ();
		[Version (since = "3.24")]
		public unowned GLib.GenericArray<string> get_summary ();
		public bool get_summary_empty ();
		public GLib.GenericArray<string> search (string expr, GLib.GenericArray<string> uids, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public void set_body_index (Camel.Index? body_index);
		[Version (since = "3.24")]
		public void set_current_message_info (Camel.MessageInfo? info);
		public void set_folder (Camel.Folder folder);
		[Version (since = "3.24")]
		public void set_only_cached_messages (bool only_cached_messages);
		public void set_summary (GLib.GenericArray<string> summary);
		[Version (since = "3.24")]
		public void take_current_message_info (Camel.MessageInfo? info);
		[Version (since = "3.2")]
		public static long util_add_months (long t, int months);
		[Version (since = "3.30")]
		public static int util_compare_date (int64 datetime1, int64 datetime2);
		[Version (since = "3.30")]
		public static long util_make_time (int argc, Camel.SExpResult argv);
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_folder_summary_get_type ()")]
	public class FolderSummary : GLib.Object {
		[CCode (has_construct_function = false)]
		public FolderSummary (Camel.Folder folder);
		public void add (Camel.MessageInfo info, bool force_keep_uid);
		[Version (since = "2.24")]
		public bool check_uid (string uid);
		public bool clear () throws GLib.Error;
		public uint count ();
		[CCode (vfunc_name = "message_info_from_uid")]
		[Version (since = "3.4")]
		public virtual Camel.MessageInfo? @get (string uid);
		[Version (since = "3.4")]
		public GLib.GenericArray<string> get_array ();
		[Version (since = "2.24")]
		public GLib.GenericArray<string> get_changed ();
		[Version (since = "3.4")]
		public uint32 get_deleted_count ();
		[Version (since = "3.24")]
		public uint32 get_flags ();
		[Version (since = "3.4")]
		public unowned Camel.Folder get_folder ();
		[Version (since = "3.6")]
		public GLib.HashTable<weak string,int> get_hash ();
		[Version (since = "3.4")]
		public unowned Camel.Index get_index ();
		[Version (since = "3.12")]
		public uint32 get_info_flags (string uid);
		[Version (since = "3.4")]
		public uint32 get_junk_count ();
		[Version (since = "3.4")]
		public uint32 get_junk_not_deleted_count ();
		[Version (since = "3.4")]
		public uint32 get_next_uid ();
		[Version (since = "3.4")]
		public uint32 get_saved_count ();
		[Version (since = "3.24")]
		public int64 get_timestamp ();
		[Version (since = "3.4")]
		public uint32 get_unread_count ();
		[Version (since = "3.24")]
		public uint32 get_version ();
		[Version (since = "3.4")]
		public uint32 get_visible_count ();
		[Version (since = "3.24")]
		public bool header_load ([CCode (type = "_CamelStore*")] Camel.Store store, string folder_name) throws GLib.Error;
		[CCode (vfunc_name = "summary_header_load")]
		[NoWrapper]
		public virtual bool header_load_impl ([CCode (type = "_CamelFIRecord*")] Camel.FIRecord fir);
		[Version (since = "3.24")]
		public bool header_save () throws GLib.Error;
		[CCode (vfunc_name = "summary_header_save")]
		[NoWrapper]
		public virtual Camel.FIRecord? header_save_impl () throws GLib.Error;
		[CCode (vfunc_name = "message_info_new_from_headers")]
		[Version (since = "3.24")]
		public virtual Camel.MessageInfo info_new_from_headers (Camel.NameValueArray headers);
		[CCode (vfunc_name = "message_info_new_from_message")]
		public virtual Camel.MessageInfo info_new_from_message (Camel.MimeMessage message);
		[CCode (vfunc_name = "message_info_new_from_parser")]
		public virtual Camel.MessageInfo info_new_from_parser (Camel.MimeParser parser);
		[Version (since = "3.24")]
		public bool load () throws GLib.Error;
		[Version (since = "2.32")]
		public void @lock ();
		public uint32 next_uid ();
		public virtual string next_uid_string ();
		[Version (since = "2.26")]
		public Camel.MessageInfo? peek_loaded (string uid);
		[Version (since = "2.32")]
		public void prepare_fetch_all () throws GLib.Error;
		[CCode (vfunc_name = "prepare_fetch_all")]
		[NoWrapper]
		public virtual void prepare_fetch_all_v ();
		public bool remove (Camel.MessageInfo info);
		public bool remove_uid (string uid);
		[Version (since = "3.6")]
		public bool remove_uids (GLib.List<string> uids);
		[Version (since = "3.6")]
		public bool replace_flags (Camel.MessageInfo info);
		[Version (since = "3.24")]
		public bool save () throws GLib.Error;
		[Version (since = "3.24")]
		public void set_flags (uint32 flags);
		public void set_index (Camel.Index index);
		public void set_next_uid (uint32 uid);
		[Version (since = "3.24")]
		public void set_timestamp (int64 timestamp);
		[Version (since = "3.24")]
		public void set_version (uint32 version);
		public void touch ();
		[Version (since = "2.32")]
		public void @unlock ();
		public uint deleted_count { get; }
		public Camel.Folder folder { get; construct; }
		public uint junk_count { get; }
		public uint junk_not_deleted_count { get; }
		public uint saved_count { get; }
		public uint unread_count { get; }
		public uint visible_count { get; }
		public signal void changed ();
	}
	[CCode (cheader_filename = "camel/camel.h", lower_case_csuffix = "folder_thread_messages", ref_function = "camel_folder_thread_messages_ref", type_id = "camel_folder_thread_messages_get_type ()", unref_function = "camel_folder_thread_messages_unref")]
	[Compact]
	public class FolderThread {
		public Camel.Folder folder;
		public Camel.MemChunk node_chunks;
		public uint32 refcount;
		public uint32 subject;
		public GLib.GenericArray<Camel.MessageInfo> summary;
		public Camel.FolderThreadNode tree;
		[CCode (has_construct_function = false)]
		public FolderThread (Camel.Folder folder, GLib.GenericArray<string> uids, bool thread_subject);
		public void apply (GLib.GenericArray<string> uids);
		public Camel.FolderThread @ref ();
		public void unref ();
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_gpg_context_get_type ()")]
	public class GpgContext : Camel.CipherContext {
		[CCode (has_construct_function = false, type = "CamelCipherContext*")]
		public GpgContext (Camel.Session session);
		[Version (since = "2.32")]
		public bool get_always_trust ();
		[Version (since = "3.20")]
		public bool get_prefer_inline ();
		public void set_always_trust (bool always_trust);
		[Version (since = "3.20")]
		public void set_prefer_inline (bool prefer_inline);
		public bool always_trust { get; set construct; }
		public bool prefer_inline { get; set construct; }
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_html_parser_get_type ()")]
	public class HTMLParser : GLib.Object {
		[CCode (has_construct_function = false)]
		public HTMLParser ();
		public unowned string attr (string name);
		public unowned GLib.GenericArray<string> attr_list (ref GLib.GenericArray<string>? values);
		public unowned string left (int lenp);
		public void set_data (string start, int len, int last);
		public Camel.HTMLParserState step (string datap, int lenp);
		public unowned string tag ();
	}
	[CCode (cheader_filename = "camel/camel.h", ref_function = "camel_header_address_ref", type_id = "camel_header_address_get_type ()", unref_function = "camel_header_address_unref")]
	[Compact]
	public class HeaderAddress {
		public string name;
		public Camel.HeaderAddress? next;
		public uint refcount;
		public Camel.HeaderAddressType type;
		[CCode (cname = "v.addr")]
		public string v_addr;
		[CCode (cname = "v.members")]
		public Camel.HeaderAddress? v_members;
		[CCode (has_construct_function = false)]
		public HeaderAddress ();
		public void add_member (Camel.HeaderAddress member);
		public static Camel.HeaderAddress decode (string @in, string charset);
		public static string fold (string @in, size_t headerlen);
		[CCode (has_construct_function = false)]
		public HeaderAddress.group (string name);
		public static void list_append ([CCode (array_length = false, array_null_terminated = true)] Camel.HeaderAddress[] addrlistp, Camel.HeaderAddress addr);
		public static void list_append_list ([CCode (array_length = false, array_null_terminated = true)] Camel.HeaderAddress[] addrlistp, [CCode (array_length = false, array_null_terminated = true)] Camel.HeaderAddress[] addrs);
		public static void list_clear ([CCode (array_length = false, array_null_terminated = true)] Camel.HeaderAddress[] addrlistp);
		public static string list_encode ([CCode (array_length = false, array_null_terminated = true)] Camel.HeaderAddress[] addrlist);
		public static string list_format ([CCode (array_length = false, array_null_terminated = true)] Camel.HeaderAddress[] addrlist);
		public Camel.HeaderAddress @ref ();
		public void set_addr (string addr);
		public void set_members ([CCode (array_length = false, array_null_terminated = true)] Camel.HeaderAddress[] group);
		public void set_name (string name);
		public void unref ();
		[CCode (cname = "camel_header_address_new_name", has_construct_function = false)]
		public HeaderAddress.with_name (string name, string addr);
	}
	[CCode (cheader_filename = "camel/camel.h", free_function = "camel_header_param_list_free", has_type_id = false)]
	[Compact]
	public class HeaderParam {
		public string name;
		public Camel.HeaderParam? next;
		public string value;
		[CCode (cname = "camel_header_param_list_decode")]
		public static Camel.HeaderParam? decode (string? @in);
		[CCode (cname = "camel_header_param_list_format")]
		public string format ();
		[CCode (cname = "camel_header_param_list_format_append", instance_pos = 1.5)]
		public void format_append (GLib.StringBuilder @out);
		[CCode (cname = "camel_header_param_list_free")]
		[DestroysInstance]
		public void free ();
		[CCode (cname = "camel_header_param")]
		public unowned string get_value (string name);
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_index_get_type ()")]
	public class Index : GLib.Object {
		public uint32 flags;
		public weak Camel.IndexNorm normalize;
		public void* normalize_data;
		public weak string path;
		public uint32 state;
		public uint32 version;
		[CCode (has_construct_function = false)]
		protected Index ();
		public virtual unowned Camel.IndexName? add_name (string name);
		public virtual int compress ();
		public void @construct (string path, int flags);
		public int @delete ();
		[NoWrapper]
		public virtual int delete_ ();
		public virtual void delete_name (string name);
		public virtual unowned Camel.IndexCursor? find (string word);
		public virtual unowned Camel.IndexCursor? find_name (string name);
		public virtual int has_name (string name);
		public virtual int rename (string path);
		[Version (since = "2.32")]
		public void set_normalize (Camel.IndexNorm func);
		public virtual int sync ();
		public virtual unowned Camel.IndexCursor? words ();
		public virtual int write_name (Camel.IndexName idn);
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_index_cursor_get_type ()")]
	public class IndexCursor : GLib.Object {
		public weak Camel.Index index;
		[CCode (has_construct_function = false)]
		protected IndexCursor ();
		public virtual unowned string next ();
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_index_name_get_type ()")]
	public class IndexName : GLib.Object {
		public weak GLib.ByteArray buffer;
		public weak Camel.Index index;
		public weak string name;
		public weak GLib.HashTable<void*,void*> words;
		[CCode (has_construct_function = false)]
		protected IndexName ();
		public virtual size_t add_buffer (string buffer, size_t len);
		public virtual void add_word (string word);
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_internet_address_get_type ()")]
	public class InternetAddress : Camel.Address {
		[CCode (has_construct_function = false)]
		public InternetAddress ();
		public int add (string name, string address);
		public static string encode_address (int len, string name, string addr);
		[Version (since = "3.16")]
		public void ensure_ascii_domains ();
		public int find_address (string address, out string? namep);
		public int find_name (string name, out string? addressp);
		public static string format_address (string name, string addr);
		public bool @get (int index, out string? namep, out string? addressp);
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_key_file_get_type ()")]
	public class KeyFile : GLib.Object {
		[CCode (has_construct_function = false)]
		public KeyFile (string path, int flags, string version);
		public int @delete ();
		public int read (Camel._block_t start, [CCode (array_length_cname = "len", array_length_pos = 1.5, array_length_type = "gsize")] Camel._key_t[]? records);
		public int rename (string path);
		public int write (Camel._block_t parent, [CCode (array_length_cname = "len", array_length_pos = 1.5, array_length_type = "gsize")] Camel._key_t[] records);
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_key_table_get_type ()")]
	public class KeyTable : GLib.Object {
		[CCode (has_construct_function = false)]
		public KeyTable (Camel.BlockFile bs, Camel._block_t root);
		public Camel._key_t add (string key, Camel._block_t data, uint flags);
		public Camel._block_t lookup (Camel._key_t keyid, string key, uint flags);
		public Camel._key_t next (Camel._key_t next, string keyp, uint flagsp, Camel._block_t datap);
		public bool set_data (Camel._key_t keyid, Camel._block_t data);
		public bool set_flags (Camel._key_t keyid, uint flags, uint @set);
		public int sync ();
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_local_settings_get_type ()")]
	[Version (since = "3.4")]
	public class LocalSettings : Camel.StoreSettings {
		[CCode (has_construct_function = false)]
		protected LocalSettings ();
		public string dup_path ();
		[Version (since = "3.24")]
		public bool get_filter_all ();
		[Version (since = "3.24")]
		public bool get_filter_junk ();
		public unowned string get_path ();
		[Version (since = "3.24")]
		public void set_filter_all (bool filter_all);
		[Version (since = "3.24")]
		public void set_filter_junk (bool filter_junk);
		public void set_path (string path);
		public bool filter_all { get; set construct; }
		public bool filter_junk { get; set construct; }
		public string path { get; set construct; }
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_medium_get_type ()")]
	public abstract class Medium : Camel.DataWrapper {
		[CCode (has_construct_function = false)]
		protected Medium ();
		public virtual void add_header (string name, string value);
		[Version (since = "3.24")]
		public virtual Camel.NameValueArray dup_headers ();
		public virtual unowned Camel.DataWrapper? get_content ();
		public virtual unowned string? get_header (string name);
		[Version (since = "3.24")]
		public virtual unowned Camel.NameValueArray get_headers ();
		public virtual void remove_header (string name);
		public virtual void set_content (Camel.DataWrapper content);
		public virtual void set_header (string name, string value);
		public Camel.DataWrapper content { get; set; }
	}
	[CCode (cheader_filename = "camel/camel.h", has_type_id = false)]
	[Compact]
	[Version (since = "3.4")]
	public class MemChunk {
	}
	[CCode (cheader_filename = "camel/camel.h", has_type_id = false)]
	[Compact]
	[Version (since = "2.32")]
	public class MemPool {
	}
	[CCode (cheader_filename = "camel/camel.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "camel_message_content_info_get_type ()")]
	[Compact]
	public class MessageContentInfo {
		public Camel.MessageContentInfo? childs;
		public string description;
		public Camel.ContentDisposition disposition;
		public string encoding;
		public string id;
		public Camel.MessageContentInfo? next;
		public weak Camel.MessageContentInfo? parent;
		public uint32 size;
		public Camel.ContentType type;
		[CCode (has_construct_function = false)]
		public MessageContentInfo ();
		[Version (since = "3.24")]
		public Camel.MessageContentInfo copy ();
		public void dump (int depth);
		public void free ();
		[CCode (has_construct_function = false)]
		public MessageContentInfo.from_headers (Camel.NameValueArray headers);
		[CCode (has_construct_function = false)]
		public MessageContentInfo.from_message (Camel.MimePart mime_part);
		[CCode (has_construct_function = false)]
		public MessageContentInfo.from_parser (Camel.MimeParser parser);
		public bool traverse (Camel.MessageContentInfoTraverseCallback func);
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_message_info_get_type ()")]
	public abstract class MessageInfo : GLib.Object {
		[CCode (has_construct_function = false)]
		protected MessageInfo ();
		[Version (since = "3.24")]
		public virtual Camel.MessageInfo clone (Camel.FolderSummary? assign_summary);
		[Version (since = "3.24")]
		public void dump ();
		[Version (since = "3.24")]
		public Camel.NameValueArray? dup_headers ();
		[Version (since = "3.24")]
		public GLib.Array<uint64>? dup_references ();
		[Version (since = "3.24")]
		public virtual Camel.NamedFlags dup_user_flags ();
		[Version (since = "3.24")]
		public string? dup_user_tag (string name);
		[Version (since = "3.24")]
		public virtual Camel.NameValueArray? dup_user_tags ();
		[Version (since = "3.24")]
		public void freeze_notifications ();
		[Version (since = "3.24")]
		public bool get_abort_notifications ();
		[Version (since = "3.24")]
		public virtual unowned string get_cc ();
		[Version (since = "3.24")]
		public virtual int64 get_date_received ();
		[Version (since = "3.24")]
		public virtual int64 get_date_sent ();
		[Version (since = "3.24")]
		public bool get_dirty ();
		[Version (since = "3.24")]
		public virtual uint32 get_flags ();
		[Version (since = "3.24")]
		public bool get_folder_flagged ();
		[Version (since = "3.24")]
		public uint get_folder_flagged_stamp ();
		[Version (since = "3.24")]
		public virtual unowned string get_from ();
		[Version (since = "3.24")]
		public virtual unowned Camel.NameValueArray? get_headers ();
		[Version (since = "3.24")]
		public virtual uint64 get_message_id ();
		[Version (since = "3.24")]
		public virtual unowned string get_mlist ();
		[Version (since = "3.24")]
		public bool get_notifications_frozen ();
		[Version (since = "3.24")]
		public virtual unowned GLib.Array<uint64>? get_references ();
		[Version (since = "3.24")]
		public virtual uint32 get_size ();
		[Version (since = "3.24")]
		public virtual unowned string get_subject ();
		[Version (since = "3.24")]
		public virtual unowned string get_to ();
		[Version (since = "3.24")]
		public unowned string get_uid ();
		[Version (since = "3.24")]
		public virtual bool get_user_flag (string name);
		[Version (since = "3.24")]
		public virtual unowned Camel.NamedFlags? get_user_flags ();
		[Version (since = "3.24")]
		public virtual unowned string? get_user_tag (string name);
		[Version (since = "3.24")]
		public virtual unowned Camel.NameValueArray? get_user_tags ();
		[Version (since = "3.24")]
		public virtual bool load (Camel.MIRecord? record, string bdata_ptr);
		[Version (since = "3.24")]
		public unowned string pooldup_uid ();
		[Version (since = "3.24")]
		public void property_lock ();
		[Version (since = "3.24")]
		public void property_unlock ();
		[Version (since = "3.24")]
		public Camel.FolderSummary? ref_summary ();
		[Version (since = "3.24")]
		public virtual bool save (Camel.MIRecord? record, GLib.StringBuilder bdata_str);
		[Version (since = "3.24")]
		public void set_abort_notifications (bool abort_notifications);
		[Version (since = "3.24")]
		public virtual bool set_cc (string? cc);
		[Version (since = "3.24")]
		public virtual bool set_date_received (int64 date_received);
		[Version (since = "3.24")]
		public virtual bool set_date_sent (int64 date_sent);
		[Version (since = "3.24")]
		public void set_dirty (bool dirty);
		[Version (since = "3.24")]
		public virtual bool set_flags (uint32 mask, uint32 @set);
		[Version (since = "3.24")]
		public bool set_folder_flagged (bool folder_flagged);
		[Version (since = "3.24")]
		public virtual bool set_from (string? from);
		[Version (since = "3.24")]
		public virtual bool set_message_id (uint64 message_id);
		[Version (since = "3.24")]
		public virtual bool set_mlist (string? mlist);
		[Version (since = "3.24")]
		public virtual bool set_size (uint32 size);
		[Version (since = "3.24")]
		public virtual bool set_subject (string? subject);
		[Version (since = "3.24")]
		public virtual bool set_to (string? to);
		[Version (since = "3.24")]
		public bool set_uid (string uid);
		[Version (since = "3.24")]
		public virtual bool set_user_flag (string name, bool state);
		[Version (since = "3.24")]
		public virtual bool set_user_tag (string name, string? value);
		[Version (since = "3.24")]
		public virtual bool take_headers (owned Camel.NameValueArray? headers);
		[Version (since = "3.24")]
		public virtual bool take_references (owned GLib.Array<uint64>? references);
		[Version (since = "3.24")]
		public virtual bool take_user_flags (owned Camel.NamedFlags? user_flags);
		[Version (since = "3.24")]
		public virtual bool take_user_tags (owned Camel.NameValueArray? user_tags);
		[Version (since = "3.24")]
		public void thaw_notifications ();
		[Version (since = "3.24")]
		public bool abort_notifications { get; set; }
		[Version (since = "3.24")]
		public string cc { get; set; }
		[Version (since = "3.24")]
		public int64 date_received { get; set; }
		[Version (since = "3.24")]
		public int64 date_sent { get; set; }
		[Version (since = "3.24")]
		public bool dirty { get; set; }
		[NoAccessorMethod]
		[Version (since = "3.24")]
		public uint flags { get; set; }
		[Version (since = "3.24")]
		public bool folder_flagged { get; set; }
		[Version (since = "3.24")]
		public uint folder_flagged_stamp { get; }
		[Version (since = "3.24")]
		public string from { get; set; }
		[NoAccessorMethod]
		[Version (since = "3.24")]
		public Camel.NameValueArray headers { owned get; set; }
		[Version (since = "3.24")]
		public uint64 message_id { get; set; }
		[Version (since = "3.24")]
		public string mlist { get; set; }
		[NoAccessorMethod]
		[Version (since = "3.24")]
		public GLib.Array<uint64> references { owned get; set; }
		[Version (since = "3.24")]
		public uint size { get; set; }
		[Version (since = "3.24")]
		public string subject { get; set; }
		[NoAccessorMethod]
		[Version (since = "3.24")]
		public Camel.FolderSummary summary { owned get; construct; }
		[Version (since = "3.24")]
		public string to { get; set; }
		[Version (since = "3.24")]
		public string uid { get; set; }
		[NoAccessorMethod]
		[Version (since = "3.24")]
		public Camel.NamedFlags user_flags { owned get; set; }
		[NoAccessorMethod]
		[Version (since = "3.24")]
		public Camel.NameValueArray user_tags { owned get; set; }
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_message_info_base_get_type ()")]
	public class MessageInfoBase : Camel.MessageInfo {
		[CCode (has_construct_function = false)]
		protected MessageInfoBase ();
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_mime_filter_get_type ()")]
	public abstract class MimeFilter : GLib.Object {
		public string backbuf;
		public size_t backlen;
		public size_t backsize;
		public weak string outbuf;
		public size_t outpre;
		public weak string outptr;
		public string outreal;
		public size_t outsize;
		[CCode (has_construct_function = false)]
		protected MimeFilter ();
		public void backup ([CCode (array_length_cname = "length", array_length_pos = 1.1, array_length_type = "gsize")] string[] data);
		public virtual void complete ([CCode (array_length_cname = "len", array_length_pos = 1.5, array_length_type = "gsize")] string[] @in, size_t prespace, [CCode (array_length_cname = "outlen", array_length_pos = 3.5, array_length_type = "gsize")] out string[] @out, out size_t outprespace);
		public virtual void filter ([CCode (array_length_cname = "len", array_length_pos = 1.5, array_length_type = "gsize")] string[] @in, size_t prespace, [CCode (array_length_cname = "outlen", array_length_pos = 3.5, array_length_type = "gsize")] out string[] @out, out size_t outprespace);
		public static Camel.MimeFilter @new ();
		public virtual void reset ();
		public void set_size (size_t size, int keep);
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_mime_filter_basic_get_type ()")]
	public class MimeFilterBasic : Camel.MimeFilter {
		[CCode (has_construct_function = false, type = "CamelMimeFilter*")]
		public MimeFilterBasic (Camel.MimeFilterBasicType type);
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_mime_filter_bestenc_get_type ()")]
	public class MimeFilterBestenc : Camel.MimeFilter {
		[CCode (has_construct_function = false, type = "CamelMimeFilter*")]
		public MimeFilterBestenc (uint flags);
		public unowned string get_best_charset ();
		public Camel.TransferEncoding get_best_encoding (Camel.BestencEncoding required);
		public void set_flags (uint flags);
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_mime_filter_crlf_get_type ()")]
	public class MimeFilterCRLF : Camel.MimeFilter {
		[CCode (has_construct_function = false, type = "CamelMimeFilter*")]
		public MimeFilterCRLF (Camel.MimeFilterCRLFDirection direction, Camel.MimeFilterCRLFMode mode);
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_mime_filter_canon_get_type ()")]
	public class MimeFilterCanon : Camel.MimeFilter {
		[CCode (has_construct_function = false, type = "CamelMimeFilter*")]
		public MimeFilterCanon (uint32 flags);
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_mime_filter_charset_get_type ()")]
	public class MimeFilterCharset : Camel.MimeFilter {
		[CCode (has_construct_function = false, type = "CamelMimeFilter*")]
		public MimeFilterCharset (string from_charset, string to_charset);
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_mime_filter_enriched_get_type ()")]
	public class MimeFilterEnriched : Camel.MimeFilter {
		[CCode (has_construct_function = false, type = "CamelMimeFilter*")]
		public MimeFilterEnriched (uint32 flags);
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_mime_filter_from_get_type ()")]
	public class MimeFilterFrom : Camel.MimeFilter {
		[CCode (has_construct_function = false, type = "CamelMimeFilter*")]
		public MimeFilterFrom ();
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_mime_filter_gzip_get_type ()")]
	public class MimeFilterGZip : Camel.MimeFilter {
		[CCode (has_construct_function = false, type = "CamelMimeFilter*")]
		public MimeFilterGZip (Camel.MimeFilterGZipMode mode, int level);
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_mime_filter_html_get_type ()")]
	public class MimeFilterHTML : Camel.MimeFilter {
		[CCode (has_construct_function = false, type = "CamelMimeFilter*")]
		public MimeFilterHTML ();
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_mime_filter_index_get_type ()")]
	public class MimeFilterIndex : Camel.MimeFilter {
		[CCode (has_construct_function = false, type = "CamelMimeFilter*")]
		public MimeFilterIndex (Camel.Index index);
		public void set_index (Camel.Index index);
		public void set_name (Camel.IndexName name);
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_mime_filter_linewrap_get_type ()")]
	public class MimeFilterLinewrap : Camel.MimeFilter {
		[CCode (has_construct_function = false, type = "CamelMimeFilter*")]
		public MimeFilterLinewrap (uint preferred_len, uint max_len, char indent_char, uint32 flags);
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_mime_filter_pgp_get_type ()")]
	public class MimeFilterPgp : Camel.MimeFilter {
		[CCode (has_construct_function = false, type = "CamelMimeFilter*")]
		public MimeFilterPgp ();
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_mime_filter_progress_get_type ()")]
	[Version (since = "2.24")]
	public class MimeFilterProgress : Camel.MimeFilter {
		[CCode (has_construct_function = false, type = "CamelMimeFilter*")]
		public MimeFilterProgress (GLib.Cancellable? cancellable = null, size_t total);
	}
	[CCode (cheader_filename = "camel/camel.h", lower_case_csuffix = "mime_filter_tohtml", type_id = "camel_mime_filter_tohtml_get_type ()")]
	public class MimeFilterToHTML : Camel.MimeFilter {
		[CCode (has_construct_function = false, type = "CamelMimeFilter*")]
		public MimeFilterToHTML (Camel.MimeFilterToHTMLFlags flags, uint32 color);
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_mime_filter_windows_get_type ()")]
	public class MimeFilterWindows : Camel.MimeFilter {
		[CCode (has_construct_function = false, type = "CamelMimeFilter*")]
		public MimeFilterWindows (string claimed_charset);
		public bool is_windows_charset ();
		public unowned string real_charset ();
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_mime_filter_yenc_get_type ()")]
	public class MimeFilterYenc : Camel.MimeFilter {
		[CCode (has_construct_function = false, type = "CamelMimeFilter*")]
		public MimeFilterYenc (Camel.MimeFilterYencDirection direction);
		public uint32 get_crc ();
		public uint32 get_pcrc ();
		public void set_crc (uint32 crc);
		public void set_state (int state);
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_mime_message_get_type ()")]
	public class MimeMessage : Camel.MimePart {
		[CCode (has_construct_function = false)]
		public MimeMessage ();
		public string build_mbox_from ();
		public void dump (int body);
		public void encode_8bit_parts ();
		[Version (since = "3.34")]
		public void foreach_part ();
		public long get_date (out int offset);
		public long get_date_received (out int offset);
		public unowned Camel.InternetAddress? get_from ();
		public unowned string? get_message_id ();
		public unowned Camel.MimePart? get_part_by_content_id (string content_id);
		public unowned Camel.InternetAddress? get_recipients (string type);
		public unowned Camel.InternetAddress? get_reply_to ();
		public unowned string? get_source ();
		public unowned string? get_subject ();
		public bool has_8bit_parts ();
		[Version (since = "2.28")]
		public bool has_attachment ();
		public void set_best_encoding (Camel.BestencRequired required, Camel.BestencEncoding enctype);
		public void set_date (long date, int offset);
		public void set_from (Camel.InternetAddress? from);
		public void set_message_id (string? message_id);
		public void set_recipients (string type, Camel.InternetAddress? recipients);
		public void set_reply_to (Camel.InternetAddress? reply_to);
		public void set_source (string? source_uid);
		public void set_subject (string? subject);
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_mime_parser_get_type ()")]
	public class MimeParser : GLib.Object {
		[CCode (has_construct_function = false)]
		public MimeParser ();
		[NoWrapper]
		public virtual void content ();
		public Camel.ContentType content_type ();
		public void drop_step ();
		[Version (since = "3.24")]
		public Camel.NameValueArray dup_headers ();
		public int errno ();
		[Version (since = "2.22")]
		public int filter_add (Camel.MimeFilter mf);
		[Version (since = "2.22")]
		public void filter_remove (int id);
		[Version (since = "2.22")]
		public unowned string from_line ();
		public unowned string header (string name, int offset);
		[Version (since = "3.12")]
		public void init_with_bytes (GLib.Bytes bytes);
		public int init_with_fd (int fd);
		[Version (since = "3.12")]
		public void init_with_input_stream (GLib.InputStream input_stream);
		public int init_with_stream (Camel.Stream stream) throws GLib.Error;
		[NoWrapper]
		public virtual void message (void* headers);
		[NoWrapper]
		public virtual void part ();
		[Version (since = "2.22")]
		public unowned string postface ();
		[Version (since = "2.22")]
		public unowned string preface ();
		public void push_state (Camel.MimeParserState newstate, string boundary);
		public ssize_t read ([CCode (array_length = false)] out uint8[] databuffer, ssize_t len) throws GLib.Error;
		public void scan_from (bool scan_from);
		public void scan_pre_from (bool scan_pre_from);
		[Version (since = "2.22")]
		public int64 seek (int64 offset, int whence);
		public int set_header_regex (string matchstr);
		public Camel.MimeParserState state ();
		public Camel.MimeParserState step ([CCode (array_length_cname = "datalength", array_length_pos = 1.1)] ref string[]? databuffer);
		public unowned Camel.Stream? stream ();
		[Version (since = "2.22")]
		public int64 tell ();
		[Version (since = "2.22")]
		public int64 tell_start_boundary ();
		[Version (since = "2.22")]
		public int64 tell_start_from ();
		[Version (since = "2.22")]
		public int64 tell_start_headers ();
		public void unstep ();
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_mime_part_get_type ()")]
	public class MimePart : Camel.Medium {
		[CCode (has_construct_function = false)]
		public MimePart ();
		[Version (since = "2.24")]
		public bool construct_content_from_parser (Camel.MimeParser mp, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.0")]
		public async bool construct_from_parser (Camel.MimeParser parser, int io_priority, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.0")]
		public virtual bool construct_from_parser_sync (Camel.MimeParser parser, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "2.30")]
		public unowned Camel.ContentDisposition get_content_disposition ();
		public unowned string get_content_id ();
		public unowned GLib.List<string> get_content_languages ();
		public unowned string get_content_location ();
		public unowned string get_content_md5 ();
		public unowned Camel.ContentType get_content_type ();
		public unowned string get_description ();
		public unowned string get_disposition ();
		public Camel.TransferEncoding get_encoding ();
		public unowned string get_filename ();
		public void set_content ([CCode (array_length_cname = "length", array_length_pos = 1.5)] string[]? data, string? type);
		public void set_content_id (string contentid);
		public void set_content_languages (GLib.List<string> content_languages);
		public void set_content_location (string location);
		public void set_content_md5 (string md5sum);
		public void set_content_type (string content_type);
		public void set_description (string description);
		public void set_disposition (string disposition);
		public void set_encoding (Camel.TransferEncoding encoding);
		public void set_filename (string filename);
		public string content_id { get; set; }
		public string content_md5 { get; set; }
		public string description { get; set; }
		public string disposition { get; set; }
	}
	[CCode (cheader_filename = "camel/camel.h", has_type_id = false)]
	[Compact]
	[Version (since = "2.24")]
	public class MsgPort {
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_multipart_get_type ()")]
	public class Multipart : Camel.DataWrapper {
		[CCode (has_construct_function = false)]
		public Multipart ();
		public virtual void add_part (Camel.MimePart part);
		public virtual int construct_from_parser (Camel.MimeParser parser);
		public virtual unowned string get_boundary ();
		public virtual uint get_number ();
		public virtual unowned Camel.MimePart get_part (uint index);
		[Version (since = "3.12")]
		public unowned string get_postface ();
		[Version (since = "3.12")]
		public unowned string get_preface ();
		public virtual void set_boundary (string? boundary);
		public void set_postface (string postface);
		public void set_preface (string preface);
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_multipart_encrypted_get_type ()")]
	public class MultipartEncrypted : Camel.Multipart {
		[CCode (has_construct_function = false)]
		public MultipartEncrypted ();
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_multipart_signed_get_type ()")]
	public class MultipartSigned : Camel.Multipart {
		[CCode (has_construct_function = false)]
		public MultipartSigned ();
		public Camel.Stream get_content_stream () throws GLib.Error;
		[Version (since = "3.12")]
		public void set_content_stream (Camel.Stream content_stream);
		[Version (since = "3.12")]
		public void set_signature (Camel.MimePart signature);
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_nntp_address_get_type ()")]
	public class NNTPAddress : Camel.Address {
		[CCode (has_construct_function = false)]
		public NNTPAddress ();
		public int add (string name);
		public bool @get (int index, string namep);
	}
	[CCode (cheader_filename = "camel/camel.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "camel_name_value_array_get_type ()")]
	[Compact]
	[Version (since = "3.24")]
	public class NameValueArray {
		[CCode (has_construct_function = false)]
		public NameValueArray ();
		public void append (string name, string value);
		public void clear ();
		public Camel.NameValueArray copy ();
		public bool equal (Camel.NameValueArray? array_b, Camel.CompareType compare_type);
		public void free ();
		public bool @get (uint index, out string? out_name, out string? out_value);
		public uint get_length ();
		public unowned string? get_name (uint index);
		public unowned string? get_named (Camel.CompareType compare_type, string name);
		public unowned string? get_value (uint index);
		public bool remove (uint index);
		public uint remove_named (Camel.CompareType compare_type, string name, bool all_occurrences);
		public bool @set (uint index, string name, string value);
		public bool set_name (uint index, string name);
		public bool set_named (Camel.CompareType compare_type, string name, string value);
		public bool set_value (uint index, string value);
		[CCode (has_construct_function = false)]
		public NameValueArray.sized (uint reserve_size);
	}
	[CCode (cheader_filename = "camel/camel.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "camel_named_flags_get_type ()")]
	[Compact]
	[Version (since = "3.24")]
	public class NamedFlags {
		[CCode (has_construct_function = false)]
		public NamedFlags ();
		public void clear ();
		public bool contains (string name);
		public Camel.NamedFlags copy ();
		public bool equal (Camel.NamedFlags? named_flags_b);
		public void free ();
		public unowned string? @get (uint index);
		public uint get_length ();
		public bool insert (string name);
		public bool remove (string name);
		[CCode (has_construct_function = false)]
		public NamedFlags.sized (uint reserve_size);
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_null_output_stream_get_type ()")]
	public class NullOutputStream : GLib.OutputStream {
		[CCode (has_construct_function = false, type = "GOutputStream*")]
		[Version (since = "3.12")]
		public NullOutputStream ();
		[Version (since = "3.12")]
		public size_t get_bytes_written ();
		[Version (since = "3.30")]
		public bool get_ends_with_crlf ();
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_object_get_type ()")]
	public abstract class Object : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Object ();
		[Version (since = "2.32")]
		public unowned string get_state_filename ();
		[Version (since = "2.32")]
		public void set_state_filename (string state_filename);
		[NoWrapper]
		public virtual int state_read ([CCode (type = "FILE*")] GLib.FileStream fp);
		[NoWrapper]
		public virtual int state_write ([CCode (type = "FILE*")] GLib.FileStream fp);
		public string state_filename { get; set construct; }
	}
	[CCode (cheader_filename = "camel/camel.h", has_type_id = false)]
	[Compact]
	public class ObjectBag {
		public void abort (void* key);
		public void add (void* key, void* object);
		public void destroy ();
		public void* @get (void* key);
		public GLib.GenericArray<GLib.Object> list ();
		public void* peek (void* key);
		public void rekey (void* object, void* new_key);
		public void remove (void* object);
		public void* reserve (void* key);
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_offline_folder_get_type ()")]
	public class OfflineFolder : Camel.Folder {
		[CCode (has_construct_function = false)]
		protected OfflineFolder ();
		[Version (since = "3.22")]
		public bool can_downsync ();
		[Version (since = "3.0")]
		public async bool downsync (string expression, int io_priority, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.0")]
		public virtual bool downsync_sync (string expression, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "2.32")]
		public Camel.ThreeState get_offline_sync ();
		[Version (since = "2.32")]
		public void set_offline_sync (Camel.ThreeState offline_sync);
		public Camel.ThreeState offline_sync { get; set; }
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_offline_settings_get_type ()")]
	[Version (since = "3.2")]
	public class OfflineSettings : Camel.StoreSettings {
		[CCode (has_construct_function = false)]
		protected OfflineSettings ();
		[Version (since = "3.24")]
		public bool get_limit_by_age ();
		[Version (since = "3.24")]
		public Camel.TimeUnit get_limit_unit ();
		[Version (since = "3.24")]
		public int get_limit_value ();
		public bool get_stay_synchronized ();
		[Version (since = "3.18")]
		public int get_store_changes_interval ();
		[Version (since = "3.24")]
		public void set_limit_by_age (bool limit_by_age);
		[Version (since = "3.24")]
		public void set_limit_unit (Camel.TimeUnit limit_unit);
		[Version (since = "3.24")]
		public void set_limit_value (bool limit_value);
		public void set_stay_synchronized (bool stay_synchronized);
		[Version (since = "3.18")]
		public void set_store_changes_interval (int interval);
		public bool limit_by_age { get; set construct; }
		public Camel.TimeUnit limit_unit { get; set construct; }
		public int limit_value { get; set construct; }
		public bool stay_synchronized { get; set construct; }
		public int store_changes_interval { get; set construct; }
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_offline_store_get_type ()")]
	public class OfflineStore : Camel.Store, GLib.Initable {
		[CCode (has_construct_function = false)]
		protected OfflineStore ();
		[Version (since = "3.28")]
		public virtual GLib.GenericArray<Camel.Folder> dup_downsync_folders ();
		[Version (since = "2.24")]
		public bool get_online ();
		[Version (since = "2.22")]
		public bool prepare_for_offline_sync (GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.12")]
		public bool requires_downsync ();
		[Version (since = "3.26")]
		public async bool set_online (bool online, int io_priority, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public bool set_online_sync (bool online, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public bool online { get; }
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_operation_get_type ()")]
	public class Operation : GLib.Cancellable {
		[CCode (has_construct_function = false, type = "GCancellable*")]
		public Operation ();
		public static void cancel_all ();
		[CCode (has_construct_function = false, type = "GCancellable*")]
		[Version (since = "3.24")]
		public Operation.proxy (GLib.Cancellable? cancellable = null);
		[PrintfFormat]
		public void push_message (string format, ...);
		[HasEmitter]
		public signal void pop_message ();
		[HasEmitter]
		public signal void progress (int percent);
		[CCode (cname = "push-message")]
		public signal void pushed_message (string object);
		public virtual signal void status (string what, int pc);
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_partition_table_get_type ()")]
	public class PartitionTable : GLib.Object {
		[CCode (has_construct_function = false)]
		public PartitionTable (Camel.BlockFile bs, Camel._block_t root);
		public int add (string key, Camel._key_t keyid);
		public Camel._key_t lookup (string key);
		public bool remove (string key);
		public int sync ();
	}
	[CCode (cheader_filename = "camel/camel.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "camel_provider_get_type ()")]
	[Compact]
	public class Provider {
		public weak GLib.List<weak Camel.ServiceAuthType> authtypes;
		public weak string description;
		public weak string domain;
		public Camel.ProviderConfEntry extra_conf;
		public Camel.ProviderFlags flags;
		public weak string name;
		[CCode (array_length = false)]
		public weak GLib.Type[] object_types;
		public Camel.ProviderPortEntry port_entries;
		public weak string protocol;
		public weak string translation_domain;
		public weak GLib.EqualFunc url_equal;
		public Camel.ProviderURLFlags url_flags;
		public weak GLib.HashFunc url_hash;
		public int auto_detect (Camel.URL url, out GLib.HashTable<string,string>? auto_detected) throws GLib.Error;
		public static Camel.Provider @get (string protocol) throws GLib.Error;
		public static void init ();
		public static GLib.List<weak Camel.Provider> list (bool load);
		public static bool load (string path) throws GLib.Error;
		public void register ();
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_sexp_get_type ()")]
	[Version (since = "3.4")]
	public class SExp : GLib.Object {
		[CCode (has_construct_function = false)]
		public SExp ();
		public void add_function (uint scope, string name, Camel.SExpFunc func);
		public void add_ifunction (uint scope, string name, Camel.SExpIFunc ifunc);
		public void add_variable (uint scope, string name, Camel.SExpTerm value);
		public static void encode_bool (GLib.StringBuilder string, bool v_bool);
		public static void encode_string (GLib.StringBuilder string, string v_string);
		public unowned string? error ();
		public unowned Camel.SExpResult? eval ();
		public bool evaluate_occur_times (long start, long end);
		public void fatal_error (string why, ...);
		public void input_file (int fd);
		public void input_text (string text, int len);
		public int parse ();
		public unowned Camel.SExpTerm? parse_value ();
		public void remove_symbol (uint scope, string name);
		public void result_free (Camel.SExpResult? result);
		public Camel.SExpResult? result_new (int type);
		public void resultv_free ([CCode (array_length_cname = "argc", array_length_pos = 0.5)] Camel.SExpResult[] argv);
		public int set_scope (uint scope);
		public Camel.SExpResult? term_eval (Camel.SExpTerm term);
		[Version (since = "2.26")]
		public static string to_sql_sexp (string sexp);
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_smime_context_get_type ()")]
	public class SMIMEContext : Camel.CipherContext {
		[CCode (has_construct_function = false, type = "CamelCipherContext*")]
		public SMIMEContext (Camel.Session session);
		public uint32 describe_part ([CCode (type = "_CamelMimePart*")] Camel.MimePart part);
		public void set_encrypt_key (bool use, string key);
		public void set_sign_mode (Camel.SMIMESign type);
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_sasl_get_type ()")]
	public abstract class Sasl : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Sasl ();
		public static Camel.ServiceAuthType authtype (string mechanism);
		public static GLib.List<weak Camel.ServiceAuthType> authtype_list (bool include_plain);
		[Version (since = "3.0")]
		public async GLib.ByteArray challenge (GLib.ByteArray token, int io_priority, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.0")]
		public async string challenge_base64 (string token, int io_priority, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.0")]
		public string challenge_base64_sync (string token, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public virtual GLib.ByteArray challenge_sync (GLib.ByteArray token, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[CCode (cname = "camel_sasl_new")]
		public static Camel.Sasl? for_service (string service_name, string mechanism, Camel.Service service);
		public bool get_authenticated ();
		[Version (since = "2.32")]
		public unowned string get_mechanism ();
		[Version (since = "2.32")]
		public unowned Camel.Service get_service ();
		[Version (since = "2.32")]
		public unowned string get_service_name ();
		[Version (since = "3.28")]
		public static bool is_xoauth2_alias (string? mechanism);
		[Version (since = "2.32")]
		public void set_authenticated (bool authenticated);
		[Version (since = "3.2")]
		public async bool try_empty_password (int io_priority, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.2")]
		public virtual bool try_empty_password_sync (GLib.Cancellable? cancellable = null) throws GLib.Error;
		public bool authenticated { get; set; }
		public string mechanism { get; construct; }
		public Camel.Service service { get; construct; }
		public string service_name { get; construct; }
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_sasl_anonymous_get_type ()")]
	public class SaslAnonymous : Camel.Sasl {
		[CCode (has_construct_function = false, type = "CamelSasl*")]
		public SaslAnonymous (Camel.SaslAnonTraceType type, string trace_info);
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_sasl_cram_md5_get_type ()")]
	public class SaslCramMd5 : Camel.Sasl {
		[CCode (has_construct_function = false)]
		protected SaslCramMd5 ();
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_sasl_digest_md5_get_type ()")]
	public class SaslDigestMd5 : Camel.Sasl {
		[CCode (has_construct_function = false)]
		protected SaslDigestMd5 ();
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_sasl_gssapi_get_type ()")]
	public class SaslGssapi : Camel.Sasl {
		[CCode (has_construct_function = false)]
		protected SaslGssapi ();
		[Version (since = "3.12")]
		public static bool is_available ();
		[Version (since = "3.12")]
		public void override_host_and_user (string? override_host, string? override_user);
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_sasl_login_get_type ()")]
	public class SaslLogin : Camel.Sasl {
		[CCode (has_construct_function = false)]
		protected SaslLogin ();
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_sasl_ntlm_get_type ()")]
	public class SaslNTLM : Camel.Sasl {
		[CCode (has_construct_function = false)]
		protected SaslNTLM ();
	}
	[CCode (cheader_filename = "camel/camel.h", lower_case_csuffix = "sasl_popb4smtp", type_id = "camel_sasl_popb4smtp_get_type ()")]
	public class SaslPOPB4SMTP : Camel.Sasl {
		[CCode (has_construct_function = false)]
		protected SaslPOPB4SMTP ();
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_sasl_plain_get_type ()")]
	public class SaslPlain : Camel.Sasl {
		[CCode (has_construct_function = false)]
		protected SaslPlain ();
	}
	[CCode (cheader_filename = "camel/camel.h", lower_case_csuffix = "sasl_xoauth2", type_id = "camel_sasl_xoauth2_get_type ()")]
	public class SaslXOAuth2 : Camel.Sasl {
		[CCode (has_construct_function = false)]
		protected SaslXOAuth2 ();
	}
	[CCode (cheader_filename = "camel/camel.h", lower_case_csuffix = "sasl_xoauth2_google", type_id = "camel_sasl_xoauth2_google_get_type ()")]
	public class SaslXOAuth2Google : Camel.SaslXOAuth2 {
		[CCode (has_construct_function = false)]
		protected SaslXOAuth2Google ();
	}
	[CCode (cheader_filename = "camel/camel.h", lower_case_csuffix = "sasl_xoauth2_outlook", type_id = "camel_sasl_xoauth2_outlook_get_type ()")]
	public class SaslXOAuth2Outlook : Camel.SaslXOAuth2 {
		[CCode (has_construct_function = false)]
		protected SaslXOAuth2Outlook ();
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_service_get_type ()")]
	public abstract class Service : Camel.Object, GLib.Initable {
		[CCode (has_construct_function = false)]
		protected Service ();
		[Version (since = "3.4")]
		public async Camel.AuthenticationResult authenticate (string? mechanism, int io_priority, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.4")]
		public virtual Camel.AuthenticationResult authenticate_sync (string? mechanism, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.6")]
		public async bool connect (int io_priority, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.6")]
		public virtual bool connect_sync (GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.6")]
		public async bool disconnect (bool clean, int io_priority, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.6")]
		public virtual bool disconnect_sync (bool clean, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.12")]
		public string dup_display_name ();
		[Version (since = "3.12")]
		public string dup_password ();
		public static GLib.Quark error_quark ();
		[Version (since = "3.2")]
		public Camel.ServiceConnectionStatus get_connection_status ();
		[Version (since = "3.2")]
		public unowned string get_display_name ();
		public virtual string get_name (bool brief);
		[Version (since = "3.4")]
		public unowned string get_password ();
		public Camel.Provider get_provider ();
		[Version (since = "3.2")]
		public unowned string get_uid ();
		[Version (since = "3.4")]
		public unowned string get_user_cache_dir ();
		[Version (since = "3.2")]
		public unowned string get_user_data_dir ();
		[Version (since = "3.4")]
		public void migrate_files ();
		[Version (since = "3.2")]
		public Camel.URL new_camel_url ();
		[Version (since = "3.2")]
		public async GLib.List<weak Camel.ServiceAuthType> query_auth_types (int io_priority, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public virtual GLib.List<weak Camel.ServiceAuthType> query_auth_types_sync (GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.12")]
		public void queue_task (GLib.Task task, [CCode (scope = "async")] GLib.TaskThreadFunc task_func);
		[Version (since = "3.12")]
		public GLib.ProxyResolver ref_proxy_resolver ();
		[Version (since = "3.8")]
		public Camel.Session ref_session ();
		[Version (since = "3.6")]
		public Camel.Settings ref_settings ();
		[Version (since = "3.2")]
		public void set_display_name (string display_name);
		[Version (since = "3.4")]
		public void set_password (string password);
		[Version (since = "3.12")]
		public void set_proxy_resolver (GLib.ProxyResolver proxy_resolver);
		[Version (since = "3.2")]
		public void set_settings (Camel.Settings settings);
		public Camel.ServiceConnectionStatus connection_status { get; }
		public string display_name { get; set construct; }
		public string password { get; set construct; }
		public Camel.Provider provider { owned get; construct; }
		[NoAccessorMethod]
		public GLib.ProxyResolver proxy_resolver { owned get; set; }
		[NoAccessorMethod]
		public Camel.Session session { owned get; construct; }
		[NoAccessorMethod]
		public Camel.Settings settings { owned get; set construct; }
		public string uid { get; construct; }
	}
	[CCode (cheader_filename = "camel/camel.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "camel_service_auth_type_get_type ()")]
	[Compact]
	public class ServiceAuthType {
		public string authproto;
		public string description;
		public string name;
		public bool need_password;
		[Version (since = "3.24")]
		public Camel.ServiceAuthType copy ();
		[Version (since = "3.24")]
		public void free ();
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_session_get_type ()")]
	public class Session : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Session ();
		[Version (since = "3.2")]
		public virtual Camel.Service add_service (string uid, string protocol, Camel.ProviderType type) throws GLib.Error;
		[Version (since = "3.4")]
		public async bool authenticate (Camel.Service service, string? mechanism, int io_priority, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.4")]
		public virtual bool authenticate_sync (Camel.Service service, string? mechanism, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public virtual bool forget_password (Camel.Service service, string item) throws GLib.Error;
		[Version (since = "3.6")]
		public async bool forward_to (Camel.Folder folder, Camel.MimeMessage message, string address, int io_priority, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.6")]
		public virtual bool forward_to_sync (Camel.Folder folder, Camel.MimeMessage message, string address, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public virtual unowned Camel.FilterDriver get_filter_driver (string type, Camel.Folder? for_folder) throws GLib.Error;
		[Version (since = "3.2")]
		public unowned Camel.JunkFilter get_junk_filter ();
		[Version (since = "2.22")]
		public unowned GLib.HashTable<string,string> get_junk_headers ();
		[Version (since = "3.28")]
		public virtual bool get_oauth2_access_token_sync (Camel.Service service, out string? out_access_token, out int out_expires_in, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public bool get_online ();
		public virtual string get_password (Camel.Service service, string prompt, string item, uint32 flags) throws GLib.Error;
		[Version (since = "3.30")]
		public virtual bool get_recipient_certificates_sync (uint32 flags, GLib.GenericArray<string> recipients, out GLib.SList<string> out_certificates, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.4")]
		public unowned string get_user_cache_dir ();
		[Version (since = "3.2")]
		public unowned string get_user_data_dir ();
		[Version (since = "3.6")]
		public uint idle_add (int priority, owned GLib.SourceFunc function);
		[Version (since = "3.2")]
		public GLib.List<Camel.Service> list_services ();
		[Version (since = "2.22")]
		public virtual bool lookup_addressbook (string name);
		[Version (since = "3.8")]
		public GLib.MainContext ref_main_context ();
		[Version (since = "3.22")]
		public GLib.NetworkMonitor ref_network_monitor ();
		[Version (since = "3.6")]
		public Camel.Service ref_service (string uid);
		[Version (since = "3.6")]
		public Camel.Service ref_service_by_url (Camel.URL url, Camel.ProviderType type);
		[Version (since = "3.2")]
		public virtual void remove_service (Camel.Service service);
		[Version (since = "3.2")]
		public void remove_services ();
		[Version (since = "3.2")]
		public void set_junk_filter (Camel.JunkFilter junk_filter);
		[Version (since = "2.22")]
		public void set_junk_headers ([CCode (array_length_cname = "len", array_length_pos = 2.1)] string[] headers, [CCode (array_length = false)] string[] values);
		[Version (since = "3.22")]
		public void set_network_monitor (GLib.NetworkMonitor? network_monitor);
		public void set_online (bool online);
		[Version (since = "3.2")]
		public void submit_job (string description, owned Camel.SessionCallback callback);
		[Version (since = "3.8")]
		public virtual Camel.CertTrust trust_prompt (Camel.Service service, GLib.TlsCertificate certificate, GLib.TlsCertificateFlags errors);
		public Camel.JunkFilter junk_filter { get; set; }
		[NoAccessorMethod]
		public GLib.MainContext main_context { owned get; }
		[NoAccessorMethod]
		public GLib.NetworkMonitor network_monitor { owned get; set; }
		public bool online { get; set construct; }
		[NoAccessorMethod]
		public string user_cache_dir { owned get; set construct; }
		[NoAccessorMethod]
		public string user_data_dir { owned get; set construct; }
		public virtual signal void job_finished (GLib.Cancellable? cancellable, GLib.Error error);
		public virtual signal void job_started (GLib.Cancellable? cancellable = null);
		[HasEmitter]
		public virtual signal void user_alert (Camel.Service service, Camel.SessionAlertType type, string message);
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_settings_get_type ()")]
	[Version (since = "3.2")]
	public class Settings : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Settings ();
		public virtual Camel.Settings clone ();
		public virtual bool equal (Camel.Settings settings_b);
		[CCode (cname = "camel_settings_class_list_settings")]
		public class GLib.ParamSpec list_settings (uint n_settings);
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_store_get_type ()")]
	public abstract class Store : Camel.Service, GLib.Initable {
		[CCode (has_construct_function = false)]
		protected Store ();
		[Version (since = "2.22")]
		public virtual bool can_refresh_folder (Camel.FolderInfo info) throws GLib.Error;
		[Version (since = "3.0")]
		public async Camel.FolderInfo? create_folder (string? parent_name, string folder_name, int io_priority, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.0")]
		public virtual Camel.FolderInfo? create_folder_sync (string? parent_name, string folder_name, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.24")]
		public void delete_cached_folder (string folder_name);
		[Version (since = "3.0")]
		public async bool delete_folder (string folder_name, int io_priority, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.0")]
		public virtual bool delete_folder_sync (string folder_name, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.24")]
		public GLib.GenericArray<Camel.Folder> dup_opened_folders ();
		public static GLib.Quark error_quark ();
		[Version (since = "3.24")]
		public unowned Camel.DB get_db ();
		[Version (since = "3.24")]
		public uint32 get_flags ();
		[Version (since = "3.0")]
		public async Camel.Folder? get_folder (string folder_name, Camel.StoreGetFolderFlags flags, int io_priority, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.0")]
		public async Camel.FolderInfo? get_folder_info (string? top, Camel.StoreGetFolderInfoFlags flags, int io_priority, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.0")]
		public virtual Camel.FolderInfo? get_folder_info_sync (string? top, Camel.StoreGetFolderInfoFlags flags, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.0")]
		public virtual Camel.Folder? get_folder_sync (string folder_name, Camel.StoreGetFolderFlags flags, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.24")]
		public unowned Camel.ObjectBag get_folders_bag ();
		[Version (since = "3.0")]
		public async Camel.Folder? get_inbox_folder (int io_priority, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.0")]
		public virtual Camel.Folder? get_inbox_folder_sync (GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.0")]
		public async Camel.Folder? get_junk_folder (int io_priority, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.0")]
		public virtual Camel.Folder? get_junk_folder_sync (GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.24")]
		public uint32 get_permissions ();
		[Version (since = "3.0")]
		public async Camel.Folder? get_trash_folder (int io_priority, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.0")]
		public virtual Camel.Folder? get_trash_folder_sync (GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.20")]
		public async bool initial_setup (int io_priority, GLib.Cancellable? cancellable = null, out GLib.HashTable<weak string,weak string> out_save_setup) throws GLib.Error;
		[Version (since = "3.20")]
		public virtual bool initial_setup_sync (out GLib.HashTable<weak string,weak string> out_save_setup, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.16")]
		public bool maybe_run_db_maintenance () throws GLib.Error;
		[Version (since = "3.0")]
		public async bool rename_folder (string old_name, string new_name, int io_priority, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.0")]
		public virtual bool rename_folder_sync (string old_name, string new_name, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.24")]
		public void set_flags (uint32 flags);
		[Version (since = "3.24")]
		public void set_permissions (uint32 permissions);
		[Version (since = "3.0")]
		public async bool synchronize (bool expunge, int io_priority, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.0")]
		public virtual bool synchronize_sync (bool expunge, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[HasEmitter]
		public virtual signal void folder_created (Camel.FolderInfo folder_info);
		[HasEmitter]
		public virtual signal void folder_deleted (Camel.FolderInfo folder_info);
		[HasEmitter]
		public virtual signal void folder_info_stale ();
		[HasEmitter]
		public virtual signal void folder_opened (Camel.Folder folder);
		[HasEmitter]
		public virtual signal void folder_renamed (string old_name, Camel.FolderInfo folder_info);
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_store_settings_get_type ()")]
	[Version (since = "3.2")]
	public class StoreSettings : Camel.Settings {
		[CCode (has_construct_function = false)]
		protected StoreSettings ();
		public bool get_filter_inbox ();
		public void set_filter_inbox (bool filter_inbox);
		public bool filter_inbox { get; set construct; }
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_store_summary_get_type ()")]
	public class StoreSummary : GLib.Object {
		[CCode (has_construct_function = false)]
		public StoreSummary ();
		public void add (Camel.StoreInfo info);
		public unowned Camel.StoreInfo? add_from_path (string path);
		public GLib.GenericArray<Camel.StoreInfo?> array ();
		public void array_free (GLib.GenericArray<Camel.StoreInfo?> array);
		[Version (since = "3.4")]
		public bool connect_folder_summary (string path, Camel.FolderSummary folder_summary);
		public int count ();
		[Version (since = "3.4")]
		public bool disconnect_folder_summary (Camel.FolderSummary folder_summary);
		public unowned Camel.StoreInfo? info_new ();
		public Camel.StoreInfo? info_ref (Camel.StoreInfo info);
		public void info_unref (Camel.StoreInfo info);
		public int load ();
		public unowned Camel.StoreInfo? path (string path);
		public void remove (Camel.StoreInfo info);
		public void remove_path (string path);
		public int save ();
		public void set_filename (string filename);
		[Version (since = "3.24")]
		public void sort (GLib.CompareDataFunc compare_func);
		[NoWrapper]
		public virtual void store_info_free (Camel.StoreInfo info);
		[NoWrapper]
		public virtual unowned Camel.StoreInfo? store_info_load ([CCode (type = "FILE*")] GLib.FileStream file);
		[NoWrapper]
		public virtual unowned Camel.StoreInfo? store_info_new (string path);
		[NoWrapper]
		public virtual int store_info_save ([CCode (type = "FILE*")] GLib.FileStream file, Camel.StoreInfo info);
		[NoWrapper]
		public virtual void store_info_set_string (Camel.StoreInfo info, int type, string value);
		[NoWrapper]
		public virtual int summary_header_load ([CCode (type = "FILE*")] GLib.FileStream file);
		[NoWrapper]
		public virtual int summary_header_save ([CCode (type = "FILE*")] GLib.FileStream file);
		public void touch ();
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_stream_get_type ()")]
	public class Stream : GLib.Object, GLib.Seekable {
		[CCode (has_construct_function = false)]
		[Version (since = "3.12")]
		public Stream (GLib.IOStream base_stream);
		public virtual int close (GLib.Cancellable? cancellable = null) throws GLib.Error;
		public virtual bool eos ();
		public virtual int flush (GLib.Cancellable? cancellable = null) throws GLib.Error;
		public virtual ssize_t read ([CCode (array_length_cname = "n", array_length_pos = 1.5, array_length_type = "gsize")] char[] buffer, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.12")]
		public GLib.IOStream? ref_base_stream ();
		[Version (since = "3.12")]
		public void set_base_stream (GLib.IOStream base_stream);
		public virtual ssize_t write ([CCode (array_length_cname = "n", array_length_pos = 1.5, array_length_type = "gsize")] char[] buffer, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public ssize_t write_string (string string, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public ssize_t write_to_stream (Camel.Stream output_stream, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[NoAccessorMethod]
		public GLib.IOStream base_stream { owned get; set; }
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_stream_buffer_get_type ()")]
	public class StreamBuffer : Camel.Stream, GLib.Seekable {
		[CCode (has_construct_function = false, type = "CamelStream*")]
		public StreamBuffer (Camel.Stream stream, Camel.StreamBufferMode mode);
		[Version (since = "3.38")]
		public void discard_cache ();
		public int gets ([CCode (array_length_cname = "max", array_length_pos = 1.5, array_length_type = "guint")] char[] buf, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[NoWrapper]
		public virtual void init (Camel.Stream stream, Camel.StreamBufferMode mode);
		[NoWrapper]
		public virtual void init_vbuf (Camel.Stream stream, Camel.StreamBufferMode mode, string buf, uint32 size);
		public string? read_line (GLib.Cancellable? cancellable = null) throws GLib.Error;
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_stream_filter_get_type ()")]
	public class StreamFilter : Camel.Stream, GLib.Seekable {
		[CCode (has_construct_function = false, type = "CamelStream*")]
		[Version (since = "2.32")]
		public StreamFilter (Camel.Stream source);
		public int add (Camel.MimeFilter filter);
		[Version (since = "2.32")]
		public unowned Camel.Stream get_source ();
		public void remove (int id);
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_stream_fs_get_type ()")]
	public class StreamFs : Camel.Stream, GLib.Seekable {
		[CCode (has_construct_function = false)]
		protected StreamFs ();
		[Version (since = "2.32")]
		public int get_fd ();
		[CCode (has_construct_function = false, type = "CamelStream*")]
		public StreamFs.with_fd (int fd);
		[CCode (has_construct_function = false, type = "CamelStream*")]
		public StreamFs.with_name (string name, int flags, uint32 mode) throws GLib.Error;
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_stream_mem_get_type ()")]
	public class StreamMem : Camel.Stream, GLib.Seekable {
		[CCode (has_construct_function = false, type = "CamelStream*")]
		public StreamMem ();
		[Version (since = "2.32")]
		public unowned GLib.ByteArray get_byte_array ();
		public void set_buffer ([CCode (array_length_cname = "len", array_length_pos = 1.1, array_length_type = "gsize")] uint8[] buffer);
		public void set_byte_array (owned GLib.ByteArray buffer);
		public void set_secure ();
		[CCode (has_construct_function = false, type = "CamelStream*")]
		public StreamMem.with_buffer ([CCode (array_length_cname = "len", array_length_pos = 1.1, array_length_type = "gsize")] uint8[] buffer);
		[CCode (has_construct_function = false, type = "CamelStream*")]
		public StreamMem.with_byte_array (owned GLib.ByteArray buffer);
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_stream_null_get_type ()")]
	public class StreamNull : Camel.Stream, GLib.Seekable {
		[CCode (has_construct_function = false, type = "CamelStream*")]
		public StreamNull ();
		[Version (since = "3.24")]
		public size_t get_bytes_written ();
		[Version (since = "3.30")]
		public bool get_ends_with_crlf ();
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_stream_process_get_type ()")]
	public class StreamProcess : Camel.Stream, GLib.Seekable {
		[CCode (has_construct_function = false, type = "CamelStream*")]
		public StreamProcess ();
		public int connect (string command, string env) throws GLib.Error;
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_text_index_get_type ()")]
	public class TextIndex : Camel.Index {
		[CCode (has_construct_function = false)]
		public TextIndex (string path, int flags);
		public static int check (string path);
		public void dump ();
		public void info ();
		public static int remove (string old);
		public static int rename (string old, string new_);
		public void validate ();
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_text_index_cursor_get_type ()")]
	public class TextIndexCursor : Camel.IndexCursor {
		[CCode (has_construct_function = false)]
		protected TextIndexCursor ();
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_text_index_key_cursor_get_type ()")]
	public class TextIndexKeyCursor : Camel.IndexCursor {
		[CCode (has_construct_function = false)]
		protected TextIndexKeyCursor ();
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_text_index_name_get_type ()")]
	public class TextIndexName : Camel.IndexName {
		[CCode (has_construct_function = false)]
		protected TextIndexName ();
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_transport_get_type ()")]
	public abstract class Transport : Camel.Service, GLib.Initable {
		[CCode (has_construct_function = false)]
		protected Transport ();
		[Version (since = "3.0")]
		public async bool send_to (Camel.MimeMessage message, Camel.Address from, Camel.Address recipients, int io_priority, GLib.Cancellable? cancellable = null, out bool out_sent_message_saved) throws GLib.Error;
		[Version (since = "3.0")]
		public virtual bool send_to_sync (Camel.MimeMessage message, Camel.Address from, Camel.Address recipients, out bool out_sent_message_saved, GLib.Cancellable? cancellable = null) throws GLib.Error;
	}
	[CCode (cheader_filename = "camel/camel.h", has_type_id = false)]
	[Compact]
	[Version (since = "2.24")]
	public class Trie {
		public void add (string pattern, int pattern_id);
		public unowned string? search ([CCode (array_length_cname = "buflen", array_length_pos = 1.5, array_length_type = "gsize")] char[] buffer, out int matched_id);
	}
	[CCode (cheader_filename = "camel/camel.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "camel_url_get_type ()")]
	[Compact]
	public class URL {
		public weak string authmech;
		public weak string fragment;
		public weak string host;
		public GLib.Datalist @params;
		public weak string path;
		public int port;
		public weak string protocol;
		public weak string query;
		public weak string user;
		[CCode (has_construct_function = false)]
		public URL (string url_string) throws GLib.Error;
		public static bool addrspec_end (string @in, string pos, string inend, Camel.UrlMatch match);
		public static bool addrspec_start (string @in, string pos, string inend, Camel.UrlMatch match);
		public Camel.URL copy ();
		public static void decode (string part);
		public static string decode_path (string path);
		public static string encode (string part, string escape_extra);
		public bool equal (Camel.URL u2);
		public static bool file_end (string @in, string pos, string inend, Camel.UrlMatch match);
		public static bool file_start (string @in, string pos, string inend, Camel.UrlMatch match);
		public void free ();
		public unowned string get_param (string name);
		public uint hash ();
		public Camel.URL new_with_base (string url_string);
		public void set_authmech (string authmech);
		public void set_fragment (string fragment);
		public void set_host (string host);
		public void set_param (string name, string value);
		public void set_path (string path);
		public void set_port (int port);
		public void set_protocol (string protocol);
		public void set_query (string query);
		public void set_user (string user);
		public string to_string (Camel.URLFlags flags);
		public static bool web_end (string @in, string pos, string inend, Camel.UrlMatch match);
		public static bool web_start (string @in, string pos, string inend, Camel.UrlMatch match);
	}
	[CCode (cheader_filename = "camel/camel.h", has_type_id = false)]
	[Compact]
	public class UrlScanner {
		public void add (Camel.UrlPattern pattern);
		public bool scan ([CCode (array_length_cname = "inlen", array_length_pos = 1.5, array_length_type = "gsize")] char[] @in, Camel.UrlMatch match);
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_vtrash_folder_get_type ()")]
	public class VTrashFolder : Camel.VeeFolder {
		[CCode (has_construct_function = false, type = "CamelFolder*")]
		public VTrashFolder (Camel.Store parent_store, Camel.VTrashFolderType type);
		[Version (since = "3.24")]
		public Camel.VTrashFolderType get_folder_type ();
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_vee_data_cache_get_type ()")]
	[Version (since = "3.6")]
	public class VeeDataCache : GLib.Object {
		[CCode (has_construct_function = false)]
		public VeeDataCache ();
		public void add_subfolder (Camel.Folder subfolder);
		public bool contains_message_info_data (Camel.Folder folder, string orig_message_uid);
		public void foreach_message_info_data (Camel.Folder fromfolder, Camel.ForeachInfoData func);
		public Camel.VeeMessageInfoData get_message_info_data (Camel.Folder folder, string orig_message_uid);
		public Camel.VeeMessageInfoData? get_message_info_data_by_vuid (string vee_message_uid);
		public Camel.VeeSubfolderData get_subfolder_data (Camel.Folder folder);
		public void remove_message_info_data (Camel.VeeMessageInfoData mi_data);
		public void remove_subfolder (Camel.Folder subfolder);
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_vee_folder_get_type ()")]
	public class VeeFolder : Camel.Folder {
		[CCode (has_construct_function = false, type = "CamelFolder*")]
		public VeeFolder (Camel.Store parent_store, string full, uint32 flags);
		public virtual void add_folder (Camel.Folder subfolder, GLib.Cancellable? cancellable = null);
		[Version (since = "3.6")]
		public void add_vuid ([CCode (type = "_CamelVeeMessageInfoData*")] Camel.VeeMessageInfoData mi_data, Camel.FolderChangeInfo? changes);
		public void @construct (uint32 flags);
		[NoWrapper]
		public virtual void folder_changed (Camel.Folder subfolder, Camel.FolderChangeInfo changes);
		[Version (since = "3.6")]
		public bool get_auto_update ();
		[Version (since = "3.6")]
		public unowned string get_expression ();
		[Version (since = "3.24")]
		public uint32 get_flags ();
		public unowned Camel.Folder get_location (Camel.VeeMessageInfo vinfo, out string? realuid);
		[Version (since = "3.6")]
		public unowned Camel.Folder? get_vee_uid_folder (string vee_message_uid);
		[Version (since = "3.2")]
		public void ignore_next_changed_event (Camel.Folder subfolder);
		[Version (since = "3.38")]
		public void propagate_skipped_changes ();
		public virtual void rebuild_folder (Camel.Folder subfolder, GLib.Cancellable? cancellable = null);
		[Version (since = "3.28")]
		public GLib.List<Camel.Folder> ref_folders ();
		public virtual void remove_folder (Camel.Folder subfolder, GLib.Cancellable? cancellable = null);
		[Version (since = "3.12")]
		public void remove_from_ignore_changed_event (Camel.Folder subfolder);
		[Version (since = "3.6")]
		public void remove_vuid ([CCode (type = "_CamelVeeMessageInfoData*")] Camel.VeeMessageInfoData mi_data, Camel.FolderChangeInfo? changes);
		[Version (since = "3.6")]
		public void set_auto_update (bool auto_update);
		[Version (since = "3.6")]
		public virtual void set_expression (string expression);
		public void set_folders (GLib.List<Camel.Folder> folders, GLib.Cancellable? cancellable = null);
		public bool auto_update { get; set; }
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_vee_message_info_get_type ()")]
	public class VeeMessageInfo : Camel.MessageInfo {
		[CCode (has_construct_function = false, type = "CamelMessageInfo*")]
		[Version (since = "3.24")]
		public VeeMessageInfo (Camel.FolderSummary summary, Camel.FolderSummary original_summary, string vuid);
		[Version (since = "3.24")]
		public unowned Camel.Folder get_original_folder ();
		[Version (since = "3.24")]
		public unowned Camel.FolderSummary get_original_summary ();
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_vee_message_info_data_get_type ()")]
	[Version (since = "3.6")]
	public class VeeMessageInfoData : GLib.Object {
		[CCode (has_construct_function = false)]
		public VeeMessageInfoData (Camel.VeeSubfolderData subfolder_data, string orig_message_uid);
		public unowned string get_orig_message_uid ();
		public unowned Camel.VeeSubfolderData get_subfolder_data ();
		public unowned string get_vee_message_uid ();
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_vee_store_get_type ()")]
	public class VeeStore : Camel.Store, GLib.Initable {
		[CCode (has_construct_function = false)]
		public VeeStore ();
		[Version (since = "3.6")]
		public bool get_unmatched_enabled ();
		[Version (since = "3.6")]
		public unowned Camel.VeeFolder get_unmatched_folder ();
		[Version (since = "3.6")]
		public unowned Camel.VeeFolder get_vee_data_cache ();
		[Version (since = "3.6")]
		public void note_subfolder_unused (Camel.Folder subfolder, Camel.VeeFolder unused_by);
		[Version (since = "3.6")]
		public void note_subfolder_used (Camel.Folder subfolder, Camel.VeeFolder used_by);
		[Version (since = "3.6")]
		public void note_vuid_unused (Camel.VeeMessageInfoData mi_data, Camel.VeeFolder unused_by);
		[Version (since = "3.6")]
		public void note_vuid_used (Camel.VeeMessageInfoData mi_data, Camel.VeeFolder used_by);
		[Version (since = "3.6")]
		public void rebuild_unmatched_folder (GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.6")]
		public void set_unmatched_enabled (bool is_enabled);
		public bool unmatched_enabled { get; set; }
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_vee_subfolder_data_get_type ()")]
	[Version (since = "3.6")]
	public class VeeSubfolderData : GLib.Object {
		[CCode (has_construct_function = false)]
		public VeeSubfolderData (Camel.Folder folder);
		public unowned Camel.Folder get_folder ();
		public unowned string get_folder_id ();
	}
	[CCode (cheader_filename = "camel/camel.h", type_id = "camel_vee_summary_get_type ()")]
	public class VeeSummary : Camel.FolderSummary {
		[CCode (has_construct_function = false, type = "CamelFolderSummary*")]
		public VeeSummary (Camel.Folder parent);
		public Camel.VeeMessageInfo add (Camel.VeeMessageInfoData mi_data);
		[Version (since = "3.6")]
		public GLib.HashTable<weak string,int> get_uids_for_subfolder (Camel.Folder subfolder);
		[Version (since = "3.6")]
		public void remove (string vuid, Camel.Folder subfolder);
		[Version (since = "3.6")]
		public void replace_flags (string uid);
	}
	[CCode (cheader_filename = "camel/camel.h", ref_function = "camel_weak_ref_group_ref", type_id = "camel_weak_ref_group_get_type ()", unref_function = "camel_weak_ref_group_unref")]
	[Compact]
	public class WeakRefGroup {
		[CCode (has_construct_function = false)]
		[Version (since = "3.24")]
		public WeakRefGroup ();
		[Version (since = "3.24")]
		public GLib.Object @get ();
		[Version (since = "3.24")]
		public Camel.WeakRefGroup @ref ();
		[Version (since = "3.24")]
		public void @set ([CCode (type = "gpointer")] owned GLib.Object object);
		[Version (since = "3.24")]
		public void unref ();
	}
	[CCode (cheader_filename = "camel/camel.h", type_cname = "CamelJunkFilterInterface", type_id = "camel_junk_filter_get_type ()")]
	[Version (since = "3.2")]
	public interface JunkFilter : GLib.Object {
		public abstract Camel.JunkStatus classify (Camel.MimeMessage message, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public abstract bool learn_junk (Camel.MimeMessage message, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public abstract bool learn_not_junk (Camel.MimeMessage message, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public abstract bool synchronize (GLib.Cancellable? cancellable = null) throws GLib.Error;
	}
	[CCode (cheader_filename = "camel/camel.h", type_cname = "CamelNetworkServiceInterface", type_id = "camel_network_service_get_type ()")]
	[Version (since = "3.2")]
	public interface NetworkService : Camel.Service {
		[Version (since = "3.12")]
		public async bool can_reach (GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.12")]
		public bool can_reach_sync (GLib.Cancellable? cancellable = null) throws GLib.Error;
		public abstract GLib.IOStream connect_sync (GLib.Cancellable? cancellable = null) throws GLib.Error;
		public abstract uint16 get_default_port (Camel.NetworkSecurityMethod method);
		[Version (since = "3.8")]
		public bool get_host_reachable ();
		public abstract unowned string get_service_name (Camel.NetworkSecurityMethod method);
		[NoWrapper]
		public abstract unowned GLib.SocketConnectable new_connectable ();
		[Version (since = "3.8")]
		public GLib.SocketConnectable ref_connectable ();
		[Version (since = "3.8")]
		public void set_connectable (GLib.SocketConnectable connectable);
		[Version (since = "3.12")]
		public GLib.IOStream starttls (GLib.IOStream base_stream) throws GLib.Error;
		[NoAccessorMethod]
		public abstract GLib.SocketConnectable connectable { owned get; set; }
		[ConcreteAccessor]
		public abstract bool host_reachable { get; }
	}
	[CCode (cheader_filename = "camel/camel.h", type_cname = "CamelNetworkSettingsInterface", type_id = "camel_network_settings_get_type ()")]
	[Version (since = "3.2")]
	public interface NetworkSettings : Camel.Settings {
		[Version (since = "3.4")]
		public string dup_auth_mechanism ();
		[Version (since = "3.4")]
		public string dup_host ();
		[Version (since = "3.16")]
		public string dup_host_ensure_ascii ();
		[Version (since = "3.4")]
		public string dup_user ();
		[Version (since = "3.4")]
		public unowned string get_auth_mechanism ();
		[Version (since = "3.4")]
		public unowned string get_host ();
		[Version (since = "3.4")]
		public uint16 get_port ();
		public Camel.NetworkSecurityMethod get_security_method ();
		[Version (since = "3.4")]
		public unowned string get_user ();
		[Version (since = "3.4")]
		public void set_auth_mechanism (string auth_mechanism);
		[Version (since = "3.4")]
		public void set_host (string host);
		[Version (since = "3.4")]
		public void set_port (uint16 port);
		public void set_security_method (Camel.NetworkSecurityMethod method);
		[Version (since = "3.4")]
		public void set_user (string user);
		[ConcreteAccessor]
		public abstract string auth_mechanism { get; set construct; }
		[ConcreteAccessor]
		public abstract string host { get; set construct; }
		[ConcreteAccessor]
		public abstract uint port { get; set construct; }
		[ConcreteAccessor]
		public abstract Camel.NetworkSecurityMethod security_method { get; set construct; }
		[ConcreteAccessor]
		public abstract string user { get; set construct; }
	}
	[CCode (cheader_filename = "camel/camel.h", type_cname = "CamelSubscribableInterface", type_id = "camel_subscribable_get_type ()")]
	[Version (since = "3.2")]
	public interface Subscribable : Camel.Store {
		public abstract bool folder_is_subscribed (string folder_name);
		public async bool subscribe_folder (string folder_name, int io_priority, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public abstract bool subscribe_folder_sync (string folder_name, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public async bool unsubscribe_folder (string folder_name, int io_priority, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public abstract bool unsubscribe_folder_sync (string folder_name, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[HasEmitter]
		public virtual signal void folder_subscribed (Camel.FolderInfo folder_info);
		[HasEmitter]
		public virtual signal void folder_unsubscribed (Camel.FolderInfo folder_info);
	}
	[CCode (cheader_filename = "camel/camel.h", has_type_id = false)]
	public struct Block {
		public Camel._block_t id;
		public Camel.BlockFlags flags;
		public uint32 refcount;
		public uint32 align00;
		[CCode (array_length = false)]
		public weak uint8 data[1024];
	}
	[CCode (cheader_filename = "camel/camel.h", has_type_id = false)]
	public struct BlockRoot {
		[CCode (array_length = false)]
		public weak char version[8];
		public uint32 flags;
		public uint32 block_size;
		public Camel._block_t free;
		public Camel._block_t last;
	}
	[CCode (cheader_filename = "camel/camel.h", has_type_id = false)]
	public struct Charset {
		public uint mask;
		public int level;
		public static unowned string? best ([CCode (array_length_cname = "len", array_length_pos = 1.1)] char[] @in);
		public unowned string best_name ();
		public void init ();
		public static unowned string iso_to_windows (string isocharset);
		public void step ([CCode (array_length_cname = "len", array_length_pos = 1.1)] char[] @in);
	}
	[CCode (cheader_filename = "camel/camel.h", has_type_id = false)]
	public struct CipherCertInfo {
		public weak string name;
		public weak string email;
		public void* cert_data;
		public weak GLib.DestroyNotify cert_data_free;
		public weak Camel.CipherCloneFunc cert_data_clone;
		public weak GLib.SList<Camel.CipherCertInfoProperty> properties;
		[CCode (cname = "camel_cipher_certinfo_get_property")]
		[Version (since = "3.22")]
		public void* get_property (string name);
		[CCode (cname = "camel_cipher_certinfo_set_property")]
		[Version (since = "3.22")]
		public void set_property (string name, [CCode (destroy_notify_pos = 2.5)] owned void* value, Camel.CipherCloneFunc? value_clone);
	}
	[CCode (cheader_filename = "camel/camel.h", has_type_id = false)]
	public struct CipherCertInfoProperty {
		public weak string name;
		public void* value;
		public weak GLib.DestroyNotify value_free;
		public weak Camel.CipherCloneFunc value_clone;
	}
	[CCode (cheader_filename = "camel/camel.h", has_type_id = false)]
	[Version (since = "2.24")]
	public struct FIRecord {
		public weak string folder_name;
		public uint32 version;
		public uint32 flags;
		public uint32 nextuid;
		public int64 timestamp;
		public uint32 saved_count;
		public uint32 unread_count;
		public uint32 deleted_count;
		public uint32 junk_count;
		public uint32 visible_count;
		public uint32 jnd_count;
		public weak string bdata;
	}
	[CCode (cheader_filename = "camel/camel.h", has_type_id = false)]
	public struct FolderThreadNode {
		public weak Camel.FolderThreadNode? next;
		public weak Camel.FolderThreadNode? parent;
		public weak Camel.FolderThreadNode? child;
		public weak Camel.MessageInfo message;
		public weak string root_subject;
		public uint32 order;
		public uint32 re;
		[CCode (cname = "camel_folder_threaded_messages_dump")]
		public int dump ();
	}
	[CCode (cheader_filename = "camel/camel.h", has_type_id = false)]
	public struct KeyBlock {
		public Camel._block_t next;
		public uint32 used;
		[CCode (array_length = false, cname = "u.keys")]
		public weak void*[] u_keys;
		[CCode (array_length = false, cname = "u.keydata")]
		public weak char u_keydata[1016];
	}
	[CCode (cheader_filename = "camel/camel.h", has_type_id = false)]
	public struct KeyRootBlock {
		public Camel._block_t first;
		public Camel._block_t last;
		public Camel._key_t free;
	}
	[CCode (cheader_filename = "camel/camel.h", has_type_id = false)]
	[Version (since = "2.24")]
	public struct MIRecord {
		public weak string uid;
		public uint32 flags;
		public uint32 msg_type;
		public uint32 dirty;
		public bool read;
		public bool deleted;
		public bool replied;
		public bool important;
		public bool junk;
		public bool attachment;
		public uint32 size;
		public int64 dsent;
		public int64 dreceived;
		public weak string subject;
		public weak string from;
		public weak string to;
		public weak string cc;
		public weak string mlist;
		public weak string followup_flag;
		public weak string followup_completed_on;
		public weak string followup_due_by;
		public weak string part;
		public weak string labels;
		public weak string usertags;
		public weak string cinfo;
		public weak string bdata;
	}
	[CCode (cheader_filename = "camel/camel.h", has_type_id = false)]
	[Version (since = "2.24")]
	public struct Msg {
		public weak Camel.MsgPort reply_port;
	}
	[CCode (cheader_filename = "camel/camel.h", has_type_id = false)]
	public struct PartitionKey {
		public Camel._hash_t hashid;
		public Camel._key_t keyid;
	}
	[CCode (cheader_filename = "camel/camel.h", has_type_id = false)]
	public struct PartitionKeyBlock {
		public uint32 used;
		[CCode (array_length = false)]
		public weak void*[] keys;
	}
	[CCode (cheader_filename = "camel/camel.h", has_type_id = false)]
	public struct PartitionMap {
		public Camel._hash_t hashid;
		public Camel._block_t blockid;
	}
	[CCode (cheader_filename = "camel/camel.h", has_type_id = false)]
	public struct PartitionMapBlock {
		public Camel._block_t next;
		public uint32 used;
		[CCode (array_length = false)]
		public weak void*[] partition;
	}
	[CCode (cheader_filename = "camel/camel.h", has_type_id = false)]
	public struct ProviderConfEntry {
		public Camel.ProviderConfType type;
		public weak string name;
		public weak string depname;
		public weak string text;
		public weak string value;
	}
	[CCode (cheader_filename = "camel/camel.h", has_type_id = false)]
	public struct ProviderModule {
		public weak string path;
		public weak GLib.SList<void*> types;
		public uint loaded;
		public static void init ();
	}
	[CCode (cheader_filename = "camel/camel.h", has_type_id = false)]
	[Version (since = "3.2")]
	public struct ProviderPortEntry {
		public int port;
		public weak string desc;
		public bool is_ssl;
	}
	[CCode (cheader_filename = "camel/camel.h", has_type_id = false)]
	[Version (since = "3.4")]
	public struct SExpResult {
		public Camel.SExpResultType type;
		public bool time_generator;
		public long occuring_start;
		public long occuring_end;
		[CCode (cname = "value.ptrarray")]
		public weak GLib.GenericArray<void*> value_ptrarray;
		[CCode (cname = "value.number")]
		public int value_number;
		[CCode (cname = "value.string")]
		public weak string value_string;
		[CCode (cname = "value.boolean")]
		public int value_boolean;
		[CCode (cname = "value.time")]
		public long value_time;
	}
	[CCode (cheader_filename = "camel/camel.h", has_type_id = false)]
	[Version (since = "3.4")]
	public struct SExpSymbol {
		public int type;
		public weak string name;
		public void* data;
	}
	[CCode (cheader_filename = "camel/camel.h", has_type_id = false)]
	[Version (since = "3.4")]
	public struct SExpTerm {
		public Camel.SExpTermType type;
		[CCode (cname = "value.string")]
		public weak string value_string;
		[CCode (cname = "value.number")]
		public int value_number;
		[CCode (cname = "value.boolean")]
		public int value_boolean;
		[CCode (cname = "value.time")]
		public long value_time;
		[CCode (cname = "value.var")]
		public Camel.SExpSymbol value_var;
		[CCode (cname = "value.func.sym")]
		public Camel.SExpSymbol value_func_sym;
		[CCode (array_length = false, cname = "value.func.terms")]
		public Camel.SExpTerm[] value_func_terms;
		[CCode (cname = "value.func.termcount")]
		public int value_func_termcount;
	}
	[CCode (cheader_filename = "camel/camel.h", has_type_id = false)]
	public struct StoreInfo {
		public int refcount;
		public weak string path;
		public uint32 flags;
		public uint32 unread;
		public uint32 total;
		public static unowned string name (Camel.StoreSummary summary, Camel.StoreInfo info);
		public static void set_string (Camel.StoreSummary summary, Camel.StoreInfo info, int type, string value);
	}
	[CCode (cheader_filename = "camel/camel.h", has_type_id = false)]
	public struct SummaryMessageID {
		[CCode (cname = "id.id")]
		public uint64 id_id;
		[CCode (array_length = false, cname = "id.hash")]
		public weak uint8 id_hash[8];
		[CCode (cname = "id.part.hi")]
		public uint32 id_part_hi;
		[CCode (cname = "id.part.lo")]
		public uint32 id_part_lo;
	}
	[CCode (cheader_filename = "camel/camel.h", has_type_id = false)]
	public struct UIDCache {
		public weak string filename;
		public weak GLib.HashTable<void*,void*> uids;
		public uint level;
		public size_t expired;
		public size_t size;
		public int fd;
		public void destroy ();
		public static void free_uids (owned GLib.GenericArray<string> uids);
		public GLib.GenericArray<string> get_new_uids (GLib.GenericArray<string> uids);
		public bool save ();
		public void save_uid (string uid);
	}
	[CCode (cheader_filename = "camel/camel.h", has_type_id = false)]
	public struct UrlMatch {
		public weak string pattern;
		public weak string prefix;
		public int64 um_so;
		public int64 um_eo;
	}
	[CCode (cheader_filename = "camel/camel.h", has_type_id = false)]
	public struct UrlPattern {
		public weak string pattern;
		public weak string prefix;
		public weak Camel.UrlScanFunc start;
		public weak Camel.UrlScanFunc end;
	}
	[CCode (cheader_filename = "camel/camel.h", cname = "_CamelKeyKey", has_type_id = false)]
	public struct _KeyKey {
		public Camel._block_t data;
		public uint offset;
		public uint flags;
	}
	[CCode (cheader_filename = "camel/camel.h", cname = "_CamelLockHelperMsg", has_type_id = false)]
	public struct _LockHelperMsg {
		public uint32 magic;
		public uint32 seq;
		public uint32 id;
		public uint32 data;
	}
	[CCode (cheader_filename = "camel/camel.h", cname = "_camel_search_word", has_type_id = false)]
	public struct __search_word {
		public Camel._search_word_t type;
		public weak string word;
	}
	[CCode (cheader_filename = "camel/camel.h", cname = "_camel_search_words", has_type_id = false)]
	public struct __search_words {
		public int len;
		public Camel._search_word_t type;
		public void* words;
	}
	[CCode (cheader_filename = "camel/camel.h", cname = "camel_block_t")]
	[SimpleType]
	public struct _block_t : uint32 {
	}
	[CCode (cheader_filename = "camel/camel.h", cname = "_encrypt", has_type_id = false)]
	public struct _encrypt {
		public Camel.CipherValidityEncrypt status;
		public weak string description;
		public weak GLib.Queue encrypters;
	}
	[CCode (cheader_filename = "camel/camel.h", cname = "camel_hash_t")]
	[SimpleType]
	public struct _hash_t : uint32 {
	}
	[CCode (cheader_filename = "camel/camel.h", cname = "camel_key_t")]
	[SimpleType]
	public struct _key_t : uint32 {
	}
	[CCode (cheader_filename = "camel/camel.h", cname = "_sign", has_type_id = false)]
	public struct _sign {
		public Camel.CipherValiditySign status;
		public weak string description;
		public weak GLib.Queue signers;
	}
	[CCode (cheader_filename = "camel/camel.h", cprefix = "CAMEL_AUTHENTICATION_", type_id = "camel_authentication_result_get_type ()")]
	[Version (since = "3.4")]
	public enum AuthenticationResult {
		ERROR,
		ACCEPTED,
		REJECTED
	}
	[CCode (cheader_filename = "camel/camel.h", cprefix = "CAMEL_BESTENC_", has_type_id = false)]
	[Flags]
	public enum BestencEncoding {
		@7BIT,
		@8BIT,
		BINARY,
		TEXT
	}
	[CCode (cheader_filename = "camel/camel.h", cprefix = "CAMEL_BESTENC_", has_type_id = false)]
	[Flags]
	public enum BestencRequired {
		GET_ENCODING,
		GET_CHARSET,
		LF_IS_CRLF,
		NO_FROM
	}
	[CCode (cheader_filename = "camel/camel.h", cprefix = "CAMEL_BLOCK_FILE_", has_type_id = false)]
	[Flags]
	public enum BlockFileFlags {
		[CCode (cname = "CAMEL_BLOCK_FILE_SYNC")]
		BLOCK_FILE_SYNC
	}
	[CCode (cheader_filename = "camel/camel.h", cprefix = "CAMEL_BLOCK_", has_type_id = false)]
	[Flags]
	public enum BlockFlags {
		DIRTY,
		DETACHED
	}
	[CCode (cheader_filename = "camel/camel.h", cprefix = "CAMEL_CERT_TRUST_", has_type_id = false)]
	public enum CertTrust {
		UNKNOWN,
		NEVER,
		MARGINAL,
		FULLY,
		ULTIMATE,
		TEMPORARY
	}
	[CCode (cheader_filename = "camel/camel.h", cprefix = "CAMEL_CIPHER_HASH_", has_type_id = false)]
	public enum CipherHash {
		DEFAULT,
		MD2,
		MD5,
		SHA1,
		SHA256,
		SHA384,
		SHA512,
		RIPEMD160,
		TIGER192,
		HAVAL5160
	}
	[CCode (cheader_filename = "camel/camel.h", cprefix = "CAMEL_CIPHER_VALIDITY_ENCRYPT_", has_type_id = false)]
	public enum CipherValidityEncrypt {
		NONE,
		WEAK,
		ENCRYPTED,
		STRONG
	}
	[CCode (cheader_filename = "camel/camel.h", cprefix = "CAMEL_CIPHER_VALIDITY_", has_type_id = false)]
	public enum CipherValidityMode {
		SIGN,
		ENCRYPT
	}
	[CCode (cheader_filename = "camel/camel.h", cprefix = "CAMEL_CIPHER_VALIDITY_SIGN_", has_type_id = false)]
	public enum CipherValiditySign {
		NONE,
		GOOD,
		BAD,
		UNKNOWN,
		NEED_PUBLIC_KEY
	}
	[CCode (cheader_filename = "camel/camel.h", cprefix = "CAMEL_COMPARE_CASE_", type_id = "camel_compare_type_get_type ()")]
	[Version (since = "3.24")]
	public enum CompareType {
		INSENSITIVE,
		SENSITIVE
	}
	[CCode (cheader_filename = "camel/camel.h", cprefix = "CAMEL_DB_COLUMN_", has_type_id = false)]
	[Version (since = "3.4")]
	public enum DBKnownColumnNames {
		UNKNOWN,
		ATTACHMENT,
		BDATA,
		CINFO,
		DELETED,
		DELETED_COUNT,
		DRECEIVED,
		DSENT,
		FLAGS,
		FOLDER_NAME,
		FOLLOWUP_COMPLETED_ON,
		FOLLOWUP_DUE_BY,
		FOLLOWUP_FLAG,
		IMPORTANT,
		JND_COUNT,
		JUNK,
		JUNK_COUNT,
		LABELS,
		MAIL_CC,
		MAIL_FROM,
		MAIL_TO,
		MLIST,
		NEXTUID,
		PART,
		READ,
		REPLIED,
		SAVED_COUNT,
		SIZE,
		SUBJECT,
		TIME,
		UID,
		UNREAD_COUNT,
		USERTAGS,
		VERSION,
		VISIBLE_COUNT,
		VUID
	}
	[CCode (cheader_filename = "camel/camel.h", cprefix = "CAMEL_FETCH_HEADERS_", type_id = "camel_fetch_headers_type_get_type ()")]
	[Version (since = "3.2")]
	public enum FetchHeadersType {
		BASIC,
		BASIC_AND_MAILING_LIST,
		ALL
	}
	[CCode (cheader_filename = "camel/camel.h", cprefix = "CAMEL_FETCH_", has_type_id = false)]
	[Version (since = "3.4")]
	public enum FetchType {
		OLD_MESSAGES,
		NEW_MESSAGES
	}
	[CCode (cheader_filename = "camel/camel.h", cprefix = "CAMEL_FOLDER_ERROR_", has_type_id = false)]
	[Version (since = "2.32")]
	public enum FolderError {
		INVALID,
		INVALID_STATE,
		NON_EMPTY,
		NON_UID,
		INSUFFICIENT_PERMISSION,
		INVALID_PATH,
		INVALID_UID,
		SUMMARY_INVALID
	}
	[CCode (cheader_filename = "camel/camel.h", cprefix = "CAMEL_FOLDER_", type_id = "camel_folder_flags_get_type ()")]
	[Flags]
	public enum FolderFlags {
		HAS_SUMMARY_CAPABILITY,
		FILTER_RECENT,
		HAS_BEEN_DELETED,
		IS_TRASH,
		IS_JUNK,
		FILTER_JUNK
	}
	[CCode (cheader_filename = "camel/camel.h", cprefix = "CAMEL_FOLDER_", type_id = "camel_folder_info_flags_get_type ()")]
	[Flags]
	public enum FolderInfoFlags {
		NOSELECT,
		NOINFERIORS,
		CHILDREN,
		NOCHILDREN,
		SUBSCRIBED,
		VIRTUAL,
		SYSTEM,
		VTRASH,
		SHARED_TO_ME,
		SHARED_BY_ME,
		TYPE_NORMAL,
		TYPE_INBOX,
		TYPE_OUTBOX,
		TYPE_TRASH,
		TYPE_JUNK,
		TYPE_SENT,
		TYPE_CONTACTS,
		TYPE_EVENTS,
		TYPE_MEMOS,
		TYPE_TASKS,
		TYPE_ALL,
		TYPE_ARCHIVE,
		TYPE_DRAFTS,
		READONLY,
		WRITEONLY,
		FLAGGED,
		FLAGS_LAST
	}
	[CCode (cheader_filename = "camel/camel.h", cprefix = "CAMEL_FOLDER_SUMMARY_", has_type_id = false)]
	[Flags]
	public enum FolderSummaryFlags {
		DIRTY,
		IN_MEMORY_ONLY
	}
	[CCode (cheader_filename = "camel/camel.h", cprefix = "CAMEL_HTML_PARSER_", has_type_id = false)]
	public enum HTMLParserState {
		DATA,
		ENT,
		ELEMENT,
		TAG,
		DTDENT,
		COMMENT0,
		COMMENT,
		ATTR0,
		ATTR,
		VAL0,
		VAL,
		VAL_ENT,
		EOD,
		EOF
	}
	[CCode (cheader_filename = "camel/camel.h", cprefix = "CAMEL_HEADER_ADDRESS_", has_type_id = false)]
	public enum HeaderAddressType {
		NONE,
		NAME,
		GROUP
	}
	[CCode (cheader_filename = "camel/camel.h", cprefix = "CAMEL_JUNK_STATUS_", type_id = "camel_junk_status_get_type ()")]
	public enum JunkStatus {
		ERROR,
		INCONCLUSIVE,
		MESSAGE_IS_JUNK,
		MESSAGE_IS_NOT_JUNK
	}
	[CCode (cheader_filename = "camel/camel.h", cprefix = "CAMEL_LOCK_", has_type_id = false)]
	public enum LockType {
		READ,
		WRITE
	}
	[CCode (cheader_filename = "camel/camel.h", cprefix = "CAMEL_MEMPOOL_ALIGN_", has_type_id = false)]
	[Version (since = "2.32")]
	public enum MemPoolFlags {
		STRUCT,
		WORD,
		BYTE,
		MASK
	}
	[CCode (cheader_filename = "camel/camel.h", cprefix = "CAMEL_MESSAGE_", has_type_id = false)]
	[Flags]
	public enum MessageFlags {
		ANSWERED,
		DELETED,
		DRAFT,
		FLAGGED,
		SEEN,
		ATTACHMENTS,
		ANSWERED_ALL,
		JUNK,
		SECURE,
		NOTJUNK,
		FORWARDED,
		FOLDER_FLAGGED,
		JUNK_LEARN,
		USER
	}
	[CCode (cheader_filename = "camel/camel.h", cprefix = "CAMEL_MIME_FILTER_BASIC_", type_id = "camel_mime_filter_basic_type_get_type ()")]
	public enum MimeFilterBasicType {
		INVALID,
		BASE64_ENC,
		BASE64_DEC,
		QP_ENC,
		QP_DEC,
		UU_ENC,
		UU_DEC
	}
	[CCode (cheader_filename = "camel/camel.h", cprefix = "CAMEL_MIME_FILTER_CRLF_", type_id = "camel_mime_filter_crlf_direction_get_type ()")]
	public enum MimeFilterCRLFDirection {
		ENCODE,
		DECODE
	}
	[CCode (cheader_filename = "camel/camel.h", cprefix = "CAMEL_MIME_FILTER_CRLF_MODE_CRLF_", type_id = "camel_mime_filter_crlf_mode_get_type ()")]
	public enum MimeFilterCRLFMode {
		DOTS,
		ONLY
	}
	[CCode (cheader_filename = "camel/camel.h", cprefix = "CAMEL_MIME_FILTER_GZIP_MODE_", type_id = "camel_mime_filter_gzip_mode_get_type ()")]
	public enum MimeFilterGZipMode {
		ZIP,
		UNZIP
	}
	[CCode (cheader_filename = "camel/camel.h", cprefix = "CAMEL_MIME_FILTER_TOHTML_", type_id = "camel_mime_filter_to_html_flags_get_type ()")]
	[Flags]
	public enum MimeFilterToHTMLFlags {
		PRE,
		CONVERT_NL,
		CONVERT_SPACES,
		CONVERT_URLS,
		MARK_CITATION,
		CONVERT_ADDRESSES,
		ESCAPE_8BIT,
		CITE,
		PRESERVE_8BIT,
		FORMAT_FLOWED,
		QUOTE_CITATION,
		DIV
	}
	[CCode (cheader_filename = "camel/camel.h", cprefix = "CAMEL_MIME_FILTER_YENC_DIRECTION_", type_id = "camel_mime_filter_yenc_direction_get_type ()")]
	public enum MimeFilterYencDirection {
		ENCODE,
		DECODE
	}
	[CCode (cheader_filename = "camel/camel.h", cprefix = "CAMEL_MIME_PARSER_STATE_", has_type_id = false)]
	public enum MimeParserState {
		INITIAL,
		PRE_FROM,
		FROM,
		HEADER,
		BODY,
		MULTIPART,
		MESSAGE,
		PART,
		END,
		EOF,
		PRE_FROM_END,
		FROM_END,
		HEADER_END,
		BODY_END,
		MULTIPART_END,
		MESSAGE_END
	}
	[CCode (cheader_filename = "camel/camel.h", cprefix = "CAMEL_NETWORK_SECURITY_METHOD_", type_id = "camel_network_security_method_get_type ()")]
	[Version (since = "3.2")]
	public enum NetworkSecurityMethod {
		NONE,
		SSL_ON_ALTERNATE_PORT,
		STARTTLS_ON_STANDARD_PORT
	}
	[CCode (cheader_filename = "camel/camel.h", cprefix = "CAMEL_PARAM_", has_type_id = false)]
	[Flags]
	[Version (since = "2.32")]
	public enum ParamFlags {
		[CCode (cname = "CAMEL_PARAM_PERSISTENT")]
		PARAM_PERSISTENT
	}
	[CCode (cheader_filename = "camel/camel.h", cprefix = "CAMEL_PROVIDER_CONF_", type_id = "camel_provider_conf_type_get_type ()")]
	public enum ProviderConfType {
		END,
		SECTION_START,
		SECTION_END,
		CHECKBOX,
		CHECKSPIN,
		ENTRY,
		LABEL,
		HIDDEN,
		OPTIONS,
		PLACEHOLDER
	}
	[CCode (cheader_filename = "camel/camel.h", cprefix = "CAMEL_PROVIDER_", type_id = "camel_provider_flags_get_type ()")]
	[Flags]
	public enum ProviderFlags {
		IS_REMOTE,
		IS_LOCAL,
		IS_EXTERNAL,
		IS_SOURCE,
		IS_STORAGE,
		SUPPORTS_SSL,
		HAS_LICENSE,
		DISABLE_SENT_FOLDER,
		ALLOW_REAL_TRASH_FOLDER,
		ALLOW_REAL_JUNK_FOLDER,
		SUPPORTS_MOBILE_DEVICES,
		SUPPORTS_BATCH_FETCH,
		SUPPORTS_PURGE_MESSAGE_CACHE
	}
	[CCode (cheader_filename = "camel/camel.h", cprefix = "CAMEL_PROVIDER_", type_id = "camel_provider_type_get_type ()")]
	public enum ProviderType {
		STORE,
		TRANSPORT
	}
	[CCode (cheader_filename = "camel/camel.h", cprefix = "CAMEL_URL_", has_type_id = false)]
	[Flags]
	public enum ProviderURLFlags {
		ALLOW_USER,
		ALLOW_AUTH,
		ALLOW_PASSWORD,
		ALLOW_HOST,
		ALLOW_PORT,
		ALLOW_PATH,
		NEED_USER,
		NEED_AUTH,
		NEED_PASSWORD,
		NEED_HOST,
		NEED_PORT,
		NEED_PATH,
		NEED_PATH_DIR,
		HIDDEN_USER,
		HIDDEN_AUTH,
		HIDDEN_PASSWORD,
		HIDDEN_HOST,
		HIDDEN_PORT,
		HIDDEN_PATH,
		FRAGMENT_IS_PATH,
		PATH_IS_ABSOLUTE
	}
	[CCode (cheader_filename = "camel/camel.h", cprefix = "CAMEL_RECIPIENT_CERTIFICATE_", type_id = "camel_recipient_certificate_flags_get_type ()")]
	[Flags]
	[Version (since = "3.30")]
	public enum RecipientCertificateFlags {
		SMIME,
		PGP
	}
	[CCode (cheader_filename = "camel/camel.h", cprefix = "CAMEL_SEXP_RES_", has_type_id = false)]
	[Version (since = "3.4")]
	public enum SExpResultType {
		ARRAY_PTR,
		INT,
		STRING,
		BOOL,
		TIME,
		UNDEFINED
	}
	[CCode (cheader_filename = "camel/camel.h", cprefix = "CAMEL_SEXP_TERM_", has_type_id = false)]
	[Version (since = "3.4")]
	public enum SExpTermType {
		INT,
		BOOL,
		STRING,
		TIME,
		FUNC,
		IFUNC,
		VAR
	}
	[CCode (cheader_filename = "camel/camel.h", cprefix = "CAMEL_SMIME_", has_type_id = false)]
	[Flags]
	public enum SMIMEDescribe {
		SIGNED,
		ENCRYPTED,
		CERTS,
		CRLS
	}
	[CCode (cheader_filename = "camel/camel.h", cprefix = "CAMEL_SMIME_SIGN_", has_type_id = false)]
	public enum SMIMESign {
		CLEARSIGN,
		ENVELOPED
	}
	[CCode (cheader_filename = "camel/camel.h", cprefix = "CAMEL_SASL_ANON_TRACE_", type_id = "camel_sasl_anon_trace_type_get_type ()")]
	public enum SaslAnonTraceType {
		EMAIL,
		OPAQUE,
		EMPTY
	}
	[CCode (cheader_filename = "camel/camel.h", cprefix = "CAMEL_SERVICE_", type_id = "camel_service_connection_status_get_type ()")]
	[Version (since = "3.6")]
	public enum ServiceConnectionStatus {
		DISCONNECTED,
		CONNECTING,
		CONNECTED,
		DISCONNECTING
	}
	[CCode (cheader_filename = "camel/camel.h", cprefix = "CAMEL_SERVICE_ERROR_", has_type_id = false)]
	[Version (since = "2.32")]
	public enum ServiceError {
		INVALID,
		URL_INVALID,
		UNAVAILABLE,
		CANT_AUTHENTICATE,
		NOT_CONNECTED
	}
	[CCode (cheader_filename = "camel/camel.h", cprefix = "CAMEL_SESSION_ALERT_", type_id = "camel_session_alert_type_get_type ()")]
	public enum SessionAlertType {
		INFO,
		WARNING,
		ERROR
	}
	[CCode (cheader_filename = "camel/camel.h", cprefix = "CAMEL_SORT_", type_id = "camel_sort_type_get_type ()")]
	[Version (since = "3.2")]
	public enum SortType {
		ASCENDING,
		DESCENDING
	}
	[CCode (cheader_filename = "camel/camel.h", cprefix = "CAMEL_STORE_ERROR_", has_type_id = false)]
	[Version (since = "2.32")]
	public enum StoreError {
		INVALID,
		NO_FOLDER
	}
	[CCode (cheader_filename = "camel/camel.h", cprefix = "CAMEL_STORE_", type_id = "camel_store_flags_get_type ()")]
	[Flags]
	public enum StoreFlags {
		VTRASH,
		VJUNK,
		PROXY,
		IS_MIGRATING,
		REAL_JUNK_FOLDER,
		CAN_EDIT_FOLDERS,
		USE_CACHE_DIR,
		CAN_DELETE_FOLDERS_AT_ONCE,
		SUPPORTS_INITIAL_SETUP
	}
	[CCode (cheader_filename = "camel/camel.h", cprefix = "CAMEL_STORE_FOLDER_", has_type_id = false)]
	[Flags]
	public enum StoreGetFolderFlags {
		NONE,
		CREATE,
		EXCL,
		BODY_INDEX,
		PRIVATE
	}
	[CCode (cheader_filename = "camel/camel.h", cprefix = "CAMEL_STORE_FOLDER_INFO_", type_id = "camel_store_get_folder_info_flags_get_type ()")]
	[Flags]
	public enum StoreGetFolderInfoFlags {
		FAST,
		RECURSIVE,
		SUBSCRIBED,
		NO_VIRTUAL,
		SUBSCRIPTION_LIST,
		REFRESH
	}
	[CCode (cheader_filename = "camel/camel.h", cprefix = "CAMEL_STORE_INFO_FOLDER_", type_id = "camel_store_info_flags_get_type ()")]
	[Flags]
	public enum StoreInfoFlags {
		NOSELECT,
		NOINFERIORS,
		CHILDREN,
		NOCHILDREN,
		SUBSCRIBED,
		VIRTUAL,
		SYSTEM,
		VTRASH,
		SHARED_TO_ME,
		SHARED_BY_ME,
		TYPE_NORMAL,
		TYPE_INBOX,
		TYPE_OUTBOX,
		TYPE_TRASH,
		TYPE_JUNK,
		TYPE_SENT,
		TYPE_CONTACTS,
		TYPE_EVENTS,
		TYPE_MEMOS,
		TYPE_TASKS,
		TYPE_ALL,
		TYPE_ARCHIVE,
		TYPE_DRAFTS,
		READONLY,
		WRITEONLY,
		FLAGGED
	}
	[CCode (cheader_filename = "camel/camel.h", cprefix = "CAMEL_STORE_", type_id = "camel_store_permission_flags_get_type ()")]
	[Flags]
	public enum StorePermissionFlags {
		READ,
		WRITE
	}
	[CCode (cheader_filename = "camel/camel.h", cprefix = "CAMEL_STREAM_BUFFER_", has_type_id = false)]
	public enum StreamBufferMode {
		BUFFER,
		NONE,
		READ,
		WRITE,
		MODE
	}
	[CCode (cheader_filename = "camel/camel.h", cprefix = "CAMEL_THREE_STATE_", type_id = "camel_three_state_get_type ()")]
	[Version (since = "3.22")]
	public enum ThreeState {
		OFF,
		ON,
		INCONSISTENT
	}
	[CCode (cheader_filename = "camel/camel.h", cprefix = "CAMEL_TIME_UNIT_", type_id = "camel_time_unit_get_type ()")]
	[Version (since = "3.24")]
	public enum TimeUnit {
		DAYS,
		WEEKS,
		MONTHS,
		YEARS
	}
	[CCode (cheader_filename = "camel/camel.h", cprefix = "CAMEL_TRANSFER_", type_id = "camel_transfer_encoding_get_type ()")]
	public enum TransferEncoding {
		ENCODING_DEFAULT,
		ENCODING_7BIT,
		ENCODING_8BIT,
		ENCODING_BASE64,
		ENCODING_QUOTEDPRINTABLE,
		ENCODING_BINARY,
		ENCODING_UUENCODE,
		NUM_ENCODINGS;
		public static Camel.TransferEncoding from_string (string string);
		public unowned string to_string ();
	}
	[CCode (cheader_filename = "camel/camel.h", cprefix = "CAMEL_URL_HIDE_", has_type_id = false)]
	[Flags]
	public enum URLFlags {
		PARAMS,
		AUTH
	}
	[CCode (cheader_filename = "camel/camel.h", cprefix = "CAMEL_UUDECODE_STATE_", has_type_id = false)]
	[Flags]
	public enum UUDecodeState {
		INIT,
		BEGIN,
		END
	}
	[CCode (cheader_filename = "camel/camel.h", cprefix = "CAMEL_VTRASH_FOLDER_", has_type_id = false)]
	public enum VTrashFolderType {
		TRASH,
		JUNK,
		LAST
	}
	[CCode (cheader_filename = "camel/camel.h", cname = "camel_search_flags_t", cprefix = "CAMEL_SEARCH_MATCH_", has_type_id = false)]
	[Flags]
	public enum _search_flags_t {
		START,
		END,
		REGEX,
		ICASE,
		NEWLINE
	}
	[CCode (cheader_filename = "camel/camel.h", cname = "camel_search_match_t", cprefix = "CAMEL_SEARCH_MATCH_", has_type_id = false)]
	public enum _search_match_t {
		EXACT,
		CONTAINS,
		WORD,
		STARTS,
		ENDS,
		SOUNDEX
	}
	[CCode (cheader_filename = "camel/camel.h", cname = "camel_search_t", cprefix = "CAMEL_SEARCH_TYPE_", has_type_id = false)]
	public enum _search_t {
		ASIS,
		ENCODED,
		ADDRESS,
		ADDRESS_ENCODED,
		MLIST
	}
	[CCode (cheader_filename = "camel/camel.h", cname = "camel_search_word_t", cprefix = "CAMEL_SEARCH_WORD_", has_type_id = false)]
	public enum _search_word_t {
		SIMPLE,
		COMPLEX,
		@8BIT
	}
	[CCode (cheader_filename = "camel/camel.h", cprefix = "CAMEL_ERROR_")]
	[Version (since = "2.32")]
	public errordomain Error {
		[CCode (cname = "CAMEL_ERROR_GENERIC")]
		ERROR_GENERIC;
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "camel/camel.h", has_target = false)]
	public delegate void* CipherCloneFunc (void* value);
	[CCode (cheader_filename = "camel/camel.h", has_target = false)]
	public delegate void* CopyFunc (void* object);
	[CCode (cheader_filename = "camel/camel.h", has_target = false)]
	[Version (since = "2.24")]
	public delegate int DBCollate (void* enc, int length1, void* data1, int length2, void* data2);
	[CCode (cheader_filename = "camel/camel.h", instance_pos = 0.9)]
	[Version (since = "2.24")]
	public delegate int DBSelectCB ([CCode (array_length_cname = "ncol", array_length_pos = 0.666667)] string[] colvalues, [CCode (array_length_cname = "ncol", array_length_pos = 0.666667)] string[] colnames);
	[CCode (cheader_filename = "camel/camel.h", instance_pos = 2.9)]
	[Version (since = "3.26")]
	public delegate bool DataCacheRemoveFunc (Camel.DataCache cdc, string filename);
	[CCode (cheader_filename = "camel/camel.h", instance_pos = 2.9)]
	public delegate unowned Camel.Folder FilterGetFolderFunc (Camel.FilterDriver driver, string uri) throws GLib.Error;
	[CCode (cheader_filename = "camel/camel.h", instance_pos = 2.9)]
	public delegate void FilterPlaySoundFunc (Camel.FilterDriver driver, string filename);
	[CCode (cheader_filename = "camel/camel.h", instance_pos = 3.9)]
	public delegate void FilterShellFunc (Camel.FilterDriver driver, int argc, string argv);
	[CCode (cheader_filename = "camel/camel.h", instance_pos = 4.9)]
	public delegate void FilterStatusFunc (Camel.FilterDriver driver, void* status, int pc, string desc);
	[CCode (cheader_filename = "camel/camel.h", instance_pos = 1.9)]
	public delegate void FilterSystemBeepFunc (Camel.FilterDriver driver);
	[CCode (cheader_filename = "camel/camel.h", instance_pos = 2.9)]
	public delegate void ForeachInfoData (Camel.VeeMessageInfoData mi_data, Camel.Folder subfolder);
	[CCode (cheader_filename = "camel/camel.h", instance_pos = 3.9)]
	[Version (since = "3.34")]
	public delegate bool ForeachPartFunc (Camel.MimeMessage message, Camel.MimePart part, Camel.MimePart? parent_part);
	[CCode (cheader_filename = "camel/camel.h", instance_pos = 2.9)]
	public delegate string IndexNorm (Camel.Index index, string word);
	[CCode (cheader_filename = "camel/camel.h", instance_pos = 2.9)]
	[Version (since = "3.36")]
	public delegate bool MessageContentInfoTraverseCallback (Camel.MessageContentInfo ci, int depth);
	[CCode (cheader_filename = "camel/camel.h", has_target = false)]
	public delegate int ProviderAutoDetectFunc (Camel.URL url, out GLib.HashTable<string,string>? auto_detected) throws GLib.Error;
	[CCode (cheader_filename = "camel/camel.h", instance_pos = 2.9)]
	[Version (since = "3.4")]
	public delegate unowned Camel.SExpResult? SExpFunc (Camel.SExp sexp, [CCode (array_length_cname = "argc", array_length_pos = 1.5)] Camel.SExpResult[] argv);
	[CCode (cheader_filename = "camel/camel.h", instance_pos = 2.9)]
	[Version (since = "3.4")]
	public delegate unowned Camel.SExpResult? SExpIFunc (Camel.SExp sexp, [CCode (array_length_cname = "argc", array_length_pos = 1.5)] Camel.SExpTerm[] argv);
	[CCode (cheader_filename = "camel/camel.h", instance_pos = 2.9)]
	[Version (since = "3.2")]
	public delegate void SessionCallback (Camel.Session session, GLib.Cancellable? cancellable) throws GLib.Error;
	[CCode (cheader_filename = "camel/camel.h", has_target = false)]
	public delegate void TextIndexFunc (Camel.TextIndex idx, string word, string buffer);
	[CCode (cheader_filename = "camel/camel.h", has_target = false)]
	public delegate bool UrlScanFunc (string @in, string pos, string inend, Camel.UrlMatch match);
	[CCode (cheader_filename = "camel/camel.h", cname = "AI_CANONNAME")]
	public const int AI_CANONNAME;
	[CCode (cheader_filename = "camel/camel.h", cname = "AI_NUMERICHOST")]
	public const int AI_NUMERICHOST;
	[CCode (cheader_filename = "camel/camel.h", cname = "CAMEL_BLOCK_SIZE")]
	public const int BLOCK_SIZE;
	[CCode (cheader_filename = "camel/camel.h", cname = "CAMEL_BLOCK_SIZE_BITS")]
	public const int BLOCK_SIZE_BITS;
	[CCode (cheader_filename = "camel/camel.h", cname = "CAMEL_CIPHER_CERT_INFO_PROPERTY_PHOTO_FILENAME")]
	[Version (since = "3.22")]
	public const string CIPHER_CERT_INFO_PROPERTY_PHOTO_FILENAME;
	[CCode (cheader_filename = "camel/camel.h", cname = "CAMEL_CIPHER_CERT_INFO_PROPERTY_SIGNERS_ALT_EMAILS")]
	[Version (since = "3.28")]
	public const string CIPHER_CERT_INFO_PROPERTY_SIGNERS_ALT_EMAILS;
	[CCode (cheader_filename = "camel/camel.h", cname = "CAMEL_DB_FILE")]
	[Version (since = "2.24")]
	public const string DB_FILE;
	[CCode (cheader_filename = "camel/camel.h", cname = "CAMEL_DB_FREE_CACHE_SIZE")]
	[Version (since = "2.24")]
	public const int DB_FREE_CACHE_SIZE;
	[CCode (cheader_filename = "camel/camel.h", cname = "CAMEL_DB_IN_MEMORY_DB")]
	[Version (since = "2.26")]
	public const string DB_IN_MEMORY_DB;
	[CCode (cheader_filename = "camel/camel.h", cname = "CAMEL_DB_IN_MEMORY_TABLE")]
	[Version (since = "2.26")]
	public const string DB_IN_MEMORY_TABLE;
	[CCode (cheader_filename = "camel/camel.h", cname = "CAMEL_DB_IN_MEMORY_TABLE_LIMIT")]
	[Version (since = "2.26")]
	public const int DB_IN_MEMORY_TABLE_LIMIT;
	[CCode (cheader_filename = "camel/camel.h", cname = "CAMEL_DB_SLEEP_INTERVAL")]
	[Version (since = "2.24")]
	public const int DB_SLEEP_INTERVAL;
	[CCode (cheader_filename = "camel/camel.h", cname = "CAMEL_DEBUG_IMAP")]
	public const string DEBUG_IMAP;
	[CCode (cheader_filename = "camel/camel.h", cname = "CAMEL_DEBUG_IMAP_FOLDER")]
	public const string DEBUG_IMAP_FOLDER;
	[CCode (cheader_filename = "camel/camel.h", cname = "CAMEL_DOT_LOCK_REFRESH")]
	public const int DOT_LOCK_REFRESH;
	[CCode (cheader_filename = "camel/camel.h", cname = "EAI_ADDRFAMILY")]
	public const int EAI_ADDRFAMILY;
	[CCode (cheader_filename = "camel/camel.h", cname = "EAI_AGAIN")]
	public const int EAI_AGAIN;
	[CCode (cheader_filename = "camel/camel.h", cname = "EAI_BADFLAGS")]
	public const int EAI_BADFLAGS;
	[CCode (cheader_filename = "camel/camel.h", cname = "EAI_FAIL")]
	public const int EAI_FAIL;
	[CCode (cheader_filename = "camel/camel.h", cname = "EAI_FAMILY")]
	public const int EAI_FAMILY;
	[CCode (cheader_filename = "camel/camel.h", cname = "EAI_MEMORY")]
	public const int EAI_MEMORY;
	[CCode (cheader_filename = "camel/camel.h", cname = "EAI_NODATA")]
	public const int EAI_NODATA;
	[CCode (cheader_filename = "camel/camel.h", cname = "EAI_NONAME")]
	public const int EAI_NONAME;
	[CCode (cheader_filename = "camel/camel.h", cname = "EAI_OVERFLOW")]
	public const int EAI_OVERFLOW;
	[CCode (cheader_filename = "camel/camel.h", cname = "EAI_SERVICE")]
	public const int EAI_SERVICE;
	[CCode (cheader_filename = "camel/camel.h", cname = "EAI_SOCKTYPE")]
	public const int EAI_SOCKTYPE;
	[CCode (cheader_filename = "camel/camel.h", cname = "EAI_SYSTEM")]
	public const int EAI_SYSTEM;
	[CCode (cheader_filename = "camel/camel.h", cname = "EDS_CAMEL_PROVIDER_DIR")]
	public const string EDS_CAMEL_PROVIDER_DIR;
	[CCode (cheader_filename = "camel/camel.h", cname = "CAMEL_FOLDER_TYPE_BIT")]
	public const int FOLDER_TYPE_BIT;
	[CCode (cheader_filename = "camel/camel.h", cname = "CAMEL_FOLDER_TYPE_MASK")]
	public const int FOLDER_TYPE_MASK;
	[CCode (cheader_filename = "camel/camel.h", cname = "CAMEL_FOLD_MAX_SIZE")]
	public const int FOLD_MAX_SIZE;
	[CCode (cheader_filename = "camel/camel.h", cname = "CAMEL_FOLD_SIZE")]
	public const int FOLD_SIZE;
	[CCode (cheader_filename = "camel/camel.h", cname = "CAMEL_INDEX_DELETED")]
	public const int INDEX_DELETED;
	[CCode (cheader_filename = "camel/camel.h", cname = "CAMEL_KEY_TABLE_MAX_KEY")]
	public const int KEY_TABLE_MAX_KEY;
	[CCode (cheader_filename = "camel/camel.h", cname = "CAMEL_LOCK_DELAY")]
	public const int LOCK_DELAY;
	[CCode (cheader_filename = "camel/camel.h", cname = "CAMEL_LOCK_DOT_DELAY")]
	public const int LOCK_DOT_DELAY;
	[CCode (cheader_filename = "camel/camel.h", cname = "CAMEL_LOCK_DOT_RETRY")]
	public const int LOCK_DOT_RETRY;
	[CCode (cheader_filename = "camel/camel.h", cname = "CAMEL_LOCK_DOT_STALE")]
	public const int LOCK_DOT_STALE;
	[CCode (cheader_filename = "camel/camel.h", cname = "CAMEL_LOCK_RETRY")]
	public const int LOCK_RETRY;
	[CCode (cheader_filename = "camel/camel.h", cname = "CAMEL_MESSAGE_DATE_CURRENT")]
	public const int MESSAGE_DATE_CURRENT;
	[CCode (cheader_filename = "camel/camel.h", cname = "CAMEL_MESSAGE_SYSTEM_MASK")]
	public const int MESSAGE_SYSTEM_MASK;
	[CCode (cheader_filename = "camel/camel.h", cname = "CAMEL_MIME_FILTER_ENRICHED_IS_RICHTEXT")]
	public const int MIME_FILTER_ENRICHED_IS_RICHTEXT;
	[CCode (cheader_filename = "camel/camel.h", cname = "CAMEL_MIME_YDECODE_STATE_BEGIN")]
	public const int MIME_YDECODE_STATE_BEGIN;
	[CCode (cheader_filename = "camel/camel.h", cname = "CAMEL_MIME_YDECODE_STATE_DECODE")]
	public const int MIME_YDECODE_STATE_DECODE;
	[CCode (cheader_filename = "camel/camel.h", cname = "CAMEL_MIME_YDECODE_STATE_END")]
	public const int MIME_YDECODE_STATE_END;
	[CCode (cheader_filename = "camel/camel.h", cname = "CAMEL_MIME_YDECODE_STATE_EOLN")]
	public const int MIME_YDECODE_STATE_EOLN;
	[CCode (cheader_filename = "camel/camel.h", cname = "CAMEL_MIME_YDECODE_STATE_ESCAPE")]
	public const int MIME_YDECODE_STATE_ESCAPE;
	[CCode (cheader_filename = "camel/camel.h", cname = "CAMEL_MIME_YDECODE_STATE_INIT")]
	public const int MIME_YDECODE_STATE_INIT;
	[CCode (cheader_filename = "camel/camel.h", cname = "CAMEL_MIME_YDECODE_STATE_PART")]
	public const int MIME_YDECODE_STATE_PART;
	[CCode (cheader_filename = "camel/camel.h", cname = "CAMEL_MIME_YENCODE_CRC_INIT")]
	public const int MIME_YENCODE_CRC_INIT;
	[CCode (cheader_filename = "camel/camel.h", cname = "CAMEL_MIME_YENCODE_STATE_INIT")]
	public const int MIME_YENCODE_STATE_INIT;
	[CCode (cheader_filename = "camel/camel.h", cname = "NI_DGRAM")]
	public const int NI_DGRAM;
	[CCode (cheader_filename = "camel/camel.h", cname = "NI_NAMEREQD")]
	public const int NI_NAMEREQD;
	[CCode (cheader_filename = "camel/camel.h", cname = "NI_NOFQDN")]
	public const int NI_NOFQDN;
	[CCode (cheader_filename = "camel/camel.h", cname = "NI_NUMERICHOST")]
	public const int NI_NUMERICHOST;
	[CCode (cheader_filename = "camel/camel.h", cname = "NI_NUMERICSERV")]
	public const int NI_NUMERICSERV;
	[CCode (cheader_filename = "camel/camel.h", cname = "O_BINARY")]
	public const int O_BINARY;
	[CCode (cheader_filename = "camel/camel.h", cname = "CAMEL_RECIPIENT_TYPE_BCC")]
	public const string RECIPIENT_TYPE_BCC;
	[CCode (cheader_filename = "camel/camel.h", cname = "CAMEL_RECIPIENT_TYPE_CC")]
	public const string RECIPIENT_TYPE_CC;
	[CCode (cheader_filename = "camel/camel.h", cname = "CAMEL_RECIPIENT_TYPE_RESENT_BCC")]
	public const string RECIPIENT_TYPE_RESENT_BCC;
	[CCode (cheader_filename = "camel/camel.h", cname = "CAMEL_RECIPIENT_TYPE_RESENT_CC")]
	public const string RECIPIENT_TYPE_RESENT_CC;
	[CCode (cheader_filename = "camel/camel.h", cname = "CAMEL_RECIPIENT_TYPE_RESENT_TO")]
	public const string RECIPIENT_TYPE_RESENT_TO;
	[CCode (cheader_filename = "camel/camel.h", cname = "CAMEL_RECIPIENT_TYPE_TO")]
	public const string RECIPIENT_TYPE_TO;
	[CCode (cheader_filename = "camel/camel.h", cname = "CAMEL_STORE_INFO_FOLDER_TYPE_BIT")]
	public const int STORE_INFO_FOLDER_TYPE_BIT;
	[CCode (cheader_filename = "camel/camel.h", cname = "CAMEL_STORE_INFO_FOLDER_TYPE_MASK")]
	public const int STORE_INFO_FOLDER_TYPE_MASK;
	[CCode (cheader_filename = "camel/camel.h", cname = "CAMEL_STORE_INFO_FOLDER_UNKNOWN")]
	public const int STORE_INFO_FOLDER_UNKNOWN;
	[CCode (cheader_filename = "camel/camel.h", cname = "CAMEL_STORE_SETUP_ARCHIVE_FOLDER")]
	public const string STORE_SETUP_ARCHIVE_FOLDER;
	[CCode (cheader_filename = "camel/camel.h", cname = "CAMEL_STORE_SETUP_DRAFTS_FOLDER")]
	public const string STORE_SETUP_DRAFTS_FOLDER;
	[CCode (cheader_filename = "camel/camel.h", cname = "CAMEL_STORE_SETUP_SENT_FOLDER")]
	public const string STORE_SETUP_SENT_FOLDER;
	[CCode (cheader_filename = "camel/camel.h", cname = "CAMEL_STORE_SETUP_TEMPLATES_FOLDER")]
	public const string STORE_SETUP_TEMPLATES_FOLDER;
	[CCode (cheader_filename = "camel/camel.h", cname = "CAMEL_UNMATCHED_NAME")]
	public const string UNMATCHED_NAME;
	[CCode (cheader_filename = "camel/camel.h", cname = "CAMEL_URL_HIDE_ALL")]
	public const int URL_HIDE_ALL;
	[CCode (cheader_filename = "camel/camel.h", cname = "CAMEL_URL_PART_AUTH")]
	public const int URL_PART_AUTH;
	[CCode (cheader_filename = "camel/camel.h", cname = "CAMEL_URL_PART_HIDDEN")]
	public const int URL_PART_HIDDEN;
	[CCode (cheader_filename = "camel/camel.h", cname = "CAMEL_URL_PART_HOST")]
	public const int URL_PART_HOST;
	[CCode (cheader_filename = "camel/camel.h", cname = "CAMEL_URL_PART_NEED")]
	public const int URL_PART_NEED;
	[CCode (cheader_filename = "camel/camel.h", cname = "CAMEL_URL_PART_PASSWORD")]
	public const int URL_PART_PASSWORD;
	[CCode (cheader_filename = "camel/camel.h", cname = "CAMEL_URL_PART_PATH")]
	public const int URL_PART_PATH;
	[CCode (cheader_filename = "camel/camel.h", cname = "CAMEL_URL_PART_PATH_DIR")]
	public const int URL_PART_PATH_DIR;
	[CCode (cheader_filename = "camel/camel.h", cname = "CAMEL_URL_PART_PORT")]
	public const int URL_PART_PORT;
	[CCode (cheader_filename = "camel/camel.h", cname = "CAMEL_URL_PART_USER")]
	public const int URL_PART_USER;
	[CCode (cheader_filename = "camel/camel.h", cname = "CAMEL_UUDECODE_STATE_MASK")]
	public const int UUDECODE_STATE_MASK;
	[CCode (cheader_filename = "camel/camel.h", cname = "CAMEL_VJUNK_NAME")]
	public const string VJUNK_NAME;
	[CCode (cheader_filename = "camel/camel.h", cname = "CAMEL_VTRASH_NAME")]
	public const string VTRASH_NAME;
	[CCode (cheader_filename = "camel/camel.h")]
	[Version (since = "3.16")]
	public static unowned GLib.Binding binding_bind_property (GLib.Object source, string source_property, GLib.Object target, string target_property, GLib.BindingFlags flags);
	[CCode (cheader_filename = "camel/camel.h")]
	[Version (since = "3.16")]
	public static unowned GLib.Binding binding_bind_property_full (GLib.Object source, string source_property, GLib.Object target, string target_property, GLib.BindingFlags flags, GLib.BindingTransformFunc? transform_to, owned GLib.BindingTransformFunc? transform_from);
	[CCode (cheader_filename = "camel/camel.h")]
	[Version (since = "3.16")]
	public static unowned GLib.Binding binding_bind_property_with_closures (GLib.Object source, string source_property, GLib.Object target, string target_property, GLib.BindingFlags flags, GLib.Closure transform_to, GLib.Closure transform_from);
	[CCode (cheader_filename = "camel/camel.h")]
	[Version (since = "3.22")]
	public static bool cipher_can_load_photos ();
	[CCode (cheader_filename = "camel/camel.h")]
	public static int cipher_canonical_to_stream (Camel.MimePart part, uint32 flags, Camel.Stream ostream, GLib.Cancellable? cancellable = null) throws GLib.Error;
	[CCode (cheader_filename = "camel/camel.h")]
	public static string content_transfer_encoding_decode (string @in);
	[CCode (cheader_filename = "camel/camel.h")]
	public static bool debug (string mode);
	[CCode (cheader_filename = "camel/camel.h")]
	[Version (since = "3.30")]
	public static void debug_demangle_backtrace (ref GLib.StringBuilder? bt);
	[CCode (cheader_filename = "camel/camel.h")]
	public static void debug_end ();
	[CCode (cheader_filename = "camel/camel.h")]
	[Version (since = "3.12")]
	public static GLib.StringBuilder debug_get_backtrace ();
	[CCode (cheader_filename = "camel/camel.h")]
	[Version (since = "3.30")]
	public static GLib.StringBuilder debug_get_raw_backtrace ();
	[CCode (cheader_filename = "camel/camel.h")]
	public static void debug_init ();
	[CCode (cheader_filename = "camel/camel.h")]
	[Version (since = "3.20")]
	public static void debug_ref_unref_dump_backtraces ();
	[CCode (cheader_filename = "camel/camel.h")]
	[Version (since = "3.20")]
	public static void debug_ref_unref_push_backtrace (GLib.StringBuilder backtrace, uint object_ref_count);
	[CCode (cheader_filename = "camel/camel.h")]
	[Version (since = "3.20")]
	public static void debug_ref_unref_push_backtrace_for_object (void* _object);
	[CCode (cheader_filename = "camel/camel.h")]
	public static bool debug_start (string mode);
	[CCode (cheader_filename = "camel/camel.h")]
	public static string enriched_to_html (string @in, uint32 flags);
	[CCode (cheader_filename = "camel/camel.h")]
	public static int file_util_decode_fixed_int32 (void* @in, int32 dest);
	[CCode (cheader_filename = "camel/camel.h")]
	public static int file_util_decode_fixed_string (void* @in, string str, size_t len);
	[CCode (cheader_filename = "camel/camel.h")]
	public static int file_util_decode_gsize (void* @in, size_t dest);
	[CCode (cheader_filename = "camel/camel.h")]
	public static int file_util_decode_off_t (void* @in, size_t dest);
	[CCode (cheader_filename = "camel/camel.h")]
	public static int file_util_decode_string (void* @in, string str);
	[CCode (cheader_filename = "camel/camel.h")]
	public static int file_util_decode_time_t (void* @in, long dest);
	[CCode (cheader_filename = "camel/camel.h")]
	public static int file_util_decode_uint32 (void* @in, uint32 dest);
	[CCode (cheader_filename = "camel/camel.h")]
	public static int file_util_encode_fixed_int32 (void* @out, int32 value);
	[CCode (cheader_filename = "camel/camel.h")]
	public static int file_util_encode_fixed_string (void* @out, string str, size_t len);
	[CCode (cheader_filename = "camel/camel.h")]
	public static int file_util_encode_gsize (void* @out, size_t value);
	[CCode (cheader_filename = "camel/camel.h")]
	public static int file_util_encode_off_t (void* @out, size_t value);
	[CCode (cheader_filename = "camel/camel.h")]
	public static int file_util_encode_string (void* @out, string str);
	[CCode (cheader_filename = "camel/camel.h")]
	public static int file_util_encode_time_t (void* @out, long value);
	[CCode (cheader_filename = "camel/camel.h")]
	public static int file_util_encode_uint32 (void* @out, uint32 value);
	[CCode (cheader_filename = "camel/camel.h")]
	public static string file_util_safe_filename (string name);
	[CCode (cheader_filename = "camel/camel.h")]
	public static string file_util_savename (string filename);
	[CCode (cheader_filename = "camel/camel.h")]
	[Version (since = "2.22")]
	public static void freeaddrinfo (void* host);
	[CCode (cheader_filename = "camel/camel.h")]
	[Version (since = "2.22")]
	public static void* getaddrinfo (string name, string service, void* hints, GLib.Cancellable? cancellable = null) throws GLib.Error;
	[CCode (cheader_filename = "camel/camel.h")]
	public static string header_contentid_decode (string @in);
	[CCode (cheader_filename = "camel/camel.h")]
	public static long header_decode_date (string str, int tz_offset);
	[CCode (cheader_filename = "camel/camel.h")]
	public static int header_decode_int (string @in);
	[CCode (cheader_filename = "camel/camel.h")]
	public static string header_decode_string (string @in, string default_charset);
	[CCode (cheader_filename = "camel/camel.h")]
	public static string header_encode_phrase (uint8 @in);
	[CCode (cheader_filename = "camel/camel.h")]
	public static string header_encode_string (uint8 @in);
	[CCode (cheader_filename = "camel/camel.h")]
	public static string header_fold (string @in, size_t headerlen);
	[CCode (cheader_filename = "camel/camel.h")]
	public static string header_format_ctext (string @in, string default_charset);
	[CCode (cheader_filename = "camel/camel.h")]
	public static string header_format_date (long date, int tz_offset);
	[CCode (cheader_filename = "camel/camel.h")]
	public static string header_location_decode (string @in);
	[CCode (cheader_filename = "camel/camel.h")]
	public static Camel.HeaderAddress header_mailbox_decode (string @in, string charset);
	[CCode (cheader_filename = "camel/camel.h")]
	public static void header_mime_decode (string @in, int maj, int min);
	[CCode (cheader_filename = "camel/camel.h")]
	public static string header_msgid_decode (string @in);
	[CCode (cheader_filename = "camel/camel.h")]
	public static string header_msgid_generate (string domain);
	[CCode (cheader_filename = "camel/camel.h")]
	public static GLib.SList<string> header_newsgroups_decode (string @in);
	[CCode (cheader_filename = "camel/camel.h")]
	public static GLib.SList<string> header_references_decode (string @in);
	[CCode (cheader_filename = "camel/camel.h")]
	public static void* header_set_param (void* paramsp, string name, string value);
	[CCode (cheader_filename = "camel/camel.h")]
	public static string header_token_decode (string @in);
	[CCode (cheader_filename = "camel/camel.h")]
	public static string header_unfold (string @in);
	[CCode (cheader_filename = "camel/camel.h")]
	public static string? headers_dup_mailing_list (Camel.NameValueArray headers);
	[CCode (cheader_filename = "camel/camel.h")]
	[Version (since = "3.16")]
	public static string host_idna_to_ascii (string host);
	[CCode (cheader_filename = "camel/camel.h")]
	public static unowned string iconv_charset_language (string charset);
	[CCode (cheader_filename = "camel/camel.h")]
	public static unowned string iconv_charset_name (string charset);
	[CCode (cheader_filename = "camel/camel.h")]
	public static unowned string iconv_locale_charset ();
	[CCode (cheader_filename = "camel/camel.h")]
	public static unowned string iconv_locale_language ();
	[CCode (cheader_filename = "camel/camel.h")]
	public static int init (string certdb_dir, bool nss_init);
	[CCode (cheader_filename = "camel/camel.h")]
	public static void localtime_with_offset (long tt, [CCode (type = "tm*")] Posix.tm tm, int offset);
	[CCode (cheader_filename = "camel/camel.h")]
	public static int lock_dot (string path) throws GLib.Error;
	[CCode (cheader_filename = "camel/camel.h")]
	public static int lock_fcntl (int fd, Camel.LockType type) throws GLib.Error;
	[CCode (cheader_filename = "camel/camel.h")]
	public static int lock_flock (int fd, Camel.LockType type) throws GLib.Error;
	[CCode (cheader_filename = "camel/camel.h")]
	public static int lock_folder (string path, int fd, Camel.LockType type) throws GLib.Error;
	[CCode (cheader_filename = "camel/camel.h")]
	public static int lock_helper_lock (string path) throws GLib.Error;
	[CCode (cheader_filename = "camel/camel.h")]
	public static int lock_helper_unlock (int lockid);
	[CCode (cheader_filename = "camel/camel.h")]
	[Version (since = "3.4")]
	public static long mktime_utc ([CCode (type = "tm*")] Posix.tm tm);
	[CCode (cheader_filename = "camel/camel.h")]
	public static int movemail (string source, string dest) throws GLib.Error;
	[CCode (cheader_filename = "camel/camel.h")]
	[Version (since = "3.6")]
	public static void pointer_tracker_dump ();
	[CCode (cheader_filename = "camel/camel.h")]
	[Version (since = "3.6")]
	public static void pointer_tracker_track_with_info (void* ptr, string info);
	[CCode (cheader_filename = "camel/camel.h")]
	[Version (since = "3.6")]
	public static void pointer_tracker_untrack (void* ptr);
	[CCode (cheader_filename = "camel/camel.h")]
	public static unowned string pstring_add (string string, bool own);
	[CCode (cheader_filename = "camel/camel.h")]
	[Version (since = "3.22")]
	public static bool pstring_contains (string string);
	[CCode (cheader_filename = "camel/camel.h")]
	[Version (since = "3.6")]
	public static void pstring_dump_stat ();
	[CCode (cheader_filename = "camel/camel.h")]
	public static void pstring_free (string string);
	[CCode (cheader_filename = "camel/camel.h")]
	[Version (since = "2.24")]
	public static unowned string pstring_peek (string string);
	[CCode (cheader_filename = "camel/camel.h")]
	public static unowned string pstring_strdup (string string);
	[CCode (cheader_filename = "camel/camel.h")]
	public static size_t quoted_decode_step ([CCode (array_length_cname = "len", array_length_pos = 1.5, array_length_type = "gsize")] uint8[] @in, [CCode (array_length = false)] ref uint8[] @out, [CCode (array_length_cname = "savestate", array_length_pos = 2.5)] ref int[] saveme);
	[CCode (cheader_filename = "camel/camel.h")]
	public static size_t quoted_encode_close ([CCode (array_length_cname = "len", array_length_pos = 1.5, array_length_type = "gsize")] uint8[] @in, [CCode (array_length = false)] ref uint8[] @out, [CCode (array_length_cname = "state", array_length_pos = 2.5)] ref int[] save);
	[CCode (cheader_filename = "camel/camel.h")]
	public static size_t quoted_encode_step ([CCode (array_length_cname = "len", array_length_pos = 1.5, array_length_type = "gsize")] uint8[] @in, [CCode (array_length = false)] ref uint8[] @out, [CCode (array_length_cname = "state", array_length_pos = 2.5)] ref int[] save);
	[CCode (cheader_filename = "camel/camel.h")]
	public static ssize_t read (int fd, string buf, size_t n, GLib.Cancellable? cancellable = null) throws GLib.Error;
	[CCode (cheader_filename = "camel/camel.h")]
	public static bool search_camel_header_soundex (string header, string match);
	[CCode (cheader_filename = "camel/camel.h")]
	[Version (since = "3.22")]
	public static string search_get_all_headers_decoded (Camel.MimeMessage message);
	[CCode (cheader_filename = "camel/camel.h")]
	[Version (since = "3.28")]
	public static unowned string search_get_default_charset_from_headers (Camel.NameValueArray headers);
	[CCode (cheader_filename = "camel/camel.h")]
	[Version (since = "3.22")]
	public static unowned string search_get_default_charset_from_message (Camel.MimeMessage message);
	[CCode (cheader_filename = "camel/camel.h")]
	[Version (since = "3.22")]
	public static string search_get_header_decoded (string header_name, string header_value, string? default_charset);
	[CCode (cheader_filename = "camel/camel.h")]
	[Version (since = "3.28")]
	public static string search_get_headers_decoded (Camel.NameValueArray headers, string? default_charset);
	[CCode (cheader_filename = "camel/camel.h")]
	[Version (since = "3.22")]
	public static bool search_header_is_address (string header_name);
	[CCode (cheader_filename = "camel/camel.h")]
	public static bool search_header_match (string value, string match, Camel._search_match_t how, Camel._search_t type, string default_charset);
	[CCode (cheader_filename = "camel/camel.h")]
	public static void search_words_free (void* words);
	[CCode (cheader_filename = "camel/camel.h")]
	public static void* search_words_simple (void* words);
	[CCode (cheader_filename = "camel/camel.h")]
	public static void* search_words_split (uint8 @in);
	[CCode (cheader_filename = "camel/camel.h")]
	[Version (since = "2.24")]
	public static void shutdown ();
	[CCode (cheader_filename = "camel/camel.h")]
	public static unowned string store_info_path (Camel.StoreSummary summary, Camel.StoreInfo info);
	[CCode (cheader_filename = "camel/camel.h")]
	public static int strcase_equal (void* a, void* b);
	[CCode (cheader_filename = "camel/camel.h")]
	public static uint strcase_hash (void* v);
	[CCode (cheader_filename = "camel/camel.h")]
	public static unowned string strdown (string str);
	[CCode (cheader_filename = "camel/camel.h")]
	public static string strstrcase (string haystack, string needle);
	[CCode (cheader_filename = "camel/camel.h")]
	public static Camel.MessageFlags system_flag (string name);
	[CCode (cheader_filename = "camel/camel.h")]
	public static bool system_flag_get (Camel.MessageFlags flags, string name);
	[CCode (cheader_filename = "camel/camel.h")]
	public static string text_to_html (string @in, Camel.MimeFilterToHTMLFlags flags, uint32 color);
	[CCode (cheader_filename = "camel/camel.h")]
	[Version (since = "3.24")]
	public static long time_value_apply (long src_time, Camel.TimeUnit unit, int value);
	[CCode (cheader_filename = "camel/camel.h")]
	public static string ucs2_utf8 (string ptr);
	[CCode (cheader_filename = "camel/camel.h")]
	public static void unlock_dot (string path);
	[CCode (cheader_filename = "camel/camel.h")]
	public static void unlock_fcntl (int fd);
	[CCode (cheader_filename = "camel/camel.h")]
	public static void unlock_flock (int fd);
	[CCode (cheader_filename = "camel/camel.h")]
	public static void unlock_folder (string path, int fd);
	[CCode (cheader_filename = "camel/camel.h")]
	public static unowned string ustrstrcase (string haystack, string needle);
	[CCode (cheader_filename = "camel/camel.h")]
	public static string utf7_utf8 (string ptr);
	[CCode (cheader_filename = "camel/camel.h")]
	public static uint32 utf8_getc (ref uint8 ptr);
	[CCode (cheader_filename = "camel/camel.h")]
	public static uint32 utf8_getc_limit (ref uint8 ptr, uint8 end);
	[CCode (cheader_filename = "camel/camel.h")]
	[Version (since = "2.26")]
	public static string utf8_make_valid (string text);
	[CCode (cheader_filename = "camel/camel.h")]
	[Version (since = "3.34")]
	public static string utf8_make_valid_len (string text, ssize_t text_len);
	[CCode (cheader_filename = "camel/camel.h")]
	public static void utf8_putc (ref uint8 ptr, uint32 c);
	[CCode (cheader_filename = "camel/camel.h")]
	public static string utf8_ucs2 (string ptr);
	[CCode (cheader_filename = "camel/camel.h")]
	public static string utf8_utf7 (string ptr);
	[CCode (cheader_filename = "camel/camel.h")]
	[Version (since = "3.24")]
	public static int64 util_bdata_get_number (string bdata_ptr, int64 default_value);
	[CCode (cheader_filename = "camel/camel.h")]
	[Version (since = "3.24")]
	public static string util_bdata_get_string (string bdata_ptr, string default_value);
	[CCode (cheader_filename = "camel/camel.h")]
	[Version (since = "3.24")]
	public static void util_bdata_put_number (GLib.StringBuilder bdata_str, int64 value);
	[CCode (cheader_filename = "camel/camel.h")]
	[Version (since = "3.24")]
	public static void util_bdata_put_string (GLib.StringBuilder bdata_str, string value);
	[CCode (cheader_filename = "camel/camel.h")]
	public static size_t uudecode_step ([CCode (array_length_cname = "inlen", array_length_pos = 1.5, array_length_type = "gsize")] uint8[] @in, [CCode (array_length = false)] ref uint8[] @out, [CCode (array_length_cname = "state", array_length_pos = 2.5)] ref uint32[] save);
	[CCode (cheader_filename = "camel/camel.h")]
	public static size_t uuencode_close ([CCode (array_length_cname = "len", array_length_pos = 1.5, array_length_type = "gsize")] uint8[] @in, [CCode (array_length = false)] ref uint8[] @out, [CCode (array_length = false)] ref uint8 uubuf[60], [CCode (array_length_cname = "state", array_length_pos = 3.5)] ref uint32[] save);
	[CCode (cheader_filename = "camel/camel.h")]
	public static size_t uuencode_step ([CCode (array_length_cname = "len", array_length_pos = 1.5, array_length_type = "gsize")] uint8[] @in, [CCode (array_length = false)] ref uint8[] @out, [CCode (array_length = false)] ref uint8 uubuf[60], [CCode (array_length_cname = "state", array_length_pos = 3.5)] ref uint32[] save);
	[CCode (cheader_filename = "camel/camel.h")]
	public static ssize_t write (int fd, string buf, size_t n, GLib.Cancellable? cancellable = null) throws GLib.Error;
	[CCode (cheader_filename = "camel/camel.h")]
	public static size_t ydecode_step ([CCode (array_length_cname = "inlen", array_length_pos = 1.5, array_length_type = "gsize")] uint8[] @in, [CCode (array_length = false)] out uint8[] @out, out int state, out uint32 pcrc, out uint32 crc);
	[CCode (cheader_filename = "camel/camel.h")]
	public static size_t yencode_close ([CCode (array_length_cname = "inlen", array_length_pos = 1.5, array_length_type = "gsize")] uint8[] @in, [CCode (array_length = false)] out uint8[] @out, out int state, out uint32 pcrc, out uint32 crc);
	[CCode (cheader_filename = "camel/camel.h")]
	public static size_t yencode_step ([CCode (array_length_cname = "inlen", array_length_pos = 1.5, array_length_type = "gsize")] uint8[] @in, [CCode (array_length = false)] out uint8[] @out, out int state, out uint32 pcrc, out uint32 crc);
}
