/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.membership.cloud;

import java.io.IOException;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.membership.MemberImpl;
import org.apache.catalina.tribes.membership.cloud.CloudMembershipProvider;
import org.apache.catalina.tribes.membership.cloud.CloudMembershipService;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class DNSMembershipProvider
extends CloudMembershipProvider {
    private static final Log log = LogFactory.getLog(DNSMembershipProvider.class);
    private String dnsServiceName;

    @Override
    public void start(int n) throws Exception {
        if ((n & 4) == 0) {
            return;
        }
        super.start(n);
        this.dnsServiceName = DNSMembershipProvider.getEnv("DNS_MEMBERSHIP_SERVICE_NAME");
        if (this.dnsServiceName == null) {
            this.dnsServiceName = this.getNamespace();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Namespace [%s] set; clustering enabled", this.dnsServiceName));
        }
        this.dnsServiceName = URLEncoder.encode(this.dnsServiceName, "UTF-8");
        this.heartbeat();
    }

    @Override
    public boolean stop(int n) throws Exception {
        return super.stop(n);
    }

    @Override
    protected Member[] fetchMembers() {
        ArrayList<MemberImpl> arrayList = new ArrayList<MemberImpl>();
        InetAddress[] inetAddressArray = null;
        try {
            inetAddressArray = InetAddress.getAllByName(this.dnsServiceName);
        }
        catch (UnknownHostException unknownHostException) {
            log.warn((Object)sm.getString("dnsMembershipProvider.dnsError", this.dnsServiceName), (Throwable)unknownHostException);
        }
        if (inetAddressArray != null) {
            for (InetAddress inetAddress : inetAddressArray) {
                String string = inetAddress.getHostAddress();
                byte[] byArray = this.md5.digest(string.getBytes());
                if (string.equals(this.localIp)) {
                    Member member = this.service.getLocalMember(false);
                    if (member.getUniqueId() != CloudMembershipService.INITIAL_ID || !(member instanceof MemberImpl)) continue;
                    ((MemberImpl)member).setUniqueId(byArray);
                    continue;
                }
                long l = -1L;
                MemberImpl memberImpl = null;
                try {
                    memberImpl = new MemberImpl(string, this.port, l);
                }
                catch (IOException iOException) {
                    log.error((Object)sm.getString("kubernetesMembershipProvider.memberError"), (Throwable)iOException);
                    continue;
                }
                memberImpl.setUniqueId(byArray);
                arrayList.add(memberImpl);
            }
        }
        return arrayList.toArray(new Member[0]);
    }
}

