/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.core.ui.actions;

import com.sun.tools.visualvm.core.datasource.DataSource;
import com.sun.tools.visualvm.core.datasupport.Utils;
import com.sun.tools.visualvm.core.explorer.ExplorerSelectionListener;
import com.sun.tools.visualvm.core.explorer.ExplorerSupport;
import com.sun.tools.visualvm.core.ui.actions.ActionUtils;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.Set;
import javax.swing.AbstractAction;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public abstract class DataSourceAction<X extends DataSource>
extends AbstractAction {
    private final Class<X> scope;
    private boolean initialized = false;

    public DataSourceAction(Class<X> scope) {
        this.scope = scope;
    }

    protected abstract void updateState(Set<X> var1);

    protected void notifyCannotPerform() {
        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(DataSourceAction.class, (String)"MSG_Cannot_perform_action_in_this_context"), 0));
    }

    protected void initialize() {
        ExplorerSupport.sharedInstance().addSelectionListener(new ExplorerSelectionListener(){

            @Override
            public void selectionChanged(Set<DataSource> selected) {
                Set selectedFiltered = Utils.getFilteredSet(selected, DataSourceAction.this.getScope());
                if (selectedFiltered.size() == selected.size()) {
                    DataSourceAction.this.updateState(selectedFiltered);
                } else {
                    DataSourceAction.this.updateState(Collections.EMPTY_SET);
                }
            }
        });
        this.updateState(ActionUtils.getSelectedDataSources(this.getScope()));
    }

    @Override
    public final Object getValue(String key) {
        this.doInitialize();
        return super.getValue(key);
    }

    @Override
    public final boolean isEnabled() {
        this.doInitialize();
        return super.isEnabled();
    }

    @Override
    public final void addPropertyChangeListener(PropertyChangeListener listener) {
        this.doInitialize();
        super.addPropertyChangeListener(listener);
    }

    public final Class<X> getScope() {
        return this.scope;
    }

    private synchronized void doInitialize() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.initialize();
    }
}

