/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.cpu;

import java.lang.ref.WeakReference;
import org.netbeans.lib.profiler.global.Platform;
import org.netbeans.lib.profiler.global.ProfilingSessionStatus;
import org.netbeans.lib.profiler.results.cpu.InstrTimingData;

public class TimingAdjusterOld {
    private static TimingAdjusterOld instance;
    private static WeakReference lastStatusRef;
    private InstrTimingData timingData;

    private TimingAdjusterOld(InstrTimingData instrTimingData) {
        this.timingData = instrTimingData;
    }

    public static synchronized TimingAdjusterOld getDefault() {
        if (instance == null) {
            instance = new TimingAdjusterOld(InstrTimingData.DEFAULT);
        }
        return instance;
    }

    public static synchronized TimingAdjusterOld getInstance(ProfilingSessionStatus profilingSessionStatus) {
        if (instance != null) {
            ProfilingSessionStatus profilingSessionStatus2;
            ProfilingSessionStatus profilingSessionStatus3 = profilingSessionStatus2 = lastStatusRef != null ? (ProfilingSessionStatus)lastStatusRef.get() : null;
            if (profilingSessionStatus2 != null && !profilingSessionStatus2.equals(profilingSessionStatus) || profilingSessionStatus2 == null) {
                lastStatusRef = new WeakReference<ProfilingSessionStatus>(profilingSessionStatus);
                switch (profilingSessionStatus.currentInstrType) {
                    case 3: {
                        instance = new TimingAdjusterOld(TimingAdjusterOld.getFullInstrTimingData(profilingSessionStatus));
                        break;
                    }
                    case 4: {
                        instance = new TimingAdjusterOld(TimingAdjusterOld.getSampledInstrTimingData(profilingSessionStatus));
                    }
                }
            }
        } else {
            lastStatusRef = new WeakReference<ProfilingSessionStatus>(profilingSessionStatus);
            switch (profilingSessionStatus.currentInstrType) {
                case 3: {
                    instance = new TimingAdjusterOld(TimingAdjusterOld.getFullInstrTimingData(profilingSessionStatus));
                    break;
                }
                case 4: {
                    instance = new TimingAdjusterOld(TimingAdjusterOld.getSampledInstrTimingData(profilingSessionStatus));
                }
            }
        }
        return instance;
    }

    public final double adjustTime(long l, int n, int n2, boolean bl) {
        if (this.timingData == null) {
            return l;
        }
        if (this.timingData.methodEntryExitCallTime0 == 0.0) {
            if (bl) {
                return (double)l / (double)this.timingData.timerCountsInSecond1;
            }
            return (double)l / (double)this.timingData.timerCountsInSecond0;
        }
        if (bl) {
            return ((double)l - (double)n * this.timingData.methodEntryExitInnerTime1 - (double)n2 * this.timingData.methodEntryExitOuterTime1) * 1000000.0 / (double)this.timingData.timerCountsInSecond1;
        }
        return ((double)l - (double)n * this.timingData.methodEntryExitInnerTime0 - (double)n2 * this.timingData.methodEntryExitOuterTime0) * 1000000.0 / (double)this.timingData.timerCountsInSecond0;
    }

    public final double delta(int n, int n2, boolean bl) {
        if (this.timingData == null || this.timingData.methodEntryExitCallTime0 == 0.0) {
            return 0.0;
        }
        double d = 0.0;
        d = bl ? ((double)n * this.timingData.methodEntryExitInnerTime1 + (double)n2 * this.timingData.methodEntryExitOuterTime1) * 1000000.0 / (double)this.timingData.timerCountsInSecond1 : ((double)n * this.timingData.methodEntryExitInnerTime0 + (double)n2 * this.timingData.methodEntryExitOuterTime0) * 1000000.0 / (double)this.timingData.timerCountsInSecond0;
        if (d < 0.0) {
            d = 0.0;
        }
        return d;
    }

    public InstrTimingData getInstrTimingData() {
        InstrTimingData instrTimingData = TimingAdjusterOld.getFullInstrTimingData(lastStatusRef != null ? (ProfilingSessionStatus)lastStatusRef.get() : null);
        return instrTimingData != null ? (InstrTimingData)instrTimingData.clone() : (InstrTimingData)InstrTimingData.DEFAULT.clone();
    }

    private static InstrTimingData getFullInstrTimingData(ProfilingSessionStatus profilingSessionStatus) {
        if (profilingSessionStatus == null) {
            return null;
        }
        InstrTimingData instrTimingData = new InstrTimingData();
        double d = 0.88;
        double d2 = 0.88;
        double d3 = 0.88;
        if (profilingSessionStatus.collectingTwoTimeStamps()) {
            instrTimingData.methodEntryExitCallTime0 = profilingSessionStatus.methodEntryExitCallTime[2] * d3;
            instrTimingData.methodEntryExitCallTime1 = profilingSessionStatus.methodEntryExitCallTime[3] * (double)profilingSessionStatus.timerCountsInSecond[1] / (double)profilingSessionStatus.timerCountsInSecond[0] * d3;
            instrTimingData.methodEntryExitInnerTime0 = profilingSessionStatus.methodEntryExitInnerTime[2] * d3;
            instrTimingData.methodEntryExitOuterTime0 = profilingSessionStatus.methodEntryExitOuterTime[2] * d3;
            instrTimingData.methodEntryExitInnerTime1 = profilingSessionStatus.methodEntryExitInnerTime[3] * (double)profilingSessionStatus.timerCountsInSecond[1] / (double)profilingSessionStatus.timerCountsInSecond[0] * d3;
            instrTimingData.methodEntryExitOuterTime1 = profilingSessionStatus.methodEntryExitOuterTime[3] * (double)profilingSessionStatus.timerCountsInSecond[1] / (double)profilingSessionStatus.timerCountsInSecond[0] * d3;
            instrTimingData.timerCountsInSecond0 = profilingSessionStatus.timerCountsInSecond[0];
            instrTimingData.timerCountsInSecond1 = profilingSessionStatus.timerCountsInSecond[1];
        } else if (profilingSessionStatus.absoluteTimerOn) {
            instrTimingData.methodEntryExitCallTime0 = profilingSessionStatus.methodEntryExitCallTime[0] * d;
            instrTimingData.methodEntryExitInnerTime0 = profilingSessionStatus.methodEntryExitInnerTime[0] * d;
            instrTimingData.methodEntryExitOuterTime0 = profilingSessionStatus.methodEntryExitOuterTime[0] * d;
            instrTimingData.timerCountsInSecond0 = profilingSessionStatus.timerCountsInSecond[0];
        } else {
            String string = profilingSessionStatus.targetMachineOSName;
            if (Platform.isWindows(string) && profilingSessionStatus.targetJDKVersionString.equals("jdk16")) {
                d2 = 0.0;
            }
            instrTimingData.methodEntryExitCallTime0 = profilingSessionStatus.methodEntryExitCallTime[1] * (double)profilingSessionStatus.timerCountsInSecond[1] / (double)profilingSessionStatus.timerCountsInSecond[0] * d2;
            instrTimingData.methodEntryExitInnerTime0 = profilingSessionStatus.methodEntryExitInnerTime[1] * (double)profilingSessionStatus.timerCountsInSecond[1] / (double)profilingSessionStatus.timerCountsInSecond[0] * d2;
            instrTimingData.methodEntryExitOuterTime0 = profilingSessionStatus.methodEntryExitOuterTime[1] * (double)profilingSessionStatus.timerCountsInSecond[1] / (double)profilingSessionStatus.timerCountsInSecond[0] * d2;
            instrTimingData.timerCountsInSecond0 = profilingSessionStatus.timerCountsInSecond[1];
        }
        return instrTimingData;
    }

    private static InstrTimingData getSampledInstrTimingData(ProfilingSessionStatus profilingSessionStatus) {
        if (profilingSessionStatus == null) {
            return null;
        }
        InstrTimingData instrTimingData = new InstrTimingData();
        double d = profilingSessionStatus.methodEntryExitCallTime[4];
        double d2 = d / (double)profilingSessionStatus.timerCountsInSecond[0] * (double)profilingSessionStatus.timerCountsInSecond[1];
        if (profilingSessionStatus.collectingTwoTimeStamps()) {
            instrTimingData.methodEntryExitCallTime0 = d;
            instrTimingData.methodEntryExitCallTime1 = d2;
            instrTimingData.methodEntryExitInnerTime0 = d;
            instrTimingData.methodEntryExitOuterTime0 = 0.0;
            instrTimingData.methodEntryExitInnerTime1 = d2;
            instrTimingData.methodEntryExitOuterTime1 = 0.0;
            instrTimingData.timerCountsInSecond0 = profilingSessionStatus.timerCountsInSecond[0];
            instrTimingData.timerCountsInSecond1 = profilingSessionStatus.timerCountsInSecond[1];
        } else if (profilingSessionStatus.absoluteTimerOn) {
            instrTimingData.methodEntryExitCallTime0 = d;
            instrTimingData.methodEntryExitInnerTime0 = d;
            instrTimingData.methodEntryExitOuterTime0 = 0.0;
            instrTimingData.timerCountsInSecond0 = profilingSessionStatus.timerCountsInSecond[0];
        } else {
            instrTimingData.methodEntryExitCallTime0 = d2;
            instrTimingData.methodEntryExitInnerTime0 = d2;
            instrTimingData.methodEntryExitOuterTime0 = 0.0;
            instrTimingData.timerCountsInSecond0 = profilingSessionStatus.timerCountsInSecond[1];
        }
        return instrTimingData;
    }
}

