/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.AWTException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.border.CompoundBorder;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.GenericGUIUtilities;

public class ScreenRectangleSelectionButton
extends JButton {
    public ScreenRectangleSelectionButton(BufferedImage bufferedImage) {
        this.setIcon(new ScreenRectangle(bufferedImage));
        this.setMargin(new Insets(2, 2, 2, 2));
        this.addActionListener(new ActionHandler());
    }

    public BufferedImage getSelectedImage() {
        return ((ScreenRectangle)this.getIcon()).image;
    }

    public void setSelectedImage(BufferedImage bufferedImage) {
        ((ScreenRectangle)this.getIcon()).image = bufferedImage;
        this.repaint();
        this.fireStateChanged();
    }

    public void setRectangleDimension(Dimension dimension) {
        ((ScreenRectangle)this.getIcon()).dimension = dimension;
        this.repaint();
        this.fireStateChanged();
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent2) {
            final int n = ScreenRectangleSelectionButton.this.getIcon().getIconWidth();
            final int n2 = ScreenRectangleSelectionButton.this.getIcon().getIconHeight();
            int n3 = n * 12;
            int n4 = n2 * 12;
            JLabel jLabel = new JLabel(jEdit.getProperty("screen-rectangle-selection.directions"));
            ImageIcon imageIcon = new ImageIcon();
            JLabel jLabel2 = new JLabel(imageIcon){

                @Override
                protected void paintComponent(Graphics graphics) {
                    super.paintComponent(graphics);
                    graphics = graphics.create();
                    graphics.setColor(Color.RED);
                    graphics.drawRect(n * 2 - 1, n2 * 2 - 1, n * 8 + 1, n2 * 8 + 1);
                }
            };
            jLabel2.setMinimumSize(new Dimension(n3, n4));
            jLabel2.setPreferredSize(new Dimension(n3, n4));
            jLabel2.setMaximumSize(new Dimension(n3, n4));
            Robot[] robotArray = new Robot[1];
            try {
                robotArray[0] = new Robot();
            }
            catch (AWTException aWTException) {
                // empty catch block
            }
            int n5 = Math.round((float)n * 0.75f);
            int n6 = Math.round((float)n2 * 0.75f);
            Rectangle rectangle = new Rectangle(Math.round((float)n * 1.5f), Math.round((float)n2 * 1.5f));
            final BufferedImage[] bufferedImageArray = new BufferedImage[1];
            final Timer timer = new Timer(100, actionEvent -> {
                Point point = MouseInfo.getPointerInfo().getLocation();
                rectangle.x = point.x - n5;
                rectangle.y = point.y - n6;
                bufferedImageArray[0] = robotArray[0].createScreenCapture(rectangle);
                imageIcon.setImage(bufferedImageArray[0].getScaledInstance(n3, n4, 4));
                jLabel2.repaint();
            });
            timer.setInitialDelay(0);
            if (robotArray[0] != null) {
                timer.start();
            }
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 3));
            jPanel.setBorder(new CompoundBorder(BorderFactory.createRaisedBevelBorder(), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
            jLabel.setAlignmentX(0.5f);
            jPanel.add(jLabel);
            jPanel.add(Box.createRigidArea(new Dimension(0, 10)));
            jLabel2.setAlignmentX(0.5f);
            jPanel.add(jLabel2);
            JDialog jDialog = GenericGUIUtilities.getParentDialog(ScreenRectangleSelectionButton.this);
            final JDialog jDialog2 = new JDialog((Window)jDialog, Dialog.ModalityType.APPLICATION_MODAL);
            jDialog2.setContentPane(jPanel);
            jDialog2.setUndecorated(true);
            jDialog2.setAlwaysOnTop(true);
            jDialog2.setDefaultCloseOperation(0);
            jDialog2.addKeyListener(new KeyAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void keyReleased(KeyEvent keyEvent) {
                    switch (keyEvent.getKeyCode()) {
                        case 10: {
                            timer.stop();
                            jDialog2.dispose();
                            BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
                            Graphics2D graphics2D = bufferedImage.createGraphics();
                            try {
                                int n5 = Math.round((float)n * 0.25f);
                                int n22 = Math.round((float)n2 * 0.25f);
                                int n3 = n + n5;
                                int n4 = n2 + n22;
                                graphics2D.drawImage(bufferedImageArray[0], 0, 0, n, n2, n5, n22, n3, n4, null);
                            }
                            finally {
                                graphics2D.dispose();
                            }
                            ScreenRectangleSelectionButton.this.setSelectedImage(bufferedImage);
                            break;
                        }
                        case 27: {
                            timer.stop();
                            jDialog2.dispose();
                            break;
                        }
                    }
                }
            });
            jDialog2.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                    jDialog2.pack();
                    jDialog2.setLocationRelativeTo(ScreenRectangleSelectionButton.this);
                }
            });
            jDialog2.pack();
            jDialog2.setLocationRelativeTo(ScreenRectangleSelectionButton.this);
            jDialog2.setVisible(true);
        }
    }

    static class ScreenRectangle
    implements Icon {
        Dimension dimension;
        BufferedImage image;

        ScreenRectangle(BufferedImage bufferedImage) {
            this.image = bufferedImage;
        }

        @Override
        public int getIconWidth() {
            return this.dimension.width;
        }

        @Override
        public int getIconHeight() {
            return this.dimension.height;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics = graphics.create();
            graphics.setColor(component.getBackground());
            graphics.fillRect(n, n2, this.getIconWidth(), this.getIconHeight());
            if (this.image != null) {
                graphics.setClip(n, n2, this.getIconWidth(), this.getIconHeight());
                graphics.drawImage(this.image, n, n2, null);
            }
        }
    }
}

