/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.pluginmgr;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.pluginmgr.MirrorListHandler;
import org.gjt.sp.util.IOUtilities;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.ProgressObserver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class MirrorList {
    private final String xml;
    private final List<Mirror> mirrors;

    public static MirrorList mirrorListFromDisk(ProgressObserver progressObserver) throws IOException, SAXException, ParserConfigurationException {
        Log.log(5, MirrorList.class, "Loading mirror list from cache");
        String string = MirrorList.readXml().orElseThrow(() -> new IOException("Unable to read local mirror cache"));
        return new MirrorList(string, progressObserver);
    }

    public static MirrorList mirrorListFromInternet(ProgressObserver progressObserver) throws IOException, ParserConfigurationException, SAXException {
        Log.log(5, MirrorList.class, "Loading mirror list from internet");
        String string = jEdit.getProperty("plugin-manager.mirror-url");
        String string2 = MirrorList.downloadXml(string).orElseThrow(() -> new IOException("Unable to load remote mirror cache"));
        return new MirrorList(string2, progressObserver);
    }

    public MirrorList(String string, ProgressObserver progressObserver) throws ParserConfigurationException, SAXException, IOException {
        this.xml = string;
        this.mirrors = new ArrayList<Mirror>();
        Mirror mirror = new Mirror();
        mirror.id = "NONE";
        mirror.continent = "";
        mirror.country = "";
        mirror.location = "";
        mirror.description = "";
        this.mirrors.add(mirror);
        MirrorListHandler mirrorListHandler = new MirrorListHandler(this);
        progressObserver.setValue(1L);
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        InputSource inputSource = new InputSource(bufferedReader);
        inputSource.setSystemId("jedit.jar");
        XMLReader xMLReader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
        xMLReader.setContentHandler(mirrorListHandler);
        xMLReader.setDTDHandler(mirrorListHandler);
        xMLReader.setEntityResolver(mirrorListHandler);
        xMLReader.setErrorHandler(mirrorListHandler);
        xMLReader.parse(inputSource);
        progressObserver.setValue(2L);
    }

    public String getXml() {
        return this.xml;
    }

    public List<Mirror> getMirrors() {
        return this.mirrors;
    }

    private static Optional<String> readXml() {
        return MirrorList.getMirrorListFile().filter(path -> Files.exists(path, new LinkOption[0])).flatMap(MirrorList::readFile);
    }

    public void saveXml() {
        MirrorList.getMirrorListFile().ifPresent(this::saveFile);
    }

    private static Optional<String> readFile(Path path) {
        try {
            return Optional.of(Files.readString(path));
        }
        catch (IOException iOException) {
            Log.log(9, MirrorList.class, "Unable to read path " + path, iOException);
            return Optional.empty();
        }
    }

    private void saveFile(Path path) {
        try {
            Files.writeString(path, (CharSequence)this.xml, new OpenOption[0]);
        }
        catch (IOException iOException) {
            Log.log(9, this, "Unable to write cached mirror list : " + this.xml, iOException);
        }
    }

    private static Optional<Path> getMirrorListFile() {
        String string = jEdit.getSettingsDirectory();
        if (string == null) {
            return Optional.empty();
        }
        Path path = Path.of(MiscUtilities.constructPath(string, "mirrorList.xml"), new String[0]);
        return Optional.of(path);
    }

    private static Optional<String> downloadXml(String string) throws IOException {
        try (InputStream inputStream = new URL(string).openStream();){
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            IOUtilities.copyStream(null, inputStream, byteArrayOutputStream, false);
            Optional<String> optional = Optional.of(byteArrayOutputStream.toString());
            return optional;
        }
    }

    void add(Mirror mirror) {
        this.mirrors.add(mirror);
    }

    void finished() {
        this.mirrors.sort(new MirrorCompare());
    }

    private static class MirrorCompare
    implements Comparator<Mirror> {
        private MirrorCompare() {
        }

        @Override
        public int compare(Mirror mirror, Mirror mirror2) {
            int n = mirror.continent.compareToIgnoreCase(mirror2.continent);
            if (n == 0 && (n = mirror.country.compareToIgnoreCase(mirror2.country)) == 0 && (n = mirror.location.compareToIgnoreCase(mirror2.location)) == 0) {
                return mirror.description.compareToIgnoreCase(mirror2.description);
            }
            return n;
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof MirrorCompare;
        }
    }

    public static class Mirror {
        public static final String NONE = "NONE";
        public String id;
        public String description;
        public String location;
        public String country;
        public String continent;
    }
}

