/*
 * Decompiled with CFR 0.152.
 */
package org.bridj.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import org.bridj.ann.Forwardable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationUtils {
    public static <A extends Annotation> A getInheritableAnnotation(Class<A> ac, AnnotatedElement m, Annotation ... directAnnotations) {
        return AnnotationUtils.getAnnotation(ac, true, m, directAnnotations);
    }

    public static <A extends Annotation> A getAnnotation(Class<A> ac, AnnotatedElement m, Annotation ... directAnnotations) {
        return AnnotationUtils.getAnnotation(ac, false, m, directAnnotations);
    }

    private static boolean isForwardable(Class<? extends Annotation> ac) {
        return ac.isAnnotationPresent(Forwardable.class);
    }

    public static boolean isAnnotationPresent(Class<? extends Annotation> ac, Annotation ... annotations) {
        return AnnotationUtils.isAnnotationPresent(ac, AnnotationUtils.isForwardable(ac), annotations);
    }

    private static boolean isAnnotationPresent(Class<? extends Annotation> ac, boolean isForwardable, Annotation ... annotations) {
        for (Annotation ann : annotations) {
            if (ac.isInstance(ann)) {
                return true;
            }
            if (!isForwardable || !ann.annotationType().isAnnotationPresent(ac)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAnnotationPresent(Class<? extends Annotation> ac, AnnotatedElement m, Annotation ... directAnnotations) {
        boolean isForwardable = AnnotationUtils.isForwardable(ac);
        if (m != null && (isForwardable ? AnnotationUtils.isAnnotationPresent(ac, true, m.getAnnotations()) : m.isAnnotationPresent(ac))) {
            return true;
        }
        if (directAnnotations != null) {
            return AnnotationUtils.isAnnotationPresent(ac, isForwardable, directAnnotations);
        }
        return false;
    }

    private static <A extends Annotation> A getAnnotation(Class<A> ac, boolean inherit, AnnotatedElement m, Annotation ... directAnnotations) {
        if (directAnnotations != null) {
            for (Annotation ann : directAnnotations) {
                if (!ac.isInstance(ann)) continue;
                return (A)((Annotation)ac.cast(ann));
            }
        }
        if (m == null) {
            return null;
        }
        A a = m.getAnnotation(ac);
        if (a != null) {
            return a;
        }
        if (inherit) {
            if (m instanceof Member) {
                return AnnotationUtils.getAnnotation(ac, inherit, ((Member)((Object)m)).getDeclaringClass(), new Annotation[0]);
            }
            if (m instanceof Class) {
                Class c = (Class)m;
                Class<?> dc = c.getDeclaringClass();
                for (Class p = c.getSuperclass(); p != null; p = p.getSuperclass()) {
                    a = AnnotationUtils.getAnnotation(ac, true, p, new Annotation[0]);
                    if (a == null) continue;
                    return a;
                }
                if (dc != null) {
                    return AnnotationUtils.getAnnotation(ac, inherit, dc, new Annotation[0]);
                }
            }
        }
        return null;
    }
}

