/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.core2;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import net.sourceforge.plantuml.project.core2.IteratorSlice;
import net.sourceforge.plantuml.project.core2.Slice;
import net.sourceforge.plantuml.project.core2.WorkLoad;
import net.sourceforge.plantuml.project.time.DayOfWeek;

public class WorkLoadConstantButWeekDay
implements WorkLoad {
    private final int value;
    private final Set<DayOfWeek> excepts = EnumSet.noneOf(DayOfWeek.class);
    private static final long dayDuration = 86400000L;

    public WorkLoadConstantButWeekDay(int value, DayOfWeek ... butThisDays) {
        this.value = value;
        this.excepts.addAll(Arrays.asList(butThisDays));
    }

    @Override
    public IteratorSlice slices(long timeBiggerThan) {
        Slice first = this.getNext(timeBiggerThan);
        return new MyIterator(first);
    }

    private Slice getNext(long limit) {
        long end;
        long start = limit;
        if (this.isClose(start)) {
            start = this.round(start);
            while (this.isClose(start)) {
                start += 86400000L;
            }
            end = start + 86400000L;
        } else {
            end = this.round(start) + 86400000L;
        }
        assert (!this.isClose(start));
        while (!this.isClose(end)) {
            end += 86400000L;
        }
        assert (this.isClose(end));
        return new Slice(start, end, this.value);
    }

    private boolean isClose(long start) {
        return this.excepts.contains((Object)DayOfWeek.fromTime(start));
    }

    private long round(long start) {
        return 86400000L * (start / 86400000L);
    }

    class MyIterator
    implements IteratorSlice {
        private Slice current;

        public MyIterator(Slice first) {
            this.current = first;
        }

        @Override
        public Slice next() {
            Slice result = this.current;
            this.current = WorkLoadConstantButWeekDay.this.getNext(this.current.getEnd());
            return result;
        }
    }
}

