/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.rose;

import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.SkinParam;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.skin.AbstractTextualComponent;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public final class ComponentRoseNoteBox
extends AbstractTextualComponent {
    private final SymbolContext symbolContext;
    private final double roundCorner;

    public ComponentRoseNoteBox(Style style, SymbolContext symbolContext, FontConfiguration font, Display strings, ISkinSimple spriteContainer, double roundCorner, HorizontalAlignment alignment) {
        super(style, spriteContainer.wrapWidth(), strings, font, alignment, 4, 4, 4, spriteContainer, false, null, null);
        if (SkinParam.USE_STYLES()) {
            this.symbolContext = style.getSymbolContext(this.getIHtmlColorSet());
            this.roundCorner = style.value(PName.RoundCorner).asInt();
        } else {
            this.symbolContext = symbolContext;
            this.roundCorner = roundCorner;
        }
    }

    @Override
    public final double getPreferredWidth(StringBounder stringBounder) {
        double result = this.getTextWidth(stringBounder) + 2.0 * this.getPaddingX();
        return result;
    }

    @Override
    public final double getPreferredHeight(StringBounder stringBounder) {
        return this.getTextHeight(stringBounder) + 2.0 * this.getPaddingY();
    }

    @Override
    public double getPaddingX() {
        return 5.0;
    }

    @Override
    public double getPaddingY() {
        return 5.0;
    }

    @Override
    protected void drawInternalU(UGraphic ug, Area area) {
        StringBounder stringBounder = ug.getStringBounder();
        int textHeight = (int)this.getTextHeight(stringBounder);
        int x2 = (int)this.getTextWidth(stringBounder);
        double diffX = area.getDimensionToUse().getWidth() - this.getPreferredWidth(stringBounder);
        if (diffX < 0.0) {
            throw new IllegalArgumentException();
        }
        if (area.getDimensionToUse().getWidth() > this.getPreferredWidth(stringBounder)) {
            x2 = (int)(area.getDimensionToUse().getWidth() - 2.0 * this.getPaddingX());
        }
        ug = this.symbolContext.apply(ug);
        URectangle rect = new URectangle(x2, textHeight).rounded(this.roundCorner);
        rect.setDeltaShadow(this.symbolContext.getDeltaShadow());
        ug.draw(rect);
        ug = ug.apply(new UStroke());
        this.getTextBlock().drawU(ug.apply(new UTranslate((double)this.getMarginX1() + diffX / 2.0, this.getMarginY())));
    }
}

