/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.scenegraph.io.retained;

import com.sun.j3d.utils.scenegraph.io.retained.SGIORuntimeException;
import java.io.IOException;
import java.io.InputStream;

class PositionInputStream
extends InputStream {
    private long pos = 0L;
    private InputStream stream;

    public PositionInputStream(InputStream inputStream) {
        this.stream = inputStream;
    }

    @Override
    public int read() throws IOException {
        ++this.pos;
        return this.stream.read();
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        int n = this.stream.read(byArray);
        this.pos += (long)n;
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.stream.read(byArray, n, n2);
        this.pos += (long)n3;
        return n3;
    }

    @Override
    public long skip(long l) throws IOException {
        long l2 = this.stream.skip(l);
        this.pos += l2;
        return l2;
    }

    public void seekForward(long l) throws IOException {
        if (this.pos > l) {
            throw new SGIORuntimeException("Seeking Backward " + this.pos + "  " + l);
        }
        this.stream.skip((int)(l - this.pos));
        this.pos = l;
    }

    public long getFilePointer() {
        return this.pos;
    }
}

