/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.protocol;

import com.sun.media.Log;
import com.sun.media.protocol.Streamable;
import java.io.IOException;
import javax.media.Buffer;
import javax.media.Duration;
import javax.media.Format;
import javax.media.MediaLocator;
import javax.media.Time;
import javax.media.protocol.BufferTransferHandler;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.PushBufferDataSource;
import javax.media.protocol.PushBufferStream;

public class DelegateDataSource
extends PushBufferDataSource
implements Streamable {
    protected String contentType = "raw";
    protected PushBufferDataSource master;
    protected DelegateStream[] streams;
    protected boolean started = false;
    protected boolean connected = false;

    public DelegateDataSource(Format[] format) {
        this.streams = new DelegateStream[format.length];
        int i = 0;
        while (i < format.length) {
            this.streams[i] = new DelegateStream(format[i]);
            ++i;
        }
        try {
            this.connect();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setMaster(PushBufferDataSource ds) throws IOException {
        this.master = ds;
        PushBufferStream[] mstrms = ds.getStreams();
        int i = 0;
        while (i < mstrms.length) {
            int j = 0;
            while (j < this.streams.length) {
                if (this.streams[j].getFormat().matches(mstrms[i].getFormat())) {
                    this.streams[j].setMaster(mstrms[i]);
                }
                ++j;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < mstrms.length) {
            if (this.streams[i2].getMaster() == null) {
                Log.error("DelegateDataSource: cannot not find a matching track from the master with this format: " + this.streams[i2].getFormat());
            }
            ++i2;
        }
        if (this.connected) {
            this.master.connect();
        }
        if (this.started) {
            this.master.start();
        }
    }

    public DataSource getMaster() {
        return this.master;
    }

    public PushBufferStream[] getStreams() {
        return this.streams;
    }

    public MediaLocator getLocator() {
        if (this.master != null) {
            return this.master.getLocator();
        }
        return null;
    }

    public String getContentType() {
        if (!this.connected) {
            System.err.println("Error: DataSource not connected");
            return null;
        }
        return this.contentType;
    }

    public void connect() throws IOException {
        if (this.connected) {
            return;
        }
        if (this.master != null) {
            this.master.connect();
        }
        this.connected = true;
    }

    public void disconnect() {
        try {
            if (this.started) {
                this.stop();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.master != null) {
            this.master.disconnect();
        }
        this.connected = false;
    }

    public void start() throws IOException {
        if (!this.connected) {
            throw new Error("DataSource must be connected before it can be started");
        }
        if (this.started) {
            return;
        }
        if (this.master != null) {
            this.master.start();
        }
        this.started = true;
    }

    public void stop() throws IOException {
        if (!this.connected || !this.started) {
            return;
        }
        if (this.master != null) {
            this.master.stop();
        }
        this.started = false;
    }

    public Object[] getControls() {
        if (this.master != null) {
            return this.master.getControls();
        }
        return new Object[0];
    }

    public Object getControl(String controlType) {
        if (this.master != null) {
            return this.master.getControl(controlType);
        }
        return null;
    }

    public Time getDuration() {
        if (this.master != null) {
            return this.master.getDuration();
        }
        return Duration.DURATION_UNKNOWN;
    }

    public boolean isPrefetchable() {
        return false;
    }

    class DelegateStream
    implements PushBufferStream,
    BufferTransferHandler {
        Format format;
        PushBufferStream master;
        BufferTransferHandler th;

        public DelegateStream(Format format) {
            this.format = format;
        }

        public void setMaster(PushBufferStream master) {
            this.master = master;
            master.setTransferHandler(this);
        }

        public PushBufferStream getMaster() {
            return this.master;
        }

        public Format getFormat() {
            if (this.master != null) {
                return this.master.getFormat();
            }
            return this.format;
        }

        public ContentDescriptor getContentDescriptor() {
            if (this.master != null) {
                return this.master.getContentDescriptor();
            }
            return new ContentDescriptor("raw");
        }

        public long getContentLength() {
            if (this.master != null) {
                return this.master.getContentLength();
            }
            return -1L;
        }

        public boolean endOfStream() {
            if (this.master != null) {
                return this.master.endOfStream();
            }
            return false;
        }

        public void read(Buffer buffer) throws IOException {
            if (this.master != null) {
                this.master.read(buffer);
            }
            throw new IOException("No data available");
        }

        public void setTransferHandler(BufferTransferHandler transferHandler) {
            this.th = transferHandler;
        }

        public void transferData(PushBufferStream stream) {
            if (this.th != null) {
                this.th.transferData(stream);
            }
        }

        public Object[] getControls() {
            if (this.master != null) {
                return this.master.getControls();
            }
            return new Object[0];
        }

        public Object getControl(String controlType) {
            if (this.master != null) {
                return this.master.getControl(controlType);
            }
            return null;
        }
    }
}

